/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.internal.grammar.AnnotationSignatureParser;
import org.openrewrite.java.internal.grammar.AspectJLexer;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class FindAnnotations
extends JavaSourceVisitor<List<J.Annotation>> {
    private final AnnotationMatcher matcher;

    public FindAnnotations(String signature) {
        this.matcher = new AnnotationMatcher(signature);
    }

    public List<J.Annotation> defaultTo(Tree t) {
        return Collections.emptyList();
    }

    @Override
    public List<J.Annotation> visitAnnotation(J.Annotation annotation) {
        return this.matcher.matches(annotation) ? Collections.singletonList(annotation) : Collections.emptyList();
    }

    private static class AnnotationMatcher {
        private final AnnotationSignatureParser.AnnotationContext match;

        public AnnotationMatcher(String signature) {
            this.match = new AnnotationSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new AspectJLexer((CharStream)CharStreams.fromString((String)signature)))).annotation();
        }

        public boolean matches(J.Annotation annotation) {
            return this.matchesAnnotationName(annotation) && this.matchesSingleParameter(annotation) && this.matchesNamedParameters(annotation);
        }

        private boolean matchesAnnotationName(J.Annotation annotation) {
            JavaType.Class typeAsClass = TypeUtils.asClass(annotation.getType());
            return this.match.annotationName().getText().equals(typeAsClass == null ? null : typeAsClass.getFullyQualifiedName());
        }

        private boolean matchesNamedParameters(J.Annotation annotation) {
            AnnotationSignatureParser.ElementValuePairsContext pairs = this.match.elementValuePairs();
            if (pairs == null || pairs.elementValuePair() == null) {
                return true;
            }
            List matchArgs = pairs.elementValuePair().stream().map(pair -> new AnnotationParameter(pair.Identifier().getText(), pair.elementValue().getText())).collect(Collectors.toList());
            return annotation.getArgs() != null && annotation.getArgs().getArgs().stream().map(arg -> {
                J.Assign assign = (J.Assign)arg;
                return new AnnotationParameter(assign.getVariable().printTrimmed(), assign.getAssignment().printTrimmed());
            }).allMatch(param -> matchArgs.stream().anyMatch(param::equals));
        }

        private boolean matchesSingleParameter(J.Annotation annotation) {
            if (this.match.elementValue() == null) {
                return true;
            }
            return annotation.getArgs() == null ? true : annotation.getArgs().getArgs().stream().findAny().map(arg -> {
                if (arg instanceof J.Assign) {
                    return ((J.Assign)arg).getAssignment().printTrimmed().equals(this.match.elementValue().getText());
                }
                if (arg instanceof J.Literal) {
                    return ((J.Literal)arg).getValueSource().equals(this.match.elementValue().getText());
                }
                return false;
            }).orElse(true);
        }

        private static class AnnotationParameter {
            private final String id;
            private final String value;

            public AnnotationParameter(String id, String value) {
                this.id = id;
                this.value = value;
            }

            public String getId() {
                return this.id;
            }

            public String getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AnnotationParameter)) {
                    return false;
                }
                AnnotationParameter other = (AnnotationParameter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            protected boolean canEqual(Object other) {
                return other instanceof AnnotationParameter;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            public String toString() {
                return "FindAnnotations.AnnotationMatcher.AnnotationParameter(id=" + this.getId() + ", value=" + this.getValue() + ")";
            }
        }
    }
}

