/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

class TypeMapping {
    private static final int KIND_BITMASK_INTERFACE = 512;
    private static final int KIND_BITMASK_ANNOTATION = 8192;
    private static final int KIND_BITMASK_ENUM = 16384;
    private final boolean relaxedClassTypeMatching;
    private final Map<String, JavaType.Class> sharedClassTypes;

    @Nullable
    public JavaType type(@Nullable Type type) {
        return this.type(type, Collections.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public JavaType type(@Nullable Type type, List<Symbol> stack) {
        if (type instanceof Type.ClassType) {
            List typeParameters;
            if (type instanceof Type.ErrorType) {
                return null;
            }
            Type.ClassType classType = (Type.ClassType)type;
            Symbol.ClassSymbol sym = (Symbol.ClassSymbol)type.tsym;
            Type.ClassType symType = (Type.ClassType)sym.type;
            if (stack.contains(sym)) {
                return new JavaType.Cyclic(sym.className());
            }
            JavaType.Class clazz = this.sharedClassTypes.get(sym.className());
            ArrayList<Symbol> stackWithSym = new ArrayList<Symbol>(stack);
            stackWithSym.add(sym);
            if (clazz == null) {
                void var11_20;
                List interfaces;
                if (!sym.completer.isTerminal()) {
                    try {
                        String packageName = sym.packge().fullname.toString();
                        if (!(packageName.startsWith("com.sun.") || packageName.startsWith("sun.") || packageName.startsWith("jdk."))) {
                            sym.complete();
                        }
                    }
                    catch (Symbol.CompletionFailure packageName) {
                        // empty catch block
                    }
                }
                List fields = Collections.emptyList();
                List methods = Collections.emptyList();
                if (sym.members_field != null) {
                    for (Symbol symbol : sym.members_field.getSymbols()) {
                        if (symbol instanceof Symbol.VarSymbol && (symbol.flags_field & 0x30A0001000L) == 0L) {
                            if (fields.isEmpty()) {
                                fields = new ArrayList();
                            }
                            fields.add(this.variableType(symbol, stackWithSym));
                            continue;
                        }
                        if (!(symbol instanceof Symbol.MethodSymbol) || (symbol.flags_field & 0x30A0001000L) != 0L) continue;
                        if (methods.isEmpty()) {
                            methods = new ArrayList();
                        }
                        methods.add(this.methodType(symbol.type, symbol, symbol.getSimpleName().toString(), stackWithSym));
                    }
                }
                if (symType.interfaces_field == null) {
                    interfaces = Collections.emptyList();
                } else {
                    interfaces = new ArrayList(symType.interfaces_field.length());
                    for (Type iParam : symType.interfaces_field) {
                        JavaType.FullyQualified javaType = TypeUtils.asFullyQualified((JavaType)this.type(iParam, stackWithSym));
                        if (javaType == null) continue;
                        interfaces.add(javaType);
                    }
                }
                if ((sym.flags_field & 0x4000L) != 0L) {
                    JavaType.Class.Kind kind = JavaType.Class.Kind.Enum;
                } else if ((sym.flags_field & 0x2000L) != 0L) {
                    JavaType.Class.Kind kind = JavaType.Class.Kind.Annotation;
                } else if ((sym.flags_field & 0x200L) != 0L) {
                    JavaType.Class.Kind kind = JavaType.Class.Kind.Interface;
                } else {
                    JavaType.Class.Kind kind = JavaType.Class.Kind.Class;
                }
                JavaType.FullyQualified owner = null;
                if (sym.owner instanceof Symbol.ClassSymbol) {
                    owner = TypeUtils.asFullyQualified((JavaType)this.type(sym.owner.type, stackWithSym));
                }
                List annotations = Collections.emptyList();
                if (!sym.getDeclarationAttributes().isEmpty()) {
                    annotations = new ArrayList(sym.getDeclarationAttributes().size());
                    for (Attribute.Compound a : sym.getDeclarationAttributes()) {
                        JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)this.type(a.type, stackWithSym));
                        if (fq == null) continue;
                        annotations.add(fq);
                    }
                }
                clazz = JavaType.Class.build((long)sym.flags_field, (String)sym.className(), (JavaType.Class.Kind)var11_20, fields, interfaces, methods, (JavaType.FullyQualified)TypeUtils.asFullyQualified((JavaType)this.type(classType.supertype_field == null ? symType.supertype_field : classType.supertype_field, stackWithSym)), (JavaType.FullyQualified)owner, annotations, (URI)(sym.classfile == null ? null : sym.classfile.toUri()), (boolean)this.relaxedClassTypeMatching);
                this.sharedClassTypes.put(clazz.getFullyQualifiedName(), clazz);
            }
            if (classType.typarams_field == null) {
                typeParameters = Collections.emptyList();
            } else {
                typeParameters = new ArrayList(classType.typarams_field.length());
                for (Type tParam : classType.typarams_field) {
                    JavaType javaType = this.type(tParam, stackWithSym);
                    if (javaType == null) continue;
                    typeParameters.add(javaType);
                }
            }
            if (!typeParameters.isEmpty()) {
                return JavaType.Parameterized.build((JavaType.FullyQualified)clazz, typeParameters);
            }
            return clazz;
        }
        if (type instanceof Type.TypeVar) {
            return new JavaType.GenericTypeVariable(type.tsym.name.toString(), TypeUtils.asFullyQualified((JavaType)this.type(type.getUpperBound(), stack)));
        }
        if (type instanceof Type.JCPrimitiveType) {
            return this.primitiveType(type.getTag());
        }
        if (type instanceof Type.JCVoidType) {
            return JavaType.Primitive.Void;
        }
        if (type instanceof Type.ArrayType) {
            return new JavaType.Array(this.type(((Type.ArrayType)type).elemtype, stack));
        }
        if (type instanceof Type.WildcardType) {
            Type.WildcardType wildcard = (Type.WildcardType)type;
            if (wildcard.kind == BoundKind.UNBOUND) {
                return JavaType.Class.OBJECT;
            }
            return this.type(wildcard.type, stack);
        }
        if (Type.noType.equals(type)) {
            return null;
        }
        return null;
    }

    @Nullable
    public JavaType type(Tree t) {
        return this.type(((JCTree)t).type);
    }

    public JavaType.Primitive primitiveType(TypeTag tag) {
        switch (tag) {
            case BOOLEAN: {
                return JavaType.Primitive.Boolean;
            }
            case BYTE: {
                return JavaType.Primitive.Byte;
            }
            case CHAR: {
                return JavaType.Primitive.Char;
            }
            case DOUBLE: {
                return JavaType.Primitive.Double;
            }
            case FLOAT: {
                return JavaType.Primitive.Float;
            }
            case INT: {
                return JavaType.Primitive.Int;
            }
            case LONG: {
                return JavaType.Primitive.Long;
            }
            case SHORT: {
                return JavaType.Primitive.Short;
            }
            case VOID: {
                return JavaType.Primitive.Void;
            }
            case NONE: {
                return JavaType.Primitive.None;
            }
            case CLASS: {
                return JavaType.Primitive.String;
            }
            case BOT: {
                return JavaType.Primitive.Null;
            }
        }
        throw new IllegalArgumentException("Unknown type tag " + tag);
    }

    @Nullable
    public JavaType.Variable variableType(@Nullable Symbol symbol, List<Symbol> stack) {
        if (!(symbol instanceof Symbol.VarSymbol)) {
            return null;
        }
        JavaType.FullyQualified owner = TypeUtils.asFullyQualified((JavaType)this.type(symbol.owner.type, stack));
        if (owner == null) {
            return null;
        }
        List annotations = Collections.emptyList();
        if (!symbol.getDeclarationAttributes().isEmpty()) {
            annotations = new ArrayList(symbol.getDeclarationAttributes().size());
            for (Attribute.Compound a : symbol.getDeclarationAttributes()) {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)this.type(a.type, stack));
                if (fq == null) continue;
                annotations.add(fq);
            }
        }
        return JavaType.Variable.build((String)symbol.name.toString(), (JavaType.FullyQualified)owner, (JavaType)this.type(symbol.type, stack), annotations, (long)symbol.flags_field);
    }

    @Nullable
    public JavaType.Method methodType(@Nullable Type selectType, @Nullable Symbol symbol, String methodName, List<Symbol> stack) {
        Symbol.MethodSymbol methodSymbol;
        Symbol.MethodSymbol methodSymbol2 = methodSymbol = symbol instanceof Symbol.MethodSymbol ? (Symbol.MethodSymbol)symbol : null;
        if (methodSymbol != null && selectType != null) {
            Function<Type, JavaType.Method.Signature> signature = t -> {
                if (t instanceof Type.MethodType) {
                    Type.MethodType mt = (Type.MethodType)t;
                    List paramTypes = Collections.emptyList();
                    if (!mt.argtypes.isEmpty()) {
                        paramTypes = new ArrayList(mt.argtypes.size());
                        for (Type argtype : mt.argtypes) {
                            if (argtype == null) continue;
                            JavaType javaType = this.type(argtype, stack);
                            paramTypes.add(javaType);
                        }
                    }
                    return new JavaType.Method.Signature(this.type(mt.restype, stack), paramTypes);
                }
                return null;
            };
            JavaType.Method.Signature genericSignature = methodSymbol.type instanceof Type.ForAll ? signature.apply(((Type.ForAll)methodSymbol.type).qtype) : signature.apply(methodSymbol.type);
            List paramNames = Collections.emptyList();
            if (!methodSymbol.params().isEmpty()) {
                paramNames = new ArrayList(methodSymbol.params().size());
                for (Symbol.VarSymbol p : methodSymbol.params()) {
                    String s = p.name.toString();
                    paramNames.add(s);
                }
            }
            List exceptionTypes = Collections.emptyList();
            if (selectType instanceof Type.MethodType) {
                Type.MethodType methodType = (Type.MethodType)selectType;
                if (!methodType.thrown.isEmpty()) {
                    exceptionTypes = new ArrayList(methodType.thrown.size());
                    for (Type exceptionType : methodType.thrown) {
                        JavaType.FullyQualified javaType = TypeUtils.asFullyQualified((JavaType)this.type(exceptionType, stack));
                        if (javaType == null && exceptionType instanceof Type.ClassType) {
                            Symbol.ClassSymbol sym = (Symbol.ClassSymbol)exceptionType.tsym;
                            javaType = JavaType.Class.build((String)sym.className());
                        }
                        if (javaType == null) continue;
                        exceptionTypes.add(javaType);
                    }
                }
            }
            JavaType.FullyQualified declaringType = null;
            if (methodSymbol.owner instanceof Symbol.ClassSymbol || methodSymbol.owner instanceof Symbol.TypeVariableSymbol) {
                declaringType = TypeUtils.asFullyQualified((JavaType)this.type(methodSymbol.owner.type, stack));
            } else if (methodSymbol.owner instanceof Symbol.VarSymbol) {
                declaringType = new JavaType.GenericTypeVariable(methodSymbol.owner.name.toString(), null);
            }
            if (declaringType == null) {
                return null;
            }
            List annotations = Collections.emptyList();
            if (!methodSymbol.getDeclarationAttributes().isEmpty()) {
                annotations = new ArrayList(methodSymbol.getDeclarationAttributes().size());
                for (Attribute.Compound a : methodSymbol.getDeclarationAttributes()) {
                    JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)this.type(a.type, stack));
                    if (fq == null) continue;
                    annotations.add(fq);
                }
            }
            return JavaType.Method.build((long)methodSymbol.flags_field, (JavaType.FullyQualified)declaringType, (String)methodName, (JavaType.Method.Signature)genericSignature, (JavaType.Method.Signature)signature.apply(selectType), paramNames, Collections.unmodifiableList(exceptionTypes), annotations);
        }
        return null;
    }

    public TypeMapping(boolean relaxedClassTypeMatching, Map<String, JavaType.Class> sharedClassTypes) {
        this.relaxedClassTypeMatching = relaxedClassTypeMatching;
        this.sharedClassTypes = sharedClassTypes;
    }
}

