/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.openrewrite.Parser;
import org.openrewrite.internal.StringUtils;

public class ParserInputFileObject
implements JavaFileObject {
    private final Path path;
    private final Parser.Input input;

    public ParserInputFileObject(Parser.Input input) {
        this.input = input;
        this.path = input.getPath();
    }

    @Override
    public URI toUri() {
        return this.input.getPath().toUri();
    }

    @Override
    public String getName() {
        return this.input.getPath().getFileName().toString();
    }

    @Override
    public InputStream openInputStream() {
        return this.input.getSource();
    }

    @Override
    public OutputStream openOutputStream() {
        throw new UnsupportedOperationException("Should be no need to write output to this file");
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) {
        return new InputStreamReader(this.input.getSource());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return StringUtils.readFully((InputStream)this.input.getSource());
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException("Should be no need to write output to this file");
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.SOURCE;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return true;
    }

    @Override
    public NestingKind getNestingKind() {
        return NestingKind.TOP_LEVEL;
    }

    @Override
    public Modifier getAccessLevel() {
        return Modifier.PUBLIC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParserInputFileObject that = (ParserInputFileObject)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }
}

