/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.internal.template;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openrewrite.Tree;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.hcl.RandomizeIdVisitor;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;

public class HclTemplateParser {
    private static final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("#{", "}", null);
    private final Object templateCacheLock = new Object();
    private final HclParser parser = HclParser.builder().build();
    private static final String BODY_STUB = "#{}";
    private static final String EXPRESSION_STUB = "a=#{}";
    private static final Map<String, List<? extends Hcl>> templateCache = new LinkedHashMap<String, List<? extends Hcl>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 10000;
        }
    };
    private final Consumer<String> onAfterVariableSubstitution;
    private final Consumer<String> onBeforeParseTemplate;

    public List<BodyContent> parseBodyContent(String template) {
        String stub = this.substitute(BODY_STUB, template);
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(stub, () -> {
            Hcl.ConfigFile cf = this.compileTemplate(stub);
            return cf.getBody();
        });
    }

    public Expression parseExpression(String template) {
        String stub = this.substitute(EXPRESSION_STUB, template);
        this.onBeforeParseTemplate.accept(stub);
        return (Expression)this.cache(stub, () -> {
            Hcl.ConfigFile cf = this.compileTemplate(stub);
            return Collections.singletonList(((Hcl.Attribute)cf.getBody().get(0)).getValue());
        }).get(0);
    }

    private Hcl.ConfigFile compileTemplate(String stub) {
        return (Hcl.ConfigFile)this.parser.parse(new String[]{stub}).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as HCL"));
    }

    private String substitute(String stub, String template) {
        String beforeParse = placeholderHelper.replacePlaceholders(stub, k -> template);
        this.onAfterVariableSubstitution.accept(beforeParse);
        return beforeParse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <H extends Hcl> List<H> cache(String stub, Supplier<List<? extends Hcl>> ifAbsent) {
        List<? extends Hcl> hs;
        Object object = this.templateCacheLock;
        synchronized (object) {
            hs = templateCache.get(stub);
            if (hs == null) {
                hs = ifAbsent.get();
                templateCache.put(stub, hs);
            }
        }
        return ListUtils.map(hs, j -> (Hcl)new RandomizeIdVisitor().visit((Tree)j, 0));
    }

    public HclTemplateParser(Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate) {
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.onBeforeParseTemplate = onBeforeParseTemplate;
    }
}

