/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import groovy.lang.GroovySystem;
import groovy.transform.Field;
import groovy.transform.Immutable;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.LambdaExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.groovy.FindBinaryOperationVisitor;
import org.openrewrite.groovy.GroovyParsingException;
import org.openrewrite.groovy.GroovyTypeMapping;
import org.openrewrite.groovy.internal.Delimiter;
import org.openrewrite.groovy.marker.AsStyleTypeCast;
import org.openrewrite.groovy.marker.Elvis;
import org.openrewrite.groovy.marker.EmptyArgumentListPrecedesArgument;
import org.openrewrite.groovy.marker.ImplicitDot;
import org.openrewrite.groovy.marker.InStyleForEachLoop;
import org.openrewrite.groovy.marker.LambdaStyle;
import org.openrewrite.groovy.marker.MultiVariable;
import org.openrewrite.groovy.marker.NullSafe;
import org.openrewrite.groovy.marker.StarDot;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.marker.Semicolon;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.VariableDeclarator;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class GroovyParserVisitor {
    private final Path sourcePath;
    private final @Nullable FileAttributes fileAttributes;
    private final String source;
    private final int[] sourceLineNumberOffsets;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private final GroovyTypeMapping typeMapping;
    private int cursor = 0;
    private static final Pattern MULTILINE_COMMENT_REGEX = Pattern.compile("(?s)/\\*.*?\\*/");
    private static final Pattern whitespacePrefixPattern = Pattern.compile("^\\s*");
    private static final Pattern whitespaceSuffixPattern = Pattern.compile("\\s*[^\\s]+(\\s*)");
    private int columnOffset;
    private static @Nullable Boolean olderThanGroovy3;
    private static final Map<String, J.Modifier.Type> modifierNameToType;

    public GroovyParserVisitor(Path sourcePath, @Nullable FileAttributes fileAttributes, EncodingDetectingInputStream source, JavaTypeCache typeCache, ExecutionContext ctx) {
        this.sourcePath = sourcePath;
        this.fileAttributes = fileAttributes;
        this.source = source.readFully();
        AtomicInteger counter = new AtomicInteger(1);
        AtomicInteger offsetCursor = new AtomicInteger(0);
        this.sourceLineNumberOffsets = Arrays.stream(this.source.split("\n")).mapToInt(it -> {
            int saveCursor = offsetCursor.get();
            offsetCursor.set(saveCursor + it.length() + 1);
            return saveCursor;
        }).toArray();
        this.charset = source.getCharset();
        this.charsetBomMarked = source.isCharsetBomMarked();
        this.typeMapping = new GroovyTypeMapping(typeCache);
    }

    private static boolean isOlderThanGroovy3() {
        if (olderThanGroovy3 == null) {
            String groovyVersionText = GroovySystem.getVersion();
            int majorVersion = Integer.parseInt(groovyVersionText.substring(0, groovyVersionText.indexOf(46)));
            olderThanGroovy3 = majorVersion < 3;
        }
        return olderThanGroovy3;
    }

    public G.CompilationUnit visit(SourceUnit unit, ModuleNode ast) throws GroovyParsingException {
        TreeMap<LineColumn, Object> sortedByPosition = new TreeMap<LineColumn, Object>();
        for (org.codehaus.groovy.ast.stmt.Statement s : ast.getStatementBlock().getStatements()) {
            if (GroovyParserVisitor.isSynthetic((ASTNode)s)) continue;
            sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)s), s);
        }
        String shebang = null;
        if (this.source.startsWith("#!")) {
            int i;
            for (i = 0; i < this.source.length() && this.source.charAt(i) != '\n' && this.source.charAt(i) != '\r'; ++i) {
            }
            shebang = this.source.substring(0, i);
            this.cursor += i;
        }
        Space prefix = Space.EMPTY;
        JRightPadded<J.Package> pkg = null;
        if (ast.getPackage() != null) {
            prefix = this.whitespace();
            this.skip("package");
            pkg = this.maybeSemicolon(new J.Package(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (org.openrewrite.java.tree.Expression)this.typeTree(null), Collections.emptyList()));
        }
        for (ImportNode anImport : ast.getImports()) {
            sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)anImport), anImport);
        }
        for (ImportNode anImport : ast.getStarImports()) {
            sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)anImport), anImport);
        }
        for (ImportNode anImport : ast.getStaticImports().values()) {
            sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)anImport), anImport);
        }
        for (ImportNode anImport : this.getStaticStarImports(ast)) {
            sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)anImport), anImport);
        }
        for (ClassNode aClass : ast.getClasses()) {
            if (aClass.getName().equals(ast.getMainClassName()) && aClass.getName().endsWith("doesntmatter")) continue;
            sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)aClass), aClass);
        }
        for (MethodNode method : ast.getMethods()) {
            sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)method), method);
        }
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>(sortedByPosition.size());
        for (Map.Entry entry : sortedByPosition.entrySet()) {
            if (((LineColumn)entry.getKey()).getLine() == -1) continue;
            try {
                if (entry.getValue() instanceof InnerClassNode) continue;
                JRightPadded statement = this.convertTopLevelStatement(unit, (ASTNode)entry.getValue());
                if (statements.isEmpty() && pkg == null && statement.getElement() instanceof J.Import) {
                    prefix = ((Statement)statement.getElement()).getPrefix();
                    statement = statement.withElement((Object)((Statement)((Statement)statement.getElement()).withPrefix(Space.EMPTY)));
                }
                statements.add(statement);
            }
            catch (Throwable t) {
                if (t instanceof StringIndexOutOfBoundsException) {
                    throw new GroovyParsingException("Failed to parse " + this.sourcePath + ", cursor position likely inaccurate.", t);
                }
                throw new GroovyParsingException("Failed to parse " + this.sourcePath + " at cursor position " + this.cursor + ". The next 10 characters in the original source are `" + this.source.substring(this.cursor, Math.min(this.source.length(), this.cursor + 10)) + "`", t);
            }
        }
        return new G.CompilationUnit(Tree.randomId(), shebang, prefix, Markers.EMPTY, this.sourcePath, this.fileAttributes, this.charset.name(), this.charsetBomMarked, null, pkg, statements, Space.format((String)this.source, (int)this.cursor, (int)this.source.length()));
    }

    private Markers handlesCaseWhereEmptyParensAheadOfClosure(ArgumentListExpression args, Markers markers) {
        if (args.getExpressions().size() == 1 && args.getExpressions().get(0) instanceof ClosureExpression) {
            int saveCursor = this.cursor;
            Space argPrefix = this.whitespace();
            if (this.source.charAt(this.cursor) == '(') {
                this.skip("(");
                Space infix = this.whitespace();
                if (this.source.charAt(this.cursor) == ')') {
                    this.skip(")");
                    markers = markers.add((Marker)new EmptyArgumentListPrecedesArgument(Tree.randomId(), argPrefix, infix));
                } else {
                    this.cursor = saveCursor;
                }
            } else {
                this.cursor = saveCursor;
            }
        }
        return markers;
    }

    private JRightPadded<Statement> convertTopLevelStatement(SourceUnit unit, ASTNode node) {
        if (node instanceof ClassNode) {
            ClassNode classNode = (ClassNode)node;
            RewriteGroovyClassVisitor classVisitor = new RewriteGroovyClassVisitor(unit);
            classVisitor.visitClass(classNode);
            return JRightPadded.build((Object)((Statement)classVisitor.pollQueue()));
        }
        if (node instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)node;
            RewriteGroovyClassVisitor classVisitor = new RewriteGroovyClassVisitor(unit);
            classVisitor.visitMethod(methodNode);
            return JRightPadded.build((Object)((Statement)classVisitor.pollQueue()));
        }
        if (node instanceof ImportNode) {
            ImportNode importNode = (ImportNode)node;
            Space importPrefix = this.sourceBefore("import");
            JLeftPadded<Boolean> statik = importNode.isStatic() ? this.padLeft(this.sourceBefore("static"), true) : this.padLeft(Space.EMPTY, false);
            Space space = this.whitespace();
            J.FieldAccess qualid = (J.FieldAccess)TypeTree.build((String)this.name()).withPrefix(space);
            JLeftPadded<J.Identifier> alias = null;
            if (this.sourceStartsWith("as")) {
                alias = this.padLeft(this.sourceBefore("as"), new J.Identifier(Tree.randomId(), this.whitespace(), Markers.EMPTY, Collections.emptyList(), this.name(), null, null));
            }
            return this.maybeSemicolon(new J.Import(Tree.randomId(), importPrefix, Markers.EMPTY, statik, qualid, alias));
        }
        RewriteGroovyVisitor groovyVisitor = new RewriteGroovyVisitor(node, new RewriteGroovyClassVisitor(unit));
        node.visit((GroovyCodeVisitor)groovyVisitor);
        return this.maybeSemicolon((Statement)groovyVisitor.pollQueue());
    }

    public List<J.Annotation> visitAndGetAnnotations(AnnotatedNode node, RewriteGroovyClassVisitor classVisitor) {
        if (node.getAnnotations().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<J.Annotation> paramAnnotations = new ArrayList<J.Annotation>(node.getAnnotations().size());
        for (AnnotationNode annotationNode : node.getAnnotations()) {
            if (this.sourceStartsWith("@" + Immutable.class.getSimpleName()) || this.sourceStartsWith("@" + Immutable.class.getCanonicalName())) {
                paramAnnotations.add(this.visitAnnotation(new AnnotationNode(new ClassNode(Immutable.class)), classVisitor));
            }
            if (!this.appearsInSource((ASTNode)annotationNode)) continue;
            paramAnnotations.add(this.visitAnnotation(annotationNode, classVisitor));
        }
        return paramAnnotations;
    }

    public J.Annotation visitAnnotation(AnnotationNode annotation, RewriteGroovyClassVisitor classVisitor) {
        RewriteGroovyVisitor bodyVisitor = new RewriteGroovyVisitor((ASTNode)annotation, classVisitor);
        String lastArgKey = annotation.getMembers().keySet().stream().reduce("", (k1, k2) -> k2);
        Space prefix = this.sourceBefore("@");
        TypeTree annotationType = this.visitTypeTree(annotation.getClassNode());
        JContainer arguments = null;
        if (!annotation.getMembers().isEmpty()) {
            arguments = JContainer.build((Space)this.sourceBefore("("), annotation.getMembers().entrySet().stream().filter(it -> this.sourceStartsWith((String)it.getKey()) || "value".equals(it.getKey())).map(arg -> {
                boolean isImplicitValue = "value".equals(arg.getKey()) && !this.sourceStartsWith("value");
                Space argPrefix = isImplicitValue ? this.whitespace() : this.sourceBefore((String)arg.getKey());
                Space isSign = isImplicitValue ? null : this.sourceBefore("=");
                Object expression = arg.getValue() instanceof AnnotationConstantExpression ? this.visitAnnotation((AnnotationNode)((AnnotationConstantExpression)arg.getValue()).getValue(), classVisitor) : (org.openrewrite.java.tree.Expression)bodyVisitor.visit((ASTNode)arg.getValue());
                org.openrewrite.java.tree.Expression element = isImplicitValue ? expression : new J.Assignment(Tree.randomId(), argPrefix, Markers.EMPTY, (org.openrewrite.java.tree.Expression)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), (String)arg.getKey(), null, null), this.padLeft(isSign, expression), null);
                return JRightPadded.build((Object)element).withAfter(((String)arg.getKey()).equals(lastArgKey) ? this.sourceBefore(")") : this.sourceBefore(","));
            }).collect(Collectors.toList()), (Markers)Markers.EMPTY);
            if (arguments.getElements().isEmpty()) {
                arguments = null;
            }
        } else if (this.sourceStartsWith("(")) {
            arguments = JContainer.build((Space)this.sourceBefore("("), Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY))), (Markers)Markers.EMPTY);
        }
        return new J.Annotation(Tree.randomId(), prefix, Markers.EMPTY, (NameTree)annotationType, arguments);
    }

    private static LineColumn pos(ASTNode node) {
        return new LineColumn(node.getLineNumber(), node.getColumnNumber());
    }

    private static boolean isSynthetic(ASTNode node) {
        return node.getLineNumber() == -1;
    }

    private <T> JRightPadded<T> padRight(T tree, Space right) {
        return this.padRight(tree, right, Markers.EMPTY);
    }

    private <T> JRightPadded<T> padRight(T tree, Space right, Markers markers) {
        return new JRightPadded(tree, right, markers);
    }

    private <T> JLeftPadded<T> padLeft(Space left, T tree) {
        return new JLeftPadded(left, tree, Markers.EMPTY);
    }

    private int positionOfNext(String untilDelim) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment) {
                if (this.source.charAt(delimIndex) != '\n') continue;
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() - untilDelim.length() > delimIndex + 1) {
                switch (this.source.substring(delimIndex, delimIndex + 2)) {
                    case "//": {
                        inSingleLineComment = !inMultiLineComment;
                        ++delimIndex;
                        break;
                    }
                    case "/*": {
                        inMultiLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "*/": {
                        inMultiLineComment = false;
                        delimIndex += 2;
                    }
                }
            }
            if (!inMultiLineComment && !inSingleLineComment && this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }

    private Space whitespace() {
        String prefix = this.source.substring(this.cursor, StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source));
        this.cursor += prefix.length();
        return Space.format((String)prefix);
    }

    private String skip(@Nullable String token) {
        if (token == null) {
            return null;
        }
        if (this.source.startsWith(token, this.cursor)) {
            this.cursor += token.length();
        }
        return token;
    }

    private <T extends TypeTree & org.openrewrite.java.tree.Expression> T typeTree(@Nullable ClassNode classNode) {
        return this.typeTree(classNode, false);
    }

    private <T extends TypeTree & org.openrewrite.java.tree.Expression> T typeTree(@Nullable ClassNode classNode, boolean inferredType) {
        if (classNode != null && classNode.isArray()) {
            return (T)this.arrayType(classNode);
        }
        Space prefix = this.whitespace();
        String maybeFullyQualified = this.name();
        String[] parts = maybeFullyQualified.split("\\.");
        String fullName = "";
        J.Identifier expr = null;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == 0) {
                fullName = part;
                expr = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), part, this.typeMapping.type((ASTNode)classNode), null);
                continue;
            }
            fullName = fullName + "." + part;
            Matcher whitespacePrefix = whitespacePrefixPattern.matcher(part);
            Space identFmt = whitespacePrefix.matches() ? Space.format((String)whitespacePrefix.group(0)) : Space.EMPTY;
            Matcher whitespaceSuffix = whitespaceSuffixPattern.matcher(part);
            whitespaceSuffix.matches();
            Space namePrefix = i == parts.length - 1 ? Space.EMPTY : Space.format((String)whitespaceSuffix.group(1));
            expr = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (org.openrewrite.java.tree.Expression)expr, this.padLeft(namePrefix, new J.Identifier(Tree.randomId(), identFmt, Markers.EMPTY, Collections.emptyList(), part.trim(), null, null)), (JavaType)(Character.isUpperCase(part.charAt(0)) || i == parts.length - 1 ? JavaType.ShallowClass.build((String)fullName) : null));
        }
        assert (expr != null);
        if (classNode != null && classNode.isUsingGenerics() && !classNode.isGenericsPlaceHolder()) {
            JContainer typeParameters = inferredType ? JContainer.build((Space)this.sourceBefore("<"), Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), this.sourceBefore(">"))), (Markers)Markers.EMPTY) : this.visitTypeParameterizations(classNode.getGenericsTypes());
            expr = new J.ParameterizedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (NameTree)expr, typeParameters, this.typeMapping.type((ASTNode)classNode));
        }
        return (T)((TypeTree)expr.withPrefix(prefix));
    }

    private TypeTree arrayType(ClassNode classNode) {
        ClassNode typeTree = classNode.getComponentType();
        int count = 1;
        while (typeTree.isArray()) {
            ++count;
            typeTree = typeTree.getComponentType();
        }
        Space prefix = this.whitespace();
        Object elemType = this.typeTree(typeTree);
        JLeftPadded<Space> dimension = this.sourceStartsWith("...") ? null : this.padLeft(this.sourceBefore("["), this.sourceBefore("]"));
        return new J.ArrayType(Tree.randomId(), prefix, Markers.EMPTY, count == 1 ? elemType : this.mapDimensions((TypeTree)elemType, classNode.getComponentType()), null, dimension, this.typeMapping.type((ASTNode)classNode));
    }

    private TypeTree mapDimensions(TypeTree baseType, ClassNode classNode) {
        if (classNode.isArray()) {
            Space prefix = this.whitespace();
            JLeftPadded<Space> dimension = this.padLeft(this.sourceBefore("["), this.sourceBefore("]"));
            return new J.ArrayType(Tree.randomId(), prefix, Markers.EMPTY, this.mapDimensions(baseType, classNode.getComponentType()), null, dimension, this.typeMapping.type((ASTNode)classNode));
        }
        return baseType;
    }

    private Space sourceBefore(String untilDelim) {
        int delimIndex = this.positionOfNext(untilDelim);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        if (delimIndex == this.cursor) {
            this.cursor += untilDelim.length();
            return Space.EMPTY;
        }
        Space space = Space.format((String)this.source, (int)this.cursor, (int)delimIndex);
        this.cursor = delimIndex + untilDelim.length();
        return space;
    }

    private boolean sourceStartsWith(String delimiter) {
        return this.source.startsWith(delimiter, StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source));
    }

    private boolean sourceStartsWith(String delimiter, String ... optionalSuffixes) {
        int whitespaceIndex = StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source);
        boolean startsWith = this.source.startsWith(delimiter, whitespaceIndex);
        if (startsWith) {
            for (String suffix : optionalSuffixes) {
                if (!this.source.startsWith(suffix, whitespaceIndex + delimiter.length())) continue;
                return true;
            }
            return optionalSuffixes.length == 0;
        }
        return false;
    }

    private boolean isEscaped(int index) {
        int backslashCount = 0;
        while (index >= 0 && this.source.charAt(index) == '\\') {
            ++backslashCount;
            --index;
        }
        return backslashCount % 2 != 0;
    }

    private String sourceSubstring(int beginIndex, String untilDelim) {
        int endIndex = this.source.indexOf(untilDelim, Math.max(beginIndex, this.cursor + untilDelim.length()));
        while (endIndex > 0 && this.isEscaped(endIndex - 1)) {
            endIndex = this.source.indexOf(untilDelim, endIndex + 1);
        }
        return this.source.substring(beginIndex, endIndex);
    }

    private @Nullable Integer getInsideParenthesesLevel(ASTNode node) {
        Object rawIpl = node.getNodeMetaData((Object)"_INSIDE_PARENTHESES_LEVEL");
        if (rawIpl instanceof AtomicInteger) {
            return ((AtomicInteger)rawIpl).get();
        }
        if (rawIpl instanceof Integer) {
            return (Integer)rawIpl;
        }
        if (GroovyParserVisitor.isOlderThanGroovy3()) {
            if (node instanceof ConstantExpression) {
                ConstantExpression expr = (ConstantExpression)node;
                return this.determineParenthesisLevel((ASTNode)expr, expr.getLineNumber(), expr.getLastLineNumber(), expr.getColumnNumber(), expr.getLastColumnNumber());
            }
            if (node instanceof ConstructorCallExpression) {
                ConstructorCallExpression expr = (ConstructorCallExpression)node;
                return this.determineParenthesisLevel((ASTNode)expr, expr.getArguments().getLineNumber(), expr.getLineNumber(), expr.getArguments().getColumnNumber(), expr.getColumnNumber()) - 1;
            }
            if (node instanceof BinaryExpression) {
                BinaryExpression expr = (BinaryExpression)node;
                return this.determineParenthesisLevel((ASTNode)expr, expr.getLeftExpression().getLineNumber(), expr.getLineNumber(), expr.getLeftExpression().getColumnNumber(), expr.getColumnNumber());
            }
        } else if (node instanceof MethodCallExpression) {
            MethodCallExpression expr = (MethodCallExpression)node;
            return this.determineParenthesisLevel((ASTNode)expr, expr.getObjectExpression().getLineNumber(), expr.getLineNumber(), expr.getObjectExpression().getColumnNumber(), expr.getColumnNumber());
        }
        return null;
    }

    private int determineParenthesisLevel(ASTNode node, int childLineNumber, int parentLineNumber, int childColumn, int parentColumn) {
        int endingColumn;
        int startingColumn;
        int endingLineNumber;
        int startingLineNumber;
        if (childLineNumber == parentLineNumber) {
            startingLineNumber = childLineNumber;
            endingLineNumber = childLineNumber;
            startingColumn = Math.min(childColumn, parentColumn);
            endingColumn = Math.max(childColumn, parentColumn);
        } else if (childLineNumber > parentLineNumber) {
            startingLineNumber = parentLineNumber;
            endingLineNumber = childLineNumber;
            startingColumn = parentColumn;
            endingColumn = childColumn;
        } else {
            startingLineNumber = childLineNumber;
            endingLineNumber = parentLineNumber;
            startingColumn = childColumn;
            endingColumn = parentColumn;
        }
        int start = this.sourceLineNumberOffsets[startingLineNumber - 1] + startingColumn - 1;
        int end = this.sourceLineNumberOffsets[endingLineNumber - 1] + endingColumn - 1;
        int count = 0;
        Delimiter delimiter = null;
        for (int i = start; i < end; ++i) {
            if (delimiter == null) {
                delimiter = this.getDelimiter(node, i);
                if (delimiter == null) {
                    if (this.source.charAt(i) == '(') {
                        ++count;
                        continue;
                    }
                    if (this.source.charAt(i) != ')' || node instanceof ConstantExpression) continue;
                    --count;
                    continue;
                }
                i += delimiter.open.length() - 1;
                continue;
            }
            if (!this.source.startsWith(delimiter.close, i)) continue;
            i += delimiter.close.length() - 1;
            delimiter = null;
        }
        return Math.max(count, 0);
    }

    private @Nullable Delimiter getDelimiter(ASTNode node, int cursor) {
        boolean isPatternOperator = this.source.startsWith("~", cursor);
        int c = cursor;
        if (isPatternOperator) {
            c = cursor + 1;
        }
        if (this.source.startsWith("$/", c)) {
            return isPatternOperator ? Delimiter.PATTERN_DOLLAR_SLASHY_STRING : Delimiter.DOLLAR_SLASHY_STRING;
        }
        if (this.source.startsWith("\"\"\"", c)) {
            return isPatternOperator ? Delimiter.PATTERN_TRIPLE_DOUBLE_QUOTE_STRING : Delimiter.TRIPLE_DOUBLE_QUOTE_STRING;
        }
        if (this.source.startsWith("'''", c)) {
            return isPatternOperator ? Delimiter.PATTERN_TRIPLE_SINGLE_QUOTE_STRING : Delimiter.TRIPLE_SINGLE_QUOTE_STRING;
        }
        if (this.source.startsWith("//", c)) {
            return Delimiter.SINGLE_LINE_COMMENT;
        }
        if (this.source.startsWith("/*", c)) {
            return Delimiter.MULTILINE_COMMENT;
        }
        if (this.source.startsWith("/", c) && this.validateIsDelimiter(node, c)) {
            return isPatternOperator ? Delimiter.PATTERN_SLASHY_STRING : Delimiter.SLASHY_STRING;
        }
        if (this.source.startsWith("\"", c)) {
            return isPatternOperator ? Delimiter.PATTERN_DOUBLE_QUOTE_STRING : Delimiter.DOUBLE_QUOTE_STRING;
        }
        if (this.source.startsWith("'", c)) {
            return isPatternOperator ? Delimiter.PATTERN_SINGLE_QUOTE_STRING : Delimiter.SINGLE_QUOTE_STRING;
        }
        if (this.source.startsWith("[", c)) {
            return Delimiter.ARRAY;
        }
        return null;
    }

    private boolean validateIsDelimiter(ASTNode node, int c) {
        FindBinaryOperationVisitor visitor = new FindBinaryOperationVisitor(this.source.substring(c, c + 1), c, this.sourceLineNumberOffsets);
        node.visit((GroovyCodeVisitor)visitor);
        return !visitor.isFound();
    }

    private TypeTree visitTypeTree(ClassNode classNode) {
        return this.visitTypeTree(classNode, false);
    }

    private TypeTree visitTypeTree(ClassNode classNode, boolean inferredType) {
        JavaType.Primitive primitiveType = JavaType.Primitive.fromKeyword((String)classNode.getUnresolvedName());
        if (primitiveType != null) {
            return new J.Primitive(Tree.randomId(), this.sourceBefore(classNode.getUnresolvedName()), Markers.EMPTY, primitiveType);
        }
        return this.typeTree(classNode, inferredType);
    }

    private List<J.Modifier> getModifiers() {
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        LinkedHashSet<String> possibleModifiers = new LinkedHashSet<String>(modifierNameToType.keySet());
        String currentModifier = possibleModifiers.stream().filter(this::sourceStartsWith).findFirst().orElse(null);
        while (currentModifier != null) {
            possibleModifiers.remove(currentModifier);
            modifiers.add(new J.Modifier(Tree.randomId(), this.whitespace(), Markers.EMPTY, currentModifier, modifierNameToType.get(currentModifier), Collections.emptyList()));
            this.skip(currentModifier);
            currentModifier = possibleModifiers.stream().filter(modifierName -> this.sourceStartsWith((String)modifierName, "\n", " ", ")")).findFirst().orElse(null);
        }
        return modifiers;
    }

    private <G2 extends J> JRightPadded<G2> maybeSemicolon(G2 g) {
        int saveCursor = this.cursor;
        Space beforeSemi = this.whitespace();
        Semicolon semicolon = null;
        if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == ';') {
            semicolon = new Semicolon(Tree.randomId());
            ++this.cursor;
        } else {
            beforeSemi = Space.EMPTY;
            this.cursor = saveCursor;
        }
        JRightPadded paddedG = JRightPadded.build(g).withAfter(beforeSemi);
        if (semicolon != null) {
            paddedG = paddedG.withMarkers(paddedG.getMarkers().add((Marker)semicolon));
        }
        return paddedG;
    }

    private String name() {
        int i;
        for (i = this.cursor; i < this.source.length(); ++i) {
            boolean isVarargs;
            char c = this.source.charAt(i);
            boolean bl = isVarargs = this.source.length() > i + 2 && c == '.' && this.source.charAt(i + 1) == '.' && this.source.charAt(i + 2) == '.';
            if (!Character.isJavaIdentifierPart(c) && c != '.' && c != '*' || isVarargs) break;
        }
        String result = this.source.substring(this.cursor, i);
        this.cursor += i - this.cursor;
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JContainer<org.openrewrite.java.tree.Expression> visitTypeParameterizations(GenericsType @Nullable [] genericsTypes) {
        List<Object> parameters;
        Space prefix = this.sourceBefore("<");
        if (genericsTypes == null) {
            Space paramPrefix = this.whitespace();
            if (this.source.charAt(this.cursor) == '>') {
                parameters = Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), paramPrefix, Markers.EMPTY)));
                return JContainer.build((Space)prefix, parameters, (Markers)Markers.EMPTY);
            }
            parameters = new ArrayList();
            while (true) {
                org.openrewrite.java.tree.Expression param = (org.openrewrite.java.tree.Expression)this.typeTree(null).withPrefix(paramPrefix);
                Space suffix = this.whitespace();
                parameters.add(JRightPadded.build((Object)param).withAfter(suffix));
                if (this.source.charAt(this.cursor) == '>') {
                    this.skip(">");
                    return JContainer.build((Space)prefix, parameters, (Markers)Markers.EMPTY);
                }
                ++this.cursor;
                paramPrefix = this.whitespace();
            }
        }
        parameters = new ArrayList<JRightPadded>(genericsTypes.length);
        for (int i = 0; i < genericsTypes.length; ++i) {
            parameters.add(JRightPadded.build((Object)this.visitTypeParameterization(genericsTypes[i])).withAfter(i < genericsTypes.length - 1 ? this.sourceBefore(",") : this.sourceBefore(">")));
        }
        return JContainer.build((Space)prefix, parameters, (Markers)Markers.EMPTY);
    }

    private org.openrewrite.java.tree.Expression visitTypeParameterization(GenericsType genericsType) {
        int saveCursor = this.cursor;
        Space prefix = this.whitespace();
        if (this.source.charAt(this.cursor) == '?') {
            this.skip("?");
            JLeftPadded<J.Wildcard.Bound> bound = null;
            TypeTree boundedType = null;
            if (genericsType.getUpperBounds() != null) {
                bound = this.padLeft(this.sourceBefore("extends"), J.Wildcard.Bound.Extends);
                boundedType = this.visitTypeTree(genericsType.getUpperBounds()[0]);
            } else if (genericsType.getLowerBound() != null) {
                bound = this.padLeft(this.sourceBefore("super"), J.Wildcard.Bound.Super);
                boundedType = this.visitTypeTree(genericsType.getLowerBound());
            }
            return new J.Wildcard(Tree.randomId(), prefix, Markers.EMPTY, bound, boundedType);
        }
        if (this.source.charAt(this.cursor) == '>') {
            this.skip(">");
            return new J.Empty(Tree.randomId(), prefix, Markers.EMPTY);
        }
        this.cursor = saveCursor;
        return (org.openrewrite.java.tree.Expression)this.typeTree(genericsType.getType()).withType(this.typeMapping.type((ASTNode)genericsType));
    }

    private JContainer<J.TypeParameter> visitTypeParameters(GenericsType[] genericsTypes) {
        Space prefix = this.sourceBefore("<");
        ArrayList<JRightPadded> typeParameters = new ArrayList<JRightPadded>(genericsTypes.length);
        for (int i = 0; i < genericsTypes.length; ++i) {
            typeParameters.add(JRightPadded.build((Object)this.visitTypeParameter(genericsTypes[i])).withAfter(i < genericsTypes.length - 1 ? this.sourceBefore(",") : this.sourceBefore(">")));
        }
        return JContainer.build((Space)prefix, typeParameters, (Markers)Markers.EMPTY);
    }

    private J.TypeParameter visitTypeParameter(GenericsType genericType) {
        Space prefix = this.whitespace();
        org.openrewrite.java.tree.Expression name = (org.openrewrite.java.tree.Expression)this.typeTree(null).withType(this.typeMapping.type((ASTNode)genericType));
        JContainer bounds = null;
        if (genericType.getUpperBounds() != null) {
            Space boundsPrefix = this.sourceBefore("extends");
            ClassNode[] upperBounds = genericType.getUpperBounds();
            ArrayList<JRightPadded> convertedBounds = new ArrayList<JRightPadded>(upperBounds.length);
            for (int i = 0; i < upperBounds.length; ++i) {
                convertedBounds.add(JRightPadded.build((Object)this.visitTypeTree(upperBounds[i])).withAfter(i < upperBounds.length - 1 ? this.sourceBefore("&") : Space.EMPTY));
            }
            bounds = JContainer.build((Space)boundsPrefix, convertedBounds, (Markers)Markers.EMPTY);
        } else if (genericType.getLowerBound() != null) {
            Space boundsPrefix = this.sourceBefore("super");
            ClassNode lowerBound = genericType.getLowerBound();
            ArrayList<JRightPadded> convertedBounds = new ArrayList<JRightPadded>(1);
            convertedBounds.add(JRightPadded.build((Object)this.visitTypeTree(lowerBound)).withAfter(Space.EMPTY));
            bounds = JContainer.build((Space)boundsPrefix, convertedBounds, (Markers)Markers.EMPTY);
        }
        return new J.TypeParameter(Tree.randomId(), prefix, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), name, bounds);
    }

    private boolean appearsInSource(ASTNode node) {
        if (node instanceof AnnotationNode) {
            String name = ((AnnotationNode)node).getClassNode().getUnresolvedName();
            String[] parts = name.split("\\.");
            return this.sourceStartsWith("@" + name) || this.sourceStartsWith("@" + parts[parts.length - 1]);
        }
        return node.getColumnNumber() >= 0 && node.getLineNumber() >= 0 && node.getLastColumnNumber() >= 0 && node.getLastLineNumber() >= 0;
    }

    private List<ImportNode> getStaticStarImports(ModuleNode ast) {
        ArrayList<ImportNode> completeStaticStarImports = new ArrayList<ImportNode>();
        Map staticStarImports = ast.getStaticStarImports();
        if (!staticStarImports.isEmpty()) {
            int importIndex;
            int lastLineNumber = -1;
            for (ImportNode anImport : ast.getStaticStarImports().values()) {
                lastLineNumber = Math.max(lastLineNumber, anImport.getLastLineNumber());
            }
            String importSource = this.sourceLineNumberOffsets.length <= lastLineNumber ? this.source : this.source.substring(0, this.sourceLineNumberOffsets[lastLineNumber]);
            importSource = GroovyParserVisitor.eraseComments(importSource);
            int offset = 0;
            int lineNo = 1;
            while (offset < importSource.length() && (importIndex = importSource.indexOf("import", offset)) != -1) {
                int packageBegin;
                int packageEnd;
                lineNo += StringUtils.countOccurrences((String)importSource.substring(offset, importIndex), (String)"\n");
                int maybeStaticIndex = StringUtils.indexOfNextNonWhitespace((int)(importIndex + 6), (String)importSource);
                if (!importSource.startsWith("static", maybeStaticIndex)) {
                    offset = importIndex + 6;
                    continue;
                }
                for (packageEnd = packageBegin = StringUtils.indexOfNextNonWhitespace((int)(maybeStaticIndex + 6), (String)importSource); packageEnd < importSource.length() && (Character.isJavaIdentifierPart(importSource.charAt(packageEnd)) || importSource.charAt(packageEnd) == '.'); ++packageEnd) {
                }
                if (packageEnd < importSource.length() && importSource.charAt(packageEnd) == '*') {
                    ImportNode node = new ImportNode(((ImportNode)staticStarImports.get(importSource.substring(packageBegin, packageEnd - 1))).getType());
                    node.setLineNumber(lineNo);
                    node.setColumnNumber(importIndex + 1);
                    completeStaticStarImports.add(node);
                }
                lineNo += StringUtils.countOccurrences((String)importSource.substring(importIndex, packageEnd), (String)"\n");
                offset = packageEnd;
            }
        }
        return completeStaticStarImports;
    }

    static String eraseComments(String importSource) {
        Matcher matcher = MULTILINE_COMMENT_REGEX.matcher(importSource);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group();
            String replacement = match.replaceAll("[^\\n]", " ");
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        String multiLineRemoved = sb.toString();
        return Arrays.stream(multiLineRemoved.split("\n", -1)).map(x -> x.split(Delimiter.SINGLE_LINE_COMMENT.open)[0]).collect(Collectors.joining("\n"));
    }

    private DeclarationExpression transformBackToDeclarationExpression(ConstantExpression expression) {
        int start;
        int end;
        String str = this.source.substring(this.cursor);
        int equalsIndex = str.indexOf("=");
        for (end = equalsIndex - 1; end >= 0 && Character.isWhitespace(str.charAt(end)); --end) {
        }
        for (start = end; start >= 0 && !Character.isWhitespace(str.charAt(start)); --start) {
        }
        int startX = StringUtils.indexOfNextNonWhitespace((int)(equalsIndex + 1), (String)str);
        int endX = startX;
        Delimiter delim = this.getDelimiter((ASTNode)expression, endX);
        if (delim != null) {
            endX = str.indexOf(delim.close, endX + delim.open.length()) + 1;
        } else {
            while (endX < str.length() && (Character.isJavaIdentifierPart(str.charAt(endX)) || str.charAt(endX) == ',' || str.charAt(endX) == '(' || str.charAt(endX) == ')')) {
                ++endX;
            }
        }
        VariableExpression left = new VariableExpression(str.substring(start + 1, end + 1));
        Token operation = new Token(100, "=", -1, -1);
        ConstantExpression right = new ConstantExpression((Object)str.substring(startX, endX));
        DeclarationExpression declarationExpression = new DeclarationExpression(left, operation, (Expression)right);
        declarationExpression.addAnnotations(Collections.singletonList(new AnnotationNode(new ClassNode(Field.class))));
        return declarationExpression;
    }

    private static ClassNode staticType(Expression expression) {
        ClassNode inferred = (ClassNode)expression.getNodeMetaData().get(StaticTypesMarker.INFERRED_TYPE);
        if (inferred == null) {
            return expression.getType();
        }
        return inferred;
    }

    private static ClassNode staticType(Variable variable) {
        if (variable instanceof Parameter) {
            return GroovyParserVisitor.staticType((Parameter)variable);
        }
        if (variable instanceof Expression) {
            return GroovyParserVisitor.staticType((Expression)variable);
        }
        return variable.getType();
    }

    private static ClassNode staticType(Parameter parameter) {
        ClassNode inferred = (ClassNode)parameter.getNodeMetaData().get(StaticTypesMarker.INFERRED_TYPE);
        if (inferred == null) {
            return parameter.getType();
        }
        return inferred;
    }

    static {
        modifierNameToType = new LinkedHashMap<String, J.Modifier.Type>();
        modifierNameToType.put("def", J.Modifier.Type.LanguageExtension);
        modifierNameToType.put("var", J.Modifier.Type.LanguageExtension);
        modifierNameToType.put("public", J.Modifier.Type.Public);
        modifierNameToType.put("protected", J.Modifier.Type.Protected);
        modifierNameToType.put("private", J.Modifier.Type.Private);
        modifierNameToType.put("abstract", J.Modifier.Type.Abstract);
        modifierNameToType.put("static", J.Modifier.Type.Static);
        modifierNameToType.put("final", J.Modifier.Type.Final);
        modifierNameToType.put("volatile", J.Modifier.Type.Volatile);
        modifierNameToType.put("synchronized", J.Modifier.Type.Synchronized);
        modifierNameToType.put("transient", J.Modifier.Type.Transient);
        modifierNameToType.put("native", J.Modifier.Type.Native);
        modifierNameToType.put("default", J.Modifier.Type.Default);
        modifierNameToType.put("strictfp", J.Modifier.Type.Strictfp);
    }

    private static final class LineColumn
    implements Comparable<LineColumn> {
        private final int line;
        private final int column;

        @Override
        public int compareTo(@org.jspecify.annotations.NonNull LineColumn lc) {
            return this.line != lc.line ? this.line - lc.line : this.column - lc.column;
        }

        @Generated
        public LineColumn(int line, int column) {
            this.line = line;
            this.column = column;
        }

        @Generated
        public int getLine() {
            return this.line;
        }

        @Generated
        public int getColumn() {
            return this.column;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LineColumn)) {
                return false;
            }
            LineColumn other = (LineColumn)o;
            if (this.getLine() != other.getLine()) {
                return false;
            }
            return this.getColumn() == other.getColumn();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLine();
            result = result * 59 + this.getColumn();
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "GroovyParserVisitor.LineColumn(line=" + this.getLine() + ", column=" + this.getColumn() + ")";
        }
    }

    private class RewriteGroovyClassVisitor
    extends ClassCodeVisitorSupport {
        private final SourceUnit sourceUnit;
        private final Queue<Object> queue = new LinkedList<Object>();

        public void visitClass(ClassNode clazz) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            List<J.Annotation> leadingAnnotations = GroovyParserVisitor.this.visitAndGetAnnotations((AnnotatedNode)clazz, this);
            List modifiers = GroovyParserVisitor.this.getModifiers();
            Space kindPrefix = GroovyParserVisitor.this.whitespace();
            J.ClassDeclaration.Kind.Type kindType = null;
            if (GroovyParserVisitor.this.sourceStartsWith("class")) {
                kindType = J.ClassDeclaration.Kind.Type.Class;
                GroovyParserVisitor.this.skip("class");
            } else if (GroovyParserVisitor.this.sourceStartsWith("interface")) {
                kindType = J.ClassDeclaration.Kind.Type.Interface;
                GroovyParserVisitor.this.skip("interface");
            } else if (GroovyParserVisitor.this.sourceStartsWith("@interface")) {
                kindType = J.ClassDeclaration.Kind.Type.Annotation;
                GroovyParserVisitor.this.skip("@interface");
            } else if (GroovyParserVisitor.this.sourceStartsWith("enum")) {
                kindType = J.ClassDeclaration.Kind.Type.Enum;
                GroovyParserVisitor.this.skip("enum");
            }
            assert (kindType != null);
            J.ClassDeclaration.Kind kind = new J.ClassDeclaration.Kind(Tree.randomId(), kindPrefix, Markers.EMPTY, Collections.emptyList(), kindType);
            J.Identifier name = new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, Collections.emptyList(), GroovyParserVisitor.this.name(), GroovyParserVisitor.this.typeMapping.type((ASTNode)clazz), null);
            JContainer typeParameterContainer = null;
            if (clazz.isUsingGenerics() && clazz.getGenericsTypes() != null) {
                typeParameterContainer = GroovyParserVisitor.this.visitTypeParameters(clazz.getGenericsTypes());
            }
            JLeftPadded extendings = null;
            if (kindType == J.ClassDeclaration.Kind.Type.Class && GroovyParserVisitor.this.sourceStartsWith("extends")) {
                extendings = GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("extends"), GroovyParserVisitor.this.visitTypeTree(clazz.getSuperClass()));
            }
            JContainer implementings = null;
            if (clazz.getInterfaces().length > 0) {
                Space implPrefix = kindType == J.ClassDeclaration.Kind.Type.Interface || kindType == J.ClassDeclaration.Kind.Type.Annotation ? GroovyParserVisitor.this.sourceBefore("extends") : GroovyParserVisitor.this.sourceBefore("implements");
                ArrayList<JRightPadded> implTypes = new ArrayList<JRightPadded>(clazz.getInterfaces().length);
                ClassNode[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    ClassNode anInterface = interfaces[i];
                    if (kindType == J.ClassDeclaration.Kind.Type.Annotation && Annotation.class.getName().equals(anInterface.getName())) continue;
                    implTypes.add(JRightPadded.build((Object)GroovyParserVisitor.this.visitTypeTree(anInterface)).withAfter(i == interfaces.length - 1 ? Space.EMPTY : GroovyParserVisitor.this.sourceBefore(",")));
                }
                if (!implTypes.isEmpty()) {
                    implementings = JContainer.build((Space)implPrefix, implTypes, (Markers)Markers.EMPTY);
                }
            }
            this.queue.add(new J.ClassDeclaration(Tree.randomId(), fmt, Markers.EMPTY, leadingAnnotations, modifiers, kind, name, typeParameterContainer, null, extendings, implementings, null, this.visitClassBlock(clazz), TypeUtils.asFullyQualified((JavaType)GroovyParserVisitor.this.typeMapping.type((ASTNode)clazz))));
        }

        J.Block visitClassBlock(ClassNode clazz) {
            TreeMap<LineColumn, Object> sortedByPosition = new TreeMap<LineColumn, Object>();
            for (MethodNode method : clazz.getMethods()) {
                if (method.isSynthetic()) {
                    if (!"<clinit>".equals(method.getName()) || !(method.getCode() instanceof BlockStatement) || ((BlockStatement)method.getCode()).getStatements().size() != 1) continue;
                    org.codehaus.groovy.ast.stmt.Statement statement = (org.codehaus.groovy.ast.stmt.Statement)((BlockStatement)method.getCode()).getStatements().get(0);
                    sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)statement), statement);
                    continue;
                }
                if (!method.getAnnotations(new ClassNode(groovy.transform.Generated.class)).isEmpty()) continue;
                sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)method), method);
            }
            for (Object objectInitializer : clazz.getObjectInitializerStatements()) {
                if (!(objectInitializer instanceof BlockStatement)) continue;
                BlockStatement s = (BlockStatement)objectInitializer;
                if (s.getStatements().size() == 1 && GroovyParserVisitor.pos((ASTNode)s).equals(GroovyParserVisitor.pos((ASTNode)s.getStatements().get(0)))) {
                    s = (BlockStatement)s.getStatements().get(0);
                }
                sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)s), s);
            }
            HashSet<InnerClassNode> fieldInitializers = new HashSet<InnerClassNode>();
            for (FieldNode field : clazz.getFields()) {
                ConstructorCallExpression cce;
                if (!GroovyParserVisitor.this.appearsInSource((ASTNode)field)) continue;
                if (field.hasInitialExpression() && field.getInitialExpression() instanceof ConstructorCallExpression && (cce = (ConstructorCallExpression)field.getInitialExpression()).isUsingAnonymousInnerClass() && cce.getType() instanceof InnerClassNode) {
                    fieldInitializers.add((InnerClassNode)cce.getType());
                }
                sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)field), field);
            }
            for (ConstructorNode ctor : clazz.getDeclaredConstructors()) {
                if (!GroovyParserVisitor.this.appearsInSource((ASTNode)ctor)) continue;
                sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)ctor), ctor);
            }
            Iterator innerClassIterator = clazz.getInnerClasses();
            while (innerClassIterator.hasNext()) {
                InnerClassNode icn = (InnerClassNode)innerClassIterator.next();
                if (icn.isSynthetic() || fieldInitializers.contains(icn)) continue;
                sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)icn), icn);
            }
            return new J.Block(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("{"), Markers.EMPTY, JRightPadded.build((Object)false), sortedByPosition.values().stream().filter(ast -> !(ast instanceof InnerClassNode) || !((InnerClassNode)ast).isAnonymous()).map(ast -> {
                if (ast instanceof FieldNode) {
                    this.visitField((FieldNode)ast);
                } else if (ast instanceof MethodNode) {
                    this.visitMethod((MethodNode)ast);
                } else if (ast instanceof ClassNode) {
                    this.visitClass((ClassNode)ast);
                } else if (ast instanceof BlockStatement) {
                    this.visitBlockStatement((BlockStatement)ast);
                }
                Statement stat = (Statement)this.pollQueue();
                return GroovyParserVisitor.this.maybeSemicolon((J)stat);
            }).collect(Collectors.toList()), GroovyParserVisitor.this.sourceBefore("}"));
        }

        public void visitBlockStatement(BlockStatement statement) {
            this.queue.add(new RewriteGroovyVisitor((ASTNode)statement, this).visit((ASTNode)statement));
        }

        public void visitField(FieldNode field) {
            if ((field.getModifiers() & 0x4000) != 0) {
                this.visitEnumField(field);
            } else {
                this.visitVariableField(field);
            }
        }

        private void visitEnumField(FieldNode fieldNode) {
            throw new UnsupportedOperationException("enum fields are not implemented.");
        }

        private void visitVariableField(FieldNode field) {
            RewriteGroovyVisitor visitor = new RewriteGroovyVisitor((ASTNode)field, this);
            List<J.Annotation> annotations = GroovyParserVisitor.this.visitAndGetAnnotations((AnnotatedNode)field, this);
            List modifiers = GroovyParserVisitor.this.getModifiers();
            TypeTree typeExpr = field.isDynamicTyped() ? null : GroovyParserVisitor.this.visitTypeTree(field.getOriginType());
            J.Identifier name = new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(field.getName()), Markers.EMPTY, Collections.emptyList(), field.getName(), GroovyParserVisitor.this.typeMapping.type((ASTNode)field.getOriginType()), GroovyParserVisitor.this.typeMapping.variableType(field));
            J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), name.getPrefix(), Markers.EMPTY, (VariableDeclarator)name.withPrefix(Space.EMPTY), Collections.emptyList(), null, GroovyParserVisitor.this.typeMapping.variableType(field));
            if (field.getInitialExpression() != null) {
                Space beforeAssign = GroovyParserVisitor.this.sourceBefore("=");
                org.openrewrite.java.tree.Expression initializer = (org.openrewrite.java.tree.Expression)visitor.visit((ASTNode)field.getInitialExpression());
                namedVariable = namedVariable.getPadding().withInitializer(GroovyParserVisitor.this.padLeft(beforeAssign, initializer));
            }
            J.VariableDeclarations variableDeclarations = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, annotations, modifiers, typeExpr, null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)namedVariable)));
            this.queue.add(variableDeclarations);
        }

        protected void visitAnnotation(AnnotationNode annotation) {
            GroovyParserVisitor.this.visitAnnotation(annotation, this);
        }

        public void visitMethod(MethodNode method) {
            int i;
            String methodName;
            Space fmt = GroovyParserVisitor.this.whitespace();
            List<J.Annotation> annotations = GroovyParserVisitor.this.visitAndGetAnnotations((AnnotatedNode)method, this);
            List modifiers = GroovyParserVisitor.this.getModifiers();
            boolean isConstructorOfInnerNonStaticClass = false;
            J.TypeParameters typeParameters = null;
            if (method.getGenericsTypes() != null) {
                Space prefix = GroovyParserVisitor.this.sourceBefore("<");
                GenericsType[] genericsTypes = method.getGenericsTypes();
                ArrayList<JRightPadded> typeParametersList = new ArrayList<JRightPadded>(genericsTypes.length);
                for (int i2 = 0; i2 < genericsTypes.length; ++i2) {
                    typeParametersList.add(JRightPadded.build((Object)GroovyParserVisitor.this.visitTypeParameter(genericsTypes[i2])).withAfter(i2 < genericsTypes.length - 1 ? GroovyParserVisitor.this.sourceBefore(",") : GroovyParserVisitor.this.sourceBefore(">")));
                }
                typeParameters = new J.TypeParameters(Tree.randomId(), prefix, Markers.EMPTY, Collections.emptyList(), typeParametersList);
            }
            TypeTree returnType = method instanceof ConstructorNode || method.isDynamicReturnType() ? null : GroovyParserVisitor.this.visitTypeTree(method.getReturnType());
            Space namePrefix = GroovyParserVisitor.this.whitespace();
            if (method instanceof ConstructorNode) {
                isConstructorOfInnerNonStaticClass = method.getDeclaringClass() instanceof InnerClassNode && (method.getDeclaringClass().getModifiers() & 8) == 0;
                methodName = method.getDeclaringClass().getNameWithoutPackage().replaceFirst(".*\\$", "");
            } else if (GroovyParserVisitor.this.source.startsWith(method.getName(), GroovyParserVisitor.this.cursor)) {
                methodName = method.getName();
            } else {
                char openingQuote = GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor);
                methodName = openingQuote + method.getName() + openingQuote;
            }
            GroovyParserVisitor.this.cursor += methodName.length();
            J.Identifier name = new J.Identifier(Tree.randomId(), namePrefix, Markers.EMPTY, Collections.emptyList(), methodName, null, null);
            RewriteGroovyVisitor bodyVisitor = new RewriteGroovyVisitor((ASTNode)method, this);
            Space beforeParen = GroovyParserVisitor.this.sourceBefore("(");
            ArrayList<JRightPadded> params = new ArrayList<JRightPadded>(method.getParameters().length);
            Parameter[] unparsedParams = method.getParameters();
            int n = i = isConstructorOfInnerNonStaticClass ? 1 : 0;
            while (i < unparsedParams.length) {
                Parameter param = unparsedParams[i];
                List<J.Annotation> paramAnnotations = GroovyParserVisitor.this.visitAndGetAnnotations((AnnotatedNode)param, this);
                List paramModifiers = GroovyParserVisitor.this.getModifiers();
                J.Identifier paramType = param.isDynamicTyped() ? new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "", (JavaType)JavaType.ShallowClass.build((String)"java.lang.Object"), null) : GroovyParserVisitor.this.visitTypeTree(param.getOriginType());
                Space varargs = null;
                if (paramType instanceof J.ArrayType && GroovyParserVisitor.this.sourceStartsWith("...")) {
                    int varargStart = StringUtils.indexOfNextNonWhitespace((int)GroovyParserVisitor.this.cursor, (String)GroovyParserVisitor.this.source);
                    varargs = Space.format((String)GroovyParserVisitor.this.source, (int)GroovyParserVisitor.this.cursor, (int)varargStart);
                    GroovyParserVisitor.this.cursor = varargStart + 3;
                }
                JRightPadded paramName = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (VariableDeclarator)new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, Collections.emptyList(), param.getName(), null, null), Collections.emptyList(), null, null));
                GroovyParserVisitor.this.skip(param.getName());
                Expression defaultValue = param.getInitialExpression();
                if (defaultValue != null) {
                    paramName = paramName.withElement((Object)((J.VariableDeclarations.NamedVariable)paramName.getElement()).getPadding().withInitializer(new JLeftPadded(GroovyParserVisitor.this.sourceBefore("="), (Object)((org.openrewrite.java.tree.Expression)new RewriteGroovyVisitor((ASTNode)defaultValue, this).visit((ASTNode)defaultValue)), Markers.EMPTY)));
                }
                Space rightPad = GroovyParserVisitor.this.sourceBefore(i == unparsedParams.length - 1 ? ")" : ",");
                params.add(JRightPadded.build((Object)new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, paramAnnotations, paramModifiers, (TypeTree)paramType, varargs, Collections.emptyList(), Collections.singletonList(paramName))).withAfter(rightPad));
                ++i;
            }
            if (unparsedParams.length == 0 || isConstructorOfInnerNonStaticClass && unparsedParams.length == 1) {
                params.add(JRightPadded.build((Object)new J.Empty(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(")"), Markers.EMPTY)));
            }
            JContainer throws_ = method.getExceptions().length == 0 ? null : JContainer.build((Space)GroovyParserVisitor.this.sourceBefore("throws"), (List)bodyVisitor.visitRightPadded((ASTNode[])method.getExceptions(), null), (Markers)Markers.EMPTY);
            J.Block body = null;
            if (method.getCode() != null) {
                BlockStatement code = isConstructorOfInnerNonStaticClass ? new BlockStatement(((BlockStatement)method.getCode()).getStatements().subList(2, ((BlockStatement)method.getCode()).getStatements().size()), ((BlockStatement)method.getCode()).getVariableScope()) : method.getCode();
                body = (J.Block)bodyVisitor.visit((ASTNode)code);
            }
            this.queue.add(new J.MethodDeclaration(Tree.randomId(), fmt, Markers.EMPTY, annotations, modifiers, typeParameters, returnType, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), JContainer.build((Space)beforeParen, params, (Markers)Markers.EMPTY), throws_, body, null, GroovyParserVisitor.this.typeMapping.methodType(method)));
        }

        private <T> T pollQueue() {
            return (T)this.queue.poll();
        }

        @Generated
        public RewriteGroovyClassVisitor(SourceUnit sourceUnit) {
            this.sourceUnit = sourceUnit;
        }

        @Generated
        public SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }
    }

    private class RewriteGroovyVisitor
    extends CodeVisitorSupport {
        private Cursor nodeCursor;
        private final Queue<Object> queue = new LinkedList<Object>();
        private final RewriteGroovyClassVisitor classVisitor;

        public RewriteGroovyVisitor(ASTNode root, RewriteGroovyClassVisitor classVisitor) {
            this.nodeCursor = new Cursor(null, (Object)root);
            this.classVisitor = classVisitor;
        }

        private <T> T visit(ASTNode node) {
            this.nodeCursor = new Cursor(this.nodeCursor, (Object)node);
            node.visit((GroovyCodeVisitor)this);
            this.nodeCursor = this.nodeCursor.getParentOrThrow();
            return this.pollQueue();
        }

        private <T> List<JRightPadded<T>> visitRightPadded(ASTNode[] nodes, @Nullable String afterLast) {
            ArrayList<JRightPadded<T>> ts = new ArrayList<JRightPadded<T>>(nodes.length);
            for (int i = 0; i < nodes.length; ++i) {
                ASTNode node = nodes[i];
                JRightPadded converted = JRightPadded.build(node instanceof ClassNode ? GroovyParserVisitor.this.visitTypeTree((ClassNode)node) : this.visit(node));
                if (i == nodes.length - 1) {
                    converted = converted.withAfter(GroovyParserVisitor.this.whitespace());
                    if (',' == GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor)) {
                        GroovyParserVisitor.this.skip(",");
                        converted = converted.withMarkers(Markers.EMPTY.add((Marker)new TrailingComma(Tree.randomId(), GroovyParserVisitor.this.whitespace())));
                    }
                    ts.add(converted);
                    GroovyParserVisitor.this.skip(afterLast);
                    continue;
                }
                ts.add(converted.withAfter(GroovyParserVisitor.this.sourceBefore(",")));
            }
            return ts;
        }

        private org.openrewrite.java.tree.Expression insideParentheses(ASTNode node, Function<Space, org.openrewrite.java.tree.Expression> parenthesizedTree) {
            Integer insideParenthesesLevel = GroovyParserVisitor.this.getInsideParenthesesLevel(node);
            if (insideParenthesesLevel != null) {
                Stack<Space> openingParens = new Stack<Space>();
                for (int i = 0; i < insideParenthesesLevel; ++i) {
                    openingParens.push(GroovyParserVisitor.this.sourceBefore("("));
                }
                org.openrewrite.java.tree.Expression parenthesized = parenthesizedTree.apply(GroovyParserVisitor.this.whitespace());
                for (int i = 0; i < insideParenthesesLevel; ++i) {
                    parenthesized = new J.Parentheses(Tree.randomId(), (Space)openingParens.pop(), Markers.EMPTY, GroovyParserVisitor.this.padRight(parenthesized, GroovyParserVisitor.this.sourceBefore(")")));
                }
                return parenthesized;
            }
            return parenthesizedTree.apply(GroovyParserVisitor.this.whitespace());
        }

        private Statement labeled(org.codehaus.groovy.ast.stmt.Statement statement, Supplier<Statement> labeledTree) {
            ArrayList<J.Label> labels = null;
            if (statement.getStatementLabels() != null && !statement.getStatementLabels().isEmpty()) {
                labels = new ArrayList<J.Label>(statement.getStatementLabels().size());
                for (int i = 0; i < statement.getStatementLabels().size(); ++i) {
                    labels.add(new J.Label(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, JRightPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), GroovyParserVisitor.this.name(), null, null)).withAfter(GroovyParserVisitor.this.sourceBefore(":")), (Statement)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)));
                }
            }
            Statement s = labeledTree.get();
            if (labels != null) {
                return this.condenseLabels(labels, s);
            }
            return s;
        }

        public void visitArrayExpression(ArrayExpression expression) {
            Space prefix = GroovyParserVisitor.this.whitespace();
            GroovyParserVisitor.this.skip("new");
            TypeTree typeTree = GroovyParserVisitor.this.visitTypeTree(expression.getElementType());
            List<J.ArrayDimension> dimensions = this.buildNewArrayDimensions(expression);
            JContainer<org.openrewrite.java.tree.Expression> initializer = this.buildNewArrayInitializer(expression);
            this.queue.add(new J.NewArray(Tree.randomId(), prefix, Markers.EMPTY, typeTree, dimensions, initializer, GroovyParserVisitor.this.typeMapping.type((ASTNode)expression.getElementType())));
        }

        private JContainer<org.openrewrite.java.tree.Expression> buildNewArrayInitializer(ArrayExpression expression) {
            List expressions;
            if (expression.getSizeExpression() != null) {
                return null;
            }
            Space fmt = GroovyParserVisitor.this.sourceBefore("{");
            if (expression.getExpressions().isEmpty()) {
                expressions = Collections.singletonList(GroovyParserVisitor.this.padRight(new J.Empty(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("}"), Markers.EMPTY), Space.EMPTY));
            } else {
                expressions = this.convertAll(expression.getExpressions(), n -> GroovyParserVisitor.this.sourceBefore(","), n -> GroovyParserVisitor.this.whitespace(), n -> {
                    if (n == expression.getExpression(expression.getExpressions().size() - 1) && GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ',') {
                        GroovyParserVisitor.this.cursor++;
                        return Markers.build(Collections.singletonList(new TrailingComma(Tree.randomId(), GroovyParserVisitor.this.whitespace())));
                    }
                    return Markers.EMPTY;
                });
                GroovyParserVisitor.this.skip("}");
            }
            return JContainer.build((Space)fmt, expressions, (Markers)Markers.EMPTY);
        }

        private List<J.ArrayDimension> buildNewArrayDimensions(ArrayExpression expression) {
            ArrayList<J.ArrayDimension> dimensions = new ArrayList<J.ArrayDimension>();
            for (int i = 0; expression.getSizeExpression() != null && i < expression.getSizeExpression().size(); ++i) {
                dimensions.add(new J.ArrayDimension(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("["), Markers.EMPTY, GroovyParserVisitor.this.padRight((org.openrewrite.java.tree.Expression)this.visit((ASTNode)expression.getSizeExpression().get(i)), GroovyParserVisitor.this.sourceBefore("]"))));
            }
            while (true) {
                int beginBracket = StringUtils.indexOfNextNonWhitespace((int)GroovyParserVisitor.this.cursor, (String)GroovyParserVisitor.this.source);
                if (GroovyParserVisitor.this.source.charAt(beginBracket) != '[') break;
                int endBracket = StringUtils.indexOfNextNonWhitespace((int)(beginBracket + 1), (String)GroovyParserVisitor.this.source);
                dimensions.add(new J.ArrayDimension(Tree.randomId(), Space.format((String)GroovyParserVisitor.this.source, (int)GroovyParserVisitor.this.cursor, (int)beginBracket), Markers.EMPTY, GroovyParserVisitor.this.padRight(new J.Empty(Tree.randomId(), Space.format((String)GroovyParserVisitor.this.source, (int)(beginBracket + 1), (int)endBracket), Markers.EMPTY), Space.EMPTY)));
                GroovyParserVisitor.this.cursor = endBracket + 1;
            }
            return dimensions;
        }

        public void visitArgumentlistExpression(ArgumentListExpression expression) {
            MapExpression namedArgExpressions;
            ArrayList<JRightPadded> args = new ArrayList<JRightPadded>(expression.getExpressions().size());
            int saveCursor = GroovyParserVisitor.this.cursor;
            Space beforeOpenParen = GroovyParserVisitor.this.whitespace();
            boolean hasParentheses = true;
            if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                GroovyParserVisitor.this.skip("(");
            } else {
                hasParentheses = false;
                beforeOpenParen = Space.EMPTY;
                GroovyParserVisitor.this.cursor = saveCursor;
            }
            List unparsedArgs = expression.getExpressions().stream().filter(x$0 -> GroovyParserVisitor.this.appearsInSource(x$0)).collect(Collectors.toList());
            if (unparsedArgs.size() > 1 && unparsedArgs.get(0) instanceof MapExpression && (((Expression)unparsedArgs.get(0)).getLastLineNumber() > ((Expression)unparsedArgs.get(1)).getLastLineNumber() || ((Expression)unparsedArgs.get(0)).getLastLineNumber() == ((Expression)unparsedArgs.get(1)).getLastLineNumber() && ((Expression)unparsedArgs.get(0)).getLastColumnNumber() > ((Expression)unparsedArgs.get(1)).getLastColumnNumber())) {
                namedArgExpressions = (MapExpression)unparsedArgs.get(0);
                unparsedArgs = ListUtils.concatAll(unparsedArgs.subList(1, unparsedArgs.size()), (List)namedArgExpressions.getMapEntryExpressions()).stream().sorted(Comparator.comparing(ASTNode::getLastLineNumber).thenComparing(ASTNode::getLastColumnNumber)).collect(Collectors.toList());
            } else if (!unparsedArgs.isEmpty() && unparsedArgs.get(0) instanceof MapExpression) {
                saveCursor = GroovyParserVisitor.this.cursor;
                GroovyParserVisitor.this.whitespace();
                if ('[' != GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor)) {
                    namedArgExpressions = (MapExpression)unparsedArgs.get(0);
                    unparsedArgs = Stream.concat(namedArgExpressions.getMapEntryExpressions().stream(), unparsedArgs.subList(1, unparsedArgs.size()).stream()).collect(Collectors.toList());
                }
                GroovyParserVisitor.this.cursor = saveCursor;
            }
            if (unparsedArgs.isEmpty()) {
                args.add(JRightPadded.build((Object)new J.Empty(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY)).withAfter(hasParentheses ? GroovyParserVisitor.this.sourceBefore(")") : Space.EMPTY));
            } else {
                boolean lastArgumentsAreAllClosures = this.endsWithClosures(expression.getExpressions());
                for (int i = 0; i < unparsedArgs.size(); ++i) {
                    Expression rawArg = (Expression)unparsedArgs.get(i);
                    org.openrewrite.java.tree.Expression arg = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)rawArg);
                    if (!hasParentheses) {
                        arg = (org.openrewrite.java.tree.Expression)arg.withMarkers(arg.getMarkers().add((Marker)new OmitParentheses(Tree.randomId())));
                    }
                    Space after = Space.EMPTY;
                    if (i == unparsedArgs.size() - 1) {
                        if (hasParentheses) {
                            after = GroovyParserVisitor.this.sourceBefore(")");
                        }
                    } else if (!(arg instanceof J.Lambda) || !lastArgumentsAreAllClosures || hasParentheses) {
                        after = GroovyParserVisitor.this.whitespace();
                        if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ')') {
                            hasParentheses = false;
                        }
                        GroovyParserVisitor.this.cursor++;
                    }
                    args.add(JRightPadded.build((Object)arg).withAfter(after));
                }
            }
            this.queue.add(JContainer.build((Space)beforeOpenParen, args, (Markers)Markers.EMPTY));
        }

        public boolean endsWithClosures(List<Expression> list) {
            if (!(list.get(list.size() - 1) instanceof ClosureExpression)) {
                return false;
            }
            boolean foundNonClosure = false;
            for (int i = list.size() - 2; i >= 0; --i) {
                if (list.get(i) instanceof ClosureExpression) {
                    if (!foundNonClosure) continue;
                    return false;
                }
                foundNonClosure = true;
            }
            return true;
        }

        public void visitClassExpression(ClassExpression clazz) {
            Space prefix = GroovyParserVisitor.this.whitespace();
            String name = clazz.getType().getUnresolvedName().replace('$', '.');
            if (!GroovyParserVisitor.this.source.startsWith(name, GroovyParserVisitor.this.cursor)) {
                name = clazz.getType().getNameWithoutPackage().replace('$', '.');
            }
            GroovyParserVisitor.this.skip(name);
            if (GroovyParserVisitor.this.sourceStartsWith(".class")) {
                String classSuffix = GroovyParserVisitor.this.source.substring(GroovyParserVisitor.this.cursor, StringUtils.indexOfNextNonWhitespace((int)GroovyParserVisitor.this.cursor, (String)GroovyParserVisitor.this.source)) + ".class";
                name = name + classSuffix;
                GroovyParserVisitor.this.skip(classSuffix);
            }
            this.queue.add(TypeTree.build((String)name).withType(GroovyParserVisitor.this.typeMapping.type((ASTNode)clazz.getType())).withPrefix(prefix));
        }

        public void visitAssertStatement(AssertStatement statement) {
            Space prefix = GroovyParserVisitor.this.whitespace();
            GroovyParserVisitor.this.skip("assert");
            org.openrewrite.java.tree.Expression condition = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)statement.getBooleanExpression());
            JLeftPadded message = null;
            if (!(statement.getMessageExpression() instanceof ConstantExpression) || !((ConstantExpression)statement.getMessageExpression()).isNullExpression()) {
                Space messagePrefix = GroovyParserVisitor.this.whitespace();
                GroovyParserVisitor.this.skip(":");
                message = GroovyParserVisitor.this.padLeft(messagePrefix, (org.openrewrite.java.tree.Expression)this.visit((ASTNode)statement.getMessageExpression()));
            }
            this.queue.add(new J.Assert(Tree.randomId(), prefix, Markers.EMPTY, condition, message));
        }

        public void visitBinaryExpression(BinaryExpression binary) {
            this.queue.add(this.insideParentheses((ASTNode)binary, fmt -> {
                org.openrewrite.java.tree.Expression left = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)binary.getLeftExpression());
                Space opPrefix = GroovyParserVisitor.this.whitespace();
                boolean assignment = false;
                boolean instanceOf = false;
                J.AssignmentOperation.Type assignOp = null;
                J.Binary.Type binaryOp = null;
                G.Binary.Type gBinaryOp = null;
                switch (binary.getOperation().getText()) {
                    case "+": {
                        binaryOp = J.Binary.Type.Addition;
                        break;
                    }
                    case "&&": {
                        binaryOp = J.Binary.Type.And;
                        break;
                    }
                    case "&": {
                        binaryOp = J.Binary.Type.BitAnd;
                        break;
                    }
                    case "|": {
                        binaryOp = J.Binary.Type.BitOr;
                        break;
                    }
                    case "^": {
                        binaryOp = J.Binary.Type.BitXor;
                        break;
                    }
                    case "/": {
                        binaryOp = J.Binary.Type.Division;
                        break;
                    }
                    case "==": {
                        binaryOp = J.Binary.Type.Equal;
                        break;
                    }
                    case ">": {
                        binaryOp = J.Binary.Type.GreaterThan;
                        break;
                    }
                    case ">=": {
                        binaryOp = J.Binary.Type.GreaterThanOrEqual;
                        break;
                    }
                    case "<<": {
                        binaryOp = J.Binary.Type.LeftShift;
                        break;
                    }
                    case "<": {
                        binaryOp = J.Binary.Type.LessThan;
                        break;
                    }
                    case "<=": {
                        binaryOp = J.Binary.Type.LessThanOrEqual;
                        break;
                    }
                    case "%": {
                        binaryOp = J.Binary.Type.Modulo;
                        break;
                    }
                    case "*": {
                        binaryOp = J.Binary.Type.Multiplication;
                        break;
                    }
                    case "!=": {
                        binaryOp = J.Binary.Type.NotEqual;
                        break;
                    }
                    case "||": {
                        binaryOp = J.Binary.Type.Or;
                        break;
                    }
                    case ">>": {
                        binaryOp = J.Binary.Type.RightShift;
                        break;
                    }
                    case "-": {
                        binaryOp = J.Binary.Type.Subtraction;
                        break;
                    }
                    case ">>>": {
                        binaryOp = J.Binary.Type.UnsignedRightShift;
                        break;
                    }
                    case "instanceof": {
                        instanceOf = true;
                        break;
                    }
                    case "=": {
                        assignment = true;
                        break;
                    }
                    case "+=": {
                        assignOp = J.AssignmentOperation.Type.Addition;
                        break;
                    }
                    case "-=": {
                        assignOp = J.AssignmentOperation.Type.Subtraction;
                        break;
                    }
                    case "&=": {
                        assignOp = J.AssignmentOperation.Type.BitAnd;
                        break;
                    }
                    case "|=": {
                        assignOp = J.AssignmentOperation.Type.BitOr;
                        break;
                    }
                    case "^=": {
                        assignOp = J.AssignmentOperation.Type.BitXor;
                        break;
                    }
                    case "/=": {
                        assignOp = J.AssignmentOperation.Type.Division;
                        break;
                    }
                    case "<<=": {
                        assignOp = J.AssignmentOperation.Type.LeftShift;
                        break;
                    }
                    case "%=": {
                        assignOp = J.AssignmentOperation.Type.Modulo;
                        break;
                    }
                    case "*=": {
                        assignOp = J.AssignmentOperation.Type.Multiplication;
                        break;
                    }
                    case ">>=": {
                        assignOp = J.AssignmentOperation.Type.RightShift;
                        break;
                    }
                    case ">>>=": {
                        assignOp = J.AssignmentOperation.Type.UnsignedRightShift;
                        break;
                    }
                    case "=~": {
                        gBinaryOp = G.Binary.Type.Find;
                        break;
                    }
                    case "==~": {
                        gBinaryOp = G.Binary.Type.Match;
                        break;
                    }
                    case "[": {
                        gBinaryOp = G.Binary.Type.Access;
                        break;
                    }
                    case "in": {
                        gBinaryOp = G.Binary.Type.In;
                        break;
                    }
                    case "!in": {
                        gBinaryOp = G.Binary.Type.NotIn;
                        break;
                    }
                    case "<=>": {
                        gBinaryOp = G.Binary.Type.Spaceship;
                    }
                }
                GroovyParserVisitor.this.cursor += binary.getOperation().getText().length();
                org.openrewrite.java.tree.Expression right = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)binary.getRightExpression());
                if (assignment) {
                    return new J.Assignment(Tree.randomId(), fmt, Markers.EMPTY, left, JLeftPadded.build((Object)right).withBefore(opPrefix), GroovyParserVisitor.this.typeMapping.type((ASTNode)binary.getType()));
                }
                if (instanceOf) {
                    return new J.InstanceOf(Tree.randomId(), fmt, Markers.EMPTY, JRightPadded.build((Object)left).withAfter(opPrefix), (J)right, null, GroovyParserVisitor.this.typeMapping.type((ASTNode)binary.getType()));
                }
                if (assignOp != null) {
                    return new J.AssignmentOperation(Tree.randomId(), fmt, Markers.EMPTY, left, JLeftPadded.build((Object)assignOp).withBefore(opPrefix), right, GroovyParserVisitor.this.typeMapping.type((ASTNode)binary.getType()));
                }
                if (binaryOp != null) {
                    return new J.Binary(Tree.randomId(), fmt, Markers.EMPTY, left, JLeftPadded.build((Object)binaryOp).withBefore(opPrefix), right, GroovyParserVisitor.this.typeMapping.type((ASTNode)binary.getType()));
                }
                if (gBinaryOp != null) {
                    Space after = Space.EMPTY;
                    if (gBinaryOp == G.Binary.Type.Access) {
                        after = GroovyParserVisitor.this.sourceBefore("]");
                    }
                    return new G.Binary(Tree.randomId(), (Space)fmt, Markers.EMPTY, left, (JLeftPadded<G.Binary.Type>)JLeftPadded.build((Object)((Object)gBinaryOp)).withBefore(opPrefix), right, after, GroovyParserVisitor.this.typeMapping.type((ASTNode)binary.getType()));
                }
                throw new IllegalStateException("Unknown binary expression " + binary.getClass().getSimpleName());
            }));
        }

        public void visitBlockStatement(BlockStatement block) {
            boolean withinClosure;
            Space fmt = Space.EMPTY;
            Space staticInitPadding = Space.EMPTY;
            boolean isStaticInit = GroovyParserVisitor.this.sourceStartsWith("static");
            Object parent = this.nodeCursor.getParentOrThrow().getValue();
            boolean bl = withinClosure = parent instanceof ClosureExpression || parent instanceof ExpressionStatement && ((ExpressionStatement)parent).getExpression() instanceof ClosureExpression;
            if (isStaticInit) {
                fmt = GroovyParserVisitor.this.sourceBefore("static");
                staticInitPadding = GroovyParserVisitor.this.whitespace();
                GroovyParserVisitor.this.skip("{");
            } else if (!withinClosure) {
                fmt = GroovyParserVisitor.this.sourceBefore("{");
            }
            ArrayList<JRightPadded> statements = new ArrayList<JRightPadded>(block.getStatements().size());
            List blockStatements = block.getStatements();
            for (int i = 0; i < blockStatements.size(); ++i) {
                ASTNode statement = (ASTNode)blockStatements.get(i);
                J expr = (J)this.visit(statement);
                if (i == blockStatements.size() - 1 && expr instanceof org.openrewrite.java.tree.Expression && (parent instanceof ClosureExpression || parent instanceof MethodNode && JavaType.Primitive.Void != GroovyParserVisitor.this.typeMapping.type((ASTNode)((MethodNode)parent).getReturnType()))) {
                    expr = new J.Return(Tree.randomId(), expr.getPrefix(), Markers.EMPTY, (org.openrewrite.java.tree.Expression)expr.withPrefix(Space.EMPTY));
                    expr = (J)expr.withMarkers(expr.getMarkers().add((Marker)new ImplicitReturn(Tree.randomId())));
                }
                JRightPadded stat = JRightPadded.build((Object)((Statement)expr));
                int saveCursor = GroovyParserVisitor.this.cursor;
                Space beforeSemicolon = GroovyParserVisitor.this.whitespace();
                if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ';') {
                    stat = stat.withMarkers(stat.getMarkers().add((Marker)new Semicolon(Tree.randomId()))).withAfter(beforeSemicolon);
                    GroovyParserVisitor.this.skip(";");
                } else {
                    GroovyParserVisitor.this.cursor = saveCursor;
                }
                statements.add(stat);
            }
            this.queue.add(new J.Block(Tree.randomId(), fmt, Markers.EMPTY, new JRightPadded((Object)isStaticInit, staticInitPadding, Markers.EMPTY), statements, GroovyParserVisitor.this.whitespace()));
            if (!withinClosure) {
                GroovyParserVisitor.this.skip("}");
            }
        }

        public void visitCatchStatement(CatchStatement node) {
            Space prefix = GroovyParserVisitor.this.sourceBefore("catch");
            Space parenPrefix = GroovyParserVisitor.this.sourceBefore("(");
            Parameter param = node.getVariable();
            Space paramPrefix = GroovyParserVisitor.this.whitespace();
            Object paramType = Exception.class.getName().equals(param.getType().getName()) && !GroovyParserVisitor.this.source.startsWith("Exception", GroovyParserVisitor.this.cursor) && !GroovyParserVisitor.this.source.startsWith("java.lang.Exception", GroovyParserVisitor.this.cursor) ? new J.Identifier(Tree.randomId(), paramPrefix, Markers.EMPTY, Collections.emptyList(), "", (JavaType)JavaType.ShallowClass.build((String)Exception.class.getName()), null) : (TypeTree)GroovyParserVisitor.this.visitTypeTree(param.getOriginType()).withPrefix(paramPrefix);
            JRightPadded paramName = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, (VariableDeclarator)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), param.getName(), null, null), Collections.emptyList(), null, null));
            GroovyParserVisitor.this.cursor += param.getName().length();
            Space rightPad = GroovyParserVisitor.this.whitespace();
            GroovyParserVisitor.this.skip(")");
            JRightPadded variable = JRightPadded.build((Object)new J.VariableDeclarations(Tree.randomId(), paramType.getPrefix(), Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), (TypeTree)paramType.withPrefix(Space.EMPTY), null, Collections.emptyList(), Collections.singletonList(paramName))).withAfter(rightPad);
            J.ControlParentheses catchControl = new J.ControlParentheses(Tree.randomId(), parenPrefix, Markers.EMPTY, variable);
            this.queue.add(new J.Try.Catch(Tree.randomId(), prefix, Markers.EMPTY, catchControl, (J.Block)this.visit((ASTNode)node.getCode())));
        }

        public void visitBreakStatement(BreakStatement statement) {
            this.queue.add(new J.Break(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("break"), Markers.EMPTY, statement.getLabel() == null ? null : new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(statement.getLabel()), Markers.EMPTY, Collections.emptyList(), statement.getLabel(), null, null)));
        }

        public void visitCaseStatement(CaseStatement statement) {
            this.queue.add(new J.Case(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("case"), Markers.EMPTY, J.Case.Type.Statement, null, JContainer.build(Collections.singletonList(JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)statement.getExpression()))))), null, null, statement.getCode() instanceof EmptyStatement ? JContainer.build((Space)GroovyParserVisitor.this.sourceBefore(":"), this.convertStatements(Collections.emptyList()), (Markers)Markers.EMPTY) : JContainer.build((Space)GroovyParserVisitor.this.sourceBefore(":"), this.convertStatements(((BlockStatement)statement.getCode()).getStatements()), (Markers)Markers.EMPTY), null));
        }

        private J.Case visitDefaultCaseStatement(BlockStatement statement) {
            return new J.Case(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("default"), Markers.EMPTY, J.Case.Type.Statement, null, JContainer.build(Collections.singletonList(JRightPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), GroovyParserVisitor.this.skip("default"), null, null)))), null, null, JContainer.build((Space)GroovyParserVisitor.this.sourceBefore(":"), this.convertStatements(statement.getStatements()), (Markers)Markers.EMPTY), null);
        }

        public void visitCastExpression(CastExpression cast) {
            this.queue.add(this.insideParentheses((ASTNode)cast, prefix -> {
                if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                    GroovyParserVisitor.this.skip("(");
                    return new J.TypeCast(Tree.randomId(), prefix, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded((Object)GroovyParserVisitor.this.visitTypeTree(cast.getType()), GroovyParserVisitor.this.sourceBefore(")"), Markers.EMPTY)), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)cast.getExpression()));
                }
                org.openrewrite.java.tree.Expression expr = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)cast.getExpression());
                Space asPrefix = GroovyParserVisitor.this.sourceBefore("as");
                return new J.TypeCast(Tree.randomId(), prefix, new Markers(Tree.randomId(), Collections.singletonList(new AsStyleTypeCast(Tree.randomId()))), new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded((Object)GroovyParserVisitor.this.visitTypeTree(cast.getType()), asPrefix, Markers.EMPTY)), expr);
            }));
        }

        public void visitClosureExpression(ClosureExpression expression) {
            List<Object> paramExprs;
            Space prefix = GroovyParserVisitor.this.whitespace();
            LambdaStyle ls = new LambdaStyle(Tree.randomId(), expression instanceof LambdaExpression, true);
            boolean parenthesized = false;
            if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                parenthesized = true;
                GroovyParserVisitor.this.skip("(");
            } else if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '{') {
                GroovyParserVisitor.this.skip("{");
            }
            JavaType closureType = GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType((Expression)expression));
            if (expression.getParameters() != null && expression.getParameters().length > 0) {
                paramExprs = new ArrayList(expression.getParameters().length);
                Parameter[] parameters = expression.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter p = parameters[i];
                    JavaType type = GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType(p));
                    J.VariableDeclarations expr = new J.VariableDeclarations(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), p.isDynamicTyped() ? null : GroovyParserVisitor.this.visitTypeTree(p.getType()), null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(p.getName()), Markers.EMPTY, (VariableDeclarator)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), p.getName(), type, null), Collections.emptyList(), null, GroovyParserVisitor.this.typeMapping.variableType(p.getName(), (ASTNode)GroovyParserVisitor.staticType(p))))));
                    JRightPadded param = JRightPadded.build((Object)expr);
                    param = i != parameters.length - 1 ? param.withAfter(GroovyParserVisitor.this.sourceBefore(",")) : param.withAfter(GroovyParserVisitor.this.whitespace());
                    paramExprs.add(param);
                }
            } else {
                Space argPrefix = Space.EMPTY;
                if (parenthesized) {
                    argPrefix = GroovyParserVisitor.this.whitespace();
                }
                paramExprs = Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), argPrefix, Markers.EMPTY)));
            }
            if (parenthesized) {
                GroovyParserVisitor.this.cursor += 1;
            }
            J.Lambda.Parameters params = new J.Lambda.Parameters(Tree.randomId(), Space.EMPTY, Markers.EMPTY, parenthesized, paramExprs);
            int saveCursor = GroovyParserVisitor.this.cursor;
            Space arrowPrefix = GroovyParserVisitor.this.whitespace();
            if (GroovyParserVisitor.this.source.startsWith("->", GroovyParserVisitor.this.cursor)) {
                GroovyParserVisitor.this.skip("->");
            } else {
                ls = ls.withArrow(false);
                GroovyParserVisitor.this.cursor = saveCursor;
                arrowPrefix = Space.EMPTY;
            }
            J body = (J)this.visit((ASTNode)expression.getCode());
            this.queue.add(new J.Lambda(Tree.randomId(), prefix, Markers.build(Collections.singletonList(ls)), params, arrowPrefix, body, closureType));
            GroovyParserVisitor.this.skip("}");
        }

        public void visitClosureListExpression(ClosureListExpression closureListExpression) {
            List expressions = closureListExpression.getExpressions();
            ArrayList<JRightPadded> results = new ArrayList<JRightPadded>(closureListExpression.getExpressions().size());
            int expressionsSize = expressions.size();
            for (int i = 0; i < expressionsSize; ++i) {
                results.add(JRightPadded.build(this.visit((ASTNode)expressions.get(i))).withAfter(GroovyParserVisitor.this.whitespace()));
                if (i >= expressionsSize - 1) continue;
                GroovyParserVisitor.this.cursor++;
            }
            this.queue.add(results);
        }

        public void visitConstantExpression(ConstantExpression expression) {
            if (GroovyParserVisitor.this.sourceStartsWith("@" + Field.class.getSimpleName()) || GroovyParserVisitor.this.sourceStartsWith("@" + Field.class.getCanonicalName())) {
                this.visitDeclarationExpression(GroovyParserVisitor.this.transformBackToDeclarationExpression(expression));
                return;
            }
            this.queue.add(this.insideParentheses((ASTNode)expression, fmt -> {
                JavaType.Primitive jType;
                String text = expression.getText();
                Object value = expression.getValue();
                ClassNode type = expression.getType();
                if (type == ClassHelper.BigDecimal_TYPE) {
                    jType = JavaType.Primitive.Double;
                    value = ((BigDecimal)value).doubleValue();
                } else if (type == ClassHelper.boolean_TYPE) {
                    jType = JavaType.Primitive.Boolean;
                } else if (type == ClassHelper.byte_TYPE) {
                    jType = JavaType.Primitive.Byte;
                } else if (type == ClassHelper.char_TYPE) {
                    jType = JavaType.Primitive.Char;
                } else if (type == ClassHelper.double_TYPE || Double.class.getName().equals(type.getName())) {
                    jType = JavaType.Primitive.Double;
                    if (expression.getNodeMetaData().get("_FLOATING_POINT_LITERAL_TEXT") instanceof String) {
                        text = (String)expression.getNodeMetaData().get("_FLOATING_POINT_LITERAL_TEXT");
                    }
                } else if (type == ClassHelper.float_TYPE || Float.class.getName().equals(type.getName())) {
                    jType = JavaType.Primitive.Float;
                    if (expression.getNodeMetaData().get("_FLOATING_POINT_LITERAL_TEXT") instanceof String) {
                        text = (String)expression.getNodeMetaData().get("_FLOATING_POINT_LITERAL_TEXT");
                    }
                } else if (type == ClassHelper.int_TYPE || Integer.class.getName().equals(type.getName())) {
                    jType = JavaType.Primitive.Int;
                    if (expression.getNodeMetaData().get("_INTEGER_LITERAL_TEXT") instanceof String) {
                        text = (String)expression.getNodeMetaData().get("_INTEGER_LITERAL_TEXT");
                    }
                } else if (type == ClassHelper.long_TYPE || Long.class.getName().equals(type.getName())) {
                    if (expression.getNodeMetaData().get("_INTEGER_LITERAL_TEXT") instanceof String) {
                        text = (String)expression.getNodeMetaData().get("_INTEGER_LITERAL_TEXT");
                    }
                    jType = JavaType.Primitive.Long;
                } else if (type == ClassHelper.short_TYPE || Short.class.getName().equals(type.getName())) {
                    jType = JavaType.Primitive.Short;
                } else if (type == ClassHelper.STRING_TYPE) {
                    jType = JavaType.Primitive.String;
                    if (GroovyParserVisitor.this.source.startsWith("@" + value, GroovyParserVisitor.this.cursor)) {
                        value = "@" + value;
                        text = "@" + text;
                    } else {
                        Delimiter delimiter = GroovyParserVisitor.this.getDelimiter((ASTNode)expression, GroovyParserVisitor.this.cursor);
                        if (delimiter != null) {
                            value = GroovyParserVisitor.this.sourceSubstring(GroovyParserVisitor.this.cursor + delimiter.open.length(), delimiter.close);
                            text = delimiter.open + value + delimiter.close;
                        }
                    }
                } else if (expression.isNullExpression()) {
                    text = GroovyParserVisitor.this.source.startsWith("null", GroovyParserVisitor.this.cursor) ? "null" : "";
                    jType = JavaType.Primitive.Null;
                } else {
                    throw new IllegalStateException("Unexpected constant type " + type);
                }
                if (GroovyParserVisitor.this.cursor < GroovyParserVisitor.this.source.length() && GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '+' && !text.startsWith("+")) {
                    text = "+" + text;
                }
                GroovyParserVisitor.this.cursor += text.length();
                if ((jType == JavaType.Primitive.Long || jType == JavaType.Primitive.Float || jType == JavaType.Primitive.Double) && (GroovyParserVisitor.this.source.startsWith("L", GroovyParserVisitor.this.cursor) || GroovyParserVisitor.this.source.startsWith("f", GroovyParserVisitor.this.cursor) || GroovyParserVisitor.this.source.startsWith("d", GroovyParserVisitor.this.cursor))) {
                    text = text + GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor);
                    GroovyParserVisitor.this.cursor++;
                }
                return new J.Literal(Tree.randomId(), fmt, Markers.EMPTY, value, text, null, jType);
            }));
        }

        public void visitConstructorCallExpression(ConstructorCallExpression ctor) {
            this.queue.add(this.insideParentheses((ASTNode)ctor, fmt -> {
                if (ctor.getType() == ClassNode.SUPER || ctor.getType() == ClassNode.THIS) {
                    MethodNode methodNode = (MethodNode)ctor.getNodeMetaData().get(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                    return new J.MethodInvocation(Tree.randomId(), fmt, Markers.EMPTY, null, null, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), GroovyParserVisitor.this.skip(ctor.getType() == ClassNode.SUPER ? "super" : "this"), null, null), (JContainer)this.visit((ASTNode)ctor.getArguments()), GroovyParserVisitor.this.typeMapping.methodType(methodNode));
                }
                GroovyParserVisitor.this.skip("new");
                TypeTree clazz = GroovyParserVisitor.this.visitTypeTree(ctor.getType(), ctor.getNodeMetaData().containsKey(StaticTypesMarker.INFERRED_TYPE));
                JContainer args = (JContainer)this.visit((ASTNode)ctor.getArguments());
                J.Block body = null;
                if (ctor.isUsingAnonymousInnerClass() && ctor.getType() instanceof InnerClassNode) {
                    body = this.classVisitor.visitClassBlock(ctor.getType());
                }
                MethodNode methodNode = (MethodNode)ctor.getNodeMetaData().get(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                return new J.NewClass(Tree.randomId(), fmt, Markers.EMPTY, null, Space.EMPTY, clazz, args, body, GroovyParserVisitor.this.typeMapping.methodType(methodNode));
            }));
        }

        public void visitContinueStatement(ContinueStatement statement) {
            this.queue.add(new J.Continue(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("continue"), Markers.EMPTY, statement.getLabel() == null ? null : new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(statement.getLabel()), Markers.EMPTY, Collections.emptyList(), statement.getLabel(), null, null)));
        }

        public void visitNotExpression(NotExpression expression) {
            this.queue.add(this.insideParentheses((ASTNode)expression, fmt -> {
                GroovyParserVisitor.this.skip("!");
                JLeftPadded op = GroovyParserVisitor.this.padLeft(Space.EMPTY, J.Unary.Type.Not);
                org.openrewrite.java.tree.Expression expr = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)expression.getExpression());
                return new J.Unary(Tree.randomId(), fmt, Markers.EMPTY, op, expr, GroovyParserVisitor.this.typeMapping.type((ASTNode)expression.getType()));
            }));
        }

        public void visitDeclarationExpression(DeclarationExpression expression) {
            Space prefix = GroovyParserVisitor.this.whitespace();
            List<J.Annotation> leadingAnnotations = GroovyParserVisitor.this.visitAndGetAnnotations((AnnotatedNode)expression, this.classVisitor);
            Optional<MultiVariable> multiVariable = this.maybeMultiVariable();
            List modifiers = GroovyParserVisitor.this.getModifiers();
            TypeTree typeExpr = this.visitVariableExpressionType(expression.getVariableExpression());
            if (expression.isMultipleAssignmentDeclaration()) {
                throw new UnsupportedOperationException("Parsing multiple assignment (e.g.: def (a, b) = [1, 2]) is not implemented");
            }
            J.Identifier name = (J.Identifier)this.visit((ASTNode)expression.getVariableExpression());
            J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), name.getPrefix(), Markers.EMPTY, (VariableDeclarator)name.withPrefix(Space.EMPTY), Collections.emptyList(), null, GroovyParserVisitor.this.typeMapping.variableType(name.getSimpleName(), typeExpr.getType()));
            if (!(expression.getRightExpression() instanceof EmptyExpression)) {
                Space beforeAssign = GroovyParserVisitor.this.sourceBefore("=");
                org.openrewrite.java.tree.Expression initializer = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)expression.getRightExpression());
                namedVariable = namedVariable.getPadding().withInitializer(GroovyParserVisitor.this.padLeft(beforeAssign, initializer));
            }
            J.VariableDeclarations variableDeclarations = new J.VariableDeclarations(Tree.randomId(), prefix, Markers.EMPTY, leadingAnnotations, modifiers, typeExpr, null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)namedVariable)));
            if (multiVariable.isPresent()) {
                variableDeclarations = variableDeclarations.withMarkers(variableDeclarations.getMarkers().add((Marker)multiVariable.get()));
            }
            this.queue.add(variableDeclarations);
        }

        private Optional<MultiVariable> maybeMultiVariable() {
            int saveCursor = GroovyParserVisitor.this.cursor;
            Space commaPrefix = GroovyParserVisitor.this.whitespace();
            if (GroovyParserVisitor.this.source.startsWith(",", GroovyParserVisitor.this.cursor)) {
                GroovyParserVisitor.this.skip(",");
                return Optional.of(new MultiVariable(Tree.randomId(), commaPrefix));
            }
            GroovyParserVisitor.this.cursor = saveCursor;
            return Optional.empty();
        }

        public void visitEmptyExpression(EmptyExpression expression) {
            this.queue.add(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY));
        }

        public void visitExpressionStatement(ExpressionStatement statement) {
            this.queue.add(this.labeled((org.codehaus.groovy.ast.stmt.Statement)statement, () -> {
                super.visitExpressionStatement(statement);
                Object e = this.queue.poll();
                if (e instanceof Statement) {
                    return (Statement)e;
                }
                return new G.ExpressionStatement(Tree.randomId(), (org.openrewrite.java.tree.Expression)e);
            }));
        }

        Statement condenseLabels(List<J.Label> labels, Statement s) {
            if (labels.isEmpty()) {
                return s;
            }
            return labels.get(0).withStatement(this.condenseLabels(labels.subList(1, labels.size()), s));
        }

        public void visitForLoop(ForStatement forLoop) {
            this.queue.add(this.labeled((org.codehaus.groovy.ast.stmt.Statement)forLoop, () -> {
                Space prefix = GroovyParserVisitor.this.sourceBefore("for");
                Space controlFmt = GroovyParserVisitor.this.sourceBefore("(");
                if (forLoop.getCollectionExpression() instanceof ClosureListExpression) {
                    List controls = (List)this.visit((ASTNode)forLoop.getCollectionExpression());
                    List init = ((JRightPadded)controls.get(0)).getElement() instanceof List ? (List)((JRightPadded)controls.get(0)).getElement() : Collections.singletonList((JRightPadded)controls.get(0));
                    JRightPadded condition = (JRightPadded)controls.get(1);
                    List update = ((JRightPadded)controls.get(2)).getElement() instanceof List ? (List)((JRightPadded)controls.get(2)).getElement() : Collections.singletonList((JRightPadded)controls.get(2));
                    GroovyParserVisitor.this.skip(")");
                    return new J.ForLoop(Tree.randomId(), prefix, Markers.EMPTY, new J.ForLoop.Control(Tree.randomId(), controlFmt, Markers.EMPTY, init, condition, update), JRightPadded.build((Object)((Statement)this.visit((ASTNode)forLoop.getLoopBlock()))));
                }
                Parameter param = forLoop.getVariable();
                Space paramFmt = GroovyParserVisitor.this.whitespace();
                List modifiers = GroovyParserVisitor.this.getModifiers();
                TypeTree paramType = param.getOriginType().getColumnNumber() >= 0 ? GroovyParserVisitor.this.visitTypeTree(param.getOriginType()) : null;
                JRightPadded paramName = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, (VariableDeclarator)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), param.getName(), null, null), Collections.emptyList(), null, null));
                GroovyParserVisitor.this.cursor += param.getName().length();
                Space rightPad = GroovyParserVisitor.this.whitespace();
                Markers forEachMarkers = Markers.EMPTY;
                if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ':') {
                    GroovyParserVisitor.this.skip(":");
                } else {
                    GroovyParserVisitor.this.skip("in");
                    forEachMarkers = forEachMarkers.add((Marker)new InStyleForEachLoop(Tree.randomId()));
                }
                JRightPadded variable = JRightPadded.build((Object)new J.VariableDeclarations(Tree.randomId(), paramFmt, Markers.EMPTY, Collections.emptyList(), modifiers, paramType, null, Collections.emptyList(), Collections.singletonList(paramName))).withAfter(rightPad);
                JRightPadded iterable = JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)forLoop.getCollectionExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")"));
                return new J.ForEachLoop(Tree.randomId(), prefix, forEachMarkers, new J.ForEachLoop.Control(Tree.randomId(), controlFmt, Markers.EMPTY, variable, iterable), JRightPadded.build((Object)((Statement)this.visit((ASTNode)forLoop.getLoopBlock()))));
            }));
        }

        public void visitIfElse(IfStatement ifElse) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("if");
            J.ControlParentheses ifCondition = new J.ControlParentheses(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)ifElse.getBooleanExpression().getExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")")));
            JRightPadded then = GroovyParserVisitor.this.maybeSemicolon((J)((Statement)this.visit((ASTNode)ifElse.getIfBlock())));
            J.If.Else else_ = ifElse.getElseBlock() instanceof EmptyStatement ? null : new J.If.Else(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("else"), Markers.EMPTY, GroovyParserVisitor.this.maybeSemicolon((J)((Statement)this.visit((ASTNode)ifElse.getElseBlock()))));
            this.queue.add(new J.If(Tree.randomId(), fmt, Markers.EMPTY, ifCondition, then, else_));
        }

        public void visitGStringExpression(GStringExpression gstring) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            Delimiter delimiter = GroovyParserVisitor.this.getDelimiter((ASTNode)gstring, GroovyParserVisitor.this.cursor);
            GroovyParserVisitor.this.skip(delimiter.open);
            TreeMap<LineColumn, ConstantExpression> sortedByPosition = new TreeMap<LineColumn, ConstantExpression>();
            for (ConstantExpression e : gstring.getStrings()) {
                if (e.getText().isEmpty()) continue;
                sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)e), e);
            }
            for (ConstantExpression e : gstring.getValues()) {
                sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)e), e);
            }
            ArrayList rawExprs = new ArrayList(sortedByPosition.values());
            ArrayList<J> strings = new ArrayList<J>(rawExprs.size());
            for (int i = 0; i < rawExprs.size(); ++i) {
                Expression e = (Expression)rawExprs.get(i);
                if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '$') {
                    boolean inCurlies;
                    GroovyParserVisitor.this.skip("$");
                    boolean bl = inCurlies = GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '{';
                    if (inCurlies) {
                        GroovyParserVisitor.this.skip("{");
                    } else {
                        GroovyParserVisitor.this.columnOffset--;
                    }
                    strings.add(new G.GString.Value(Tree.randomId(), Markers.EMPTY, (J)this.visit((ASTNode)e), inCurlies ? GroovyParserVisitor.this.sourceBefore("}") : Space.EMPTY, inCurlies));
                    if (inCurlies) continue;
                    GroovyParserVisitor.this.columnOffset++;
                    continue;
                }
                if (e instanceof ConstantExpression) {
                    String value = GroovyParserVisitor.this.sourceSubstring(GroovyParserVisitor.this.cursor, delimiter.close);
                    int indexNextSign = GroovyParserVisitor.this.source.indexOf("$", GroovyParserVisitor.this.cursor);
                    while (indexNextSign > 0 && GroovyParserVisitor.this.source.charAt(indexNextSign - 1) == '\\') {
                        indexNextSign = GroovyParserVisitor.this.source.indexOf("$", indexNextSign + 1);
                    }
                    if (indexNextSign != -1 && indexNextSign < GroovyParserVisitor.this.cursor + value.length()) {
                        value = GroovyParserVisitor.this.source.substring(GroovyParserVisitor.this.cursor, indexNextSign);
                    }
                    strings.add((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)value, value, null, JavaType.Primitive.String));
                    GroovyParserVisitor.this.skip(value);
                    continue;
                }
                strings.add((J)this.visit((ASTNode)e));
            }
            this.queue.add(new G.GString(Tree.randomId(), fmt, Markers.EMPTY, delimiter.open, strings, GroovyParserVisitor.this.typeMapping.type((ASTNode)gstring.getType())));
            GroovyParserVisitor.this.skip(delimiter.close);
        }

        public void visitListExpression(ListExpression list) {
            this.queue.add(this.insideParentheses((ASTNode)list, fmt -> {
                GroovyParserVisitor.this.skip("[");
                if (list.getExpressions().isEmpty()) {
                    return new G.ListLiteral(Tree.randomId(), (Space)fmt, Markers.EMPTY, (JContainer<org.openrewrite.java.tree.Expression>)JContainer.build(Collections.singletonList(new JRightPadded((Object)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), GroovyParserVisitor.this.sourceBefore("]"), Markers.EMPTY))), GroovyParserVisitor.this.typeMapping.type((ASTNode)list.getType()));
                }
                return new G.ListLiteral(Tree.randomId(), (Space)fmt, Markers.EMPTY, (JContainer<org.openrewrite.java.tree.Expression>)JContainer.build(this.visitRightPadded(list.getExpressions().toArray(new ASTNode[0]), "]")), GroovyParserVisitor.this.typeMapping.type((ASTNode)list.getType()));
            }));
        }

        public void visitMapEntryExpression(MapEntryExpression expression) {
            G.MapEntry mapEntry = new G.MapEntry(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, (JRightPadded<org.openrewrite.java.tree.Expression>)JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)expression.getKeyExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(":")), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)expression.getValueExpression()), null);
            this.queue.add(mapEntry);
        }

        public void visitMapExpression(MapExpression map) {
            this.queue.add(this.insideParentheses((ASTNode)map, fmt -> {
                GroovyParserVisitor.this.skip("[");
                JContainer entries = map.getMapEntryExpressions().isEmpty() ? JContainer.build(Collections.singletonList(JRightPadded.build((Object)new G.MapEntry(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, (JRightPadded<org.openrewrite.java.tree.Expression>)JRightPadded.build((Object)new J.Empty(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(":"), Markers.EMPTY)), (org.openrewrite.java.tree.Expression)new J.Empty(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("]"), Markers.EMPTY), null)))) : JContainer.build(this.visitRightPadded(map.getMapEntryExpressions().toArray(new ASTNode[0]), "]"));
                return new G.MapLiteral(Tree.randomId(), (Space)fmt, Markers.EMPTY, (JContainer<G.MapEntry>)entries, GroovyParserVisitor.this.typeMapping.type((ASTNode)map.getType()));
            }));
        }

        public void visitMethodCallExpression(MethodCallExpression call) {
            this.queue.add(this.insideParentheses((ASTNode)call, fmt -> {
                ArgumentListExpression args;
                J.Identifier name;
                ImplicitDot implicitDot = null;
                JRightPadded select = null;
                if (!call.isImplicitThis()) {
                    org.openrewrite.java.tree.Expression selectExpr = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)call.getObjectExpression());
                    int saveCursor = GroovyParserVisitor.this.cursor;
                    Space afterSelect = GroovyParserVisitor.this.whitespace();
                    if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '.' || GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '?' || GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '*') {
                        GroovyParserVisitor.this.cursor = saveCursor;
                        afterSelect = GroovyParserVisitor.this.sourceBefore(call.isSpreadSafe() ? "*." : (call.isSafe() ? "?." : "."));
                    } else {
                        implicitDot = new ImplicitDot(Tree.randomId());
                    }
                    select = JRightPadded.build((Object)selectExpr).withAfter(afterSelect);
                }
                String methodNameExpression = call.getMethodAsString();
                if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '\"' || GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '\'') {
                    methodNameExpression = GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) + methodNameExpression + GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor);
                }
                Space prefix = GroovyParserVisitor.this.whitespace();
                if (methodNameExpression.equals(GroovyParserVisitor.this.source.substring(GroovyParserVisitor.this.cursor, GroovyParserVisitor.this.cursor + methodNameExpression.length()))) {
                    GroovyParserVisitor.this.skip(methodNameExpression);
                    name = new J.Identifier(Tree.randomId(), prefix, Markers.EMPTY, Collections.emptyList(), methodNameExpression, null, null);
                } else if (select != null && select.getElement() instanceof J.Identifier) {
                    name = (J.Identifier)select.getElement();
                    select = null;
                } else {
                    throw new IllegalArgumentException("Unable to parse method call");
                }
                if (call.isSpreadSafe()) {
                    name = name.withMarkers(name.getMarkers().add((Marker)new StarDot(Tree.randomId())));
                }
                if (call.isSafe()) {
                    name = name.withMarkers(name.getMarkers().add((Marker)new NullSafe(Tree.randomId())));
                }
                if (implicitDot != null) {
                    name = name.withMarkers(name.getMarkers().add((Marker)implicitDot));
                }
                Markers markers = Markers.EMPTY;
                if (call.getArguments() instanceof ArgumentListExpression) {
                    args = (ArgumentListExpression)call.getArguments();
                    if (call.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE) != null) {
                        for (Expression arg : args.getExpressions()) {
                            if (!(arg instanceof ClosureExpression)) continue;
                            ClosureExpression cl = (ClosureExpression)arg;
                            ClassNode actualParamTypeRaw = (ClassNode)call.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                            for (Parameter p : cl.getParameters()) {
                                if (!p.isDynamicTyped()) continue;
                                p.setType(actualParamTypeRaw);
                                p.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                            }
                            for (Map.Entry entry : cl.getVariableScope().getDeclaredVariables().entrySet()) {
                                if (!(entry.getValue() instanceof Parameter) || !((Variable)entry.getValue()).isDynamicTyped()) continue;
                                Parameter p = (Parameter)entry.getValue();
                                p.setType(actualParamTypeRaw);
                                p.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                            }
                        }
                    }
                    markers = GroovyParserVisitor.this.handlesCaseWhereEmptyParensAheadOfClosure(args, markers);
                }
                args = (JContainer)this.visit((ASTNode)call.getArguments());
                MethodNode methodNode = (MethodNode)call.getNodeMetaData().get(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                JavaType.Method methodType = null;
                if (methodNode == null && call.getObjectExpression() instanceof VariableExpression && ((VariableExpression)call.getObjectExpression()).getAccessedVariable() != null) {
                    ClassNode parameterType = GroovyParserVisitor.staticType(((VariableExpression)call.getObjectExpression()).getAccessedVariable());
                    if (args.getElements().size() == 1 && args.getElements().get(0) instanceof J.Empty) {
                        methodType = GroovyParserVisitor.this.typeMapping.methodType(parameterType.getMethod(name.getSimpleName(), new Parameter[0]));
                    } else if (call.getArguments() instanceof ArgumentListExpression) {
                        List rawArgs = ((ArgumentListExpression)call.getArguments()).getExpressions();
                        block3: for (MethodNode methodNode2 : parameterType.getAllDeclaredMethods()) {
                            if (!name.getSimpleName().equals(methodNode2.getName()) || rawArgs.size() != methodNode2.getParameters().length) continue;
                            methodType = GroovyParserVisitor.this.typeMapping.methodType(methodNode2);
                            for (int i = 0; i < methodNode2.getParameters().length; ++i) {
                                JavaType arg;
                                JavaType param = GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType(methodNode2.getParameters()[i]));
                                if (!TypeUtils.isAssignableTo((JavaType)param, (JavaType)(arg = GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType((Expression)rawArgs.get(i)))))) continue block3;
                            }
                            break;
                        }
                    }
                } else {
                    methodType = GroovyParserVisitor.this.typeMapping.methodType(methodNode);
                }
                return new J.MethodInvocation(Tree.randomId(), fmt, markers, select, null, name, (JContainer)args, methodType);
            }));
        }

        public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
            ArgumentListExpression args;
            Space fmt = GroovyParserVisitor.this.whitespace();
            MethodNode methodNode = (MethodNode)call.getNodeMetaData().get(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            JavaType.Method methodType = GroovyParserVisitor.this.typeMapping.methodType(methodNode);
            J.Identifier name = new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(call.getMethodAsString()), Markers.EMPTY, Collections.emptyList(), call.getMethodAsString(), (JavaType)methodType, null);
            Markers markers = Markers.EMPTY;
            if (call.getArguments() instanceof ArgumentListExpression) {
                args = (ArgumentListExpression)call.getArguments();
                if (call.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE) != null) {
                    for (Expression arg : args.getExpressions()) {
                        if (!(arg instanceof ClosureExpression)) continue;
                        ClosureExpression cl = (ClosureExpression)arg;
                        ClassNode actualParamTypeRaw = (ClassNode)call.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        for (Parameter p : cl.getParameters()) {
                            if (!p.isDynamicTyped()) continue;
                            p.setType(actualParamTypeRaw);
                            p.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        }
                        for (Map.Entry entry : cl.getVariableScope().getDeclaredVariables().entrySet()) {
                            if (!(entry.getValue() instanceof Parameter) || !((Variable)entry.getValue()).isDynamicTyped()) continue;
                            Parameter p = (Parameter)entry.getValue();
                            p.setType(actualParamTypeRaw);
                            p.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        }
                    }
                }
                markers = GroovyParserVisitor.this.handlesCaseWhereEmptyParensAheadOfClosure(args, markers);
            }
            args = (JContainer)this.visit((ASTNode)call.getArguments());
            this.queue.add(new J.MethodInvocation(Tree.randomId(), fmt, markers, null, null, name, (JContainer)args, methodType));
        }

        public void visitAttributeExpression(AttributeExpression attr) {
            this.queue.add(this.insideParentheses((ASTNode)attr, fmt -> {
                org.openrewrite.java.tree.Expression target = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)attr.getObjectExpression());
                Space beforeDot = attr.isSafe() ? GroovyParserVisitor.this.sourceBefore("?.") : GroovyParserVisitor.this.sourceBefore(attr.isSpreadSafe() ? "*." : ".");
                J name = (J)this.visit((ASTNode)attr.getProperty());
                if (name instanceof J.Literal) {
                    String nameStr = ((J.Literal)name).getValueSource();
                    assert (nameStr != null);
                    name = new J.Identifier(Tree.randomId(), name.getPrefix(), Markers.EMPTY, Collections.emptyList(), nameStr, null, null);
                }
                if (attr.isSpreadSafe()) {
                    name = (J)name.withMarkers(name.getMarkers().add((Marker)new StarDot(Tree.randomId())));
                }
                if (attr.isSafe()) {
                    name = (J)name.withMarkers(name.getMarkers().add((Marker)new NullSafe(Tree.randomId())));
                }
                return new J.FieldAccess(Tree.randomId(), fmt, Markers.EMPTY, target, GroovyParserVisitor.this.padLeft(beforeDot, (J.Identifier)name), null);
            }));
        }

        public void visitPropertyExpression(PropertyExpression prop) {
            this.queue.add(this.insideParentheses((ASTNode)prop, fmt -> {
                org.openrewrite.java.tree.Expression target = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)prop.getObjectExpression());
                Space beforeDot = prop.isSpreadSafe() ? GroovyParserVisitor.this.sourceBefore("*.") : GroovyParserVisitor.this.sourceBefore(prop.isSafe() ? "?." : ".");
                J name = (J)this.visit((ASTNode)prop.getProperty());
                if (name instanceof J.Literal) {
                    J.Literal nameLiteral = (J.Literal)name;
                    name = new J.Identifier(Tree.randomId(), name.getPrefix(), Markers.EMPTY, Collections.emptyList(), nameLiteral.getValueSource(), (JavaType)nameLiteral.getType(), null);
                }
                if (prop.isSpreadSafe()) {
                    name = (J)name.withMarkers(name.getMarkers().add((Marker)new StarDot(Tree.randomId())));
                } else if (prop.isSafe()) {
                    name = (J)name.withMarkers(name.getMarkers().add((Marker)new NullSafe(Tree.randomId())));
                }
                return new J.FieldAccess(Tree.randomId(), fmt, Markers.EMPTY, target, GroovyParserVisitor.this.padLeft(beforeDot, (J.Identifier)name), null);
            }));
        }

        public void visitRangeExpression(RangeExpression range) {
            this.queue.add(this.insideParentheses((ASTNode)range, fmt -> new G.Range(Tree.randomId(), (Space)fmt, Markers.EMPTY, (org.openrewrite.java.tree.Expression)this.visit((ASTNode)range.getFrom()), (JLeftPadded<Boolean>)JLeftPadded.build((Object)range.isInclusive()).withBefore(GroovyParserVisitor.this.sourceBefore(range.isInclusive() ? ".." : "..>")), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)range.getTo()))));
        }

        public void visitReturnStatement(ReturnStatement return_) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("return");
            if (return_.getExpression() instanceof ConstantExpression && GroovyParserVisitor.isSynthetic((ASTNode)return_.getExpression()) && ((ConstantExpression)return_.getExpression()).getValue() == null) {
                this.queue.add(new J.Return(Tree.randomId(), fmt, Markers.EMPTY, null));
            } else {
                this.queue.add(new J.Return(Tree.randomId(), fmt, Markers.EMPTY, (org.openrewrite.java.tree.Expression)this.visit((ASTNode)return_.getExpression())));
            }
        }

        public void visitShortTernaryExpression(ElvisOperatorExpression ternary) {
            this.queue.add(this.insideParentheses((ASTNode)ternary, fmt -> {
                org.openrewrite.java.tree.Expression trueExpr = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)ternary.getBooleanExpression());
                J.Ternary elvis = new J.Ternary(Tree.randomId(), fmt, Markers.EMPTY, trueExpr, GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("?"), trueExpr), GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore(":"), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)ternary.getFalseExpression())), GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType((Expression)ternary)));
                return elvis.withMarkers(elvis.getMarkers().add((Marker)new Elvis(Tree.randomId())));
            }));
        }

        public void visitSwitch(SwitchStatement statement) {
            this.queue.add(new J.Switch(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("switch"), Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)statement.getExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")"))), new J.Block(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("{"), Markers.EMPTY, JRightPadded.build((Object)false), ListUtils.concat(this.convertAll(statement.getCaseStatements(), t -> Space.EMPTY, t -> Space.EMPTY), statement.getDefaultStatement().isEmpty() ? null : JRightPadded.build((Object)this.visitDefaultCaseStatement((BlockStatement)statement.getDefaultStatement()))), GroovyParserVisitor.this.sourceBefore("}"))));
        }

        public void visitSynchronizedStatement(SynchronizedStatement statement) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("synchronized");
            this.queue.add(new J.Synchronized(Tree.randomId(), fmt, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)statement.getExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")"))), (J.Block)this.visit((ASTNode)statement.getCode())));
        }

        public void visitTernaryExpression(TernaryExpression ternary) {
            this.queue.add(this.insideParentheses((ASTNode)ternary, fmt -> new J.Ternary(Tree.randomId(), fmt, Markers.EMPTY, (org.openrewrite.java.tree.Expression)this.visit((ASTNode)ternary.getBooleanExpression()), GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("?"), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)ternary.getTrueExpression())), GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore(":"), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)ternary.getFalseExpression())), GroovyParserVisitor.this.typeMapping.type((ASTNode)ternary.getType()))));
        }

        public void visitThrowStatement(ThrowStatement statement) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("throw");
            this.queue.add(new J.Throw(Tree.randomId(), fmt, Markers.EMPTY, (org.openrewrite.java.tree.Expression)this.visit((ASTNode)statement.getExpression())));
        }

        public void visitTupleExpression(TupleExpression tuple) {
            int saveCursor = GroovyParserVisitor.this.cursor;
            Space beforeOpenParen = GroovyParserVisitor.this.whitespace();
            OmitParentheses omitParentheses = null;
            if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                GroovyParserVisitor.this.skip("(");
            } else {
                omitParentheses = new OmitParentheses(Tree.randomId());
                beforeOpenParen = Space.EMPTY;
                GroovyParserVisitor.this.cursor = saveCursor;
            }
            ArrayList<JRightPadded> args = new ArrayList<JRightPadded>(tuple.getExpressions().size());
            for (Expression expression : tuple.getExpressions()) {
                NamedArgumentListExpression namedArgList = (NamedArgumentListExpression)expression;
                List mapEntryExpressions = namedArgList.getMapEntryExpressions();
                for (int i = 0; i < mapEntryExpressions.size(); ++i) {
                    org.openrewrite.java.tree.Expression arg = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)mapEntryExpressions.get(i));
                    if (omitParentheses != null) {
                        arg = (org.openrewrite.java.tree.Expression)arg.withMarkers(arg.getMarkers().add((Marker)omitParentheses));
                    }
                    Space after = Space.EMPTY;
                    if (i == mapEntryExpressions.size() - 1) {
                        if (omitParentheses == null) {
                            after = GroovyParserVisitor.this.sourceBefore(")");
                        }
                    } else {
                        after = GroovyParserVisitor.this.whitespace();
                        if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ')') {
                            omitParentheses = new OmitParentheses(Tree.randomId());
                        }
                        GroovyParserVisitor.this.cursor++;
                    }
                    args.add(JRightPadded.build((Object)arg).withAfter(after));
                }
            }
            this.queue.add(JContainer.build((Space)beforeOpenParen, args, (Markers)Markers.EMPTY));
        }

        public void visitTryCatchFinally(TryCatchStatement node) {
            List catches;
            Space prefix = GroovyParserVisitor.this.sourceBefore("try");
            JContainer resources = null;
            J.Block body = (J.Block)this.visit((ASTNode)node.getTryStatement());
            if (node.getCatchStatements().isEmpty()) {
                catches = Collections.emptyList();
            } else {
                catches = new ArrayList(node.getCatchStatements().size());
                for (CatchStatement catchStatement : node.getCatchStatements()) {
                    this.visitCatchStatement(catchStatement);
                    catches.add((J.Try.Catch)this.queue.poll());
                }
            }
            JLeftPadded finally_ = !(node.getFinallyStatement() instanceof BlockStatement) ? null : GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("finally"), (J.Block)this.visit((ASTNode)((BlockStatement)node.getFinallyStatement()).getStatements().get(0)));
            this.queue.add(new J.Try(Tree.randomId(), prefix, Markers.EMPTY, resources, body, catches, finally_));
        }

        public void visitPostfixExpression(PostfixExpression unary) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            org.openrewrite.java.tree.Expression expression = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)unary.getExpression());
            Space operatorPrefix = GroovyParserVisitor.this.whitespace();
            String typeToken = unary.getOperation().getText();
            GroovyParserVisitor.this.cursor += typeToken.length();
            J.Unary.Type operator = null;
            switch (typeToken) {
                case "++": {
                    operator = J.Unary.Type.PostIncrement;
                    break;
                }
                case "--": {
                    operator = J.Unary.Type.PostDecrement;
                }
            }
            assert (operator != null);
            this.queue.add(new J.Unary(Tree.randomId(), fmt, Markers.EMPTY, JLeftPadded.build((Object)operator).withBefore(operatorPrefix), expression, null));
        }

        public void visitPrefixExpression(PrefixExpression unary) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            String typeToken = unary.getOperation().getText();
            GroovyParserVisitor.this.skip(typeToken);
            J.Unary.Type operator = null;
            switch (typeToken) {
                case "++": {
                    operator = J.Unary.Type.PreIncrement;
                    break;
                }
                case "--": {
                    operator = J.Unary.Type.PreDecrement;
                    break;
                }
                case "~": {
                    operator = J.Unary.Type.Complement;
                }
            }
            assert (operator != null);
            this.queue.add(new J.Unary(Tree.randomId(), fmt, Markers.EMPTY, JLeftPadded.build((Object)operator), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)unary.getExpression()), null));
        }

        public void visitSpreadExpression(SpreadExpression spreadExpression) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            GroovyParserVisitor.this.skip("*");
            this.queue.add(new G.Unary(Tree.randomId(), fmt, Markers.EMPTY, (JLeftPadded<G.Unary.Type>)JLeftPadded.build((Object)((Object)G.Unary.Type.Spread)), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)spreadExpression.getExpression()), null));
        }

        public TypeTree visitVariableExpressionType(VariableExpression expression) {
            if (!expression.isDynamicTyped() && expression.getOriginType().isArray()) {
                return GroovyParserVisitor.this.visitTypeTree(expression.getOriginType());
            }
            JavaType type = GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType((Expression)expression));
            Space prefix = GroovyParserVisitor.this.whitespace();
            String typeName = "";
            if (!expression.isDynamicTyped() && GroovyParserVisitor.this.source.startsWith(expression.getOriginType().getUnresolvedName(), GroovyParserVisitor.this.cursor) && GroovyParserVisitor.this.cursor + expression.getOriginType().getUnresolvedName().length() < GroovyParserVisitor.this.source.length() && !Character.isJavaIdentifierPart(GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor + expression.getOriginType().getUnresolvedName().length()))) {
                typeName = expression.getOriginType().getUnresolvedName();
                GroovyParserVisitor.this.skip(typeName);
            }
            J.Identifier ident = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), typeName, type, null);
            if (expression.getOriginType().getGenericsTypes() != null) {
                return new J.ParameterizedType(Tree.randomId(), prefix, Markers.EMPTY, (NameTree)ident, GroovyParserVisitor.this.visitTypeParameterizations(GroovyParserVisitor.staticType((Expression)expression).getGenericsTypes()), type);
            }
            return ident.withPrefix(prefix);
        }

        public void visitVariableExpression(VariableExpression expression) {
            this.queue.add(this.insideParentheses((ASTNode)expression, fmt -> {
                JavaType type = expression.isDynamicTyped() && expression.getAccessedVariable() != null && expression.getAccessedVariable().getType() != expression.getOriginType() ? GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType(expression.getAccessedVariable())) : GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType((Expression)expression));
                return new J.Identifier(Tree.randomId(), fmt.withWhitespace(fmt.getWhitespace() + GroovyParserVisitor.this.sourceBefore(expression.getName()).getWhitespace()), Markers.EMPTY, Collections.emptyList(), expression.getName(), type, null);
            }));
        }

        public void visitWhileLoop(WhileStatement loop) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("while");
            this.queue.add(new J.WhileLoop(Tree.randomId(), fmt, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)loop.getBooleanExpression().getExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")"))), JRightPadded.build((Object)((Statement)this.visit((ASTNode)loop.getLoopBlock())))));
        }

        private <J2 extends J> List<JRightPadded<J2>> convertAll(List<? extends ASTNode> nodes, Function<ASTNode, Space> innerSuffix, Function<ASTNode, Space> suffix, Function<ASTNode, Markers> markers) {
            if (nodes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<JRightPadded<J2>> converted = new ArrayList<JRightPadded<J2>>(nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                converted.add(this.convert(nodes.get(i), i == nodes.size() - 1 ? suffix : innerSuffix, markers));
            }
            return converted;
        }

        private <J2 extends J> List<JRightPadded<J2>> convertAll(List<? extends ASTNode> nodes, Function<ASTNode, Space> innerSuffix, Function<ASTNode, Space> suffix) {
            return this.convertAll(nodes, innerSuffix, suffix, n -> Markers.EMPTY);
        }

        private <J2 extends J> JRightPadded<J2> convert(ASTNode node, Function<ASTNode, Space> suffix) {
            return this.convert(node, suffix, n -> Markers.EMPTY);
        }

        private <J2 extends J> JRightPadded<J2> convert(ASTNode node, Function<ASTNode, Space> suffix, Function<ASTNode, Markers> markers) {
            J j = (J)this.visit(node);
            return GroovyParserVisitor.this.padRight(j, suffix.apply(node), markers.apply(node));
        }

        private List<JRightPadded<Statement>> convertStatements(List<? extends ASTNode> nodes) {
            if (nodes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<JRightPadded<Statement>> converted = new ArrayList<JRightPadded<Statement>>(nodes.size());
            for (ASTNode aSTNode : nodes) {
                Statement statement = (Statement)this.visit(aSTNode);
                converted.add((JRightPadded<Statement>)GroovyParserVisitor.this.maybeSemicolon((J)statement));
            }
            return converted;
        }

        private <T> T pollQueue() {
            return (T)this.queue.poll();
        }
    }
}

