/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyParsingException;
import org.openrewrite.groovy.GroovyTypeMapping;
import org.openrewrite.groovy.marker.AsStyleTypeCast;
import org.openrewrite.groovy.marker.Elvis;
import org.openrewrite.groovy.marker.EmptyArgumentListPrecedesArgument;
import org.openrewrite.groovy.marker.ImplicitDot;
import org.openrewrite.groovy.marker.InStyleForEachLoop;
import org.openrewrite.groovy.marker.NullSafe;
import org.openrewrite.groovy.marker.StarDot;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.marker.Semicolon;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class GroovyParserVisitor {
    private final Path sourcePath;
    @Nullable
    private final FileAttributes fileAttributes;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private final GroovyTypeMapping typeMapping;
    private final ExecutionContext ctx;
    private int cursor = 0;
    private static final Pattern whitespacePrefixPattern = Pattern.compile("^\\s*");
    private static final Pattern whitespaceSuffixPattern = Pattern.compile("\\s*[^\\s]+(\\s*)");

    public GroovyParserVisitor(Path sourcePath, @Nullable FileAttributes fileAttributes, EncodingDetectingInputStream source, JavaTypeCache typeCache, ExecutionContext ctx) {
        this.sourcePath = sourcePath;
        this.fileAttributes = fileAttributes;
        this.source = source.readFully();
        this.charset = source.getCharset();
        this.charsetBomMarked = source.isCharsetBomMarked();
        this.typeMapping = new GroovyTypeMapping(typeCache);
        this.ctx = ctx;
    }

    public G.CompilationUnit visit(SourceUnit unit, ModuleNode ast) throws GroovyParsingException {
        TreeMap<LineColumn, List> sortedByPosition = new TreeMap<LineColumn, List>();
        for (org.codehaus.groovy.ast.stmt.Statement s : ast.getStatementBlock().getStatements()) {
            if (GroovyParserVisitor.isSynthetic((ASTNode)s)) continue;
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)s), i -> new ArrayList()).add(s);
        }
        String shebang = null;
        if (this.source.startsWith("#!")) {
            int i2;
            for (i2 = 0; i2 < this.source.length() && this.source.charAt(i2) != '\n' && this.source.charAt(i2) != '\r'; ++i2) {
            }
            shebang = this.source.substring(0, i2);
            this.cursor += i2;
        }
        JRightPadded pkg = null;
        if (ast.getPackage() != null) {
            Space prefix = this.whitespace();
            this.cursor += "package".length();
            pkg = JRightPadded.build((Object)new J.Package(Tree.randomId(), prefix, Markers.EMPTY, (org.openrewrite.java.tree.Expression)this.typeTree(null), Collections.emptyList()));
        }
        for (ImportNode anImport : ast.getImports()) {
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)anImport), i -> new ArrayList()).add(anImport);
        }
        for (ImportNode anImport : ast.getStarImports()) {
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)anImport), i -> new ArrayList()).add(anImport);
        }
        for (ImportNode anImport : ast.getStaticImports().values()) {
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)anImport), i -> new ArrayList()).add(anImport);
        }
        for (ImportNode anImport : ast.getStaticStarImports().values()) {
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)anImport), i -> new ArrayList()).add(anImport);
        }
        for (ClassNode aClass : ast.getClasses()) {
            if (aClass.getSuperClass() != null && ("groovy.lang.Script".equals(aClass.getSuperClass().getName()) || "RewriteGradleProject".equals(aClass.getSuperClass().getName()) || "RewriteSettings".equals(aClass.getSuperClass().getName()))) continue;
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)aClass), i -> new ArrayList()).add(aClass);
        }
        for (MethodNode method : ast.getMethods()) {
            sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)method), i -> new ArrayList()).add(method);
        }
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>(sortedByPosition.size());
        for (Map.Entry entry : sortedByPosition.entrySet()) {
            if (((LineColumn)entry.getKey()).getLine() == -1) continue;
            try {
                for (ASTNode value : (List)entry.getValue()) {
                    if (value instanceof InnerClassNode) continue;
                    statements.add(this.convertTopLevelStatement(unit, value));
                }
            }
            catch (Throwable t) {
                if (t instanceof StringIndexOutOfBoundsException) {
                    throw new GroovyParsingException("Failed to parse " + this.sourcePath + ", cursor position likely inaccurate.", t);
                }
                throw new GroovyParsingException("Failed to parse " + this.sourcePath + " at cursor position " + this.cursor + ". The next 10 characters in the original source are `" + this.source.substring(this.cursor, Math.min(this.source.length(), this.cursor + 10)) + "`", t);
            }
        }
        return new G.CompilationUnit(Tree.randomId(), shebang, Space.EMPTY, Markers.EMPTY, this.sourcePath, this.fileAttributes, this.charset.name(), this.charsetBomMarked, null, (JRightPadded<J.Package>)pkg, statements, Space.format((String)this.source.substring(this.cursor)));
    }

    private JRightPadded<Statement> convertTopLevelStatement(SourceUnit unit, ASTNode node) {
        if (node instanceof ClassNode) {
            ClassNode classNode = (ClassNode)node;
            RewriteGroovyClassVisitor classVisitor = new RewriteGroovyClassVisitor(unit);
            classVisitor.visitClass(classNode);
            return JRightPadded.build((Object)((Statement)classVisitor.pollQueue()));
        }
        if (node instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)node;
            RewriteGroovyClassVisitor classVisitor = new RewriteGroovyClassVisitor(unit);
            classVisitor.visitMethod(methodNode);
            return JRightPadded.build((Object)((Statement)classVisitor.pollQueue()));
        }
        if (node instanceof ImportNode) {
            J.FieldAccess qualid;
            ImportNode importNode = (ImportNode)node;
            Space prefix = this.sourceBefore("import");
            JLeftPadded<Boolean> statik = importNode.isStatic() ? this.padLeft(this.sourceBefore("static"), true) : this.padLeft(Space.EMPTY, false);
            String packageName = importNode.getPackageName();
            if (packageName == null) {
                String type = importNode.getType().getName();
                if (importNode.isStar()) {
                    type = type + ".*";
                } else if (importNode.getFieldName() != null) {
                    type = type + "." + importNode.getFieldName();
                }
                Space space = this.sourceBefore(type);
                qualid = (J.FieldAccess)TypeTree.build((String)type).withPrefix(space);
            } else {
                if (importNode.isStar()) {
                    packageName = packageName + "*";
                }
                qualid = (J.FieldAccess)TypeTree.build((String)packageName).withPrefix(this.sourceBefore(packageName));
            }
            JLeftPadded<J.Identifier> alias = null;
            int endOfWhitespace = StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source);
            if (endOfWhitespace + 2 <= this.source.length() && "as".equals(this.source.substring(endOfWhitespace, endOfWhitespace + 2))) {
                String simpleName = importNode.getAlias();
                alias = this.padLeft(this.sourceBefore("as"), new J.Identifier(Tree.randomId(), this.sourceBefore(simpleName), Markers.EMPTY, simpleName, null, null));
            }
            J.Import anImport = new J.Import(Tree.randomId(), prefix, Markers.EMPTY, statik, qualid, alias);
            return this.maybeSemicolon(anImport);
        }
        RewriteGroovyVisitor groovyVisitor = new RewriteGroovyVisitor(node, new RewriteGroovyClassVisitor(unit));
        node.visit((GroovyCodeVisitor)groovyVisitor);
        return this.maybeSemicolon((Statement)groovyVisitor.pollQueue());
    }

    private static LineColumn pos(ASTNode node) {
        return new LineColumn(node.getLineNumber(), node.getColumnNumber());
    }

    private static boolean isSynthetic(ASTNode node) {
        return node.getLineNumber() == -1;
    }

    private <T> JRightPadded<T> padRight(T tree, Space right) {
        return new JRightPadded(tree, right, Markers.EMPTY);
    }

    private <T> JLeftPadded<T> padLeft(Space left, T tree) {
        return new JLeftPadded(left, tree, Markers.EMPTY);
    }

    private int positionOfNext(String untilDelim) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment) {
                if (this.source.charAt(delimIndex) != '\n') continue;
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() - untilDelim.length() > delimIndex + 1) {
                switch (this.source.substring(delimIndex, delimIndex + 2)) {
                    case "//": {
                        inSingleLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "/*": {
                        inMultiLineComment = true;
                        ++delimIndex;
                        break;
                    }
                    case "*/": {
                        inMultiLineComment = false;
                        delimIndex += 2;
                    }
                }
            }
            if (!inMultiLineComment && !inSingleLineComment && this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }

    private Space whitespace() {
        String prefix = this.source.substring(this.cursor, StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source));
        this.cursor += prefix.length();
        return Space.format((String)prefix);
    }

    private String skip(@Nullable String token) {
        if (token == null) {
            return null;
        }
        if (this.source.startsWith(token, this.cursor)) {
            this.cursor += token.length();
        }
        return token;
    }

    private <T extends TypeTree & org.openrewrite.java.tree.Expression> T typeTree(@Nullable ClassNode classNode) {
        Space prefix = this.whitespace();
        String maybeFullyQualified = this.name();
        String[] parts = maybeFullyQualified.split("\\.");
        String fullName = "";
        J.Identifier expr = null;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == 0) {
                fullName = part;
                expr = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, part, this.typeMapping.type((ASTNode)classNode), null);
                continue;
            }
            fullName = fullName + "." + part;
            Matcher whitespacePrefix = whitespacePrefixPattern.matcher(part);
            Space identFmt = whitespacePrefix.matches() ? Space.format((String)whitespacePrefix.group(0)) : Space.EMPTY;
            Matcher whitespaceSuffix = whitespaceSuffixPattern.matcher(part);
            whitespaceSuffix.matches();
            Space namePrefix = i == parts.length - 1 ? Space.EMPTY : Space.format((String)whitespaceSuffix.group(1));
            expr = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (org.openrewrite.java.tree.Expression)expr, this.padLeft(namePrefix, new J.Identifier(Tree.randomId(), identFmt, Markers.EMPTY, part.trim(), null, null)), (JavaType)(Character.isUpperCase(part.charAt(0)) || i == parts.length - 1 ? JavaType.ShallowClass.build((String)fullName) : null));
        }
        assert (expr != null);
        if (classNode != null) {
            if (classNode.isUsingGenerics() && !classNode.isGenericsPlaceHolder()) {
                expr = new J.ParameterizedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (NameTree)expr, this.visitTypeParameterizations(classNode.getGenericsTypes()), this.typeMapping.type((ASTNode)classNode));
            } else if (classNode.isArray()) {
                expr = new J.ArrayType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (TypeTree)expr, this.arrayDimensionsFrom(classNode));
            }
        }
        return (T)((TypeTree)expr.withPrefix(prefix));
    }

    private List<JRightPadded<Space>> arrayDimensionsFrom(ClassNode classNode) {
        ArrayList<JRightPadded<Space>> result = new ArrayList<JRightPadded<Space>>();
        while (classNode != null && classNode.isArray()) {
            classNode = classNode.getComponentType();
            result.add((JRightPadded<Space>)JRightPadded.build((Object)this.sourceBefore("[")).withAfter(this.sourceBefore("]")));
        }
        return result;
    }

    private Space sourceBefore(String untilDelim) {
        int delimIndex = this.positionOfNext(untilDelim);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        String prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length() + untilDelim.length();
        return Space.format((String)prefix);
    }

    private int sourceLengthOfNext(ASTNode node) {
        if (!GroovyParserVisitor.appearsInSource(node)) {
            return 0;
        }
        int lineCount = node.getLastLineNumber() - node.getLineNumber();
        if (lineCount == 0) {
            return node.getLastColumnNumber() - node.getColumnNumber();
        }
        int linesSoFar = 0;
        int length = 0;
        int finalLineChars = 0;
        do {
            char c;
            if ((c = this.source.charAt(this.cursor + length)) == '\n') {
                ++linesSoFar;
            }
            if (linesSoFar == lineCount) {
                ++finalLineChars;
            }
            ++length;
        } while (finalLineChars != node.getLastColumnNumber());
        return length;
    }

    private TypeTree visitTypeTree(ClassNode classNode) {
        JavaType.Primitive primitiveType = JavaType.Primitive.fromKeyword((String)classNode.getUnresolvedName());
        if (primitiveType != null) {
            return new J.Primitive(Tree.randomId(), this.sourceBefore(classNode.getUnresolvedName()), Markers.EMPTY, primitiveType);
        }
        int saveCursor = this.cursor;
        Space fmt = this.whitespace();
        if (this.cursor < this.source.length() && this.source.startsWith("def", this.cursor)) {
            this.cursor += 3;
            return new J.Identifier(Tree.randomId(), fmt, Markers.EMPTY, "def", (JavaType)JavaType.ShallowClass.build((String)"java.lang.Object"), null);
        }
        this.cursor = saveCursor;
        return this.typeTree(classNode);
    }

    private List<J.Modifier> visitModifiers(int modifiers) {
        ArrayList<J.Modifier> unorderedModifiers = new ArrayList<J.Modifier>();
        if ((modifiers & 0x400) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Abstract, Collections.emptyList()));
        }
        if ((modifiers & 0x10) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList()));
        }
        if ((modifiers & 2) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Private, Collections.emptyList()));
        }
        if ((modifiers & 4) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Protected, Collections.emptyList()));
        }
        if ((modifiers & 1) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Public, Collections.emptyList()));
        }
        if ((modifiers & 8) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Static, Collections.emptyList()));
        }
        if ((modifiers & 0x20) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Synchronized, Collections.emptyList()));
        }
        if ((modifiers & 0x80) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Transient, Collections.emptyList()));
        }
        if ((modifiers & 0x40) != 0) {
            unorderedModifiers.add(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Volatile, Collections.emptyList()));
        }
        ArrayList<J.Modifier> orderedModifiers = new ArrayList<J.Modifier>(unorderedModifiers.size());
        boolean foundModifier = true;
        block0: while (foundModifier) {
            int saveCursor = this.cursor;
            Space fmt = this.whitespace();
            for (J.Modifier mod : unorderedModifiers) {
                String modName = mod.getType().name().toLowerCase();
                if (!this.source.startsWith(modName, this.cursor)) continue;
                orderedModifiers.add(mod.withPrefix(fmt));
                unorderedModifiers.remove(mod);
                this.cursor += modName.length();
                continue block0;
            }
            foundModifier = false;
            this.cursor = saveCursor;
        }
        return orderedModifiers;
    }

    private <G2 extends J> JRightPadded<G2> maybeSemicolon(G2 g) {
        int saveCursor = this.cursor;
        Space beforeSemi = this.whitespace();
        Semicolon semicolon = null;
        if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == ';') {
            semicolon = new Semicolon(Tree.randomId());
            ++this.cursor;
        } else {
            beforeSemi = Space.EMPTY;
            this.cursor = saveCursor;
        }
        JRightPadded paddedG = JRightPadded.build(g).withAfter(beforeSemi);
        if (semicolon != null) {
            paddedG = paddedG.withMarkers(paddedG.getMarkers().add((Marker)semicolon));
        }
        return paddedG;
    }

    private String name() {
        int i = this.cursor;
        char c = this.source.charAt(i);
        while (Character.isJavaIdentifierPart(c) || c == '.' || c == '*') {
            c = this.source.charAt(++i);
        }
        String result = this.source.substring(this.cursor, i);
        this.cursor += i - this.cursor;
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JContainer<org.openrewrite.java.tree.Expression> visitTypeParameterizations(@Nullable GenericsType[] genericsTypes) {
        List<Object> parameters;
        Space prefix = this.sourceBefore("<");
        if (genericsTypes == null) {
            Space paramPrefix = this.whitespace();
            if (this.source.charAt(this.cursor) == '>') {
                parameters = Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), paramPrefix, Markers.EMPTY)));
                return JContainer.build((Space)prefix, parameters, (Markers)Markers.EMPTY);
            }
            parameters = new ArrayList();
            while (true) {
                org.openrewrite.java.tree.Expression param = (org.openrewrite.java.tree.Expression)this.typeTree(null).withPrefix(paramPrefix);
                Space suffix = this.whitespace();
                parameters.add(JRightPadded.build((Object)param).withAfter(suffix));
                if (this.source.charAt(this.cursor) == '>') {
                    ++this.cursor;
                    return JContainer.build((Space)prefix, parameters, (Markers)Markers.EMPTY);
                }
                ++this.cursor;
                paramPrefix = this.whitespace();
            }
        }
        parameters = new ArrayList<JRightPadded>(genericsTypes.length);
        for (int i = 0; i < genericsTypes.length; ++i) {
            parameters.add(JRightPadded.build((Object)this.visitTypeParameterization(genericsTypes[i])).withAfter(i < genericsTypes.length - 1 ? this.sourceBefore(",") : this.sourceBefore(">")));
        }
        return JContainer.build((Space)prefix, parameters, (Markers)Markers.EMPTY);
    }

    private org.openrewrite.java.tree.Expression visitTypeParameterization(GenericsType genericsType) {
        int saveCursor = this.cursor;
        Space prefix = this.whitespace();
        if (this.source.charAt(this.cursor) == '?') {
            this.cursor = saveCursor;
            return this.visitWildcard(genericsType);
        }
        if (this.source.charAt(this.cursor) == '>') {
            ++this.cursor;
            return new J.Empty(Tree.randomId(), prefix, Markers.EMPTY);
        }
        this.cursor = saveCursor;
        return (org.openrewrite.java.tree.Expression)this.typeTree(null).withType(this.typeMapping.type((ASTNode)genericsType));
    }

    private JContainer<J.TypeParameter> visitTypeParameters(GenericsType[] genericsTypes) {
        Space prefix = this.sourceBefore("<");
        ArrayList<JRightPadded> typeParameters = new ArrayList<JRightPadded>(genericsTypes.length);
        for (int i = 0; i < genericsTypes.length; ++i) {
            typeParameters.add(JRightPadded.build((Object)this.visitTypeParameter(genericsTypes[i])).withAfter(i < genericsTypes.length - 1 ? this.sourceBefore(",") : this.sourceBefore(">")));
        }
        return JContainer.build((Space)prefix, typeParameters, (Markers)Markers.EMPTY);
    }

    private J.TypeParameter visitTypeParameter(GenericsType genericType) {
        Space prefix = this.whitespace();
        org.openrewrite.java.tree.Expression name = (org.openrewrite.java.tree.Expression)this.typeTree(null).withType(this.typeMapping.type((ASTNode)genericType));
        JContainer bounds = null;
        if (genericType.getUpperBounds() != null) {
            Space boundsPrefix = this.sourceBefore("extends");
            ClassNode[] upperBounds = genericType.getUpperBounds();
            ArrayList<JRightPadded> convertedBounds = new ArrayList<JRightPadded>(upperBounds.length);
            for (int i = 0; i < upperBounds.length; ++i) {
                convertedBounds.add(JRightPadded.build((Object)this.visitTypeTree(upperBounds[i])).withAfter(i < upperBounds.length - 1 ? this.sourceBefore("&") : Space.EMPTY));
            }
            bounds = JContainer.build((Space)boundsPrefix, convertedBounds, (Markers)Markers.EMPTY);
        } else if (genericType.getLowerBound() != null) {
            Space boundsPrefix = this.sourceBefore("super");
            ClassNode lowerBound = genericType.getLowerBound();
            ArrayList<JRightPadded> convertedBounds = new ArrayList<JRightPadded>(1);
            convertedBounds.add(JRightPadded.build((Object)this.visitTypeTree(lowerBound)).withAfter(Space.EMPTY));
            bounds = JContainer.build((Space)boundsPrefix, convertedBounds, (Markers)Markers.EMPTY);
        }
        return new J.TypeParameter(Tree.randomId(), prefix, Markers.EMPTY, Collections.emptyList(), name, bounds);
    }

    private J.Wildcard visitWildcard(GenericsType genericType) {
        TypeTree boundedType;
        JLeftPadded<J.Wildcard.Bound> bound;
        Space namePrefix = this.sourceBefore("?");
        if (genericType.getUpperBounds() != null) {
            bound = this.padLeft(this.sourceBefore("extends"), J.Wildcard.Bound.Extends);
            boundedType = this.visitTypeTree(genericType.getUpperBounds()[0]);
        } else if (genericType.getLowerBound() != null) {
            bound = this.padLeft(this.sourceBefore("super"), J.Wildcard.Bound.Super);
            boundedType = this.visitTypeTree(genericType.getLowerBound());
        } else {
            bound = null;
            boundedType = null;
        }
        return new J.Wildcard(Tree.randomId(), namePrefix, Markers.EMPTY, bound, (NameTree)boundedType);
    }

    private static boolean appearsInSource(ASTNode node) {
        return node.getColumnNumber() >= 0 && node.getLineNumber() >= 0 && node.getLastColumnNumber() >= 0 && node.getLastLineNumber() >= 0;
    }

    private static ClassNode staticType(Expression expression) {
        ClassNode inferred = (ClassNode)expression.getNodeMetaData().get(StaticTypesMarker.INFERRED_TYPE);
        if (inferred == null) {
            return expression.getType();
        }
        return inferred;
    }

    private static ClassNode staticType(Variable variable) {
        if (variable instanceof Parameter) {
            return GroovyParserVisitor.staticType((Parameter)variable);
        }
        if (variable instanceof Expression) {
            return GroovyParserVisitor.staticType((Expression)variable);
        }
        return variable.getType();
    }

    private static ClassNode staticType(Parameter parameter) {
        ClassNode inferred = (ClassNode)parameter.getNodeMetaData().get(StaticTypesMarker.INFERRED_TYPE);
        if (inferred == null) {
            return parameter.getType();
        }
        return inferred;
    }

    private static final class LineColumn
    implements Comparable<LineColumn> {
        private final int line;
        private final int column;

        @Override
        public int compareTo(@NonNull LineColumn lc) {
            return this.line != lc.line ? this.line - lc.line : this.column - lc.column;
        }

        public LineColumn(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LineColumn)) {
                return false;
            }
            LineColumn other = (LineColumn)o;
            if (this.getLine() != other.getLine()) {
                return false;
            }
            return this.getColumn() == other.getColumn();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLine();
            result = result * 59 + this.getColumn();
            return result;
        }

        @NonNull
        public String toString() {
            return "GroovyParserVisitor.LineColumn(line=" + this.getLine() + ", column=" + this.getColumn() + ")";
        }
    }

    private class RewriteGroovyClassVisitor
    extends ClassCodeVisitorSupport {
        private final SourceUnit sourceUnit;
        private final Queue<Object> queue = new LinkedList<Object>();

        public void visitClass(ClassNode clazz) {
            List leadingAnnotations;
            Space fmt = GroovyParserVisitor.this.whitespace();
            if (clazz.getAnnotations().isEmpty()) {
                leadingAnnotations = Collections.emptyList();
            } else {
                leadingAnnotations = new ArrayList(clazz.getAnnotations().size());
                for (AnnotationNode annotation : clazz.getAnnotations()) {
                    this.visitAnnotation(annotation);
                    leadingAnnotations.add((J.Annotation)this.pollQueue());
                }
            }
            List modifiers = GroovyParserVisitor.this.visitModifiers(clazz.getModifiers());
            Space kindPrefix = GroovyParserVisitor.this.whitespace();
            J.ClassDeclaration.Kind.Type kindType = null;
            if (GroovyParserVisitor.this.source.startsWith("class", GroovyParserVisitor.this.cursor)) {
                kindType = J.ClassDeclaration.Kind.Type.Class;
                GroovyParserVisitor.this.cursor += "class".length();
            } else if (GroovyParserVisitor.this.source.startsWith("interface", GroovyParserVisitor.this.cursor)) {
                kindType = J.ClassDeclaration.Kind.Type.Interface;
                GroovyParserVisitor.this.cursor += "interface".length();
            } else if (GroovyParserVisitor.this.source.startsWith("@interface", GroovyParserVisitor.this.cursor)) {
                kindType = J.ClassDeclaration.Kind.Type.Annotation;
                GroovyParserVisitor.this.cursor += "@interface".length();
            } else if (GroovyParserVisitor.this.source.startsWith("enum", GroovyParserVisitor.this.cursor)) {
                kindType = J.ClassDeclaration.Kind.Type.Enum;
                GroovyParserVisitor.this.cursor += "enum".length();
            }
            assert (kindType != null);
            J.ClassDeclaration.Kind kind = new J.ClassDeclaration.Kind(Tree.randomId(), kindPrefix, Markers.EMPTY, Collections.emptyList(), kindType);
            Space namePrefix = GroovyParserVisitor.this.whitespace();
            String simpleName = GroovyParserVisitor.this.name();
            J.Identifier name = new J.Identifier(Tree.randomId(), namePrefix, Markers.EMPTY, simpleName, GroovyParserVisitor.this.typeMapping.type((ASTNode)clazz), null);
            JContainer typeParameterContainer = null;
            if (clazz.isUsingGenerics() && clazz.getGenericsTypes() != null) {
                typeParameterContainer = GroovyParserVisitor.this.visitTypeParameters(clazz.getGenericsTypes());
            }
            JLeftPadded extendings = null;
            if (clazz.getSuperClass().getLineNumber() >= 0) {
                extendings = GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("extends"), GroovyParserVisitor.this.visitTypeTree(clazz.getSuperClass()));
            }
            JContainer implementings = null;
            if (clazz.getInterfaces().length > 0) {
                Space implPrefix = kindType == J.ClassDeclaration.Kind.Type.Interface || kindType == J.ClassDeclaration.Kind.Type.Annotation ? GroovyParserVisitor.this.sourceBefore("extends") : GroovyParserVisitor.this.sourceBefore("implements");
                ArrayList<JRightPadded> implTypes = new ArrayList<JRightPadded>(clazz.getInterfaces().length);
                ClassNode[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    ClassNode anInterface = interfaces[i];
                    if (kindType == J.ClassDeclaration.Kind.Type.Annotation && "java.lang.annotation.Annotation".equals(anInterface.getName())) continue;
                    implTypes.add(JRightPadded.build((Object)GroovyParserVisitor.this.visitTypeTree(anInterface)).withAfter(i == interfaces.length - 1 ? Space.EMPTY : GroovyParserVisitor.this.sourceBefore(",")));
                }
                if (implTypes.size() > 0) {
                    implementings = JContainer.build((Space)implPrefix, implTypes, (Markers)Markers.EMPTY);
                }
            }
            this.queue.add(new J.ClassDeclaration(Tree.randomId(), fmt, Markers.EMPTY, leadingAnnotations, modifiers, kind, name, typeParameterContainer, null, extendings, implementings, null, this.visitClassBlock(clazz), TypeUtils.asFullyQualified((JavaType)GroovyParserVisitor.this.typeMapping.type((ASTNode)clazz))));
        }

        J.Block visitClassBlock(ClassNode clazz) {
            TreeMap<LineColumn, List> sortedByPosition = new TreeMap<LineColumn, List>();
            for (Object method : clazz.getMethods()) {
                if (method.isSynthetic()) continue;
                sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)method), i -> new ArrayList()).add(method);
            }
            HashSet<InnerClassNode> fieldInitializers = new HashSet<InnerClassNode>();
            for (FieldNode field : clazz.getFields()) {
                ConstructorCallExpression cce;
                if (!GroovyParserVisitor.appearsInSource((ASTNode)field)) continue;
                if (field.hasInitialExpression() && field.getInitialExpression() instanceof ConstructorCallExpression && (cce = (ConstructorCallExpression)field.getInitialExpression()).isUsingAnonymousInnerClass() && cce.getType() instanceof InnerClassNode) {
                    fieldInitializers.add((InnerClassNode)cce.getType());
                }
                sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)field), i -> new ArrayList()).add(field);
            }
            Iterator innerClassIterator = clazz.getInnerClasses();
            while (innerClassIterator.hasNext()) {
                InnerClassNode icn = (InnerClassNode)innerClassIterator.next();
                if (icn.isSynthetic() || fieldInitializers.contains(icn)) continue;
                sortedByPosition.computeIfAbsent(GroovyParserVisitor.pos((ASTNode)icn), i -> new ArrayList()).add(icn);
            }
            return new J.Block(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("{"), Markers.EMPTY, JRightPadded.build((Object)false), sortedByPosition.values().stream().flatMap(asts -> asts.stream().map(ast -> {
                if (ast instanceof FieldNode) {
                    this.visitField((FieldNode)ast);
                } else if (ast instanceof MethodNode) {
                    this.visitMethod((MethodNode)ast);
                } else if (ast instanceof ClassNode) {
                    this.visitClass((ClassNode)ast);
                }
                Statement stat = (Statement)this.pollQueue();
                return GroovyParserVisitor.this.maybeSemicolon((J)stat);
            })).collect(Collectors.toList()), GroovyParserVisitor.this.sourceBefore("}"));
        }

        public void visitField(FieldNode field) {
            if ((field.getModifiers() & 0x4000) != 0) {
                this.visitEnumField(field);
            } else {
                this.visitVariableField(field);
            }
        }

        private void visitEnumField(FieldNode fieldNode) {
            throw new UnsupportedOperationException("enum fields are not implemented.");
        }

        private void visitVariableField(FieldNode field) {
            RewriteGroovyVisitor visitor = new RewriteGroovyVisitor((ASTNode)field, this);
            List annotations = field.getAnnotations().stream().map(a -> {
                this.visitAnnotation((AnnotationNode)a);
                return (J.Annotation)this.pollQueue();
            }).collect(Collectors.toList());
            List modifiers = GroovyParserVisitor.this.visitModifiers(field.getModifiers());
            TypeTree typeExpr = GroovyParserVisitor.this.visitTypeTree(field.getOriginType());
            J.Identifier name = new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(field.getName()), Markers.EMPTY, field.getName(), GroovyParserVisitor.this.typeMapping.type((ASTNode)field.getOriginType()), GroovyParserVisitor.this.typeMapping.variableType(field));
            J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), name.getPrefix(), Markers.EMPTY, name.withPrefix(Space.EMPTY), Collections.emptyList(), null, GroovyParserVisitor.this.typeMapping.variableType(field));
            if (field.getInitialExpression() != null) {
                Space beforeAssign = GroovyParserVisitor.this.sourceBefore("=");
                org.openrewrite.java.tree.Expression initializer = (org.openrewrite.java.tree.Expression)visitor.visit((ASTNode)field.getInitialExpression());
                namedVariable = namedVariable.getPadding().withInitializer(GroovyParserVisitor.this.padLeft(beforeAssign, initializer));
            }
            J.VariableDeclarations variableDeclarations = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, annotations, modifiers, typeExpr, null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)namedVariable)));
            this.queue.add(variableDeclarations);
        }

        protected void visitAnnotation(AnnotationNode annotation) {
            RewriteGroovyVisitor bodyVisitor = new RewriteGroovyVisitor((ASTNode)annotation, this);
            String lastArgKey = annotation.getMembers().keySet().stream().reduce("", (k1, k2) -> k2);
            Space prefix = GroovyParserVisitor.this.sourceBefore("@");
            TypeTree annotationType = GroovyParserVisitor.this.visitTypeTree(annotation.getClassNode());
            JContainer arguments = null;
            if (!annotation.getMembers().isEmpty()) {
                arguments = JContainer.build((Space)GroovyParserVisitor.this.sourceBefore("("), annotation.getMembers().entrySet().stream().map(arg -> {
                    Space argPrefix;
                    if ("value".equals(arg.getKey())) {
                        int saveCursor = GroovyParserVisitor.this.cursor;
                        argPrefix = GroovyParserVisitor.this.whitespace();
                        if (!GroovyParserVisitor.this.source.startsWith("value", GroovyParserVisitor.this.cursor)) {
                            return new JRightPadded((Object)((org.openrewrite.java.tree.Expression)((org.openrewrite.java.tree.Expression)bodyVisitor.visit((ASTNode)arg.getValue())).withPrefix(argPrefix)), ((String)arg.getKey()).equals(lastArgKey) ? GroovyParserVisitor.this.sourceBefore(")") : GroovyParserVisitor.this.sourceBefore(","), Markers.EMPTY);
                        }
                        GroovyParserVisitor.this.cursor = saveCursor;
                    }
                    argPrefix = GroovyParserVisitor.this.sourceBefore((String)arg.getKey());
                    J.Identifier argName = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (String)arg.getKey(), null, null);
                    J.Assignment assign = new J.Assignment(Tree.randomId(), argPrefix, Markers.EMPTY, (org.openrewrite.java.tree.Expression)argName, GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("="), (org.openrewrite.java.tree.Expression)bodyVisitor.visit((ASTNode)arg.getValue())), null);
                    return JRightPadded.build((Object)assign).withAfter(((String)arg.getKey()).equals(lastArgKey) ? GroovyParserVisitor.this.sourceBefore(")") : GroovyParserVisitor.this.sourceBefore(","));
                }).collect(Collectors.toList()), (Markers)Markers.EMPTY);
            }
            this.queue.add(new J.Annotation(Tree.randomId(), prefix, Markers.EMPTY, (NameTree)annotationType, arguments));
        }

        public void visitMethod(MethodNode method) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            List annotations = method.getAnnotations().stream().map(a -> {
                this.visitAnnotation((AnnotationNode)a);
                return (J.Annotation)this.pollQueue();
            }).collect(Collectors.toList());
            List modifiers = GroovyParserVisitor.this.visitModifiers(method.getModifiers());
            TypeTree returnType = GroovyParserVisitor.this.visitTypeTree(method.getReturnType());
            J.Identifier name = new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(method.getName()), Markers.EMPTY, method.getName(), null, null);
            RewriteGroovyVisitor bodyVisitor = new RewriteGroovyVisitor((ASTNode)method, this);
            Space beforeParen = GroovyParserVisitor.this.sourceBefore("(");
            ArrayList<JRightPadded> params = new ArrayList<JRightPadded>(method.getParameters().length);
            Parameter[] unparsedParams = method.getParameters();
            for (int i = 0; i < unparsedParams.length; ++i) {
                Parameter param = unparsedParams[i];
                List paramAnnotations = param.getAnnotations().stream().map(a -> {
                    this.visitAnnotation((AnnotationNode)a);
                    return (J.Annotation)this.pollQueue();
                }).collect(Collectors.toList());
                Object paramType = param.isDynamicTyped() ? new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "", (JavaType)JavaType.ShallowClass.build((String)"java.lang.Object"), null) : GroovyParserVisitor.this.visitTypeTree(param.getOriginType());
                JRightPadded paramName = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, param.getName(), null, null), Collections.emptyList(), null, null));
                GroovyParserVisitor.this.cursor += param.getName().length();
                Expression defaultValue = param.getInitialExpression();
                if (defaultValue != null) {
                    paramName = paramName.withElement((Object)((J.VariableDeclarations.NamedVariable)paramName.getElement()).getPadding().withInitializer(new JLeftPadded(GroovyParserVisitor.this.sourceBefore("="), (Object)((org.openrewrite.java.tree.Expression)new RewriteGroovyVisitor((ASTNode)defaultValue, this).visit((ASTNode)defaultValue)), Markers.EMPTY)));
                }
                Space rightPad = GroovyParserVisitor.this.sourceBefore(i == unparsedParams.length - 1 ? ")" : ",");
                params.add(JRightPadded.build((Object)new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, paramAnnotations, Collections.emptyList(), paramType, null, Collections.emptyList(), Collections.singletonList(paramName))).withAfter(rightPad));
            }
            if (unparsedParams.length == 0) {
                params.add(JRightPadded.build((Object)new J.Empty(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(")"), Markers.EMPTY)));
            }
            JContainer throws_ = method.getExceptions().length == 0 ? null : JContainer.build((Space)GroovyParserVisitor.this.sourceBefore("throws"), (List)bodyVisitor.visitRightPadded((ASTNode[])method.getExceptions(), null), (Markers)Markers.EMPTY);
            J.Block body = method.getCode() == null ? null : (J.Block)bodyVisitor.visit((ASTNode)method.getCode());
            this.queue.add(new J.MethodDeclaration(Tree.randomId(), fmt, Markers.EMPTY, annotations, modifiers, null, returnType, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), JContainer.build((Space)beforeParen, params, (Markers)Markers.EMPTY), throws_, body, null, GroovyParserVisitor.this.typeMapping.methodType(method)));
        }

        private <T> T pollQueue() {
            return (T)this.queue.poll();
        }

        public RewriteGroovyClassVisitor(SourceUnit sourceUnit) {
            this.sourceUnit = sourceUnit;
        }

        public SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }
    }

    private class RewriteGroovyVisitor
    extends CodeVisitorSupport {
        private Cursor nodeCursor;
        private final Queue<Object> queue = new LinkedList<Object>();
        private final RewriteGroovyClassVisitor classVisitor;

        public RewriteGroovyVisitor(ASTNode root, RewriteGroovyClassVisitor classVisitor) {
            this.nodeCursor = new Cursor(null, (Object)root);
            this.classVisitor = classVisitor;
        }

        private <T> T visit(ASTNode node) {
            this.nodeCursor = new Cursor(this.nodeCursor, (Object)node);
            node.visit((GroovyCodeVisitor)this);
            this.nodeCursor = this.nodeCursor.getParentOrThrow();
            return this.pollQueue();
        }

        private <T> List<JRightPadded<T>> visitRightPadded(ASTNode[] nodes, @Nullable String afterLast) {
            ArrayList<JRightPadded<T>> ts = new ArrayList<JRightPadded<T>>(nodes.length);
            for (int i = 0; i < nodes.length; ++i) {
                ASTNode node = nodes[i];
                JRightPadded converted = JRightPadded.build(node instanceof ClassNode ? GroovyParserVisitor.this.visitTypeTree((ClassNode)node) : this.visit(node));
                if (i == nodes.length - 1) {
                    converted = converted.withAfter(GroovyParserVisitor.this.whitespace());
                    if (',' == GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor)) {
                        GroovyParserVisitor.this.cursor += 1;
                        converted = converted.withMarkers(Markers.EMPTY.add((Marker)new TrailingComma(Tree.randomId(), GroovyParserVisitor.this.whitespace())));
                    }
                    ts.add(converted);
                    if (afterLast == null || !GroovyParserVisitor.this.source.startsWith(afterLast, GroovyParserVisitor.this.cursor)) continue;
                    GroovyParserVisitor.this.cursor += afterLast.length();
                    continue;
                }
                ts.add(converted.withAfter(GroovyParserVisitor.this.sourceBefore(",")));
            }
            return ts;
        }

        private void visitParenthesized(ASTNode node, Space fmt) {
            GroovyParserVisitor.this.skip("(");
            this.queue.add(new J.Parentheses(Tree.randomId(), fmt, Markers.EMPTY, this.convert(node, t -> GroovyParserVisitor.this.sourceBefore(")"))));
        }

        public void visitArgumentlistExpression(ArgumentListExpression expression) {
            ArrayList<JRightPadded> args = new ArrayList<JRightPadded>(expression.getExpressions().size());
            int saveCursor = GroovyParserVisitor.this.cursor;
            Space beforeOpenParen = GroovyParserVisitor.this.whitespace();
            OmitParentheses omitParentheses = null;
            if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                GroovyParserVisitor.this.cursor++;
            } else {
                omitParentheses = new OmitParentheses(Tree.randomId());
                beforeOpenParen = Space.EMPTY;
                GroovyParserVisitor.this.cursor = saveCursor;
            }
            List unparsedArgs = expression.getExpressions();
            if (unparsedArgs.size() > 1 && unparsedArgs.get(0) instanceof MapExpression && (((Expression)unparsedArgs.get(0)).getLastLineNumber() > ((Expression)unparsedArgs.get(1)).getLastLineNumber() || ((Expression)unparsedArgs.get(0)).getLastLineNumber() == ((Expression)unparsedArgs.get(1)).getLastLineNumber() && ((Expression)unparsedArgs.get(0)).getLastColumnNumber() > ((Expression)unparsedArgs.get(1)).getLastColumnNumber())) {
                MapExpression namedArgExpressions = (MapExpression)unparsedArgs.get(0);
                unparsedArgs = Stream.concat(namedArgExpressions.getMapEntryExpressions().stream(), unparsedArgs.subList(1, unparsedArgs.size()).stream()).sorted(Comparator.comparing(ASTNode::getLastLineNumber).thenComparing(ASTNode::getLastColumnNumber)).collect(Collectors.toList());
            } else if (unparsedArgs.size() > 0 && unparsedArgs.get(0) instanceof MapExpression) {
                saveCursor = GroovyParserVisitor.this.cursor;
                GroovyParserVisitor.this.whitespace();
                boolean isOpeningBracketPresent = '[' == GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor);
                GroovyParserVisitor.this.cursor = saveCursor;
                if (!isOpeningBracketPresent) {
                    MapExpression namedArgExpressions = (MapExpression)unparsedArgs.get(0);
                    unparsedArgs = Stream.concat(namedArgExpressions.getMapEntryExpressions().stream(), unparsedArgs.subList(1, unparsedArgs.size()).stream()).collect(Collectors.toList());
                }
            }
            for (int i = 0; i < unparsedArgs.size(); ++i) {
                Expression rawArg = (Expression)unparsedArgs.get(i);
                Object arg = GroovyParserVisitor.appearsInSource((ASTNode)rawArg) ? (org.openrewrite.java.tree.Expression)this.visit((ASTNode)rawArg) : new J.Empty(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY);
                if (omitParentheses != null) {
                    arg = (org.openrewrite.java.tree.Expression)arg.withMarkers(arg.getMarkers().add((Marker)omitParentheses));
                }
                Space after = Space.EMPTY;
                if (i == unparsedArgs.size() - 1) {
                    if (omitParentheses == null) {
                        after = GroovyParserVisitor.this.sourceBefore(")");
                    }
                } else {
                    after = GroovyParserVisitor.this.whitespace();
                    if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ')') {
                        omitParentheses = new OmitParentheses(Tree.randomId());
                    }
                    GroovyParserVisitor.this.cursor++;
                }
                args.add(JRightPadded.build((Object)arg).withAfter(after));
            }
            if (unparsedArgs.isEmpty()) {
                J.Empty element = new J.Empty(Tree.randomId(), omitParentheses == null ? GroovyParserVisitor.this.sourceBefore(")") : Space.EMPTY, Markers.EMPTY);
                if (omitParentheses != null) {
                    element = (org.openrewrite.java.tree.Expression)element.withMarkers(element.getMarkers().add((Marker)omitParentheses));
                }
                args.add(JRightPadded.build((Object)element));
            }
            this.queue.add(JContainer.build((Space)beforeOpenParen, args, (Markers)Markers.EMPTY));
        }

        public void visitClassExpression(ClassExpression clazz) {
            this.queue.add(TypeTree.build((String)clazz.getType().getUnresolvedName()).withType(GroovyParserVisitor.this.typeMapping.type((ASTNode)clazz.getType())).withPrefix(GroovyParserVisitor.this.sourceBefore(clazz.getType().getUnresolvedName())));
        }

        public void visitBinaryExpression(BinaryExpression binary) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                this.visitParenthesized((ASTNode)binary, fmt);
            } else {
                org.openrewrite.java.tree.Expression left = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)binary.getLeftExpression());
                Space opPrefix = GroovyParserVisitor.this.whitespace();
                boolean assignment = false;
                boolean instanceOf = false;
                J.AssignmentOperation.Type assignOp = null;
                J.Binary.Type binaryOp = null;
                G.Binary.Type gBinaryOp = null;
                switch (binary.getOperation().getText()) {
                    case "+": {
                        binaryOp = J.Binary.Type.Addition;
                        break;
                    }
                    case "&&": {
                        binaryOp = J.Binary.Type.And;
                        break;
                    }
                    case "&": {
                        binaryOp = J.Binary.Type.BitAnd;
                        break;
                    }
                    case "|": {
                        binaryOp = J.Binary.Type.BitOr;
                        break;
                    }
                    case "^": {
                        binaryOp = J.Binary.Type.BitXor;
                        break;
                    }
                    case "/": {
                        binaryOp = J.Binary.Type.Division;
                        break;
                    }
                    case "==": {
                        binaryOp = J.Binary.Type.Equal;
                        break;
                    }
                    case ">": {
                        binaryOp = J.Binary.Type.GreaterThan;
                        break;
                    }
                    case ">=": {
                        binaryOp = J.Binary.Type.GreaterThanOrEqual;
                        break;
                    }
                    case "<<": {
                        binaryOp = J.Binary.Type.LeftShift;
                        break;
                    }
                    case "<": {
                        binaryOp = J.Binary.Type.LessThan;
                        break;
                    }
                    case "<=": {
                        binaryOp = J.Binary.Type.LessThanOrEqual;
                        break;
                    }
                    case "%": {
                        binaryOp = J.Binary.Type.Modulo;
                        break;
                    }
                    case "*": {
                        binaryOp = J.Binary.Type.Multiplication;
                        break;
                    }
                    case "!=": {
                        binaryOp = J.Binary.Type.NotEqual;
                        break;
                    }
                    case "||": {
                        binaryOp = J.Binary.Type.Or;
                        break;
                    }
                    case ">>": {
                        binaryOp = J.Binary.Type.RightShift;
                        break;
                    }
                    case "-": {
                        binaryOp = J.Binary.Type.Subtraction;
                        break;
                    }
                    case ">>>": {
                        binaryOp = J.Binary.Type.UnsignedRightShift;
                        break;
                    }
                    case "instanceof": {
                        instanceOf = true;
                        break;
                    }
                    case "=": {
                        assignment = true;
                        break;
                    }
                    case "+=": {
                        assignOp = J.AssignmentOperation.Type.Addition;
                        break;
                    }
                    case "-=": {
                        assignOp = J.AssignmentOperation.Type.Subtraction;
                        break;
                    }
                    case "&=": {
                        assignOp = J.AssignmentOperation.Type.BitAnd;
                        break;
                    }
                    case "|=": {
                        assignOp = J.AssignmentOperation.Type.BitOr;
                        break;
                    }
                    case "^=": {
                        assignOp = J.AssignmentOperation.Type.BitXor;
                        break;
                    }
                    case "/=": {
                        assignOp = J.AssignmentOperation.Type.Division;
                        break;
                    }
                    case "<<=": {
                        assignOp = J.AssignmentOperation.Type.LeftShift;
                        break;
                    }
                    case "%=": {
                        assignOp = J.AssignmentOperation.Type.Modulo;
                        break;
                    }
                    case "*=": {
                        assignOp = J.AssignmentOperation.Type.Multiplication;
                        break;
                    }
                    case ">>=": {
                        assignOp = J.AssignmentOperation.Type.RightShift;
                        break;
                    }
                    case ">>>=": {
                        assignOp = J.AssignmentOperation.Type.UnsignedRightShift;
                        break;
                    }
                    case "=~": {
                        gBinaryOp = G.Binary.Type.Find;
                        break;
                    }
                    case "==~": {
                        gBinaryOp = G.Binary.Type.Match;
                        break;
                    }
                    case "[": {
                        gBinaryOp = G.Binary.Type.Access;
                        break;
                    }
                    case "in": {
                        gBinaryOp = G.Binary.Type.In;
                    }
                }
                GroovyParserVisitor.this.cursor += binary.getOperation().getText().length();
                org.openrewrite.java.tree.Expression right = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)binary.getRightExpression());
                if (assignment) {
                    this.queue.add(new J.Assignment(Tree.randomId(), fmt, Markers.EMPTY, left, JLeftPadded.build((Object)right).withBefore(opPrefix), GroovyParserVisitor.this.typeMapping.type((ASTNode)binary.getType())));
                } else if (instanceOf) {
                    this.queue.add(new J.InstanceOf(Tree.randomId(), fmt, Markers.EMPTY, JRightPadded.build((Object)left).withAfter(opPrefix), (J)right, null, GroovyParserVisitor.this.typeMapping.type((ASTNode)binary.getType())));
                } else if (assignOp != null) {
                    this.queue.add(new J.AssignmentOperation(Tree.randomId(), fmt, Markers.EMPTY, left, JLeftPadded.build((Object)assignOp).withBefore(opPrefix), right, GroovyParserVisitor.this.typeMapping.type((ASTNode)binary.getType())));
                } else if (binaryOp != null) {
                    this.queue.add(new J.Binary(Tree.randomId(), fmt, Markers.EMPTY, left, JLeftPadded.build((Object)binaryOp).withBefore(opPrefix), right, GroovyParserVisitor.this.typeMapping.type((ASTNode)binary.getType())));
                } else if (gBinaryOp != null) {
                    Space after = Space.EMPTY;
                    if (gBinaryOp == G.Binary.Type.Access) {
                        after = GroovyParserVisitor.this.sourceBefore("]");
                    }
                    this.queue.add(new G.Binary(Tree.randomId(), fmt, Markers.EMPTY, left, (JLeftPadded<G.Binary.Type>)JLeftPadded.build((Object)((Object)gBinaryOp)).withBefore(opPrefix), right, after, GroovyParserVisitor.this.typeMapping.type((ASTNode)binary.getType())));
                }
            }
        }

        public void visitBlockStatement(BlockStatement block) {
            Space fmt = Space.EMPTY;
            Object parent = this.nodeCursor.getParentOrThrow().getValue();
            if (!(parent instanceof ClosureExpression)) {
                fmt = GroovyParserVisitor.this.sourceBefore("{");
            }
            ArrayList<JRightPadded> statements = new ArrayList<JRightPadded>(block.getStatements().size());
            List blockStatements = block.getStatements();
            for (int i = 0; i < blockStatements.size(); ++i) {
                ASTNode statement = (ASTNode)blockStatements.get(i);
                J expr = (J)this.visit(statement);
                if (i == blockStatements.size() - 1 && expr instanceof org.openrewrite.java.tree.Expression && (parent instanceof ClosureExpression || parent instanceof MethodNode && !JavaType.Primitive.Void.equals((Object)GroovyParserVisitor.this.typeMapping.type((ASTNode)((MethodNode)parent).getReturnType())))) {
                    expr = new J.Return(Tree.randomId(), expr.getPrefix(), Markers.EMPTY, (org.openrewrite.java.tree.Expression)expr.withPrefix(Space.EMPTY));
                    expr = (J)expr.withMarkers(expr.getMarkers().add((Marker)new ImplicitReturn(Tree.randomId())));
                }
                JRightPadded stat = JRightPadded.build((Object)((Statement)expr));
                int saveCursor = GroovyParserVisitor.this.cursor;
                Space beforeSemicolon = GroovyParserVisitor.this.whitespace();
                if (GroovyParserVisitor.this.cursor < GroovyParserVisitor.this.source.length() && GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ';') {
                    stat = stat.withMarkers(stat.getMarkers().add((Marker)new Semicolon(Tree.randomId()))).withAfter(beforeSemicolon);
                    GroovyParserVisitor.this.cursor++;
                } else {
                    GroovyParserVisitor.this.cursor = saveCursor;
                }
                statements.add(stat);
            }
            Space beforeBrace = GroovyParserVisitor.this.whitespace();
            this.queue.add(new J.Block(Tree.randomId(), fmt, Markers.EMPTY, JRightPadded.build((Object)false), statements, beforeBrace));
            if (!(parent instanceof ClosureExpression)) {
                GroovyParserVisitor.this.sourceBefore("}");
            }
        }

        public void visitCatchStatement(CatchStatement node) {
            Space prefix = GroovyParserVisitor.this.sourceBefore("catch");
            Space parenPrefix = GroovyParserVisitor.this.sourceBefore("(");
            Parameter param = node.getVariable();
            Space paramPrefix = GroovyParserVisitor.this.whitespace();
            Object paramType = "java.lang.Exception".equals(param.getType().getName()) && !GroovyParserVisitor.this.source.startsWith("Exception", GroovyParserVisitor.this.cursor) && !GroovyParserVisitor.this.source.startsWith("java.lang.Exception", GroovyParserVisitor.this.cursor) ? new J.Identifier(Tree.randomId(), paramPrefix, Markers.EMPTY, "", (JavaType)JavaType.ShallowClass.build((String)"java.lang.Exception"), null) : (TypeTree)GroovyParserVisitor.this.visitTypeTree(param.getOriginType()).withPrefix(paramPrefix);
            JRightPadded paramName = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, param.getName(), null, null), Collections.emptyList(), null, null));
            GroovyParserVisitor.this.cursor += param.getName().length();
            Space rightPad = GroovyParserVisitor.this.whitespace();
            GroovyParserVisitor.this.cursor += 1;
            JRightPadded variable = JRightPadded.build((Object)new J.VariableDeclarations(Tree.randomId(), paramType.getPrefix(), Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), (TypeTree)paramType.withPrefix(Space.EMPTY), null, Collections.emptyList(), Collections.singletonList(paramName))).withAfter(rightPad);
            J.ControlParentheses catchControl = new J.ControlParentheses(Tree.randomId(), parenPrefix, Markers.EMPTY, variable);
            this.queue.add(new J.Try.Catch(Tree.randomId(), prefix, Markers.EMPTY, catchControl, (J.Block)this.visit((ASTNode)node.getCode())));
        }

        public void visitBreakStatement(BreakStatement statement) {
            this.queue.add(new J.Break(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("break"), Markers.EMPTY, statement.getLabel() == null ? null : new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(statement.getLabel()), Markers.EMPTY, statement.getLabel(), null, null)));
        }

        public void visitCaseStatement(CaseStatement statement) {
            this.queue.add(new J.Case(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("case"), Markers.EMPTY, J.Case.Type.Statement, null, JContainer.build(Collections.singletonList(JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)statement.getExpression()))))), JContainer.build((Space)GroovyParserVisitor.this.sourceBefore(":"), this.convertStatements(((BlockStatement)statement.getCode()).getStatements(), t -> Space.EMPTY), (Markers)Markers.EMPTY), null));
        }

        private J.Case visitDefaultCaseStatement(BlockStatement statement) {
            return new J.Case(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("default"), Markers.EMPTY, J.Case.Type.Statement, null, JContainer.build(Collections.singletonList(JRightPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, GroovyParserVisitor.this.skip("default"), null, null)))), JContainer.build((Space)GroovyParserVisitor.this.sourceBefore(":"), this.convertStatements(statement.getStatements(), t -> Space.EMPTY), (Markers)Markers.EMPTY), null);
        }

        public void visitCastExpression(CastExpression cast) {
            if (cast.getLineNumber() == cast.getExpression().getLineNumber() && cast.getColumnNumber() == cast.getExpression().getColumnNumber()) {
                Space prefix = GroovyParserVisitor.this.whitespace();
                org.openrewrite.java.tree.Expression expr = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)cast.getExpression());
                Space asPrefix = GroovyParserVisitor.this.sourceBefore("as");
                this.queue.add(new J.TypeCast(Tree.randomId(), prefix, new Markers(Tree.randomId(), Collections.singletonList(new AsStyleTypeCast(Tree.randomId()))), new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded((Object)GroovyParserVisitor.this.visitTypeTree(cast.getType()), asPrefix, Markers.EMPTY)), expr));
            } else {
                this.queue.add(new J.TypeCast(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded((Object)GroovyParserVisitor.this.visitTypeTree(cast.getType()), GroovyParserVisitor.this.sourceBefore(")"), Markers.EMPTY)), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)cast.getExpression())));
            }
        }

        public void visitClosureExpression(ClosureExpression expression) {
            Space prefix = GroovyParserVisitor.this.sourceBefore("{");
            JavaType closureType = GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType((Expression)expression));
            List paramExprs = Collections.emptyList();
            if (expression.getParameters() != null && expression.getParameters().length > 0) {
                paramExprs = new ArrayList(expression.getParameters().length);
                Parameter[] parameters = expression.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter p = parameters[i];
                    JavaType type = GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType(p));
                    J.VariableDeclarations expr = new J.VariableDeclarations(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), p.isDynamicTyped() ? null : GroovyParserVisitor.this.visitTypeTree(p.getType()), null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(p.getName()), Markers.EMPTY, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, p.getName(), type, null), Collections.emptyList(), null, GroovyParserVisitor.this.typeMapping.variableType(p.getName(), (ASTNode)GroovyParserVisitor.staticType(p))))));
                    JRightPadded param2 = JRightPadded.build((Object)expr);
                    if (i != parameters.length - 1) {
                        param2 = param2.withAfter(GroovyParserVisitor.this.sourceBefore(","));
                    }
                    paramExprs.add(param2);
                }
            }
            J.Lambda.Parameters params = new J.Lambda.Parameters(Tree.randomId(), Space.EMPTY, Markers.EMPTY, false, paramExprs);
            int saveCursor = GroovyParserVisitor.this.cursor;
            Space arrowPrefix = GroovyParserVisitor.this.whitespace();
            if (GroovyParserVisitor.this.source.startsWith("->", GroovyParserVisitor.this.cursor)) {
                GroovyParserVisitor.this.cursor += "->".length();
                params = params.getParameters().isEmpty() ? params.getPadding().withParams(Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(arrowPrefix))) : params.getPadding().withParams(ListUtils.mapLast((List)params.getPadding().getParams(), param -> param.withAfter(arrowPrefix)));
            } else {
                GroovyParserVisitor.this.cursor = saveCursor;
            }
            J body = (J)this.visit((ASTNode)expression.getCode());
            this.queue.add(new J.Lambda(Tree.randomId(), prefix, Markers.EMPTY, params, Space.EMPTY, body, closureType));
            GroovyParserVisitor.this.cursor += 1;
        }

        public void visitClosureListExpression(ClosureListExpression closureListExpression) {
            List expressions = closureListExpression.getExpressions();
            ArrayList<JRightPadded> results = new ArrayList<JRightPadded>(closureListExpression.getExpressions().size());
            int expressionsSize = expressions.size();
            for (int i = 0; i < expressionsSize; ++i) {
                results.add(JRightPadded.build(this.visit((ASTNode)expressions.get(i))).withAfter(GroovyParserVisitor.this.whitespace()));
                if (i >= expressionsSize - 1) continue;
                GroovyParserVisitor.this.cursor++;
            }
            this.queue.add(results);
        }

        public void visitConstantExpression(ConstantExpression expression) {
            JavaType.Primitive jType;
            Space prefix = GroovyParserVisitor.this.whitespace();
            String text = expression.getText();
            Object value = expression.getValue();
            ClassNode type = expression.getType();
            if (type == ClassHelper.BigDecimal_TYPE) {
                jType = JavaType.Primitive.Double;
                value = ((BigDecimal)value).doubleValue();
            } else if (type == ClassHelper.boolean_TYPE) {
                jType = JavaType.Primitive.Boolean;
            } else if (type == ClassHelper.byte_TYPE) {
                jType = JavaType.Primitive.Byte;
            } else if (type == ClassHelper.char_TYPE) {
                jType = JavaType.Primitive.Char;
            } else if (type == ClassHelper.double_TYPE || "java.lang.Double".equals(type.getName())) {
                jType = JavaType.Primitive.Double;
                if (expression.getNodeMetaData().get("_FLOATING_POINT_LITERAL_TEXT") instanceof String) {
                    text = (String)expression.getNodeMetaData().get("_FLOATING_POINT_LITERAL_TEXT");
                }
            } else if (type == ClassHelper.float_TYPE || "java.lang.Float".equals(type.getName())) {
                jType = JavaType.Primitive.Float;
                if (expression.getNodeMetaData().get("_FLOATING_POINT_LITERAL_TEXT") instanceof String) {
                    text = (String)expression.getNodeMetaData().get("_FLOATING_POINT_LITERAL_TEXT");
                }
            } else if (type == ClassHelper.int_TYPE || "java.lang.Integer".equals(type.getName())) {
                jType = JavaType.Primitive.Int;
                if (expression.getNodeMetaData().get("_INTEGER_LITERAL_TEXT") instanceof String) {
                    text = (String)expression.getNodeMetaData().get("_INTEGER_LITERAL_TEXT");
                }
            } else if (type == ClassHelper.long_TYPE || "java.lang.Long".equals(type.getName())) {
                if (expression.getNodeMetaData().get("_INTEGER_LITERAL_TEXT") instanceof String) {
                    text = (String)expression.getNodeMetaData().get("_INTEGER_LITERAL_TEXT");
                }
                jType = JavaType.Primitive.Long;
            } else if (type == ClassHelper.short_TYPE || "java.lang.Short".equals(type.getName())) {
                jType = JavaType.Primitive.Short;
            } else if (type == ClassHelper.STRING_TYPE) {
                jType = JavaType.Primitive.String;
                int length = GroovyParserVisitor.this.sourceLengthOfNext((ASTNode)expression);
                text = GroovyParserVisitor.this.source.substring(GroovyParserVisitor.this.cursor, GroovyParserVisitor.this.cursor + length);
                int delimiterLength = 0;
                if (text.startsWith("$/")) {
                    delimiterLength = 2;
                } else if (text.startsWith("\"\"\"") || text.startsWith("'''")) {
                    delimiterLength = 3;
                } else if (text.startsWith("/") || text.startsWith("\"") || text.startsWith("'")) {
                    delimiterLength = 1;
                }
                value = text.substring(delimiterLength, text.length() - delimiterLength);
            } else if (expression.isNullExpression()) {
                text = "null";
                jType = JavaType.Primitive.Null;
            } else {
                GroovyParserVisitor.this.ctx.getOnError().accept(new IllegalStateException("Unexpected constant type " + type));
                return;
            }
            if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                this.visitParenthesized((ASTNode)expression, prefix);
            } else {
                if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '+' && !text.startsWith("+")) {
                    text = "+" + text;
                }
                GroovyParserVisitor.this.cursor += text.length();
                this.queue.add(new J.Literal(Tree.randomId(), prefix, Markers.EMPTY, value, text, null, jType));
            }
        }

        public void visitConstructorCallExpression(ConstructorCallExpression ctor) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("new");
            TypeTree clazz = GroovyParserVisitor.this.visitTypeTree(ctor.getType());
            JContainer args = (JContainer)this.visit((ASTNode)ctor.getArguments());
            J.Block body = null;
            if (ctor.isUsingAnonymousInnerClass() && ctor.getType() instanceof InnerClassNode) {
                body = this.classVisitor.visitClassBlock(ctor.getType());
            }
            MethodNode methodNode = (MethodNode)ctor.getNodeMetaData().get(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            this.queue.add(new J.NewClass(Tree.randomId(), fmt, Markers.EMPTY, null, Space.EMPTY, clazz, args, body, GroovyParserVisitor.this.typeMapping.methodType(methodNode)));
        }

        public void visitNotExpression(NotExpression expression) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("!");
            JLeftPadded op = GroovyParserVisitor.this.padLeft(Space.EMPTY, J.Unary.Type.Not);
            org.openrewrite.java.tree.Expression expr = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)expression.getExpression());
            this.queue.add(new J.Unary(Tree.randomId(), fmt, Markers.EMPTY, op, expr, GroovyParserVisitor.this.typeMapping.type((ASTNode)expression.getType())));
        }

        public void visitDeclarationExpression(DeclarationExpression expression) {
            TypeTree typeExpr = this.visitVariableExpressionType(expression.getVariableExpression());
            if (expression.isMultipleAssignmentDeclaration()) {
                throw new UnsupportedOperationException("FIXME");
            }
            J.Identifier name = (J.Identifier)this.visit((ASTNode)expression.getVariableExpression());
            J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), name.getPrefix(), Markers.EMPTY, name.withPrefix(Space.EMPTY), Collections.emptyList(), null, GroovyParserVisitor.this.typeMapping.variableType(name.getSimpleName(), typeExpr.getType()));
            if (!(expression.getRightExpression() instanceof EmptyExpression)) {
                Space beforeAssign = GroovyParserVisitor.this.sourceBefore("=");
                org.openrewrite.java.tree.Expression initializer = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)expression.getRightExpression());
                namedVariable = namedVariable.getPadding().withInitializer(GroovyParserVisitor.this.padLeft(beforeAssign, initializer));
            }
            J.VariableDeclarations variableDeclarations = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), typeExpr, null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)namedVariable)));
            this.queue.add(variableDeclarations);
        }

        public void visitEmptyExpression(EmptyExpression expression) {
            this.queue.add(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY));
        }

        public void visitExpressionStatement(ExpressionStatement statement) {
            ArrayList<J.Label> labels = null;
            if (statement.getStatementLabels() != null && !statement.getStatementLabels().isEmpty()) {
                labels = new ArrayList<J.Label>(statement.getStatementLabels().size());
                for (int i = 0; i < statement.getStatementLabels().size(); ++i) {
                    labels.add(new J.Label(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, JRightPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, GroovyParserVisitor.this.name(), null, null)).withAfter(GroovyParserVisitor.this.sourceBefore(":")), (Statement)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)));
                }
            }
            super.visitExpressionStatement(statement);
            if (this.queue.peek() instanceof org.openrewrite.java.tree.Expression && !(this.queue.peek() instanceof Statement)) {
                this.queue.add(new G.ExpressionStatement(Tree.randomId(), (org.openrewrite.java.tree.Expression)this.queue.poll()));
            }
            if (labels != null) {
                Statement result = this.condenseLabels(labels, (Statement)this.queue.poll());
                this.queue.add(result);
            }
        }

        Statement condenseLabels(List<J.Label> labels, Statement s) {
            if (labels.size() == 0) {
                return s;
            }
            return labels.get(0).withStatement(this.condenseLabels(labels.subList(1, labels.size()), s));
        }

        public void visitForLoop(ForStatement forLoop) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("for");
            Space controlFmt = GroovyParserVisitor.this.sourceBefore("(");
            if (forLoop.getCollectionExpression() instanceof ClosureListExpression) {
                List controls = (List)this.visit((ASTNode)forLoop.getCollectionExpression());
                List init = ((JRightPadded)controls.get(0)).getElement() instanceof List ? (List)((JRightPadded)controls.get(0)).getElement() : Collections.singletonList((JRightPadded)controls.get(0));
                JRightPadded condition = (JRightPadded)controls.get(1);
                List update = ((JRightPadded)controls.get(2)).getElement() instanceof List ? (List)((JRightPadded)controls.get(2)).getElement() : Collections.singletonList((JRightPadded)controls.get(2));
                GroovyParserVisitor.this.cursor++;
                this.queue.add(new J.ForLoop(Tree.randomId(), fmt, Markers.EMPTY, new J.ForLoop.Control(Tree.randomId(), controlFmt, Markers.EMPTY, init, condition, update), JRightPadded.build((Object)((Statement)this.visit((ASTNode)forLoop.getLoopBlock())))));
            } else {
                Parameter param = forLoop.getVariable();
                Space paramFmt = GroovyParserVisitor.this.whitespace();
                TypeTree paramType = param.getOriginType().getColumnNumber() >= 0 ? GroovyParserVisitor.this.visitTypeTree(param.getOriginType()) : null;
                JRightPadded paramName = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, param.getName(), null, null), Collections.emptyList(), null, null));
                GroovyParserVisitor.this.cursor += param.getName().length();
                Space rightPad = GroovyParserVisitor.this.whitespace();
                Markers forEachMarkers = Markers.EMPTY;
                if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ':') {
                    GroovyParserVisitor.this.cursor++;
                } else {
                    GroovyParserVisitor.this.cursor += 2;
                    forEachMarkers = forEachMarkers.add((Marker)new InStyleForEachLoop(Tree.randomId()));
                }
                JRightPadded variable = JRightPadded.build((Object)new J.VariableDeclarations(Tree.randomId(), paramFmt, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), paramType, null, Collections.emptyList(), Collections.singletonList(paramName))).withAfter(rightPad);
                JRightPadded iterable = JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)forLoop.getCollectionExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")"));
                this.queue.add(new J.ForEachLoop(Tree.randomId(), fmt, forEachMarkers, new J.ForEachLoop.Control(Tree.randomId(), controlFmt, Markers.EMPTY, variable, iterable), JRightPadded.build((Object)((Statement)this.visit((ASTNode)forLoop.getLoopBlock())))));
            }
        }

        public void visitIfElse(IfStatement ifElse) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("if");
            J.ControlParentheses ifCondition = new J.ControlParentheses(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)ifElse.getBooleanExpression().getExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")")));
            JRightPadded then = GroovyParserVisitor.this.maybeSemicolon((J)((Statement)this.visit((ASTNode)ifElse.getIfBlock())));
            J.If.Else else_ = ifElse.getElseBlock() instanceof EmptyStatement ? null : new J.If.Else(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("else"), Markers.EMPTY, GroovyParserVisitor.this.maybeSemicolon((J)((Statement)this.visit((ASTNode)ifElse.getElseBlock()))));
            this.queue.add(new J.If(Tree.randomId(), fmt, Markers.EMPTY, ifCondition, then, else_));
        }

        public void visitGStringExpression(GStringExpression gstring) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            String delimiter = GroovyParserVisitor.this.source.startsWith("\"\"\"", GroovyParserVisitor.this.cursor) ? "\"\"\"" : (GroovyParserVisitor.this.source.startsWith("/", GroovyParserVisitor.this.cursor) ? "/" : (GroovyParserVisitor.this.source.startsWith("$/", GroovyParserVisitor.this.cursor) ? "$/" : "\""));
            GroovyParserVisitor.this.cursor += delimiter.length();
            TreeMap<LineColumn, ConstantExpression> sortedByPosition = new TreeMap<LineColumn, ConstantExpression>();
            for (ConstantExpression e : gstring.getStrings()) {
                if (e.getText().isEmpty()) continue;
                sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)e), e);
            }
            for (ConstantExpression e : gstring.getValues()) {
                sortedByPosition.put(GroovyParserVisitor.pos((ASTNode)e), e);
            }
            ArrayList rawExprs = new ArrayList(sortedByPosition.values());
            ArrayList<J> strings = new ArrayList<J>(rawExprs.size());
            for (int i = 0; i < rawExprs.size(); ++i) {
                Expression e = (Expression)rawExprs.get(i);
                if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '$') {
                    boolean inCurlies;
                    GroovyParserVisitor.this.cursor++;
                    boolean bl = inCurlies = GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '{';
                    if (inCurlies) {
                        GroovyParserVisitor.this.cursor++;
                    }
                    strings.add(new G.GString.Value(Tree.randomId(), Markers.EMPTY, (J)this.visit((ASTNode)e), inCurlies ? GroovyParserVisitor.this.sourceBefore("}") : Space.EMPTY, inCurlies));
                    continue;
                }
                if (e instanceof ConstantExpression) {
                    ConstantExpression cs = (ConstantExpression)e;
                    int length = GroovyParserVisitor.this.sourceLengthOfNext((ASTNode)cs);
                    if (i == 0 || i == rawExprs.size() - 1) {
                        length -= delimiter.length();
                    }
                    if (i < rawExprs.size() - 1) {
                        --length;
                    }
                    String value = GroovyParserVisitor.this.source.substring(GroovyParserVisitor.this.cursor, GroovyParserVisitor.this.cursor + length);
                    strings.add((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)value, value, null, JavaType.Primitive.String));
                    GroovyParserVisitor.this.cursor += value.length();
                    continue;
                }
                strings.add((J)this.visit((ASTNode)e));
            }
            this.queue.add(new G.GString(Tree.randomId(), fmt, Markers.EMPTY, delimiter, strings, GroovyParserVisitor.this.typeMapping.type((ASTNode)gstring.getType())));
            GroovyParserVisitor.this.cursor += delimiter.length();
        }

        public void visitListExpression(ListExpression list) {
            if (list.getExpressions().isEmpty()) {
                this.queue.add(new G.ListLiteral(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("["), Markers.EMPTY, (JContainer<org.openrewrite.java.tree.Expression>)JContainer.build(Collections.singletonList(new JRightPadded((Object)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), GroovyParserVisitor.this.sourceBefore("]"), Markers.EMPTY))), GroovyParserVisitor.this.typeMapping.type((ASTNode)list.getType())));
            } else {
                this.queue.add(new G.ListLiteral(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("["), Markers.EMPTY, (JContainer<org.openrewrite.java.tree.Expression>)JContainer.build(this.visitRightPadded(list.getExpressions().toArray(new ASTNode[0]), "]")), GroovyParserVisitor.this.typeMapping.type((ASTNode)list.getType())));
            }
        }

        public void visitMapEntryExpression(MapEntryExpression expression) {
            G.MapEntry mapEntry = new G.MapEntry(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, (JRightPadded<org.openrewrite.java.tree.Expression>)JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)expression.getKeyExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(":")), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)expression.getValueExpression()), null);
            this.queue.add(mapEntry);
        }

        public void visitMapExpression(MapExpression map) {
            Space prefix = GroovyParserVisitor.this.sourceBefore("[");
            JContainer entries = map.getMapEntryExpressions().isEmpty() ? JContainer.build(Collections.singletonList(JRightPadded.build((Object)new G.MapEntry(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, (JRightPadded<org.openrewrite.java.tree.Expression>)JRightPadded.build((Object)new J.Empty(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(":"), Markers.EMPTY)), (org.openrewrite.java.tree.Expression)new J.Empty(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("]"), Markers.EMPTY), null)))) : JContainer.build(this.visitRightPadded(map.getMapEntryExpressions().toArray(new ASTNode[0]), "]"));
            this.queue.add(new G.MapLiteral(Tree.randomId(), prefix, Markers.EMPTY, (JContainer<G.MapEntry>)entries, GroovyParserVisitor.this.typeMapping.type((ASTNode)map.getType())));
        }

        public void visitMethodCallExpression(MethodCallExpression call) {
            ArgumentListExpression args;
            J.Identifier name;
            Space fmt = GroovyParserVisitor.this.whitespace();
            ImplicitDot implicitDot = null;
            JRightPadded select = null;
            if (!call.isImplicitThis()) {
                org.openrewrite.java.tree.Expression selectExpr = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)call.getObjectExpression());
                int saveCursor = GroovyParserVisitor.this.cursor;
                Space afterSelect = GroovyParserVisitor.this.whitespace();
                if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '.' || GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '?' || GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '*') {
                    GroovyParserVisitor.this.cursor = saveCursor;
                    afterSelect = GroovyParserVisitor.this.sourceBefore(call.isSpreadSafe() ? "*." : (call.isSafe() ? "?." : "."));
                } else {
                    implicitDot = new ImplicitDot(Tree.randomId());
                }
                select = JRightPadded.build((Object)selectExpr).withAfter(afterSelect);
            }
            if (call.getMethodAsString().equals(GroovyParserVisitor.this.source.substring(GroovyParserVisitor.this.cursor, GroovyParserVisitor.this.cursor + call.getMethodAsString().length()))) {
                name = new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(call.getMethodAsString()), Markers.EMPTY, call.getMethodAsString(), null, null);
            } else if (select != null && select.getElement() instanceof J.Identifier) {
                name = (J.Identifier)select.getElement();
                select = null;
            } else {
                throw new IllegalArgumentException("Unable to parse method call");
            }
            if (call.isSpreadSafe()) {
                name = name.withMarkers(name.getMarkers().add((Marker)new StarDot(Tree.randomId())));
            }
            if (call.isSafe()) {
                name = name.withMarkers(name.getMarkers().add((Marker)new NullSafe(Tree.randomId())));
            }
            if (implicitDot != null) {
                name = name.withMarkers(name.getMarkers().add(implicitDot));
            }
            Markers markers = Markers.EMPTY;
            if (call.getArguments() instanceof ArgumentListExpression) {
                args = (ArgumentListExpression)call.getArguments();
                if (call.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE) != null) {
                    for (Expression arg : args.getExpressions()) {
                        if (!(arg instanceof ClosureExpression)) continue;
                        ClosureExpression cl = (ClosureExpression)arg;
                        ClassNode actualParamTypeRaw = (ClassNode)call.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        for (Parameter p : cl.getParameters()) {
                            if (!p.isDynamicTyped()) continue;
                            p.setType(actualParamTypeRaw);
                            p.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        }
                        for (Map.Entry entry : cl.getVariableScope().getDeclaredVariables().entrySet()) {
                            if (!(entry.getValue() instanceof Parameter) || !((Variable)entry.getValue()).isDynamicTyped()) continue;
                            Parameter p = (Parameter)entry.getValue();
                            p.setType(actualParamTypeRaw);
                            p.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        }
                    }
                }
                if (args.getExpressions().size() == 1 && args.getExpressions().get(0) instanceof ClosureExpression) {
                    int saveCursor = GroovyParserVisitor.this.cursor;
                    Space prefix = GroovyParserVisitor.this.whitespace();
                    if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                        GroovyParserVisitor.this.cursor += 1;
                        Space infix = GroovyParserVisitor.this.whitespace();
                        if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ')') {
                            GroovyParserVisitor.this.cursor += 1;
                            markers = markers.add((Marker)new EmptyArgumentListPrecedesArgument(Tree.randomId(), prefix, infix));
                        } else {
                            GroovyParserVisitor.this.cursor = saveCursor;
                        }
                    } else {
                        GroovyParserVisitor.this.cursor = saveCursor;
                    }
                }
            }
            args = (JContainer)this.visit((ASTNode)call.getArguments());
            MethodNode methodNode = (MethodNode)call.getNodeMetaData().get(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            JavaType.Method methodType = null;
            if (methodNode == null && call.getObjectExpression() instanceof VariableExpression && ((VariableExpression)call.getObjectExpression()).getAccessedVariable() != null) {
                ClassNode parameterType = GroovyParserVisitor.staticType(((VariableExpression)call.getObjectExpression()).getAccessedVariable());
                if (args.getElements().size() == 1 && args.getElements().get(0) instanceof J.Empty) {
                    methodType = GroovyParserVisitor.this.typeMapping.methodType(parameterType.getMethod(name.getSimpleName(), new Parameter[0]));
                } else if (call.getArguments() instanceof ArgumentListExpression) {
                    List rawArgs = ((ArgumentListExpression)call.getArguments()).getExpressions();
                    block3: for (MethodNode methodNode2 : parameterType.getAllDeclaredMethods()) {
                        if (!name.getSimpleName().equals(methodNode2.getName()) || rawArgs.size() != methodNode2.getParameters().length) continue;
                        methodType = GroovyParserVisitor.this.typeMapping.methodType(methodNode2);
                        for (int i = 0; i < methodNode2.getParameters().length; ++i) {
                            JavaType arg;
                            JavaType param = GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType(methodNode2.getParameters()[i]));
                            if (!TypeUtils.isAssignableTo((JavaType)param, (JavaType)(arg = GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType((Expression)rawArgs.get(i)))))) continue block3;
                        }
                        break;
                    }
                }
            } else {
                methodType = GroovyParserVisitor.this.typeMapping.methodType(methodNode);
            }
            this.queue.add(new J.MethodInvocation(Tree.randomId(), fmt, markers, select, null, name, (JContainer)args, methodType));
        }

        public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
            ArgumentListExpression args;
            Space fmt = GroovyParserVisitor.this.whitespace();
            MethodNode methodNode = (MethodNode)call.getNodeMetaData().get(StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
            JavaType.Method methodType = GroovyParserVisitor.this.typeMapping.methodType(methodNode);
            J.Identifier name = new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(call.getMethodAsString()), Markers.EMPTY, call.getMethodAsString(), (JavaType)methodType, null);
            Markers markers = Markers.EMPTY;
            if (call.getArguments() instanceof ArgumentListExpression) {
                args = (ArgumentListExpression)call.getArguments();
                if (call.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE) != null) {
                    for (Expression arg : args.getExpressions()) {
                        if (!(arg instanceof ClosureExpression)) continue;
                        ClosureExpression cl = (ClosureExpression)arg;
                        ClassNode actualParamTypeRaw = (ClassNode)call.getNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        for (Parameter p : cl.getParameters()) {
                            if (!p.isDynamicTyped()) continue;
                            p.setType(actualParamTypeRaw);
                            p.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        }
                        for (Map.Entry entry : cl.getVariableScope().getDeclaredVariables().entrySet()) {
                            if (!(entry.getValue() instanceof Parameter) || !((Variable)entry.getValue()).isDynamicTyped()) continue;
                            Parameter p = (Parameter)entry.getValue();
                            p.setType(actualParamTypeRaw);
                            p.removeNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE);
                        }
                    }
                }
                if (args.getExpressions().size() == 1 && args.getExpressions().get(0) instanceof ClosureExpression) {
                    int saveCursor = GroovyParserVisitor.this.cursor;
                    Space prefix = GroovyParserVisitor.this.whitespace();
                    if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                        GroovyParserVisitor.this.cursor += 1;
                        Space infix = GroovyParserVisitor.this.whitespace();
                        if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ')') {
                            GroovyParserVisitor.this.cursor += 1;
                            markers = markers.add((Marker)new EmptyArgumentListPrecedesArgument(Tree.randomId(), prefix, infix));
                        } else {
                            GroovyParserVisitor.this.cursor = saveCursor;
                        }
                    } else {
                        GroovyParserVisitor.this.cursor = saveCursor;
                    }
                }
            }
            args = (JContainer)this.visit((ASTNode)call.getArguments());
            this.queue.add(new J.MethodInvocation(Tree.randomId(), fmt, markers, null, null, name, (JContainer)args, methodType));
        }

        public void visitPropertyExpression(PropertyExpression prop) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            org.openrewrite.java.tree.Expression target = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)prop.getObjectExpression());
            Space beforeDot = prop.isSafe() ? GroovyParserVisitor.this.sourceBefore("?.") : GroovyParserVisitor.this.sourceBefore(prop.isSpreadSafe() ? "*." : ".");
            J name = (J)this.visit((ASTNode)prop.getProperty());
            if (name instanceof J.Literal) {
                String nameStr = ((J.Literal)name).getValueSource();
                assert (nameStr != null);
                name = new J.Identifier(Tree.randomId(), name.getPrefix(), Markers.EMPTY, nameStr, null, null);
            }
            if (prop.isSpreadSafe()) {
                name = (J)name.withMarkers(name.getMarkers().add((Marker)new StarDot(Tree.randomId())));
            }
            if (prop.isSafe()) {
                name = (J)name.withMarkers(name.getMarkers().add((Marker)new NullSafe(Tree.randomId())));
            }
            this.queue.add(new J.FieldAccess(Tree.randomId(), fmt, Markers.EMPTY, target, GroovyParserVisitor.this.padLeft(beforeDot, (J.Identifier)name), null));
        }

        public void visitRangeExpression(RangeExpression range) {
            this.queue.add(new G.Range(Tree.randomId(), GroovyParserVisitor.this.whitespace(), Markers.EMPTY, (org.openrewrite.java.tree.Expression)this.visit((ASTNode)range.getFrom()), (JLeftPadded<Boolean>)JLeftPadded.build((Object)range.isInclusive()).withBefore(GroovyParserVisitor.this.sourceBefore(range.isInclusive() ? ".." : "..>")), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)range.getTo())));
        }

        public void visitReturnStatement(ReturnStatement return_) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("return");
            if (return_.getExpression() instanceof ConstantExpression && GroovyParserVisitor.isSynthetic((ASTNode)return_.getExpression()) && ((ConstantExpression)return_.getExpression()).getValue() == null) {
                this.queue.add(new J.Return(Tree.randomId(), fmt, Markers.EMPTY, null));
            } else {
                this.queue.add(new J.Return(Tree.randomId(), fmt, Markers.EMPTY, (org.openrewrite.java.tree.Expression)this.visit((ASTNode)return_.getExpression())));
            }
        }

        public void visitShortTernaryExpression(ElvisOperatorExpression ternary) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            org.openrewrite.java.tree.Expression trueExpr = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)ternary.getBooleanExpression());
            J.Ternary elvis = new J.Ternary(Tree.randomId(), fmt, Markers.EMPTY, trueExpr, GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("?"), trueExpr), GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore(":"), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)ternary.getFalseExpression())), GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType((Expression)ternary)));
            elvis = elvis.withMarkers(elvis.getMarkers().add((Marker)new Elvis(Tree.randomId())));
            this.queue.add(elvis);
        }

        public void visitSwitch(SwitchStatement statement) {
            this.queue.add(new J.Switch(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("switch"), Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)statement.getExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")"))), new J.Block(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("{"), Markers.EMPTY, JRightPadded.build((Object)false), ListUtils.concat(this.convertAll(statement.getCaseStatements(), t -> Space.EMPTY, t -> Space.EMPTY), statement.getDefaultStatement().isEmpty() ? null : JRightPadded.build((Object)this.visitDefaultCaseStatement((BlockStatement)statement.getDefaultStatement()))), GroovyParserVisitor.this.sourceBefore("}"))));
        }

        public void visitSynchronizedStatement(SynchronizedStatement statement) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("synchronized");
            this.queue.add(new J.Synchronized(Tree.randomId(), fmt, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)statement.getExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")"))), (J.Block)this.visit((ASTNode)statement.getCode())));
        }

        public void visitTernaryExpression(TernaryExpression ternary) {
            Space prefix = GroovyParserVisitor.this.whitespace();
            if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                this.visitParenthesized((ASTNode)ternary, prefix);
            } else {
                this.queue.add(new J.Ternary(Tree.randomId(), prefix, Markers.EMPTY, (org.openrewrite.java.tree.Expression)this.visit((ASTNode)ternary.getBooleanExpression()), GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("?"), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)ternary.getTrueExpression())), GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore(":"), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)ternary.getFalseExpression())), GroovyParserVisitor.this.typeMapping.type((ASTNode)ternary.getType())));
            }
        }

        public void visitThrowStatement(ThrowStatement statement) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("throw");
            this.queue.add(new J.Throw(Tree.randomId(), fmt, Markers.EMPTY, (org.openrewrite.java.tree.Expression)this.visit((ASTNode)statement.getExpression())));
        }

        public void visitTupleExpression(TupleExpression tuple) {
            int saveCursor = GroovyParserVisitor.this.cursor;
            Space beforeOpenParen = GroovyParserVisitor.this.whitespace();
            OmitParentheses omitParentheses = null;
            if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == '(') {
                GroovyParserVisitor.this.cursor++;
            } else {
                omitParentheses = new OmitParentheses(Tree.randomId());
                beforeOpenParen = Space.EMPTY;
                GroovyParserVisitor.this.cursor = saveCursor;
            }
            ArrayList<JRightPadded> args = new ArrayList<JRightPadded>(tuple.getExpressions().size());
            for (Expression expression : tuple.getExpressions()) {
                NamedArgumentListExpression namedArgList = (NamedArgumentListExpression)expression;
                List mapEntryExpressions = namedArgList.getMapEntryExpressions();
                for (int i = 0; i < mapEntryExpressions.size(); ++i) {
                    org.openrewrite.java.tree.Expression arg = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)mapEntryExpressions.get(i));
                    if (omitParentheses != null) {
                        arg = (org.openrewrite.java.tree.Expression)arg.withMarkers(arg.getMarkers().add((Marker)omitParentheses));
                    }
                    Space after = Space.EMPTY;
                    if (i == mapEntryExpressions.size() - 1) {
                        if (omitParentheses == null) {
                            after = GroovyParserVisitor.this.sourceBefore(")");
                        }
                    } else {
                        after = GroovyParserVisitor.this.whitespace();
                        if (GroovyParserVisitor.this.source.charAt(GroovyParserVisitor.this.cursor) == ')') {
                            omitParentheses = new OmitParentheses(Tree.randomId());
                        }
                        GroovyParserVisitor.this.cursor++;
                    }
                    args.add(JRightPadded.build((Object)arg).withAfter(after));
                }
            }
            this.queue.add(JContainer.build((Space)beforeOpenParen, args, (Markers)Markers.EMPTY));
        }

        public void visitTryCatchFinally(TryCatchStatement node) {
            List catches;
            Space prefix = GroovyParserVisitor.this.sourceBefore("try");
            JContainer resources = null;
            J.Block body = (J.Block)this.visit((ASTNode)node.getTryStatement());
            if (node.getCatchStatements().isEmpty()) {
                catches = Collections.emptyList();
            } else {
                catches = new ArrayList(node.getCatchStatements().size());
                for (CatchStatement catchStatement : node.getCatchStatements()) {
                    this.visitCatchStatement(catchStatement);
                    catches.add((J.Try.Catch)this.queue.poll());
                }
            }
            JLeftPadded finally_ = !(node.getFinallyStatement() instanceof BlockStatement) ? null : GroovyParserVisitor.this.padLeft(GroovyParserVisitor.this.sourceBefore("finally"), (J.Block)this.visit((ASTNode)((BlockStatement)node.getFinallyStatement()).getStatements().get(0)));
            this.queue.add(new J.Try(Tree.randomId(), prefix, Markers.EMPTY, resources, body, catches, finally_));
        }

        public void visitPostfixExpression(PostfixExpression unary) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            org.openrewrite.java.tree.Expression expression = (org.openrewrite.java.tree.Expression)this.visit((ASTNode)unary.getExpression());
            Space operatorPrefix = GroovyParserVisitor.this.whitespace();
            String typeToken = unary.getOperation().getText();
            GroovyParserVisitor.this.cursor += typeToken.length();
            J.Unary.Type operator = null;
            switch (typeToken) {
                case "++": {
                    operator = J.Unary.Type.PostIncrement;
                    break;
                }
                case "--": {
                    operator = J.Unary.Type.PostDecrement;
                }
            }
            assert (operator != null);
            this.queue.add(new J.Unary(Tree.randomId(), fmt, Markers.EMPTY, JLeftPadded.build((Object)operator).withBefore(operatorPrefix), expression, null));
        }

        public void visitPrefixExpression(PrefixExpression unary) {
            Space fmt = GroovyParserVisitor.this.whitespace();
            String typeToken = unary.getOperation().getText();
            GroovyParserVisitor.this.cursor += typeToken.length();
            J.Unary.Type operator = null;
            switch (typeToken) {
                case "++": {
                    operator = J.Unary.Type.PreIncrement;
                    break;
                }
                case "--": {
                    operator = J.Unary.Type.PreDecrement;
                    break;
                }
                case "~": {
                    operator = J.Unary.Type.Complement;
                }
            }
            assert (operator != null);
            this.queue.add(new J.Unary(Tree.randomId(), fmt, Markers.EMPTY, JLeftPadded.build((Object)operator), (org.openrewrite.java.tree.Expression)this.visit((ASTNode)unary.getExpression()), null));
        }

        public TypeTree visitVariableExpressionType(VariableExpression expression) {
            JavaType type = GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType((Expression)expression));
            if (expression.isDynamicTyped()) {
                return new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("def"), Markers.EMPTY, "def", type, null);
            }
            Space prefix = GroovyParserVisitor.this.sourceBefore(expression.getOriginType().getUnresolvedName());
            J.Identifier ident = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, expression.getOriginType().getUnresolvedName(), type, null);
            if (type instanceof JavaType.Parameterized) {
                return new J.ParameterizedType(Tree.randomId(), prefix, Markers.EMPTY, (NameTree)ident, GroovyParserVisitor.this.visitTypeParameterizations(GroovyParserVisitor.staticType((Expression)expression).getGenericsTypes()), type);
            }
            return ident.withPrefix(prefix);
        }

        public void visitVariableExpression(VariableExpression expression) {
            JavaType type = expression.isDynamicTyped() && expression.getAccessedVariable() != null && expression.getAccessedVariable().getType() != expression.getOriginType() ? GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType(expression.getAccessedVariable())) : GroovyParserVisitor.this.typeMapping.type((ASTNode)GroovyParserVisitor.staticType((Expression)expression));
            this.queue.add(new J.Identifier(Tree.randomId(), GroovyParserVisitor.this.sourceBefore(expression.getName()), Markers.EMPTY, expression.getName(), type, null));
        }

        public void visitWhileLoop(WhileStatement loop) {
            Space fmt = GroovyParserVisitor.this.sourceBefore("while");
            this.queue.add(new J.WhileLoop(Tree.randomId(), fmt, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), GroovyParserVisitor.this.sourceBefore("("), Markers.EMPTY, JRightPadded.build((Object)((org.openrewrite.java.tree.Expression)this.visit((ASTNode)loop.getBooleanExpression().getExpression()))).withAfter(GroovyParserVisitor.this.sourceBefore(")"))), JRightPadded.build((Object)((Statement)this.visit((ASTNode)loop.getLoopBlock())))));
        }

        private <J2 extends J> List<JRightPadded<J2>> convertAll(List<? extends ASTNode> nodes, Function<ASTNode, Space> innerSuffix, Function<ASTNode, Space> suffix) {
            if (nodes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<JRightPadded<J2>> converted = new ArrayList<JRightPadded<J2>>(nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                converted.add(this.convert(nodes.get(i), i == nodes.size() - 1 ? suffix : innerSuffix));
            }
            return converted;
        }

        private <J2 extends J> JRightPadded<J2> convert(ASTNode node, Function<ASTNode, Space> suffix) {
            J j = (J)this.visit(node);
            return GroovyParserVisitor.this.padRight(j, suffix.apply(node));
        }

        private List<JRightPadded<Statement>> convertStatements(List<? extends ASTNode> nodes, Function<ASTNode, Space> suffix) {
            if (nodes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<JRightPadded<Statement>> converted = new ArrayList<JRightPadded<Statement>>(nodes.size());
            for (ASTNode aSTNode : nodes) {
                Statement statement = (Statement)this.visit(aSTNode);
                converted.add((JRightPadded<Statement>)GroovyParserVisitor.this.padRight(statement, suffix.apply(aSTNode)));
            }
            return converted;
        }

        private <T> T pollQueue() {
            return (T)this.queue.poll();
        }
    }
}

