/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public final class RemoveExtension
extends Recipe {
    @Option(displayName="Method name", description="The name of the build extension to remove, e.g., `buildCache`.", example="buildCache")
    private final String methodName;

    public String getDisplayName() {
        return "Remove build extension by name";
    }

    public String getDescription() {
        return "Remove a Gradle build extension from `settings.gradle(.kts)` or `build.gradle(.kts)` files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (RemoveExtension.this.methodName.equals(method.getSimpleName())) {
                    return null;
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public RemoveExtension(String methodName) {
        this.methodName = methodName;
    }

    @Generated
    public String getMethodName() {
        return this.methodName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveExtension(methodName=" + this.getMethodName() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveExtension)) {
            return false;
        }
        RemoveExtension other = (RemoveExtension)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        return !(this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveExtension;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        return result;
    }
}

