/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openrewrite.Checksum;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.gradle.util.DistributionInfos;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.remote.Remote;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class GradleWrapper {
    public static final String WRAPPER_JAR_LOCATION_RELATIVE_PATH = "gradle/wrapper/gradle-wrapper.jar";
    public static final String WRAPPER_PROPERTIES_LOCATION_RELATIVE_PATH = "gradle/wrapper/gradle-wrapper.properties";
    public static final String WRAPPER_SCRIPT_LOCATION_RELATIVE_PATH = "gradlew";
    public static final String WRAPPER_BATCH_LOCATION_RELATIVE_PATH = "gradlew.bat";
    public static final Path WRAPPER_JAR_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.jar", new String[0]);
    public static final Path WRAPPER_PROPERTIES_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.properties", new String[0]);
    public static final Path WRAPPER_SCRIPT_LOCATION = Paths.get("gradlew", new String[0]);
    public static final Path WRAPPER_BATCH_LOCATION = Paths.get("gradlew.bat", new String[0]);
    private final String version;
    private final DistributionInfos distributionInfos;
    static final FileAttributes WRAPPER_JAR_FILE_ATTRIBUTES = new FileAttributes(null, null, null, true, true, false, 0L);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GradleWrapper create(@Nullable String distributionTypeName, @Nullable String version, @Nullable String repositoryUrl, ExecutionContext ctx) {
        DistributionType distributionType = Arrays.stream(DistributionType.values()).filter(dt -> dt.name().equalsIgnoreCase(distributionTypeName)).findAny().orElse(DistributionType.Bin);
        LatestRelease versionComparator = StringUtils.isBlank((String)version) ? new LatestRelease(null) : Objects.requireNonNull((VersionComparator)Semver.validate((String)version, null).getValue());
        HttpSender httpSender = HttpSenderExecutionContextView.view((ExecutionContext)ctx).getLargeFileHttpSender();
        String gradleVersionsUrl = StringUtils.isBlank((String)repositoryUrl) ? "https://services.gradle.org/versions/all" : repositoryUrl;
        try (HttpSender.Response resp = httpSender.send(httpSender.get(gradleVersionsUrl).build());){
            if (!resp.isSuccessful()) throw new IOException("Could not get Gradle versions at: " + gradleVersionsUrl);
            List allVersions = (List)new ObjectMapper().registerModule((Module)new ParameterNamesModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(resp.getBody(), (TypeReference)new TypeReference<List<GradleVersion>>(){});
            GradleVersion gradleVersion = allVersions.stream().filter(arg_0 -> GradleWrapper.lambda$create$1((VersionComparator)versionComparator, arg_0)).max((arg_0, arg_1) -> GradleWrapper.lambda$create$2((VersionComparator)versionComparator, arg_0, arg_1)).orElseThrow(() -> new IllegalStateException("Expected to find at least one Gradle wrapper version to select from."));
            DistributionInfos infos = DistributionInfos.fetch(httpSender, distributionType, gradleVersion);
            GradleWrapper gradleWrapper = new GradleWrapper(gradleVersion.version, infos);
            return gradleWrapper;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getDistributionUrl() {
        return this.distributionInfos.getDownloadUrl();
    }

    public String getPropertiesFormattedUrl() {
        return this.getDistributionUrl().replaceAll("(?<!\\\\)://", "\\\\://");
    }

    public Checksum getDistributionChecksum() {
        return this.distributionInfos.getChecksum();
    }

    public Remote wrapperJar() {
        return Remote.builder((Path)WRAPPER_JAR_LOCATION, (URI)URI.create(this.distributionInfos.getDownloadUrl())).build(new String[]{"gradle-[^\\/]+\\/(?:.*\\/)+gradle-(plugins|wrapper)-(?!shared).*\\.jar", "gradle-wrapper.jar"});
    }

    public Remote gradlew() {
        return Remote.builder((Path)WRAPPER_SCRIPT_LOCATION, (URI)URI.create(this.distributionInfos.getDownloadUrl())).build(new String[]{"gradle-[^\\/]+/(?:.*/)+gradle-plugins-.*\\.jar", "org/gradle/api/internal/plugins/unixStartScript.txt"});
    }

    public Remote gradlewBat() {
        return Remote.builder((Path)WRAPPER_BATCH_LOCATION, (URI)URI.create(this.distributionInfos.getDownloadUrl())).build(new String[]{"gradle-[^\\/]+/(?:.*/)+gradle-plugins-.*\\.jar", "org/gradle/api/internal/plugins/windowsStartScript.txt"});
    }

    public GradleWrapper(String version, DistributionInfos distributionInfos) {
        this.version = version;
        this.distributionInfos = distributionInfos;
    }

    public String getVersion() {
        return this.version;
    }

    public DistributionInfos getDistributionInfos() {
        return this.distributionInfos;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleWrapper)) {
            return false;
        }
        GradleWrapper other = (GradleWrapper)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        DistributionInfos this$distributionInfos = this.getDistributionInfos();
        DistributionInfos other$distributionInfos = other.getDistributionInfos();
        return !(this$distributionInfos == null ? other$distributionInfos != null : !((Object)this$distributionInfos).equals(other$distributionInfos));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        DistributionInfos $distributionInfos = this.getDistributionInfos();
        result = result * 59 + ($distributionInfos == null ? 43 : ((Object)$distributionInfos).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "GradleWrapper(version=" + this.getVersion() + ", distributionInfos=" + this.getDistributionInfos() + ")";
    }

    private static /* synthetic */ int lambda$create$2(VersionComparator versionComparator, GradleVersion v1, GradleVersion v2) {
        return versionComparator.compare(null, v1.version, v2.version);
    }

    private static /* synthetic */ boolean lambda$create$1(VersionComparator versionComparator, GradleVersion v) {
        return versionComparator.isValid(null, v.version);
    }

    public static enum DistributionType {
        Bin,
        All;

    }

    static final class GradleVersion {
        private final String version;
        private final String downloadUrl;
        private final String checksumUrl;
        private final String wrapperChecksumUrl;

        public GradleVersion(String version, String downloadUrl, String checksumUrl, String wrapperChecksumUrl) {
            this.version = version;
            this.downloadUrl = downloadUrl;
            this.checksumUrl = checksumUrl;
            this.wrapperChecksumUrl = wrapperChecksumUrl;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public String getChecksumUrl() {
            return this.checksumUrl;
        }

        public String getWrapperChecksumUrl() {
            return this.wrapperChecksumUrl;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleVersion)) {
                return false;
            }
            GradleVersion other = (GradleVersion)o;
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$downloadUrl = this.getDownloadUrl();
            String other$downloadUrl = other.getDownloadUrl();
            if (this$downloadUrl == null ? other$downloadUrl != null : !this$downloadUrl.equals(other$downloadUrl)) {
                return false;
            }
            String this$checksumUrl = this.getChecksumUrl();
            String other$checksumUrl = other.getChecksumUrl();
            if (this$checksumUrl == null ? other$checksumUrl != null : !this$checksumUrl.equals(other$checksumUrl)) {
                return false;
            }
            String this$wrapperChecksumUrl = this.getWrapperChecksumUrl();
            String other$wrapperChecksumUrl = other.getWrapperChecksumUrl();
            return !(this$wrapperChecksumUrl == null ? other$wrapperChecksumUrl != null : !this$wrapperChecksumUrl.equals(other$wrapperChecksumUrl));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $downloadUrl = this.getDownloadUrl();
            result = result * 59 + ($downloadUrl == null ? 43 : $downloadUrl.hashCode());
            String $checksumUrl = this.getChecksumUrl();
            result = result * 59 + ($checksumUrl == null ? 43 : $checksumUrl.hashCode());
            String $wrapperChecksumUrl = this.getWrapperChecksumUrl();
            result = result * 59 + ($wrapperChecksumUrl == null ? 43 : $wrapperChecksumUrl.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "GradleWrapper.GradleVersion(version=" + this.getVersion() + ", downloadUrl=" + this.getDownloadUrl() + ", checksumUrl=" + this.getChecksumUrl() + ", wrapperChecksumUrl=" + this.getWrapperChecksumUrl() + ")";
        }
    }
}

