/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Parser;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.plugins.GradlePluginUtils;
import org.openrewrite.gradle.search.FindPlugins;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

@Incubating(since="7.33.0")
public final class AddPluginVisitor
extends GroovyIsoVisitor<ExecutionContext> {
    private final String pluginId;
    @Nullable
    private final String newVersion;
    @Nullable
    private final String versionPattern;

    public static Optional<String> resolvePluginVersion(String pluginId, @Nullable String newVersion, @Nullable String versionPattern, ExecutionContext ctx) {
        Optional version;
        if (newVersion == null) {
            version = Optional.empty();
        } else {
            VersionComparator versionComparator = (VersionComparator)Semver.validate((String)newVersion, (String)versionPattern).getValue();
            assert (versionComparator != null);
            version = versionComparator instanceof ExactVersion ? versionComparator.upgrade("0", Collections.singletonList(newVersion)) : versionComparator.upgrade("0", GradlePluginUtils.availablePluginVersions(pluginId, ctx));
        }
        return version;
    }

    public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
        if (FindPlugins.find((J)cu, this.pluginId).isEmpty()) {
            Optional<String> version = AddPluginVisitor.resolvePluginVersion(this.pluginId, this.newVersion, this.versionPattern, ctx);
            final AtomicInteger singleQuote = new AtomicInteger();
            final AtomicInteger doubleQuote = new AtomicInteger();
            new GroovyIsoVisitor<Integer>(){
                MethodMatcher pluginIdMatcher = new MethodMatcher("PluginSpec id(..)");

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                    J.MethodInvocation m = super.visitMethodInvocation(method, (Object)integer);
                    if (this.pluginIdMatcher.matches(m) && m.getArguments().get(0) instanceof J.Literal) {
                        J.Literal l = (J.Literal)m.getArguments().get(0);
                        if (l.getValueSource().startsWith("'")) {
                            singleQuote.incrementAndGet();
                        } else {
                            doubleQuote.incrementAndGet();
                        }
                    }
                    return m;
                }
            }.visitCompilationUnit(cu, (Object)0);
            String delimiter = singleQuote.get() < doubleQuote.get() ? "\"" : "'";
            List statements = GradleParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((String)("plugins {\n    id " + delimiter + this.pluginId + delimiter + version.map(s -> " version " + delimiter + s + delimiter).orElse("") + "\n}"))), null, ctx).get(0).getStatements();
            if (FindMethods.find((J)cu, (String)"RewriteGradleProject plugins(..)").isEmpty() && FindMethods.find((J)cu, (String)"RewriteSettings plugins(..)").isEmpty()) {
                Space leadingSpace = Space.firstPrefix((List)cu.getStatements());
                if (cu.getSourcePath().endsWith(Paths.get("settings.gradle", new String[0])) && !cu.getStatements().isEmpty() && cu.getStatements().get(0) instanceof J.MethodInvocation && ((J.MethodInvocation)cu.getStatements().get(0)).getSimpleName().equals("pluginManagement")) {
                    return cu.withStatements(ListUtils.concatAll((List)ListUtils.concat((Object)((Statement)cu.getStatements().get(0)), (List)Space.formatFirstPrefix((List)statements, (Space)leadingSpace.withWhitespace("\n\n" + leadingSpace.getWhitespace()))), (List)Space.formatFirstPrefix(cu.getStatements().subList(1, cu.getStatements().size()), (Space)leadingSpace.withWhitespace("\n\n" + leadingSpace.getWhitespace()))));
                }
                return cu.withStatements(ListUtils.concatAll((List)statements, (List)Space.formatFirstPrefix((List)cu.getStatements(), (Space)leadingSpace.withWhitespace("\n\n" + leadingSpace.getWhitespace()))));
            }
            MethodMatcher buildPluginsMatcher = new MethodMatcher("RewriteGradleProject plugins(groovy.lang.Closure)");
            MethodMatcher settingsPluginsMatcher = new MethodMatcher("RewriteSettings plugins(groovy.lang.Closure)");
            return cu.withStatements(ListUtils.map((List)cu.getStatements(), stat -> {
                J.MethodInvocation m;
                if (stat instanceof J.MethodInvocation && (buildPluginsMatcher.matches(m = (J.MethodInvocation)stat) || settingsPluginsMatcher.matches(m))) {
                    J.MethodInvocation pluginDef = (J.MethodInvocation)((J.Return)((J.Block)((J.Lambda)((J.MethodInvocation)statements.get(0)).getArguments().get(0)).getBody()).getStatements().get(0)).getExpression();
                    m = m.withArguments(ListUtils.map((List)m.getArguments(), a -> {
                        if (a instanceof J.Lambda) {
                            J.Lambda l = (J.Lambda)a;
                            J.Block b = (J.Block)l.getBody();
                            List pluginStatements = b.getStatements();
                            if (!pluginStatements.isEmpty() && pluginStatements.get(pluginStatements.size() - 1) instanceof J.Return) {
                                Statement last = (Statement)pluginStatements.remove(pluginStatements.size() - 1);
                                pluginStatements.add((Statement)((J.Return)last).getExpression().withPrefix(last.getPrefix()));
                            }
                            pluginStatements.add(pluginDef);
                            return l.withBody(this.autoFormat((J)b.withStatements(pluginStatements), ctx, this.getCursor()));
                        }
                        return a;
                    }));
                    return m;
                }
                return stat;
            }));
        }
        return super.visitCompilationUnit(cu, (Object)ctx);
    }

    public AddPluginVisitor(String pluginId, @Nullable String newVersion, @Nullable String versionPattern) {
        this.pluginId = pluginId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "AddPluginVisitor(pluginId=" + this.getPluginId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPluginVisitor)) {
            return false;
        }
        AddPluginVisitor other = (AddPluginVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddPluginVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

