/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class UpgradeLiteralDependencyVersion
extends Recipe {
    private static final String VERSION_VARIABLE_KEY = "VERSION_VARIABLE_KEY";
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public String getDisplayName() {
        return "Upgrade Gradle dependencies who use a fixed literal version";
    }

    public String getDescription() {
        return "A fixed literal version is a version that is not a variable or property or supplied indirectly by platform BOMs or similar means. For example, `com.google.guava:guava:29.0-jre`.";
    }

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new FindGradleProject(FindGradleProject.SearchCriteria.Marker).getVisitor();
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher dependency = new MethodMatcher("DependencyHandlerSpec *(..)");
        final VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue());
        return new GroovyVisitor<ExecutionContext>(){

            public J visitJavaSourceFile(JavaSourceFile sourceFile, ExecutionContext ctx) {
                JavaSourceFile cu = (JavaSourceFile)super.visitJavaSourceFile(sourceFile, (Object)ctx);
                String variableName = (String)this.getCursor().getMessage(UpgradeLiteralDependencyVersion.VERSION_VARIABLE_KEY);
                if (variableName != null) {
                    Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
                    if (!maybeGp.isPresent()) {
                        return cu;
                    }
                    cu = (JavaSourceFile)new UpdateVariable(variableName, versionComparator, (GradleProject)maybeGp.get()).visitNonNull((Tree)cu, ctx);
                }
                return cu;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (dependency.matches(method)) {
                    List depArgs = method.getArguments();
                    if (depArgs.get(0) instanceof G.GString) {
                        G.GString gString = (G.GString)depArgs.get(0);
                        List strings = gString.getStrings();
                        if (strings.size() != 2 || !(strings.get(0) instanceof J.Literal) || !(strings.get(1) instanceof G.GString.Value)) {
                            return method;
                        }
                        G.GString.Value versionValue = (G.GString.Value)strings.get(1);
                        if (!(versionValue.getTree() instanceof J.Identifier)) {
                            return method;
                        }
                        String versionVariableName = ((J.Identifier)versionValue.getTree()).getSimpleName();
                        this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, UpgradeLiteralDependencyVersion.VERSION_VARIABLE_KEY, (Object)versionVariableName);
                    } else if (depArgs.get(0) instanceof J.Literal) {
                        String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                        assert (gav != null);
                        String[] parts = gav.split(":");
                        if (gav.length() >= 2 && StringUtils.matchesGlob((String)parts[0], (String)UpgradeLiteralDependencyVersion.this.groupId) && StringUtils.matchesGlob((String)parts[1], (String)UpgradeLiteralDependencyVersion.this.artifactId)) {
                            GradleProject gradleProject = (GradleProject)((JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class)).getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new IllegalArgumentException("Gradle files are expected to have a GradleProject marker."));
                            String version = parts[2];
                            if (version == null) {
                                return method;
                            }
                            if (!version.startsWith("$")) {
                                try {
                                    String newVersion = UpgradeLiteralDependencyVersion.this.findNewerVersion(UpgradeLiteralDependencyVersion.this.groupId, UpgradeLiteralDependencyVersion.this.artifactId, version, versionComparator, gradleProject, ctx);
                                    if (newVersion == null || version.equals(newVersion)) {
                                        return method;
                                    }
                                    return method.withArguments(ListUtils.mapFirst((List)method.getArguments(), arg -> {
                                        J.Literal literal = (J.Literal)arg;
                                        String newGav = UpgradeLiteralDependencyVersion.this.groupId + ":" + UpgradeLiteralDependencyVersion.this.artifactId + ":" + newVersion;
                                        return literal.withValue((Object)newGav).withValueSource(Objects.requireNonNull(literal.getValueSource()).replace(gav, newGav));
                                    }));
                                }
                                catch (MavenDownloadingException e) {
                                    return (J)e.warn((Tree)method);
                                }
                            }
                        }
                    }
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }

    @Nullable
    private String findNewerVersion(String groupId, String artifactId, String version, VersionComparator versionComparator, GradleProject gradleProject, ExecutionContext ctx) throws MavenDownloadingException {
        if (versionComparator instanceof LatestPatch && !versionComparator.isValid(version, version)) {
            return null;
        }
        try {
            MavenMetadata mavenMetadata = this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(groupId, artifactId, gradleProject, ctx));
            ArrayList<String> versions = new ArrayList<String>();
            for (String v : mavenMetadata.getVersioning().getVersions()) {
                if (!versionComparator.isValid(version, v)) continue;
                versions.add(v);
            }
            return versionComparator.upgrade(version, versions).orElse(null);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public MavenMetadata downloadMetadata(String groupId, String artifactId, GradleProject gradleProject, ExecutionContext ctx) throws MavenDownloadingException {
        return new MavenPomDownloader(Collections.emptyMap(), ctx, null, null).downloadMetadata(new GroupArtifact(groupId, artifactId), null, gradleProject.getMavenRepositories());
    }

    public UpgradeLiteralDependencyVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "UpgradeLiteralDependencyVersion(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeLiteralDependencyVersion)) {
            return false;
        }
        UpgradeLiteralDependencyVersion other = (UpgradeLiteralDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeLiteralDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    private final class UpdateVariable
    extends GroovyIsoVisitor<ExecutionContext> {
        private final String versionVariableName;
        private final VersionComparator versionComparator;
        private final GradleProject gradleProject;

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, (Object)ctx);
            if (!this.versionVariableName.equals(v.getSimpleName())) {
                return v;
            }
            if (!(v.getInitializer() instanceof J.Literal)) {
                return v;
            }
            J.Literal initializer = (J.Literal)v.getInitializer();
            if (initializer.getType() != JavaType.Primitive.String) {
                return v;
            }
            String version = (String)initializer.getValue();
            if (version == null) {
                return v;
            }
            try {
                String newVersion = UpgradeLiteralDependencyVersion.this.findNewerVersion(UpgradeLiteralDependencyVersion.this.groupId, UpgradeLiteralDependencyVersion.this.artifactId, version, this.versionComparator, this.gradleProject, ctx);
                if (newVersion == null) {
                    return v;
                }
                J.Literal newVersionLiteral = initializer.withValue((Object)newVersion).withValueSource("'" + newVersion + "'");
                v = v.withInitializer((Expression)newVersionLiteral);
            }
            catch (MavenDownloadingException e) {
                return (J.VariableDeclarations.NamedVariable)e.warn((Tree)v);
            }
            return v;
        }

        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext executionContext) {
            J.Assignment v = super.visitAssignment(assignment, (Object)executionContext);
            if (!(assignment.getAssignment() instanceof J.Identifier)) {
                return v;
            }
            J.Identifier id = (J.Identifier)assignment.getAssignment();
            if (!this.versionVariableName.equals(id.getSimpleName())) {
                return v;
            }
            return v;
        }

        public UpdateVariable(String versionVariableName, VersionComparator versionComparator, GradleProject gradleProject) {
            this.versionVariableName = versionVariableName;
            this.versionComparator = versionComparator;
            this.gradleProject = gradleProject;
        }

        public String getVersionVariableName() {
            return this.versionVariableName;
        }

        public VersionComparator getVersionComparator() {
            return this.versionComparator;
        }

        public GradleProject getGradleProject() {
            return this.gradleProject;
        }

        @NonNull
        public String toString() {
            return "UpgradeLiteralDependencyVersion.UpdateVariable(versionVariableName=" + this.getVersionVariableName() + ", versionComparator=" + this.getVersionComparator() + ", gradleProject=" + this.getGradleProject() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateVariable)) {
                return false;
            }
            UpdateVariable other = (UpdateVariable)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$versionVariableName = this.getVersionVariableName();
            String other$versionVariableName = other.getVersionVariableName();
            if (this$versionVariableName == null ? other$versionVariableName != null : !this$versionVariableName.equals(other$versionVariableName)) {
                return false;
            }
            VersionComparator this$versionComparator = this.getVersionComparator();
            VersionComparator other$versionComparator = other.getVersionComparator();
            if (this$versionComparator == null ? other$versionComparator != null : !this$versionComparator.equals(other$versionComparator)) {
                return false;
            }
            GradleProject this$gradleProject = this.getGradleProject();
            GradleProject other$gradleProject = other.getGradleProject();
            return !(this$gradleProject == null ? other$gradleProject != null : !this$gradleProject.equals(other$gradleProject));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof UpdateVariable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $versionVariableName = this.getVersionVariableName();
            result = result * 59 + ($versionVariableName == null ? 43 : $versionVariableName.hashCode());
            VersionComparator $versionComparator = this.getVersionComparator();
            result = result * 59 + ($versionComparator == null ? 43 : $versionComparator.hashCode());
            GradleProject $gradleProject = this.getGradleProject();
            result = result * 59 + ($gradleProject == null ? 43 : $gradleProject.hashCode());
            return result;
        }
    }
}

