/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.AddGradleWrapper;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.LoathingOfOthers;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.search.FindProperties;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.quark.Quark;
import org.openrewrite.text.PlainText;

public final class UpdateGradleWrapper
extends Recipe {
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="7.x")
    private final String version;
    @Option(displayName="Distribution type", description="The distribution of Gradle to use. \"bin\" includes Gradle binaries. \"all\" includes Gradle binaries, source code, and documentation. Defaults to \"bin\".", valid={"bin", "all"}, required=false)
    @Nullable
    private final String distribution;
    private Validated gradleWrapper;

    public String getDisplayName() {
        return "Update Gradle wrapper";
    }

    public String getDescription() {
        return "Update the version of Gradle used in an existing Gradle wrapper.";
    }

    public Validated validate(ExecutionContext ctx) {
        return super.validate(ctx).and(GradleWrapper.validate(ctx, this.version, this.distribution, this.gradleWrapper, null));
    }

    @LoathingOfOthers(value="JavaDoc")
    @JsonCreator
    public UpdateGradleWrapper(String version, @Nullable String distribution) {
        this.version = version;
        this.distribution = distribution;
    }

    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return new PropertiesVisitor<ExecutionContext>(){

            public Properties visitFile(Properties.File file, ExecutionContext context) {
                return !PathUtils.equalIgnoringSeparators((Path)file.getSourcePath(), (Path)GradleWrapper.WRAPPER_PROPERTIES_LOCATION) ? file : super.visitFile(file, (Object)context);
            }

            public Properties visitEntry(Properties.Entry entry, ExecutionContext context) {
                if (!"distributionUrl".equals(entry.getKey())) {
                    return entry;
                }
                GradleWrapper gradleWrapper = Objects.requireNonNull((GradleWrapper)UpdateGradleWrapper.this.validate(context).getValue());
                String currentDistributionUrl = entry.getValue().getText();
                if (!gradleWrapper.getPropertiesFormattedUrl().equals(currentDistributionUrl)) {
                    return (Properties)SearchResult.found((Tree)entry);
                }
                return entry;
            }
        };
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        GradleWrapper gradleWrapper = (GradleWrapper)this.validate(ctx).getValue();
        assert (gradleWrapper != null);
        List sourceFileList = ListUtils.map(before, sourceFile -> {
            if (sourceFile instanceof PlainText && PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_SCRIPT_LOCATION)) {
                PlainText gradlew = (PlainText)UpdateGradleWrapper.setExecutable(sourceFile);
                String gradlewText = StringUtils.readFully((InputStream)Objects.requireNonNull(UpdateGradleWrapper.class.getResourceAsStream("/gradlew")), (Charset)(sourceFile.getCharset() == null ? StandardCharsets.UTF_8 : sourceFile.getCharset()));
                if (!gradlewText.equals(gradlew.getText())) {
                    gradlew = gradlew.withText(gradlewText);
                }
                return gradlew;
            }
            if (sourceFile instanceof PlainText && PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_BATCH_LOCATION)) {
                PlainText gradlewBat = (PlainText)UpdateGradleWrapper.setExecutable(sourceFile);
                String gradlewBatText = StringUtils.readFully((InputStream)Objects.requireNonNull(UpdateGradleWrapper.class.getResourceAsStream("/gradlew.bat")), (Charset)(sourceFile.getCharset() == null ? StandardCharsets.UTF_8 : sourceFile.getCharset()));
                if (!gradlewBatText.equals(gradlewBat.getText())) {
                    gradlewBat = gradlewBat.withText(gradlewBatText);
                }
                return gradlewBat;
            }
            if (sourceFile instanceof Properties.File && PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_PROPERTIES_LOCATION)) {
                return (Properties.File)new WrapperPropertiesVisitor(gradleWrapper).visitNonNull((Tree)sourceFile, ctx);
            }
            if (sourceFile instanceof Quark && PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_JAR_LOCATION)) {
                return (SourceFile)gradleWrapper.asRemote().withId(sourceFile.getId()).withMarkers(sourceFile.getMarkers());
            }
            return sourceFile;
        });
        return AddGradleWrapper.addGradleFiles(gradleWrapper, sourceFileList);
    }

    private static <T extends SourceFile> T setExecutable(T sourceFile) {
        FileAttributes attributes = sourceFile.getFileAttributes();
        if (attributes == null) {
            ZonedDateTime now = ZonedDateTime.now();
            return (T)sourceFile.withFileAttributes(new FileAttributes(now, now, now, true, true, true, 1L));
        }
        return (T)sourceFile.withFileAttributes(sourceFile.getFileAttributes().withExecutable(true));
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getDistribution() {
        return this.distribution;
    }

    public Validated getGradleWrapper() {
        return this.gradleWrapper;
    }

    @NonNull
    public String toString() {
        return "UpdateGradleWrapper(version=" + this.getVersion() + ", distribution=" + this.getDistribution() + ", gradleWrapper=" + this.getGradleWrapper() + ")";
    }

    private UpdateGradleWrapper(String version, @Nullable String distribution, Validated gradleWrapper) {
        this.version = version;
        this.distribution = distribution;
        this.gradleWrapper = gradleWrapper;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateGradleWrapper)) {
            return false;
        }
        UpdateGradleWrapper other = (UpdateGradleWrapper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$distribution = this.getDistribution();
        String other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution)) {
            return false;
        }
        Validated this$gradleWrapper = this.getGradleWrapper();
        Validated other$gradleWrapper = other.getGradleWrapper();
        return !(this$gradleWrapper == null ? other$gradleWrapper != null : !this$gradleWrapper.equals(other$gradleWrapper));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateGradleWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        Validated $gradleWrapper = this.getGradleWrapper();
        result = result * 59 + ($gradleWrapper == null ? 43 : $gradleWrapper.hashCode());
        return result;
    }

    private static class WrapperPropertiesVisitor
    extends PropertiesVisitor<ExecutionContext> {
        private static final String DISTRIBUTION_SHA_256_SUM_KEY = "distributionSha256Sum";
        private final GradleWrapper gradleWrapper;

        public WrapperPropertiesVisitor(GradleWrapper gradleWrapper) {
            this.gradleWrapper = gradleWrapper;
        }

        public Properties visitFile(Properties.File file, ExecutionContext executionContext) {
            Properties p = super.visitFile(file, (Object)executionContext);
            Set properties = FindProperties.find((Properties)p, (String)DISTRIBUTION_SHA_256_SUM_KEY, (Boolean)false);
            if (properties.isEmpty()) {
                Properties.Value propertyValue = new Properties.Value(Tree.randomId(), "", Markers.EMPTY, this.gradleWrapper.getDistributionChecksum().getHexValue());
                Properties.Entry entry = new Properties.Entry(Tree.randomId(), "\n", Markers.EMPTY, DISTRIBUTION_SHA_256_SUM_KEY, "", Properties.Entry.Delimiter.EQUALS, propertyValue);
                List contentList = ListUtils.concat((List)((Properties.File)p).getContent(), (Object)entry);
                p = ((Properties.File)p).withContent(contentList);
            }
            return p;
        }

        public Properties visitEntry(Properties.Entry entry, ExecutionContext context) {
            if ("distributionUrl".equals(entry.getKey())) {
                return entry.withValue(entry.getValue().withText(this.gradleWrapper.getPropertiesFormattedUrl()));
            }
            if (DISTRIBUTION_SHA_256_SUM_KEY.equals(entry.getKey())) {
                return entry.withValue(entry.getValue().withText(this.gradleWrapper.getDistributionChecksum().getHexValue()));
            }
            return entry;
        }
    }
}

