/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.Collections;
import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class ReplaceInitMockToOpenMock
extends Recipe {
    private static final String MOCKITO_EXTENSION = "org.mockito.junit.jupiter.MockitoExtension";
    private static final String MOCKITO_JUNIT_RUNNER = "org.mockito.junit.MockitoJUnitRunner";
    private static final String JUPITER_BEFORE_EACH = "org.junit.jupiter.api.BeforeEach";
    private static final AnnotationMatcher BEFORE_EACH_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.BeforeEach");
    private static final AnnotationMatcher AFTER_EACH_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.AfterEach");
    private static final MethodMatcher INIT_MOCKS_MATCHER = new MethodMatcher("org.mockito.MockitoAnnotations initMocks(..)", false);

    public String getDisplayName() {
        return "Replace `MockitoAnnotations.initMocks(this)` to `MockitoAnnotations.openMocks(this)`";
    }

    public String getDescription() {
        return "Replace `MockitoAnnotations.initMocks(this)` to `MockitoAnnotations.openMocks(this)` and generate `AutoCloseable` mocks.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(INIT_MOCKS_MATCHER), new UsesType(JUPITER_BEFORE_EACH, Boolean.valueOf(false)), Preconditions.not((TreeVisitor)new UsesType(MOCKITO_EXTENSION, Boolean.valueOf(false))), Preconditions.not((TreeVisitor)new UsesType(MOCKITO_JUNIT_RUNNER, Boolean.valueOf(false)))});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private String variableName = "mocks";
            final TreeVisitor<J, ExecutionContext> updateJUnitLifecycleMethods = new JavaIsoVisitor<ExecutionContext>(){
                private final String EXCEPTION_CLASS_NAME = "java.lang.Exception";

                private boolean isAnnotatedMethodPresent(J.ClassDeclaration cd, AnnotationMatcher beforeEachMatcher) {
                    return cd.getBody().getStatements().stream().anyMatch(st -> {
                        if (!(st instanceof J.MethodDeclaration)) return false;
                        if (!((J.MethodDeclaration)st).getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)beforeEachMatcher).matches(arg_0))) return false;
                        return true;
                    });
                }

                public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext ctx) {
                    if (!this.isAnnotatedMethodPresent(cd, AFTER_EACH_MATCHER) && this.isAnnotatedMethodPresent(cd, BEFORE_EACH_MATCHER)) {
                        this.maybeAddImport("org.junit.jupiter.api.AfterEach");
                        cd = (J.ClassDeclaration)JavaTemplate.builder((String)"@AfterEach\nvoid tearDown() throws Exception {\n}").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).imports(new String[]{"org.junit.jupiter.api.AfterEach"}).build().apply(this.getCursor(), cd.getBody().getCoordinates().lastStatement(), new Object[0]);
                    }
                    cd = super.visitClassDeclaration(cd, (Object)ctx);
                    return (J.ClassDeclaration)this.autoFormat((J)cd, ctx);
                }

                public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                    J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                    if (((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), BEFORE_EACH_MATCHER) && md.getBody() != null) {
                        this.maybeRemoveImport("org.mockito.MockitoAnnotations.initMocks");
                        this.maybeAddImport("org.mockito.MockitoAnnotations");
                        return (J.MethodDeclaration)new JavaVisitor<ExecutionContext>(){

                            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                                if (INIT_MOCKS_MATCHER.matches((MethodCall)mi)) {
                                    return JavaTemplate.builder((String)(variableName + " = MockitoAnnotations.openMocks(this);")).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core"})).imports(new String[]{"org.mockito.MockitoAnnotations"}).contextSensitive().build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[0]);
                                }
                                return mi;
                            }
                        }.visitNonNull((Tree)md, (Object)ctx, this.getCursor().getParentOrThrow());
                    }
                    if (((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), AFTER_EACH_MATCHER) && md.getBody() != null) {
                        for (Statement st : md.getBody().getStatements()) {
                            if (!(st instanceof J.MethodInvocation) || !(((J.MethodInvocation)st).getSelect() instanceof J.Identifier) || !((J.Identifier)((J.MethodInvocation)st).getSelect()).getSimpleName().equals(variableName)) continue;
                            return md;
                        }
                        md = (J.MethodDeclaration)JavaTemplate.builder((String)(variableName + ".close();")).contextSensitive().build().apply(this.getCursor(), md.getBody().getCoordinates().lastStatement(), new Object[0]);
                        md = this.addThrowsIfAbsent(md);
                        return (J.MethodDeclaration)this.maybeAutoFormat((J)method, (J)md, ctx);
                    }
                    return md;
                }

                private J.MethodDeclaration addThrowsIfAbsent(J.MethodDeclaration md) {
                    if (md.getThrows() != null && md.getThrows().stream().anyMatch(j -> TypeUtils.isOfClassType((JavaType)j.getType(), (String)"java.lang.Exception"))) {
                        return md;
                    }
                    JavaType.ShallowClass exceptionType = JavaType.ShallowClass.build((String)"java.lang.Exception");
                    return md.withThrows(ListUtils.concat((List)md.getThrows(), (Object)new J.Identifier(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, Collections.emptyList(), exceptionType.getClassName(), (JavaType)exceptionType, null)));
                }
            };

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (((Boolean)this.getCursor().getMessage("initMocksFound", (Object)false)).booleanValue()) {
                    this.variableName = VariableNameUtils.generateVariableName((String)"mocks", (Cursor)this.getCursor(), (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
                    J.ClassDeclaration after = (J.ClassDeclaration)JavaTemplate.apply((String)("private AutoCloseable " + this.variableName + ";"), (Cursor)this.getCursor(), (JavaCoordinates)cd.getBody().getCoordinates().firstStatement(), (Object[])new Object[0]);
                    return (J.ClassDeclaration)this.maybeAutoFormat((J)cd, (J)after, ctx);
                }
                return cd;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), BEFORE_EACH_MATCHER)) {
                    return super.visitMethodDeclaration(method, (Object)ctx);
                }
                return method;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (INIT_MOCKS_MATCHER.matches((MethodCall)mi)) {
                    this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, "initMocksFound", (Object)true);
                    this.doAfterVisit(this.updateJUnitLifecycleMethods);
                }
                return mi;
            }
        });
    }
}

