/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.easymock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;

public class EasyMockVerifyToMockitoVerify
extends Recipe {
    private static final MethodMatcher VERIFY_MATCHER = new MethodMatcher("org.easymock.EasyMock verify(..)", true);
    private static final MethodMatcher EASY_MATCHER = new MethodMatcher("org.easymock.EasyMock expect(..)");

    public String getDisplayName() {
        return "Replace EasyMock `verify` calls with Mockito `verify` calls";
    }

    public String getDescription() {
        return "Replace `EasyMock.verify(dependency)` with individual `Mockito.verify(dependency).method()` calls based on expected methods.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(VERIFY_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                if (md.getBody() == null) {
                    return md;
                }
                this.maybeAddImport("org.mockito.Mockito", "verify");
                this.maybeRemoveImport("org.easymock.EasyMock.verify");
                int idx = 0;
                for (Statement statement : md.getBody().getStatements()) {
                    if (statement instanceof J.MethodInvocation) {
                        J.MethodInvocation m = (J.MethodInvocation)statement;
                        if (VERIFY_MATCHER.matches((MethodCall)m) && m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Identifier) {
                            J.Identifier dependency = (J.Identifier)m.getArguments().get(0);
                            List<Statement> statementsAboveVerify = md.getBody().getStatements().subList(0, idx);
                            List<J.MethodInvocation> expectedCalls = this.getExpectedCalls(dependency, statementsAboveVerify);
                            int expectedCallsSize = expectedCalls.size();
                            for (int i = 0; i < expectedCallsSize; ++i) {
                                J.MethodInvocation expectedMethod = expectedCalls.get(i);
                                List parameters = expectedMethod.getArguments();
                                if (parameters.size() == 1 && parameters.get(0) instanceof J.Empty) {
                                    parameters.clear();
                                }
                                String anyArgs = String.join((CharSequence)",", Collections.nCopies(parameters.size(), "#{any()}"));
                                parameters.add(0, dependency);
                                Statement currStatement = (Statement)md.getBody().getStatements().get(idx);
                                JavaCoordinates coordinates = i == 0 ? currStatement.getCoordinates().replace() : currStatement.getCoordinates().after();
                                md = (J.MethodDeclaration)JavaTemplate.builder((String)("verify(#{any()})." + expectedMethod.getSimpleName() + "(" + anyArgs + ")")).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-5"})).staticImports(new String[]{"org.mockito.Mockito.verify"}).build().apply(this.updateCursor((Tree)md), coordinates, parameters.toArray());
                                if (i == 0) continue;
                                ++idx;
                            }
                        }
                    }
                    ++idx;
                }
                return md;
            }

            private List<J.MethodInvocation> getExpectedCalls(J.Identifier dependency, List<Statement> statementsAboveVerify) {
                ArrayList<J.MethodInvocation> expectedCalls = new ArrayList<J.MethodInvocation>();
                for (Statement statement : statementsAboveVerify) {
                    if (!(statement instanceof J.MethodInvocation)) continue;
                    J.MethodInvocation mi = (J.MethodInvocation)statement;
                    if (this.isExpectInvocation(mi, dependency)) {
                        expectedCalls.add((J.MethodInvocation)mi.getArguments().get(0));
                        continue;
                    }
                    if (!this.isExpectAndReturnInvocation(mi, dependency)) continue;
                    expectedCalls.add((J.MethodInvocation)((J.MethodInvocation)mi.getSelect()).getArguments().get(0));
                }
                return expectedCalls;
            }

            private boolean isExpectInvocation(J.MethodInvocation mi, J.Identifier dependency) {
                return EASY_MATCHER.matches((MethodCall)mi) && mi.getArguments().size() == 1 && mi.getArguments().get(0) instanceof J.MethodInvocation && ((J.MethodInvocation)mi.getArguments().get(0)).getSelect() instanceof J.Identifier && dependency.getSimpleName().equals(((J.Identifier)((J.MethodInvocation)mi.getArguments().get(0)).getSelect()).getSimpleName());
            }

            private boolean isExpectAndReturnInvocation(J.MethodInvocation m, J.Identifier dependency) {
                return EASY_MATCHER.matches(m.getSelect()) && m.getSelect() instanceof J.MethodInvocation && this.isExpectInvocation((J.MethodInvocation)m.getSelect(), dependency);
            }
        });
    }
}

