/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class AssertEqualsNullToAssertNull
extends Recipe {
    private static final MethodMatcher ASSERT_EQUALS = new MethodMatcher("org.junit.jupiter.api.Assertions assertEquals(..)");

    public String getDisplayName() {
        return "`assertEquals(a, null)` to `assertNull(a)`";
    }

    public String getDescription() {
        return "Using `assertNull(a)` is simpler and more clear.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_EQUALS), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            JavaParser.Builder<?, ?> javaParser = null;

            private JavaParser.Builder<?, ?> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"});
                }
                return this.javaParser;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_EQUALS.matches((MethodCall)method) && this.hasNullLiteralArg(mi)) {
                    JavaTemplate t;
                    Object[] args;
                    StringBuilder sb = new StringBuilder();
                    if (mi.getSelect() != null) {
                        sb.append("Assertions.");
                    }
                    sb.append("assertNull(#{any(java.lang.Object)}");
                    if (mi.getArguments().size() == 3) {
                        sb.append(", #{any()}");
                        args = new Object[]{this.isNullLiteral((Expression)mi.getArguments().get(0)) ? mi.getArguments().get(1) : mi.getArguments().get(0), mi.getArguments().get(2)};
                    } else {
                        args = new Object[]{this.isNullLiteral((Expression)mi.getArguments().get(0)) ? mi.getArguments().get(1) : mi.getArguments().get(0)};
                    }
                    sb.append(")");
                    if (method.getSelect() == null) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertNull");
                        t = JavaTemplate.builder((String)sb.toString()).contextSensitive().javaParser(this.javaParser(ctx)).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertNull"}).build();
                    } else {
                        t = JavaTemplate.builder((String)sb.toString()).contextSensitive().javaParser(this.javaParser(ctx)).imports(new String[]{"org.junit.jupiter.api.Assertions.assertNull"}).build();
                    }
                    return t.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args);
                }
                return mi;
            }

            private boolean hasNullLiteralArg(J.MethodInvocation method) {
                if (method.getArguments().size() > 1) {
                    return this.isNullLiteral((Expression)method.getArguments().get(0)) || this.isNullLiteral((Expression)method.getArguments().get(1));
                }
                return false;
            }

            private boolean isNullLiteral(Expression expr) {
                return expr.getType() == JavaType.Primitive.Null;
            }
        });
    }
}

