/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJDoubleRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Adopt AssertJ Double Assertions";
    }

    public String getDescription() {
        return "Adopt AssertJ Double Assertions. Favor semantically explicit methods (e.g. `myDouble.isZero()` over `myDouble.isEqualTo(0.0)`).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractDoubleAssertIsCloseToWithOffsetRecipe(), new AbstractDoubleAssertIsEqualToRecipe(), new AbstractDoubleAssertIsNotEqualToRecipe(), new AbstractDoubleAssertIsZeroRecipe(), new AbstractDoubleAssertIsNotZeroRecipe(), new AbstractDoubleAssertIsOneRecipe()});
    }

    @NullMarked
    public static class AbstractDoubleAssertIsCloseToWithOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isEqualTo` with `isCloseTo`";
        }

        public String getDescription() {
            return "Replace `isEqualTo` with `isCloseTo` when `offset` or `percentage` is provided.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(#{n:any(double)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Double>)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isCloseTo(#{n:any(double)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Double>)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(#{n:any(java.lang.Double)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Double>)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isCloseTo(#{n:any(double)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Double>)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.data.Offset", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractDoubleAssertIsEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isCloseTo` with `isEqualTo`";
        }

        public String getDescription() {
            return "Replace `isCloseTo` with `isEqualTo` when `offset` or `percentage` is zero.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isCloseTo(#{n:any(double)}, org.assertj.core.data.Offset.offset(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isCloseTo(#{n:any(double)}, org.assertj.core.data.Offset.offset(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isCloseTo(#{n:any(double)}, org.assertj.core.data.Percentage.withPercentage(0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isCloseTo(#{n:any(double)}, org.assertj.core.data.Percentage.withPercentage(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$4 == null) {
                        this.before$4 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isCloseTo(#{n:any(double)}, org.assertj.core.data.Percentage.withPercentage(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$4.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractDoubleAssertIsNotEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isNotCloseTo` with `isNotEqualTo`";
        }

        public String getDescription() {
            return "Replace `isNotCloseTo` with `isNotEqualTo` when `offset` or `percentage` is zero.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate before$3;
                JavaTemplate before$4;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotCloseTo(#{n:any(double)}, org.assertj.core.data.Offset.offset(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotCloseTo(#{n:any(double)}, org.assertj.core.data.Offset.offset(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotCloseTo(#{n:any(double)}, org.assertj.core.data.Percentage.withPercentage(0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$3 == null) {
                        this.before$3 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotCloseTo(#{n:any(double)}, org.assertj.core.data.Percentage.withPercentage(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$3.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$4 == null) {
                        this.before$4 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotCloseTo(#{n:any(double)}, org.assertj.core.data.Percentage.withPercentage(0.0))").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$4.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotEqualTo(#{n:any(double)})").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isNotCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractDoubleAssertIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isEqualTo(0)` with `isZero()`";
        }

        public String getDescription() {
            return "Replace `isEqualTo(0)` with `isZero()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(0)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isZero()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(0.0)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isZero()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(0.0)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isZero()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractDoubleAssertIsNotZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isNotEqualTo(0)` with `isNotZero()`";
        }

        public String getDescription() {
            return "Replace `isNotEqualTo(0)` with `isNotZero()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotEqualTo(0)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotZero()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotEqualTo(0.0)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotZero()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotEqualTo(0.0)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isNotZero()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isNotEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractDoubleAssertIsOneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isEqualTo(1)` with `isOne()`";
        }

        public String getDescription() {
            return "Replace `isEqualTo(1)` with `isOne()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate before$2;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(1)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isOne()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(1.0)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isOne()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$2 == null) {
                        this.before$2 = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isEqualTo(1.0)").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                    }
                    if ((matcher = this.before$2.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{doubleAssert:any(org.assertj.core.api.AbstractDoubleAssert<?>)}.isOne()").bindType("org.assertj.core.api.AbstractDoubleAssert<?>").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

