/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.testing.jmockit.JMockitUtils;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

class ArgumentMatchersRewriter {
    private static final Set<String> JMOCKIT_ARGUMENT_MATCHERS = new HashSet<String>();
    private static final Map<String, String> FQN_TO_MOCKITO_ARGUMENT_MATCHER;
    private static final Map<JavaType.Primitive, String> PRIMITIVE_TO_MOCKITO_ARGUMENT_MATCHER;
    private final JavaVisitor<ExecutionContext> visitor;
    private final ExecutionContext ctx;
    private final J.Block expectationsBlock;

    ArgumentMatchersRewriter(JavaVisitor<ExecutionContext> visitor, ExecutionContext ctx, J.Block expectationsBlock) {
        this.visitor = visitor;
        this.ctx = ctx;
        this.expectationsBlock = expectationsBlock;
    }

    J.Block rewriteJMockitBlock() {
        ArrayList<Object> newStatements = new ArrayList<Object>(this.expectationsBlock.getStatements().size());
        for (Statement expectationStatement : this.expectationsBlock.getStatements()) {
            if (!(expectationStatement instanceof J.MethodInvocation)) {
                newStatements.add(expectationStatement);
                continue;
            }
            newStatements.add(this.rewriteMethodInvocation((J.MethodInvocation)expectationStatement));
        }
        return this.expectationsBlock.withStatements(newStatements);
    }

    private J.MethodInvocation rewriteMethodInvocation(J.MethodInvocation invocation) {
        if (invocation.getSelect() instanceof J.MethodInvocation) {
            invocation = invocation.withSelect((Expression)this.rewriteMethodInvocation((J.MethodInvocation)invocation.getSelect()));
        }
        List arguments = invocation.getArguments();
        arguments.replaceAll(arg -> {
            J.FieldAccess fieldAccess;
            if (arg instanceof J.FieldAccess && (fieldAccess = (J.FieldAccess)arg).getTarget() instanceof J.Identifier && "this".equals(((J.Identifier)fieldAccess.getTarget()).getSimpleName())) {
                return fieldAccess.getName();
            }
            return arg;
        });
        if (arguments.stream().noneMatch(ArgumentMatchersRewriter::isJmockitArgumentMatcher)) {
            return invocation;
        }
        ArrayList<Expression> newArguments = new ArrayList<Expression>(arguments.size());
        for (Expression argument : arguments) {
            newArguments.add(this.rewriteMethodArgument(argument));
        }
        return invocation.withArguments(newArguments);
    }

    private Expression rewriteMethodArgument(Expression methodArgument) {
        String argumentMatcher = null;
        String template = null;
        ArrayList<Object> templateParams = new ArrayList<Object>();
        JavaType type = methodArgument.getType();
        if (type == JavaType.Primitive.Null) {
            argumentMatcher = "isNull";
            template = argumentMatcher + "()";
        } else if (!ArgumentMatchersRewriter.isJmockitArgumentMatcher(methodArgument)) {
            argumentMatcher = "eq";
            template = argumentMatcher + "(#{any()})";
            templateParams.add(methodArgument);
        } else if (!(methodArgument instanceof J.TypeCast)) {
            argumentMatcher = ((J.Identifier)methodArgument).getSimpleName();
            template = argumentMatcher + "()";
        } else if (TypeUtils.isString((JavaType)type)) {
            argumentMatcher = "anyString";
            template = argumentMatcher + "()";
        } else if (type instanceof JavaType.Primitive) {
            argumentMatcher = PRIMITIVE_TO_MOCKITO_ARGUMENT_MATCHER.get(type);
            template = argumentMatcher + "()";
        } else if (type instanceof JavaType.FullyQualified || type instanceof JavaType.Array) {
            return this.rewriteAnyWithClassParameterToArgumentMatcher(methodArgument, type);
        }
        if (template == null || argumentMatcher == null) {
            return methodArgument;
        }
        return this.applyArgumentTemplate(methodArgument, argumentMatcher, template, templateParams);
    }

    private Expression applyArgumentTemplate(Expression methodArgument, String argumentMatcher, String template, List<Object> templateParams) {
        this.visitor.maybeAddImport("org.mockito.Mockito", argumentMatcher);
        return (Expression)JavaTemplate.builder((String)template).javaParser(JMockitUtils.getJavaParser(this.ctx)).staticImports(new String[]{"org.mockito.Mockito." + argumentMatcher}).build().apply(new Cursor(this.visitor.getCursor(), (Object)methodArgument), methodArgument.getCoordinates().replace(), templateParams.toArray());
    }

    private Expression applyClassArgumentTemplate(Expression methodArgument, JavaType.FullyQualified type) {
        return (Expression)((Expression)JavaTemplate.builder((String)"#{}.class").javaParser(JavaParser.fromJavaVersion()).imports(new String[]{type.getFullyQualifiedName()}).build().apply(new Cursor(this.visitor.getCursor(), (Object)methodArgument), methodArgument.getCoordinates().replace(), new Object[]{type.getClassName()})).withType((JavaType)type);
    }

    private Expression rewriteAnyWithClassParameterToArgumentMatcher(Expression methodArgument, JavaType type) {
        JavaType.FullyQualified fq;
        String argumentMatcher;
        ArrayList<Object> templateParams = new ArrayList<Object>();
        if (type instanceof JavaType.FullyQualified && (argumentMatcher = FQN_TO_MOCKITO_ARGUMENT_MATCHER.get((fq = (JavaType.FullyQualified)type).getFullyQualifiedName())) != null) {
            String template = argumentMatcher + "()";
            return this.applyArgumentTemplate(methodArgument, argumentMatcher, template, templateParams);
        }
        String argumentMatcher2 = "any";
        String template = argumentMatcher2 + "(#{any(java.lang.Class)})";
        if (type instanceof JavaType.FullyQualified) {
            templateParams.add(this.applyClassArgumentTemplate(methodArgument, (JavaType.FullyQualified)type));
        } else if (type instanceof JavaType.Array) {
            templateParams.add(this.applyArrayClassArgumentTemplate(methodArgument, ((JavaType.Array)type).getElemType()));
        }
        J.MethodInvocation invocationArgument = (J.MethodInvocation)this.applyArgumentTemplate(methodArgument, argumentMatcher2, template, templateParams);
        Expression classArgument = (Expression)templateParams.get(0);
        if (classArgument.getType() == null || invocationArgument.getMethodType() == null || invocationArgument.getMethodType().getParameterTypes().size() != 1 || !(invocationArgument.getMethodType().getParameterTypes().get(0) instanceof JavaType.Parameterized)) {
            return invocationArgument;
        }
        JavaType.Parameterized newParameterType = ((JavaType.Parameterized)invocationArgument.getMethodType().getParameterTypes().get(0)).withTypeParameters(Collections.singletonList(classArgument.getType()));
        JavaType.Method newMethodType = invocationArgument.getMethodType().withReturnType(classArgument.getType()).withParameterTypes(Collections.singletonList(newParameterType));
        return invocationArgument.withMethodType(newMethodType);
    }

    private Expression applyArrayClassArgumentTemplate(Expression methodArgument, JavaType elementType) {
        String newArrayElementClassName = elementType instanceof JavaType.FullyQualified ? ((JavaType.FullyQualified)elementType).getClassName() : (elementType instanceof JavaType.Primitive ? ((JavaType.Primitive)elementType).getKeyword() : elementType.getClass().getName());
        return (Expression)JavaTemplate.builder((String)"#{}[].class").javaParser(JavaParser.fromJavaVersion()).build().apply(new Cursor(this.visitor.getCursor(), (Object)methodArgument), methodArgument.getCoordinates().replace(), new Object[]{newArrayElementClassName});
    }

    private static boolean isJmockitArgumentMatcher(Expression expression) {
        if (expression instanceof J.TypeCast) {
            expression = ((J.TypeCast)expression).getExpression();
        }
        if (!(expression instanceof J.Identifier)) {
            return false;
        }
        J.Identifier identifier = (J.Identifier)expression;
        return JMOCKIT_ARGUMENT_MATCHERS.contains(identifier.getSimpleName());
    }

    static {
        JMOCKIT_ARGUMENT_MATCHERS.add("anyString");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyInt");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyLong");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyDouble");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyFloat");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyBoolean");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyByte");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyChar");
        JMOCKIT_ARGUMENT_MATCHERS.add("anyShort");
        JMOCKIT_ARGUMENT_MATCHERS.add("any");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER = new HashMap<String, String>();
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.util.List", "anyList");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.util.Set", "anySet");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.util.Collection", "anyCollection");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.util.Iterable", "anyIterable");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.util.Map", "anyMap");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.lang.Integer", "anyInt");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.lang.Long", "anyLong");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.lang.Double", "anyDouble");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.lang.Float", "anyFloat");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.lang.Boolean", "anyBoolean");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.lang.Byte", "anyByte");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.lang.Character", "anyChar");
        FQN_TO_MOCKITO_ARGUMENT_MATCHER.put("java.lang.Short", "anyShort");
        PRIMITIVE_TO_MOCKITO_ARGUMENT_MATCHER = new HashMap<JavaType.Primitive, String>();
        PRIMITIVE_TO_MOCKITO_ARGUMENT_MATCHER.put(JavaType.Primitive.Int, "anyInt");
        PRIMITIVE_TO_MOCKITO_ARGUMENT_MATCHER.put(JavaType.Primitive.Long, "anyLong");
        PRIMITIVE_TO_MOCKITO_ARGUMENT_MATCHER.put(JavaType.Primitive.Double, "anyDouble");
        PRIMITIVE_TO_MOCKITO_ARGUMENT_MATCHER.put(JavaType.Primitive.Float, "anyFloat");
        PRIMITIVE_TO_MOCKITO_ARGUMENT_MATCHER.put(JavaType.Primitive.Boolean, "anyBoolean");
        PRIMITIVE_TO_MOCKITO_ARGUMENT_MATCHER.put(JavaType.Primitive.Byte, "anyByte");
        PRIMITIVE_TO_MOCKITO_ARGUMENT_MATCHER.put(JavaType.Primitive.Char, "anyChar");
        PRIMITIVE_TO_MOCKITO_ARGUMENT_MATCHER.put(JavaType.Primitive.Short, "anyShort");
    }
}

