/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.LambdaBlockToExpression;

public class AssertThrowsOnLastStatement
extends Recipe {
    private static final Pattern NUMBER_SUFFIX_PATTERN = Pattern.compile("^(.+?)(\\d+)$");

    public String getDisplayName() {
        return "Applies JUnit 5 `assertThrows` on last statement in lambda block only";
    }

    public String getDescription() {
        return "Applies JUnit 5 `assertThrows` on last statement in lambda block only. In rare cases may cause compilation errors if the lambda uses effectively non final variables. In some cases, tests might fail if earlier statements in the lambda block throw exceptions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher assertThrowsMatcher = new MethodMatcher("org.junit.jupiter.api.Assertions assertThrows(java.lang.Class, org.junit.jupiter.api.function.Executable, ..)");
        return Preconditions.check((TreeVisitor)new UsesMethod(assertThrowsMatcher), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDecl, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(methodDecl, (Object)ctx);
                if (m.getBody() == null) {
                    return m;
                }
                this.doAfterVisit(new LambdaBlockToExpression().getVisitor());
                return m.withBody(m.getBody().withStatements(ListUtils.flatMap((List)m.getBody().getStatements(), methodStatement -> {
                    J.VariableDeclarations.NamedVariable assertThrowsVar;
                    J.VariableDeclarations assertThrowsWithVarDec;
                    Statement statementToCheck = methodStatement;
                    if (methodStatement instanceof J.VariableDeclarations) {
                        assertThrowsWithVarDec = (J.VariableDeclarations)methodStatement;
                        List assertThrowsNamedVars = assertThrowsWithVarDec.getVariables();
                        if (assertThrowsNamedVars.size() != 1) {
                            return methodStatement;
                        }
                        assertThrowsVar = (J.VariableDeclarations.NamedVariable)assertThrowsNamedVars.get(0);
                        statementToCheck = assertThrowsVar.getInitializer();
                    } else {
                        assertThrowsWithVarDec = null;
                        assertThrowsVar = null;
                    }
                    if (!(statementToCheck instanceof J.MethodInvocation)) {
                        return methodStatement;
                    }
                    J.MethodInvocation methodInvocation = (J.MethodInvocation)statementToCheck;
                    if (!assertThrowsMatcher.matches((MethodCall)methodInvocation)) {
                        return methodStatement;
                    }
                    List arguments = methodInvocation.getArguments();
                    if (arguments.size() <= 1) {
                        return methodStatement;
                    }
                    Expression arg = (Expression)arguments.get(1);
                    if (!(arg instanceof J.Lambda)) {
                        return methodStatement;
                    }
                    J.Lambda lambda = (J.Lambda)arg;
                    if (!(lambda.getBody() instanceof J.Block)) {
                        return methodStatement;
                    }
                    J.Block body = (J.Block)lambda.getBody();
                    List lambdaStatements = body.getStatements();
                    return ListUtils.flatMap((List)lambdaStatements, (idx, lambdaStatement) -> {
                        if (idx < lambdaStatements.size() - 1) {
                            return lambdaStatement.withPrefix(methodStatement.getPrefix().withComments(Collections.emptyList()));
                        }
                        ArrayList<Statement> variableAssignments = new ArrayList<Statement>();
                        Space prefix = methodStatement.getPrefix().withComments(Collections.emptyList());
                        Statement newLambdaStatement = this.extractExpressionArguments((Statement)lambdaStatement, (List<Statement>)variableAssignments, prefix);
                        J.MethodInvocation newAssertThrows = methodInvocation.withArguments(ListUtils.map((List)arguments, (argIdx, argument) -> {
                            if (argIdx == 1) {
                                return lambda.withBody((J)body.withStatements(Collections.singletonList(newLambdaStatement)));
                            }
                            return argument;
                        }));
                        if (assertThrowsWithVarDec == null) {
                            variableAssignments.add((Statement)newAssertThrows);
                            return variableAssignments;
                        }
                        J.VariableDeclarations.NamedVariable newAssertThrowsVar = assertThrowsVar.withInitializer((Expression)newAssertThrows);
                        variableAssignments.add((Statement)assertThrowsWithVarDec.withVariables(Collections.singletonList(newAssertThrowsVar)));
                        return variableAssignments;
                    });
                })));
            }

            private Statement extractExpressionArguments(Statement lambdaStatement, List<Statement> precedingVars, Space varPrefix) {
                if (lambdaStatement instanceof J.MethodInvocation) {
                    J.MethodInvocation mi = (J.MethodInvocation)lambdaStatement;
                    HashMap generatedVariableSuffixes = new HashMap();
                    return mi.withArguments(ListUtils.map((List)mi.getArguments(), e -> {
                        if (e instanceof J.Identifier || e instanceof J.Literal || e instanceof J.Empty || e == null) {
                            return e;
                        }
                        String variableTypeShort = "Object";
                        JavaType variableTypeFqn = null;
                        if (e.getType() instanceof JavaType.Primitive) {
                            variableTypeShort = e.getType().toString();
                            variableTypeFqn = e.getType();
                        } else if (e.getType() instanceof JavaType.FullyQualified) {
                            JavaType.FullyQualified aClass = (JavaType.FullyQualified)e.getType();
                            variableTypeShort = aClass.getClassName();
                            variableTypeFqn = aClass;
                            this.maybeAddImport(aClass.getFullyQualifiedName(), false);
                        }
                        Cursor c = new Cursor(this.getCursor(), (Object)lambdaStatement);
                        J.VariableDeclarations varDecl = (J.VariableDeclarations)JavaTemplate.builder((String)"#{} #{} = #{any()};").build().apply(c, lambdaStatement.getCoordinates().replace(), new Object[]{variableTypeShort, this.getVariableName((Expression)e, generatedVariableSuffixes), e});
                        precedingVars.add((Statement)varDecl.withPrefix(varPrefix).withType(variableTypeFqn));
                        return ((J.VariableDeclarations.NamedVariable)varDecl.getVariables().get(0)).getName().withPrefix(e.getPrefix()).withType(variableTypeFqn);
                    }));
                }
                return lambdaStatement;
            }

            private String getVariableName(Expression e, Map<String, Integer> generatedVariableSuffixes) {
                String variableName;
                if (e instanceof J.MethodInvocation) {
                    String name = ((J.MethodInvocation)e).getSimpleName();
                    name = name.replaceAll("^get", "");
                    name = name.replaceAll("^is", "");
                    variableName = VariableNameUtils.generateVariableName((String)(!(name = StringUtils.uncapitalize((String)name)).isEmpty() ? name : "x"), (Cursor)this.getCursor(), (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
                } else {
                    variableName = VariableNameUtils.generateVariableName((String)"x", (Cursor)this.getCursor(), (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
                }
                return this.ensureUniqueVariableName(variableName, generatedVariableSuffixes);
            }

            private String ensureUniqueVariableName(String variableName, Map<String, Integer> generatedVariableSuffixes) {
                Set existingVariablesInScope = VariableNameUtils.findNamesInScope((Cursor)this.getCursor());
                Matcher matcher = NUMBER_SUFFIX_PATTERN.matcher(variableName);
                if (matcher.matches()) {
                    String prefix = matcher.group(1);
                    int suffix = Integer.parseInt(matcher.group(2));
                    generatedVariableSuffixes.putIfAbsent(prefix, suffix);
                    variableName = prefix;
                }
                if (generatedVariableSuffixes.containsKey(variableName)) {
                    int suffix = generatedVariableSuffixes.get(variableName);
                    while (existingVariablesInScope.contains(variableName + suffix)) {
                        ++suffix;
                    }
                    generatedVariableSuffixes.put(variableName, suffix + 1);
                    variableName = variableName + suffix;
                } else {
                    generatedVariableSuffixes.put(variableName, 1);
                }
                return variableName;
            }
        });
    }
}

