/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class JUnitTryFailToAssertThatThrownBy
extends Recipe {
    private static final MethodMatcher FAIL_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions fail(..)");
    private static final MethodMatcher JUNIT4_FAIL_MATCHER = new MethodMatcher("org.junit.Assert fail(..)");
    private static final MethodMatcher JUNIT_FAIL_MATCHER = new MethodMatcher("junit.framework.Assert fail(..)");
    private static final MethodMatcher ASSERT_EQUALS_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertEquals(..)");
    private static final MethodMatcher JUNIT4_ASSERT_EQUALS_MATCHER = new MethodMatcher("org.junit.Assert assertEquals(..)");
    private static final MethodMatcher GET_MESSAGE_MATCHER = new MethodMatcher("java.lang.Throwable getMessage()", true);

    public String getDisplayName() {
        return "Convert try-catch-fail blocks to AssertJ's assertThatThrownBy";
    }

    public String getDescription() {
        return "Replace try-catch blocks where the try block ends with a `fail()` statement and the catch block optionally contains assertions, with AssertJ's `assertThatThrownBy()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitTry(J.Try tryBlock, ExecutionContext ctx) {
                J.Try try_ = (J.Try)super.visitTry(tryBlock, (Object)ctx);
                if (try_.getResources() != null || try_.getCatches().size() != 1 || try_.getFinally() != null) {
                    return try_;
                }
                List tryStatements = try_.getBody().getStatements();
                if (tryStatements.isEmpty() || !this.isFailMethod((Statement)tryStatements.get(tryStatements.size() - 1))) {
                    return try_;
                }
                J.Try.Catch catchBlock = (J.Try.Catch)try_.getCatches().get(0);
                JavaType.FullyQualified exceptionFqType = TypeUtils.asFullyQualified((JavaType)((J.VariableDeclarations)catchBlock.getParameter().getTree()).getType());
                if (exceptionFqType == null) {
                    return try_;
                }
                String exceptionType = exceptionFqType.getClassName();
                List<String> assertions = this.extractAssertions(catchBlock);
                if (assertions.size() != catchBlock.getBody().getStatements().size()) {
                    return try_;
                }
                ArrayList<Statement> lambdaStatements = new ArrayList<Statement>(tryStatements.subList(0, tryStatements.size() - 1));
                String template = this.buildTemplate(lambdaStatements, exceptionType, assertions);
                this.maybeRemoveImport("org.junit.jupiter.api.Assertions.fail");
                this.maybeRemoveImport("org.junit.Assert.fail");
                this.maybeRemoveImport("junit.framework.Assert.fail");
                if (!assertions.isEmpty()) {
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertEquals");
                    this.maybeRemoveImport("org.junit.Assert.assertEquals");
                }
                this.maybeAddImport("org.assertj.core.api.Assertions", "assertThatThrownBy");
                if (!exceptionFqType.getFullyQualifiedName().startsWith("java.lang.")) {
                    this.maybeAddImport(exceptionFqType.getFullyQualifiedName());
                }
                return JavaTemplate.builder((String)template).contextSensitive().staticImports(new String[]{"org.assertj.core.api.Assertions.assertThatThrownBy"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), try_.getCoordinates().replace(), lambdaStatements.toArray());
            }

            private boolean isFailMethod(Statement method) {
                if (method instanceof Expression) {
                    return FAIL_MATCHER.matches((Expression)method) || JUNIT4_FAIL_MATCHER.matches((Expression)method) || JUNIT_FAIL_MATCHER.matches((Expression)method);
                }
                return false;
            }

            private List<String> extractAssertions(J.Try.Catch catchBlock) {
                ArrayList<String> assertions = new ArrayList<String>();
                for (Statement statement : catchBlock.getBody().getStatements()) {
                    J.Literal literal;
                    if (!(statement instanceof J.MethodInvocation)) continue;
                    J.MethodInvocation mi = (J.MethodInvocation)statement;
                    if (!ASSERT_EQUALS_MATCHER.matches((MethodCall)mi) && !JUNIT4_ASSERT_EQUALS_MATCHER.matches((MethodCall)mi) || 2 > mi.getArguments().size()) continue;
                    Expression arg1 = (Expression)mi.getArguments().get(0);
                    Expression arg2 = (Expression)mi.getArguments().get(1);
                    if (GET_MESSAGE_MATCHER.matches(arg1)) {
                        if (!(arg2 instanceof J.Literal) || !((literal = (J.Literal)arg2).getValue() instanceof String)) continue;
                        assertions.add(".hasMessage(\"" + literal.getValue() + "\")");
                        continue;
                    }
                    if (!GET_MESSAGE_MATCHER.matches(arg2) || !(arg1 instanceof J.Literal) || !((literal = (J.Literal)arg1).getValue() instanceof String)) continue;
                    assertions.add(".hasMessage(\"" + literal.getValue() + "\")");
                }
                return assertions;
            }

            private String buildTemplate(List<Statement> lambdaStatements, String exceptionType, List<String> assertions) {
                StringBuilder template = new StringBuilder();
                template.append("assertThatThrownBy(() -> ");
                if (lambdaStatements.size() == 1) {
                    template.append("#{any()}");
                } else {
                    template.append("{\n");
                    for (int i = 0; i < lambdaStatements.size(); ++i) {
                        template.append("    #{any()};");
                        if (i >= lambdaStatements.size() - 1) continue;
                        template.append("\n");
                    }
                    template.append("\n}");
                }
                template.append(").isInstanceOf(").append(exceptionType).append(".class)");
                for (String assertion : assertions) {
                    template.append(assertion);
                }
                return template.toString();
            }
        };
    }
}

