/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertLiteralBooleanToFailRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace JUnit `assertTrue(false, \"reason\")` and `assertFalse(true, \"reason\")` with `fail(\"reason\")`";
    }

    public String getDescription() {
        return "Using fail is more direct and clear.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new WithMessageRecipe(), new WithoutMessageRecipe()});
    }

    @NullMarked
    public static class WithMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertLiteralBooleanToFail.WithMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic class WithMessage {\n    \n    @BeforeTemplate\n    void assertFalseBefore(String message) {\n        assertFalse(true, message);\n    }\n    \n    @BeforeTemplate\n    void assertTrueBefore(String message) {\n        assertTrue(false, message);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after(String message) {\n        fail(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate assertFalseBefore;
                JavaTemplate assertTrueBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.assertFalseBefore == null) {
                        this.assertFalseBefore = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertFalse(true, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build();
                    }
                    if ((matcher = this.assertFalseBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.fail(#{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.assertTrueBefore == null) {
                        this.assertTrueBefore = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertTrue(false, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build();
                    }
                    if ((matcher = this.assertTrueBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.fail(#{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.junit.jupiter.api.Assertions assertFalse(..)", true), new UsesMethod("org.junit.jupiter.api.Assertions assertTrue(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class WithoutMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertLiteralBooleanToFail.WithoutMessage`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic class WithoutMessage {\n    \n    @BeforeTemplate\n    void assertFalseBefore() {\n        assertFalse(true);\n    }\n    \n    @BeforeTemplate\n    void assertTrueBefore() {\n        assertTrue(false);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    void after() {\n        fail();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate assertFalseBefore;
                JavaTemplate assertTrueBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.assertFalseBefore == null) {
                        this.assertFalseBefore = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertFalse(true);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build();
                    }
                    if ((matcher = this.assertFalseBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.fail();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    if (this.assertTrueBefore == null) {
                        this.assertTrueBefore = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertTrue(false);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build();
                    }
                    if ((matcher = this.assertTrueBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.fail();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.STATIC_IMPORT_ALWAYS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.junit.jupiter.api.Assertions assertFalse(..)", true), new UsesMethod("org.junit.jupiter.api.Assertions assertTrue(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

