/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.Iterator;
import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;

public class NoInitializationForInjectMock
extends Recipe {
    private static final AnnotationMatcher INJECT_MOCKS = new AnnotationMatcher("@org.mockito.InjectMocks");

    public String getDisplayName() {
        return "Remove initialization when using `@InjectMocks`";
    }

    public String getDescription() {
        return "Removes unnecessary initialization for fields annotated with `@InjectMocks` in Mockito tests. If the field was final, the final modifier is removed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.mockito.*", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations variableDeclarations, ExecutionContext ctx) {
                J.VariableDeclarations vd = super.visitVariableDeclarations(variableDeclarations, (Object)ctx);
                if (this.isField(this.getCursor()) && new AnnotationService().matches(this.getCursor(), INJECT_MOCKS)) {
                    return (J.VariableDeclarations)this.maybeAutoFormat((J)vd, (J)vd.withModifiers(ListUtils.map((List)vd.getModifiers(), modifier -> modifier.getType() == J.Modifier.Type.Final ? null : modifier)).withVariables(ListUtils.map((List)vd.getVariables(), it -> it.withInitializer(null))), ctx, this.getCursor().getParentOrThrow());
                }
                return vd;
            }

            private boolean isField(Cursor cursor) {
                Iterator path = cursor.getPath();
                while (path.hasNext()) {
                    Object o = path.next();
                    if (o instanceof J.MethodDeclaration) {
                        return false;
                    }
                    if (!(o instanceof J.ClassDeclaration)) continue;
                    return true;
                }
                return true;
            }
        });
    }
}

