/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class UseAssertSame
extends Recipe {
    private static final MethodMatcher ASSERT_TRUE_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(..)");
    private static final MethodMatcher ASSERT_FALSE_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertFalse(..)");

    public String getDisplayName() {
        return "Use JUnit5's `assertSame` or `assertNotSame` instead of `assertTrue(... == ...)`";
    }

    public String getDescription() {
        return "Prefers the usage of `assertSame` or `assertNotSame` methods instead of using of vanilla `assertTrue` or `assertFalse` with a boolean comparison.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaIsoVisitor<ExecutionContext> visitor = new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(methodInvocation, (Object)ctx);
                if (!ASSERT_TRUE_MATCHER.matches((MethodCall)mi) && !ASSERT_FALSE_MATCHER.matches((MethodCall)mi)) {
                    return mi;
                }
                if (mi.getMethodType() == null) {
                    return mi;
                }
                Expression firstArgument = (Expression)mi.getArguments().get(0);
                if (!(firstArgument instanceof J.Binary)) {
                    return mi;
                }
                J.Binary binary = (J.Binary)firstArgument;
                if (binary.getOperator() != J.Binary.Type.Equal && binary.getOperator() != J.Binary.Type.NotEqual) {
                    return mi;
                }
                ArrayList<Object> newArguments = new ArrayList<Object>();
                newArguments.add(binary.getLeft());
                newArguments.add(binary.getRight());
                newArguments.addAll(mi.getArguments().subList(1, mi.getArguments().size()));
                String newMethodName = binary.getOperator() == J.Binary.Type.Equal == ASSERT_TRUE_MATCHER.matches((MethodCall)mi) ? "assertSame" : "assertNotSame";
                this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                this.maybeAddImport("org.junit.jupiter.api.Assertions", newMethodName);
                JavaType.Method newType = this.assertSameMethodType(mi, newMethodName);
                return mi.withName(mi.getName().withSimpleName(newMethodName).withType((JavaType)newType)).withMethodType(newType).withArguments(newArguments);
            }

            private JavaType.Method assertSameMethodType(J.MethodInvocation mi, String newMethodName) {
                JavaType.Method assertTrue = mi.getMethodType();
                assert (assertTrue != null);
                int parameterCount = assertTrue.getParameterTypes().size();
                JavaType.FullyQualified assertions = assertTrue.getDeclaringType();
                for (JavaType.Method method : assertions.getMethods()) {
                    if (!method.getName().equals("assertSame") || method.getParameterNames().size() != parameterCount + 1 || !((JavaType)assertTrue.getParameterTypes().get(parameterCount - 1)).equals(method.getParameterTypes().get(parameterCount))) continue;
                    return method;
                }
                return assertTrue.withName(newMethodName);
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(ASSERT_TRUE_MATCHER), new UsesMethod(ASSERT_FALSE_MATCHER)}), (TreeVisitor)visitor);
    }
}

