/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.testing.junit5.FileOrFolder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

class TranslateNewFolderOrFileMethodInvocation
extends JavaVisitor<ExecutionContext> {
    final J.MethodInvocation methodScope;
    final JavaType.Method newMethodType;
    final FileOrFolder fileOrFolder;

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
        J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
        if (!mi.isScope((Tree)this.methodScope)) {
            return mi;
        }
        if (mi.getSelect() != null) {
            mi = this.fileOrFolder == FileOrFolder.FOLDER ? this.toNewFolder(mi, ctx) : this.toNewFile(mi, ctx);
            mi = mi.withMethodType(this.newMethodType);
            J.ClassDeclaration parentClass = (J.ClassDeclaration)this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).getValue();
            mi = mi.withName(mi.getName().withType((JavaType)parentClass.getType()));
        }
        return mi;
    }

    private J.MethodInvocation toNewFolder(J.MethodInvocation mi, ExecutionContext ctx) {
        J tempDir = mi.getSelect().withType((JavaType)JavaType.ShallowClass.build((String)"java.io.File"));
        List<Expression> args = mi.getArguments().stream().filter(arg -> !(arg instanceof J.Empty)).collect(Collectors.toList());
        if (args.isEmpty()) {
            return (J.MethodInvocation)JavaTemplate.builder((String)"newFolder(#{any(java.io.File)}, \"junit\")").imports(new String[]{"java.io.File"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{tempDir});
        }
        if (args.size() == 1) {
            return (J.MethodInvocation)JavaTemplate.builder((String)"newFolder(#{any(java.io.File)}, #{any(java.lang.String)})").imports(new String[]{"java.io.File"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{tempDir, args.get(0)});
        }
        StringBuilder sb = new StringBuilder("newFolder(#{any(java.io.File)}");
        args.forEach(arg -> sb.append(", #{any(java.lang.String)}"));
        sb.append(")");
        ArrayList templateArgs = new ArrayList(args);
        templateArgs.add(0, tempDir);
        return (J.MethodInvocation)JavaTemplate.builder((String)sb.toString()).contextSensitive().imports(new String[]{"java.io.File"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), templateArgs.toArray());
    }

    private J.MethodInvocation toNewFile(J.MethodInvocation mi, ExecutionContext ctx) {
        J tempDir = mi.getSelect().withType((JavaType)JavaType.ShallowClass.build((String)"java.io.File"));
        List args = mi.getArguments().stream().filter(arg -> !(arg instanceof J.Empty)).collect(Collectors.toList());
        if (args.size() != 1) {
            return mi;
        }
        return (J.MethodInvocation)JavaTemplate.builder((String)"newFile(#{any(java.io.File)}, #{any(java.lang.String)})").imports(new String[]{"java.io.File"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{tempDir, args.get(0)});
    }

    @ConstructorProperties(value={"methodScope", "newMethodType", "fileOrFolder"})
    @Generated
    public TranslateNewFolderOrFileMethodInvocation(J.MethodInvocation methodScope, JavaType.Method newMethodType, FileOrFolder fileOrFolder) {
        this.methodScope = methodScope;
        this.newMethodType = newMethodType;
        this.fileOrFolder = fileOrFolder;
    }
}

