/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.reactive.reactor;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ReactorProcessorCreateToSinkRecipes
extends Recipe {
    public String getDisplayName() {
        return "Replace various `Processor.create` calls with their `Sinks` equivalent";
    }

    public String getDescription() {
        return "As of 3.5 Processors are deprecated and Sinks are preferred.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new MonoProcessorCreateToSinkRecipe(), new ReplayProcessorCreateToSinkRecipe(), new ReplayProcessorCreateIntToSinkRecipe(), new ReplayProcessorCreateIntLiteralFalseToSinkRecipe(), new ReplayProcessorCreateIntLiteralTrueToSinkRecipe(), new ReplayProcessorCreateSizeAndTimeoutToSinkRecipe(), new ReplayProcessorCreateSizeAndTimeoutSchedulerToSinkRecipe(), new ReplayProcessorCreateTimeoutToSinkRecipe(), new ReplayProcessorCreateTimeoutSchedulerToSinkRecipe(), new DirectProcessorCreateToSinkRecipe(), new EmitterProcessorCreateToSinkRecipe(), new EmitterProcessorCreateBooleanToSinkRecipe(), new EmitterProcessorCreateIntToSinkRecipe(), new EmitterProcessorCreateIntBooleanToSinkRecipe(), new UnicastProcessorCreateToSinkRecipe(), new UnicastProcessorCreateQueueToSinkRecipe(), new UnicastProcessorCreateQueueDisposableToSinkRecipe(), new UnicastProcessorCreateQueueConsumerDisposableToSinkRecipe()});
    }

    @NullMarked
    public static class MonoProcessorCreateToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `MonoProcessor.create()` with `Sinks.one()`";
        }

        public String getDescription() {
            return "As of 3.5 MonoProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.MonoProcessor.create();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.MonoProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.one();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.MonoProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.MonoProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplayProcessorCreateToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `ReplayProcessor.create()` with `Sinks.many().replay().all()`";
        }

        public String getDescription() {
            return "As of 3.5 ReplayProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.ReplayProcessor.create();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.ReplayProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().replay().all();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.ReplayProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.ReplayProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplayProcessorCreateIntToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `ReplayProcessor.create(int)` with `Sinks.many().replay().limit(int)`";
        }

        public String getDescription() {
            return "As of 3.5 ReplayProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.ReplayProcessor.create(#{integer:any(java.lang.Integer)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.ReplayProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().replay().limit(#{integer:any(java.lang.Integer)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.ReplayProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.ReplayProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplayProcessorCreateIntLiteralFalseToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `ReplayProcessor.create(int, false)` with `Sinks.many().replay().limit(int)`";
        }

        public String getDescription() {
            return "As of 3.5 ReplayProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.ReplayProcessor.create(#{integer:any(java.lang.Integer)}, false);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.ReplayProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().replay().limit(#{integer:any(java.lang.Integer)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.ReplayProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.ReplayProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplayProcessorCreateIntLiteralTrueToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `ReplayProcessor.create(int, true)` with `Sinks.many().replay().all(int)`";
        }

        public String getDescription() {
            return "As of 3.5 ReplayProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.ReplayProcessor.create(#{integer:any(java.lang.Integer)}, true);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.ReplayProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().replay().all(#{integer:any(java.lang.Integer)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.ReplayProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.ReplayProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplayProcessorCreateSizeAndTimeoutToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `ReplayProcessor.createSizeAndTimeout(int, Duration)` with `Sinks.many().replay().limit(int, duration)`";
        }

        public String getDescription() {
            return "As of 3.5 ReplayProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.ReplayProcessor.createSizeAndTimeout(#{integer:any(java.lang.Integer)}, #{duration:any(java.time.Duration)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.ReplayProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().replay().limit(#{integer:any(java.lang.Integer)}, #{duration:any(java.time.Duration)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.ReplayProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.ReplayProcessor createSizeAndTimeout(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplayProcessorCreateSizeAndTimeoutSchedulerToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `ReplayProcessor.createSizeAndTimeout(int, Duration, Scheduler)` with `Sinks.many().replay().limit(int, Duration, Scheduler)`";
        }

        public String getDescription() {
            return "As of 3.5 ReplayProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.ReplayProcessor.createSizeAndTimeout(#{integer:any(java.lang.Integer)}, #{duration:any(java.time.Duration)}, #{scheduler:any(reactor.core.scheduler.Scheduler)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.ReplayProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().replay().limit(#{integer:any(java.lang.Integer)}, #{duration:any(java.time.Duration)}, #{scheduler:any(reactor.core.scheduler.Scheduler)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.ReplayProcessor", Boolean.valueOf(true)), new UsesType("reactor.core.scheduler.Scheduler", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.ReplayProcessor createSizeAndTimeout(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplayProcessorCreateTimeoutToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `ReplayProcessor.createTimeout(Duration)` with `Sinks.many().replay().limit(duration)`";
        }

        public String getDescription() {
            return "As of 3.5 ReplayProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.ReplayProcessor.createTimeout(#{duration:any(java.time.Duration)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.ReplayProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().replay().limit(#{duration:any(java.time.Duration)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.ReplayProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.ReplayProcessor createTimeout(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplayProcessorCreateTimeoutSchedulerToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `ReplayProcessor.createTimeout(Duration, Scheduler)` with `Sinks.many().replay().limit(Duration, Scheduler)`";
        }

        public String getDescription() {
            return "As of 3.5 ReplayProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.ReplayProcessor.createTimeout(#{duration:any(java.time.Duration)}, #{scheduler:any(reactor.core.scheduler.Scheduler)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.ReplayProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().replay().limit(#{duration:any(java.time.Duration)}, #{scheduler:any(reactor.core.scheduler.Scheduler)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.ReplayProcessor", Boolean.valueOf(true)), new UsesType("reactor.core.scheduler.Scheduler", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.ReplayProcessor createTimeout(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DirectProcessorCreateToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `DirectProcessor.create()` with `Sinks.many().multicast().directBestEffort()`";
        }

        public String getDescription() {
            return "As of 3.5 DirectProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.DirectProcessor.create();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.DirectProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().multicast().directBestEffort();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.DirectProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.DirectProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EmitterProcessorCreateToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `EmitterProcessor.create()` with `Sinks.many().multicast().onBackpressureBuffer()`";
        }

        public String getDescription() {
            return "As of 3.5 EmitterProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.EmitterProcessor.create();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.EmitterProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().multicast().onBackpressureBuffer();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.EmitterProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.EmitterProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EmitterProcessorCreateBooleanToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `EmitterProcessor.create(Boolean)` with `Sinks.many().multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, Boolean)`";
        }

        public String getDescription() {
            return "As of 3.5 EmitterProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.EmitterProcessor.create(#{bool:any(java.lang.Boolean)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.EmitterProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().multicast().onBackpressureBuffer(reactor.util.concurrent.Queues.SMALL_BUFFER_SIZE, #{bool:any(java.lang.Boolean)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.EmitterProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.EmitterProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EmitterProcessorCreateIntToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `EmitterProcessor.create(int)` with `Sinks.many().multicast().onBackpressureBuffer(int)`";
        }

        public String getDescription() {
            return "As of 3.5 EmitterProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.EmitterProcessor.create(#{integer:any(java.lang.Integer)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.EmitterProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().multicast().onBackpressureBuffer(#{integer:any(java.lang.Integer)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.EmitterProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.EmitterProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EmitterProcessorCreateIntBooleanToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `EmitterProcessor.create(int, Boolean)` with `Sinks.many().multicast().onBackpressureBuffer(int, Boolean)`";
        }

        public String getDescription() {
            return "As of 3.5 EmitterProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.EmitterProcessor.create(#{integer:any(java.lang.Integer)}, #{bool:any(java.lang.Boolean)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.EmitterProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().multicast().onBackpressureBuffer(#{integer:any(java.lang.Integer)}, #{bool:any(java.lang.Boolean)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.EmitterProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.EmitterProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class UnicastProcessorCreateToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `UnicastProcessor.create()` with `Sinks.many().unicast().onBackpressureBuffer()`";
        }

        public String getDescription() {
            return "As of 3.5 UnicastProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.UnicastProcessor.create();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.UnicastProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().unicast().onBackpressureBuffer();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.UnicastProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.UnicastProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class UnicastProcessorCreateQueueToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `UnicastProcessor.create(Queue)` with `Sinks.many().unicast().onBackpressureBuffer(Queue)`";
        }

        public String getDescription() {
            return "As of 3.5 UnicastProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.UnicastProcessor.create(#{queue:any(java.util.Queue)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.UnicastProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().unicast().onBackpressureBuffer(#{queue:any(java.util.Queue)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Queue", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.UnicastProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.UnicastProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class UnicastProcessorCreateQueueDisposableToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `UnicastProcessor.create(Queue, Disposable)` with `Sinks.many().unicast().onBackpressureBuffer(Queue, Disposable)`";
        }

        public String getDescription() {
            return "As of 3.5 UnicastProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.UnicastProcessor.create(#{queue:any(java.util.Queue)}, #{disp:any(reactor.core.Disposable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.UnicastProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().unicast().onBackpressureBuffer(#{queue:any(java.util.Queue)}, #{disp:any(reactor.core.Disposable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Queue", Boolean.valueOf(true)), new UsesType("reactor.core.Disposable", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.UnicastProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.UnicastProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class UnicastProcessorCreateQueueConsumerDisposableToSinkRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `UnicastProcessor.create(Queue, Consumer, Disposable)` with `Sinks.many().unicast().onBackpressureBuffer(Queue, Disposable)`";
        }

        public String getDescription() {
            return "As of 3.5 UnicastProcessor is deprecated and Sinks are preferred";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate createBefore;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.createBefore == null) {
                        this.createBefore = JavaTemplate.builder((String)"reactor.core.publisher.UnicastProcessor.create(#{queue:any(java.util.Queue)}, #{cons:any(java.util.function.Consumer)}, #{disp:any(reactor.core.Disposable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactive-streams-1", "reactor-core-3"})).build();
                    }
                    if ((matcher = this.createBefore.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("reactor.core.publisher.UnicastProcessor");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"reactor.core.publisher.Sinks.many().unicast().onBackpressureBuffer(#{queue:any(java.util.Queue)}, #{disp:any(reactor.core.Disposable)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"reactor-core-3"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Queue", Boolean.valueOf(true)), new UsesType("java.util.function.Consumer", Boolean.valueOf(true)), new UsesType("reactor.core.Disposable", Boolean.valueOf(true)), new UsesType("reactor.core.publisher.UnicastProcessor", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.UnicastProcessor create(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

