/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class ArrayStoreExceptionToTypeNotPresentException
extends Recipe {
    private static final String ARRAY_STORE_EXCEPTION = "java.lang.ArrayStoreException";
    private static final String TYPE_NOT_PRESENT_EXCEPTION = "java.lang.TypeNotPresentException";

    public String getDisplayName() {
        return "Catch `TypeNotPresentException` thrown by `Class.getAnnotation()`";
    }

    public String getDescription() {
        return "Replace catch blocks for `ArrayStoreException` around `Class.getAnnotation()` with `TypeNotPresentException` to ensure compatibility with Java 11+.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String classGetAnnotationPattern = "java.lang.Class getAnnotation(java.lang.Class)";
        return Preconditions.check((TreeVisitor)new UsesMethod(classGetAnnotationPattern), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Try visitTry(J.Try tryStatement, ExecutionContext ctx) {
                J.Try try_ = super.visitTry(tryStatement, (Object)ctx);
                if (FindMethods.find((J)try_, (String)classGetAnnotationPattern).isEmpty()) {
                    return try_;
                }
                return try_.withCatches(ListUtils.map((List)try_.getCatches(), catch_ -> {
                    if (TypeUtils.isOfClassType((JavaType)catch_.getParameter().getType(), (String)ArrayStoreExceptionToTypeNotPresentException.ARRAY_STORE_EXCEPTION)) {
                        return (J.Try.Catch)new ChangeType(ArrayStoreExceptionToTypeNotPresentException.ARRAY_STORE_EXCEPTION, ArrayStoreExceptionToTypeNotPresentException.TYPE_NOT_PRESENT_EXCEPTION, Boolean.valueOf(true), null).getVisitor().visit((Tree)catch_, (Object)ctx);
                    }
                    return catch_;
                }));
            }
        });
    }
}

