/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import lombok.Setter;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.lombok.FieldAnnotator;
import org.openrewrite.java.migrate.lombok.LombokUtils;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class UseLombokSetter
extends Recipe {
    public String getDisplayName() {
        return "Convert setter methods to annotations";
    }

    public String getDescription() {
        return "Convert trivial setter methods to `@Setter` annotations on their respective fields.";
    }

    public Set<String> getTags() {
        return Collections.singleton("lombok");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                if (LombokUtils.isSetter(this.getCursor(), (AnnotationService)this.service(AnnotationService.class))) {
                    Expression assignmentVariable = ((J.Assignment)method.getBody().getStatements().get(0)).getVariable();
                    if (assignmentVariable instanceof J.FieldAccess && ((J.FieldAccess)assignmentVariable).getName().getFieldType() != null) {
                        this.doAfterVisit((TreeVisitor)new FieldAnnotator(Setter.class, (JavaType)((J.FieldAccess)assignmentVariable).getName().getFieldType(), LombokUtils.getAccessLevel(method)));
                        return null;
                    }
                    if (assignmentVariable instanceof J.Identifier && ((J.Identifier)assignmentVariable).getFieldType() != null) {
                        this.doAfterVisit((TreeVisitor)new FieldAnnotator(Setter.class, (JavaType)((J.Identifier)assignmentVariable).getFieldType(), LombokUtils.getAccessLevel(method)));
                        return null;
                    }
                }
                return method;
            }
        };
    }

    @Generated
    public UseLombokSetter() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseLombokSetter()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseLombokSetter)) {
            return false;
        }
        UseLombokSetter other = (UseLombokSetter)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UseLombokSetter;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

