/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.lang.var.DeclarationCheck;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class UseVarForGenericMethodInvocations
extends Recipe {
    public String getDisplayName() {
        return "Apply `var` to generic method invocations";
    }

    public String getDescription() {
        return "Apply `var` to variables initialized by invocations of generic methods. This recipe ignores generic factory methods without parameters, because open rewrite cannot handle them correctly ATM.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new UseVarForGenericsVisitor());
    }

    static final class UseVarForGenericsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        UseVarForGenericsVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
            boolean isMethodInvocation;
            vd = super.visitVariableDeclarations(vd, (Object)ctx);
            boolean isGeneralApplicable = DeclarationCheck.isVarApplicable(this.getCursor(), vd);
            if (!isGeneralApplicable) {
                return vd;
            }
            boolean isPrimitive = DeclarationCheck.isPrimitive(vd);
            boolean usesNoGenerics = !DeclarationCheck.useGenerics(vd);
            boolean usesTernary = DeclarationCheck.initializedByTernary(vd);
            if (isPrimitive || usesTernary || usesNoGenerics) {
                return vd;
            }
            Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
            boolean bl = isMethodInvocation = initializer != null && initializer.unwrap() instanceof J.MethodInvocation;
            if (!isMethodInvocation) {
                return vd;
            }
            boolean hasNoTypeParams = ((J.MethodInvocation)initializer).getTypeParameters() == null;
            boolean argumentsEmpty = UseVarForGenericsVisitor.allArgumentsEmpty((J.MethodInvocation)initializer);
            if (hasNoTypeParams && argumentsEmpty) {
                return vd;
            }
            if (vd.getType() instanceof JavaType.FullyQualified) {
                this.maybeRemoveImport((JavaType.FullyQualified)vd.getType());
            }
            return DeclarationCheck.transformToVar(vd);
        }

        private static boolean allArgumentsEmpty(J.MethodInvocation invocation) {
            for (Expression argument : invocation.getArguments()) {
                if (argument instanceof J.Empty) continue;
                return false;
            }
            return true;
        }
    }
}

