/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.migrate.lang.NullCheck;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public final class NullCheckAsSwitchCase
extends Recipe {
    public String getDisplayName() {
        return "Add null check to existing switch cases";
    }

    public String getDescription() {
        return "In later Java 21+, null checks are valid in switch cases. This recipe will only add null checks to existing switch cases if there are no other statements in between them or if the block in the if statement is not impacting the flow of the switch.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(3L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not((TreeVisitor)new KotlinFileChecker()), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitBlock(J.Block block, ExecutionContext ctx) {
                AtomicReference<@Nullable V> nullCheck = new AtomicReference();
                J.Block b = block.withStatements(ListUtils.map((List)block.getStatements(), (index, statement) -> {
                    Optional nullCheckOpt = NullCheck.Matcher.nullCheck().get((Tree)statement, this.getCursor());
                    if (nullCheckOpt.isPresent()) {
                        J nextStatement;
                        NullCheck check = (NullCheck)nullCheckOpt.get();
                        J j = nextStatement = index + 1 < block.getStatements().size() ? (J)block.getStatements().get(index + 1) : null;
                        if (!(nextStatement instanceof J.Switch) || this.hasNullCase((J.Switch)nextStatement) || !SemanticallyEqual.areEqual((J)((J.Switch)nextStatement).getSelector().getTree(), (J)check.getNullCheckedParameter()) || check.returns() || check.couldModifyNullCheckedValue()) {
                            return statement;
                        }
                        nullCheck.set(check);
                        return null;
                    }
                    NullCheck check = nullCheck.getAndSet(null);
                    if (check != null && statement instanceof J.Switch) {
                        J.Switch aSwitch = (J.Switch)statement;
                        J.Case nullCase = this.createNullCase(aSwitch, check.whenNull());
                        return aSwitch.withCases(aSwitch.getCases().withStatements(ListUtils.insert((List)aSwitch.getCases().getStatements(), (Object)nullCase, (int)0)));
                    }
                    return statement;
                }));
                return super.visitBlock(b, (Object)ctx);
            }

            private boolean hasNullCase(J.Switch switch_) {
                for (Statement c : switch_.getCases().getStatements()) {
                    if (!(c instanceof J.Case)) continue;
                    for (J j : ((J.Case)c).getCaseLabels()) {
                        if (!(j instanceof Expression) || !J.Literal.isLiteralValue((Expression)((Expression)j), null)) continue;
                        return true;
                    }
                }
                return false;
            }

            private J.Case createNullCase(J.Switch aSwitch, Statement whenNull) {
                Statement firstStatement;
                if (whenNull instanceof J.Block && ((J.Block)whenNull).getStatements().size() == 1 && ((firstStatement = (Statement)((J.Block)whenNull).getStatements().get(0)) instanceof Expression || firstStatement instanceof J.Throw)) {
                    whenNull = firstStatement;
                }
                String semicolon = whenNull instanceof J.Block ? "" : ";";
                J.Switch switchWithNullCase = (J.Switch)JavaTemplate.apply((String)("switch(#{any()}) { case null -> #{any()}" + semicolon + " }"), (Cursor)new Cursor(this.getCursor(), (Object)aSwitch), (JavaCoordinates)aSwitch.getCoordinates().replace(), (Object[])new Object[]{aSwitch.getSelector().getTree(), whenNull});
                J.Case nullCase = (J.Case)switchWithNullCase.getCases().getStatements().get(0);
                return nullCase.withBody(Objects.requireNonNull(nullCase.getBody()).withPrefix(Space.SINGLE_SPACE));
            }
        });
    }

    @Generated
    public NullCheckAsSwitchCase() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "NullCheckAsSwitchCase()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NullCheckAsSwitchCase)) {
            return false;
        }
        NullCheckAsSwitchCase other = (NullCheckAsSwitchCase)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof NullCheckAsSwitchCase;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

