/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.migrate.joda.JodaTimeRecipe;
import org.openrewrite.java.migrate.joda.ScopeAwareVisitor;
import org.openrewrite.java.migrate.joda.templates.AllTemplates;
import org.openrewrite.java.migrate.joda.templates.MethodTemplate;
import org.openrewrite.java.migrate.joda.templates.TimeClassMap;
import org.openrewrite.java.migrate.joda.templates.TimeClassNames;
import org.openrewrite.java.migrate.joda.templates.VarTemplates;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

class JodaTimeVisitor
extends ScopeAwareVisitor {
    private final boolean safeMigration;
    private final JodaTimeRecipe.Accumulator acc;

    public JodaTimeVisitor(JodaTimeRecipe.Accumulator acc, boolean safeMigration, LinkedList<ScopeAwareVisitor.VariablesInScope> scopes) {
        super(scopes);
        this.acc = acc;
        this.safeMigration = safeMigration;
    }

    protected JavadocVisitor<ExecutionContext> getJavadocVisitor() {
        return new JavadocVisitor<ExecutionContext>((JavaVisitor)this){

            public Javadoc visitReference(Javadoc.Reference reference, ExecutionContext ctx) {
                return reference;
            }
        };
    }

    @NonNull
    public J visitCompilationUnit(@NonNull J.CompilationUnit cu, @NonNull ExecutionContext ctx) {
        if (cu == null) {
            throw new NullPointerException("cu is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        J j = super.visitCompilationUnit(cu, (Object)ctx);
        if (j != cu) {
            this.maybeRemoveImport("org.joda.time.DateTime");
            this.maybeRemoveImport("org.joda.time.DateTimeZone");
            this.maybeRemoveImport("org.joda.time.format.DateTimeFormat");
            this.maybeRemoveImport("org.joda.time.Duration");
            this.maybeRemoveImport("org.joda.time.base.AbstractInstant");
            this.maybeRemoveImport("org.joda.time.Instant");
            this.maybeRemoveImport("org.joda.time.Interval");
            this.maybeRemoveImport("java.util.Locale");
            this.maybeAddImport("java.time.ZonedDateTime");
            this.maybeAddImport("java.time.ZoneOffset");
            this.maybeAddImport("java.time.ZoneId");
            this.maybeAddImport("java.time.Instant");
            this.maybeAddImport("java.time.format.DateTimeFormatter");
            this.maybeAddImport("java.time.format.FormatStyle");
            this.maybeAddImport("java.time.Duration");
            this.maybeAddImport("java.time.LocalDate");
            this.maybeAddImport("java.time.LocalTime");
            this.maybeAddImport("java.time.temporal.IsoFields");
            this.maybeAddImport("java.time.temporal.ChronoField");
            this.maybeAddImport("java.util.Date");
            this.maybeAddImport("org.threeten.extra.Interval");
        }
        return j;
    }

    @NonNull
    public J visitMethodDeclaration(@NonNull J.MethodDeclaration method, @NonNull ExecutionContext ctx) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        J.MethodDeclaration m = (J.MethodDeclaration)super.visitMethodDeclaration(method, (Object)ctx);
        if (m.getReturnTypeExpression() == null || !m.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return m;
        }
        if (this.safeMigration && !this.acc.getSafeMethodMap().getOrDefault(m.getMethodType(), false).booleanValue()) {
            return m;
        }
        JavaType.Class returnType = TimeClassMap.getJavaTimeType(((JavaType.Class)m.getType()).getFullyQualifiedName());
        J.Identifier returnExpr = (J.Identifier)TypeTree.build((String)returnType.getClassName()).withType((JavaType)returnType).withPrefix(Space.format((String)" "));
        return m.withReturnTypeExpression((TypeTree)returnExpr).withMethodType(m.getMethodType().withReturnType((JavaType)returnType));
    }

    @NonNull
    public J visitVariableDeclarations(@NonNull J.VariableDeclarations multiVariable, @NonNull ExecutionContext ctx) {
        if (multiVariable == null) {
            throw new NullPointerException("multiVariable is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (multiVariable.getTypeExpression() == null || !multiVariable.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return super.visitVariableDeclarations(multiVariable, (Object)ctx);
        }
        if (multiVariable.getVariables().stream().anyMatch(this.acc.getUnsafeVars()::contains)) {
            return multiVariable;
        }
        J.VariableDeclarations m = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, (Object)ctx);
        return VarTemplates.getTemplate(multiVariable).map(t -> t.apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), VarTemplates.getTemplateArgs(m))).orElse((J)multiVariable);
    }

    @NonNull
    public J visitVariable(@NonNull J.VariableDeclarations.NamedVariable variable, @NonNull ExecutionContext ctx) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (!variable.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return super.visitVariable(variable, (Object)ctx);
        }
        if (this.acc.getUnsafeVars().contains(variable) || !(variable.getType() instanceof JavaType.Class)) {
            return variable;
        }
        JavaType.Class jodaType = (JavaType.Class)variable.getType();
        return variable.withType((JavaType)TimeClassMap.getJavaTimeType(jodaType.getFullyQualifiedName())).withInitializer((Expression)this.visit((Tree)variable.getInitializer(), ctx));
    }

    @NonNull
    public J visitAssignment(@NonNull J.Assignment assignment, @NonNull ExecutionContext ctx) {
        if (assignment == null) {
            throw new NullPointerException("assignment is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        J.Assignment a = (J.Assignment)super.visitAssignment(assignment, (Object)ctx);
        if (!a.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return a;
        }
        if (!(a.getVariable() instanceof J.Identifier)) {
            return assignment;
        }
        J.Identifier varName = (J.Identifier)a.getVariable();
        Optional<J.VariableDeclarations.NamedVariable> mayBeVar = this.findVarInScope(varName.getSimpleName());
        if (!mayBeVar.isPresent() || this.acc.getUnsafeVars().contains(mayBeVar.get())) {
            return assignment;
        }
        return VarTemplates.getTemplate(assignment).map(t -> t.apply(this.updateCursor((Tree)a), a.getCoordinates().replace(), new Object[]{varName, a.getAssignment()})).orElse((J)assignment);
    }

    @NonNull
    public J visitNewClass(@NonNull J.NewClass newClass, @NonNull ExecutionContext ctx) {
        if (newClass == null) {
            throw new NullPointerException("newClass is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        MethodCall updated = (MethodCall)super.visitNewClass(newClass, (Object)ctx);
        if (this.hasJodaType(updated.getArguments())) {
            return newClass;
        }
        return this.migrateMethodCall((MethodCall)newClass, updated);
    }

    @NonNull
    public J visitMethodInvocation(@NonNull J.MethodInvocation method, @NonNull ExecutionContext ctx) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
        if (!method.getMethodType().getDeclaringType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN) && method.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return this.migrateNonJodaMethod(method, m);
        }
        if (this.hasJodaType(m.getArguments()) || this.isJodaVarRef(m.getSelect())) {
            return method;
        }
        return this.migrateMethodCall((MethodCall)method, (MethodCall)m);
    }

    @NonNull
    public J visitFieldAccess(@NonNull J.FieldAccess fieldAccess, @NonNull ExecutionContext ctx) {
        if (fieldAccess == null) {
            throw new NullPointerException("fieldAccess is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        J.FieldAccess f = (J.FieldAccess)super.visitFieldAccess(fieldAccess, (Object)ctx);
        if (TypeUtils.isOfClassType((JavaType)f.getType(), (String)"org.joda.time.DateTimeZone") && f.getSimpleName().equals("UTC")) {
            return JavaTemplate.builder((String)"ZoneOffset.UTC").imports(new String[]{"java.time.ZoneOffset"}).build().apply(this.updateCursor((Tree)f), f.getCoordinates().replace(), new Object[0]);
        }
        return f;
    }

    @NonNull
    public J visitIdentifier(@NonNull J.Identifier ident, @NonNull ExecutionContext ctx) {
        Optional<J.VariableDeclarations.NamedVariable> mayBeVar;
        if (ident == null) {
            throw new NullPointerException("ident is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (!this.isJodaVarRef((Expression)ident)) {
            return super.visitIdentifier(ident, (Object)ctx);
        }
        if (this.safeMigration && (!(mayBeVar = this.findVarInScope(ident.getSimpleName())).isPresent() || this.acc.getUnsafeVars().contains(mayBeVar.get()))) {
            return ident;
        }
        JavaType.Class jodaType = (JavaType.Class)ident.getType();
        JavaType.Class fqType = TimeClassMap.getJavaTimeType(jodaType.getFullyQualifiedName());
        if (fqType == null) {
            return ident;
        }
        return ident.withType((JavaType)fqType).withFieldType(ident.getFieldType().withType((JavaType)fqType));
    }

    private J migrateMethodCall(MethodCall original, MethodCall updated) {
        if (original.getMethodType() == null || !original.getMethodType().getDeclaringType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return updated;
        }
        MethodTemplate template = AllTemplates.getTemplate(original);
        if (template == null) {
            return original;
        }
        Optional<J> maybeUpdated = this.applyTemplate(original, updated, template);
        if (!maybeUpdated.isPresent()) {
            return original;
        }
        Expression updatedExpr = (Expression)maybeUpdated.get();
        if (!this.safeMigration || !this.isArgument((J)original)) {
            return updatedExpr;
        }
        MethodCall parentMethod = (MethodCall)this.getCursor().getParentTreeCursor().getValue();
        if (parentMethod.getMethodType().getDeclaringType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return updatedExpr;
        }
        int argPos = parentMethod.getArguments().indexOf(original);
        JavaType paramType = (JavaType)parentMethod.getMethodType().getParameterTypes().get(argPos);
        if (TypeUtils.isAssignableTo((JavaType)paramType, (JavaType)updatedExpr.getType())) {
            return updatedExpr;
        }
        String paramName = (String)parentMethod.getMethodType().getParameterNames().get(argPos);
        J.VariableDeclarations.NamedVariable var = this.acc.getVarTable().getVarByName((JavaType)parentMethod.getMethodType(), paramName);
        if (var != null && !this.acc.getUnsafeVars().contains(var)) {
            return updatedExpr;
        }
        return original;
    }

    private J.MethodInvocation migrateNonJodaMethod(J.MethodInvocation original, J.MethodInvocation updated) {
        if (this.safeMigration && !this.acc.getSafeMethodMap().getOrDefault(updated.getMethodType(), false).booleanValue()) {
            return original;
        }
        JavaType.Class returnType = (JavaType.Class)updated.getMethodType().getReturnType();
        JavaType.Class updatedReturnType = TimeClassMap.getJavaTimeType(returnType.getFullyQualifiedName());
        if (updatedReturnType == null) {
            return original;
        }
        return updated.withMethodType(updated.getMethodType().withReturnType((JavaType)updatedReturnType)).withName(updated.getName().withType((JavaType)updatedReturnType));
    }

    private boolean hasJodaType(List<Expression> exprs) {
        for (Expression expr : exprs) {
            JavaType exprType = expr.getType();
            if (exprType == null || !exprType.isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) continue;
            return true;
        }
        return false;
    }

    private Optional<J> applyTemplate(MethodCall original, MethodCall updated, MethodTemplate template) {
        if (template.getMatcher().matches(original)) {
            Expression[] args = template.getTemplateArgsFunc().apply(updated);
            if (args.length == 0) {
                return Optional.of(template.getTemplate().apply(this.updateCursor((Tree)updated), updated.getCoordinates().replace(), new Object[0]));
            }
            return Optional.of(template.getTemplate().apply(this.updateCursor((Tree)updated), updated.getCoordinates().replace(), (Object[])args));
        }
        return Optional.empty();
    }

    private boolean isJodaVarRef(@Nullable Expression expr) {
        if (expr == null || expr.getType() == null || !expr.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return false;
        }
        if (expr instanceof J.FieldAccess) {
            return ((J.FieldAccess)expr).getName().getFieldType() != null;
        }
        if (expr instanceof J.Identifier) {
            return ((J.Identifier)expr).getFieldType() != null;
        }
        if (expr instanceof MethodCall) {
            return expr.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN);
        }
        return false;
    }

    private boolean isArgument(J expr) {
        if (!(this.getCursor().getParentTreeCursor().getValue() instanceof MethodCall)) {
            return false;
        }
        MethodCall methodCall = (MethodCall)this.getCursor().getParentTreeCursor().getValue();
        return methodCall.getArguments().contains(expr);
    }
}

