/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok.log;

import java.util.Comparator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeFieldName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

class LogVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private final String logType;
    private final String factoryType;
    private final MethodMatcher factoryMethodMatcher;
    private final String logAnnotation;
    private final @Nullable String fieldName;

    LogVisitor(String logType, String factoryMethodPattern, String logAnnotation, @Nullable String fieldName) {
        this.logType = logType;
        this.factoryType = factoryMethodPattern.substring(0, factoryMethodPattern.indexOf(32));
        this.factoryMethodMatcher = new MethodMatcher(factoryMethodPattern);
        this.logAnnotation = logAnnotation;
        this.fieldName = fieldName;
    }

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
        J.ClassDeclaration visitClassDeclaration = super.visitClassDeclaration(classDecl, (Object)ctx);
        if (visitClassDeclaration != classDecl) {
            this.maybeRemoveImport(this.logType);
            this.maybeRemoveImport(this.factoryType);
            this.maybeAddImport(this.logAnnotation);
            return (J.ClassDeclaration)JavaTemplate.builder((String)("@" + this.logAnnotation.substring(this.logAnnotation.lastIndexOf(46) + 1) + "\n")).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"lombok"})).imports(new String[]{this.logAnnotation}).build().apply(this.updateCursor((Tree)visitClassDeclaration), visitClassDeclaration.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
        }
        return classDecl;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
        if (!(multiVariable.hasModifier(J.Modifier.Type.Private) && multiVariable.hasModifier(J.Modifier.Type.Static) && multiVariable.hasModifier(J.Modifier.Type.Final) && multiVariable.getVariables().size() == 1 && TypeUtils.isAssignableTo((String)this.logType, (JavaType)multiVariable.getType()))) {
            return multiVariable;
        }
        J.VariableDeclarations.NamedVariable var = (J.VariableDeclarations.NamedVariable)multiVariable.getVariables().get(0);
        if (this.fieldName != null && !this.fieldName.equals(var.getSimpleName())) {
            return multiVariable;
        }
        if (!this.factoryMethodMatcher.matches(var.getInitializer())) {
            return multiVariable;
        }
        J.ClassDeclaration classDeclaration = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
        if (classDeclaration == null || classDeclaration.getType() == null) {
            return multiVariable;
        }
        J.MethodInvocation methodCall = (J.MethodInvocation)var.getInitializer();
        if (methodCall.getArguments().size() != 1 || !this.getFactoryParameter(classDeclaration.getSimpleName()).equals(((Expression)methodCall.getArguments().get(0)).toString())) {
            return multiVariable;
        }
        if (!"log".equals(var.getSimpleName())) {
            this.doAfterVisit((TreeVisitor)new ChangeFieldName(classDeclaration.getType().getFullyQualifiedName(), var.getSimpleName(), "log"));
        }
        return null;
    }

    protected String getFactoryParameter(String className) {
        return className + ".class";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogVisitor)) {
            return false;
        }
        LogVisitor other = (LogVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$logType = this.logType;
        String other$logType = other.logType;
        if (this$logType == null ? other$logType != null : !this$logType.equals(other$logType)) {
            return false;
        }
        String this$factoryType = this.factoryType;
        String other$factoryType = other.factoryType;
        if (this$factoryType == null ? other$factoryType != null : !this$factoryType.equals(other$factoryType)) {
            return false;
        }
        MethodMatcher this$factoryMethodMatcher = this.factoryMethodMatcher;
        MethodMatcher other$factoryMethodMatcher = other.factoryMethodMatcher;
        if (this$factoryMethodMatcher == null ? other$factoryMethodMatcher != null : !this$factoryMethodMatcher.equals(other$factoryMethodMatcher)) {
            return false;
        }
        String this$logAnnotation = this.logAnnotation;
        String other$logAnnotation = other.logAnnotation;
        if (this$logAnnotation == null ? other$logAnnotation != null : !this$logAnnotation.equals(other$logAnnotation)) {
            return false;
        }
        String this$fieldName = this.fieldName;
        String other$fieldName = other.fieldName;
        return !(this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof LogVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $logType = this.logType;
        result = result * 59 + ($logType == null ? 43 : $logType.hashCode());
        String $factoryType = this.factoryType;
        result = result * 59 + ($factoryType == null ? 43 : $factoryType.hashCode());
        MethodMatcher $factoryMethodMatcher = this.factoryMethodMatcher;
        result = result * 59 + ($factoryMethodMatcher == null ? 43 : $factoryMethodMatcher.hashCode());
        String $logAnnotation = this.logAnnotation;
        result = result * 59 + ($logAnnotation == null ? 43 : $logAnnotation.hashCode());
        String $fieldName = this.fieldName;
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        return result;
    }
}

