/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.jakarta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class RemoveMethods
extends Recipe {
    @Option(displayName="Method Pattern", description="A method pattern for matching required method definition.", example="*..* hello(..)")
    @NonNull
    String methodPattern;

    @NotNull
    public String getDisplayName() {
        return "Remove methods calls";
    }

    @NotNull
    public String getDescription() {
        return "Checks for a method patterns and removes the method call from the class";
    }

    @JsonCreator
    public RemoveMethods(@NonNull @JsonProperty(value="methodPattern") String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @NotNull
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MethodInvocationVisitor();
    }

    private class MethodInvocationVisitor
    extends JavaVisitor<ExecutionContext> {
        private final MethodMatcher METHOD_PATTERN;

        private MethodInvocationVisitor() {
            this.METHOD_PATTERN = new MethodMatcher(RemoveMethods.this.methodPattern, false);
        }

        @Nullable
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ec) {
            return this.visitMethodCall(method);
        }

        @Nullable
        private <M extends MethodCall> M visitMethodCall(M methodCall) {
            if (!this.METHOD_PATTERN.matches(methodCall)) {
                return methodCall;
            }
            J.Block parentBlock = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
            if (parentBlock != null && !parentBlock.getStatements().contains(methodCall)) {
                return methodCall;
            }
            return null;
        }
    }
}

