/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.time.Duration;
import java.util.List;
import java.util.StringJoiner;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class UseEnumSetOf
extends Recipe {
    private static final MethodMatcher SET_OF = new MethodMatcher("java.util.Set of(..)", true);

    public String getDisplayName() {
        return "Prefer `EnumSet of(..)`";
    }

    public String getDescription() {
        return "Prefer `EnumSet of(..)` instead of using `Set of(..)` when the arguments are enums in Java 5 or higher.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(SET_OF)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                Cursor parent;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (SET_OF.matches((MethodCall)method) && method.getType() instanceof JavaType.Parameterized && !TypeUtils.isOfClassType((JavaType)method.getType(), (String)"java.util.EnumSet") && !((parent = this.getCursor().dropParentUntil(is -> is instanceof J.Assignment || is instanceof J.VariableDeclarations || is instanceof J.Block)).getValue() instanceof J.Block)) {
                    JavaType type;
                    JavaType javaType = type = parent.getValue() instanceof J.Assignment ? ((J.Assignment)parent.getValue()).getType() : ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)parent.getValue()).getVariables().get(0)).getType();
                    if (this.isAssignmentSetOfEnum(type)) {
                        this.maybeAddImport("java.util.EnumSet");
                        StringJoiner setOf = new StringJoiner(", ", "EnumSet.of(", ")");
                        List args = m.getArguments();
                        args.forEach(o -> setOf.add("#{any()}"));
                        return (J.MethodInvocation)JavaTemplate.builder((String)"EnumSet.of(#{any()})").contextSensitive().imports(new String[]{"java.util.EnumSet"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), args.toArray());
                    }
                }
                return m;
            }

            private boolean isAssignmentSetOfEnum(@Nullable JavaType type) {
                JavaType.Parameterized parameterized;
                if (type instanceof JavaType.Parameterized && TypeUtils.isOfClassType((JavaType)(parameterized = (JavaType.Parameterized)type).getType(), (String)"java.util.Set")) {
                    return ((JavaType.Parameterized)type).getTypeParameters().stream().filter(JavaType.Class.class::isInstance).map(JavaType.Class.class::cast).anyMatch(o -> o.getKind() == JavaType.FullyQualified.Kind.Enum);
                }
                return false;
            }
        });
    }
}

