/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Repeat;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.logging.AddLogger;
import org.openrewrite.java.logging.LoggingFramework;
import org.openrewrite.java.search.FindFieldsOfType;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class PrintStackTraceToLogError
extends Recipe {
    @Option(displayName="Add logger", description="Add a logger field to the class if it isn't already present.", required=false)
    @Nullable
    private final Boolean addLogger;
    @Option(displayName="Logger name", description="The name of the logger to use when generating a field.", required=false)
    @Nullable
    private final String loggerName;
    @Option(displayName="Logging framework", description="The logging framework to use.", valid={"SLF4J", "Log4J1", "Log4J2", "JUL", "COMMONS"}, required=false)
    @Nullable
    private final String loggingFramework;

    public String getDisplayName() {
        return "Use logger instead of `printStackTrace()`";
    }

    public String getDescription() {
        return "When a logger is present, log exceptions rather than calling `printStackTrace()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher printStackTrace = new MethodMatcher("java.lang.Throwable printStackTrace(..)");
        final LoggingFramework framework = LoggingFramework.fromOption(this.loggingFramework);
        final AnnotationMatcher lombokLogAnnotationMatcher = new AnnotationMatcher("@lombok.extern..*");
        JavaIsoVisitor<ExecutionContext> visitor = new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (printStackTrace.matches((MethodCall)m)) {
                    Cursor classCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
                    AnnotationService annotationService = (AnnotationService)this.service(AnnotationService.class);
                    Set loggers = FindFieldsOfType.find((J)((J)classCursor.getValue()), (String)framework.getLoggerType());
                    if (!loggers.isEmpty()) {
                        J.Identifier logField = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)loggers.iterator().next()).getVariables().get(0)).getName();
                        m = this.replaceMethodInvocation(m, logField);
                    } else if (annotationService.matches(classCursor, lombokLogAnnotationMatcher)) {
                        String fieldName = PrintStackTraceToLogError.this.loggerName == null ? "log" : PrintStackTraceToLogError.this.loggerName;
                        J.Identifier logField = new J.Identifier(UUID.randomUUID(), Space.SINGLE_SPACE, Markers.EMPTY, Collections.emptyList(), fieldName, null, null);
                        m = this.replaceMethodInvocation(m, logField);
                    } else if (PrintStackTraceToLogError.this.addLogger != null && PrintStackTraceToLogError.this.addLogger.booleanValue()) {
                        this.doAfterVisit(AddLogger.addLogger((J.ClassDeclaration)classCursor.getValue(), framework, PrintStackTraceToLogError.this.loggerName == null ? "logger" : PrintStackTraceToLogError.this.loggerName));
                    }
                }
                return m;
            }

            private J.MethodInvocation replaceMethodInvocation(J.MethodInvocation m, J.Identifier logField) {
                if (framework == LoggingFramework.JUL) {
                    this.maybeAddImport("java.util.logging.Level");
                }
                return (J.MethodInvocation)framework.getErrorTemplate("\"Exception\"").apply(new Cursor(this.getCursor().getParent(), (Object)m), m.getCoordinates().replace(), new Object[]{logField, m.getSelect()});
            }
        };
        return Repeat.repeatUntilStable((TreeVisitor)(this.addLogger != null && this.addLogger != false ? visitor : Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(framework.getLoggerType(), null), new UsesType("lombok.extern..*", null)}), (TreeVisitor)visitor)));
    }

    @ConstructorProperties(value={"addLogger", "loggerName", "loggingFramework"})
    public PrintStackTraceToLogError(@Nullable Boolean addLogger, @Nullable String loggerName, @Nullable String loggingFramework) {
        this.addLogger = addLogger;
        this.loggerName = loggerName;
        this.loggingFramework = loggingFramework;
    }

    @Nullable
    public Boolean getAddLogger() {
        return this.addLogger;
    }

    @Nullable
    public String getLoggerName() {
        return this.loggerName;
    }

    @Nullable
    public String getLoggingFramework() {
        return this.loggingFramework;
    }

    @NonNull
    public String toString() {
        return "PrintStackTraceToLogError(addLogger=" + this.getAddLogger() + ", loggerName=" + this.getLoggerName() + ", loggingFramework=" + this.getLoggingFramework() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrintStackTraceToLogError)) {
            return false;
        }
        PrintStackTraceToLogError other = (PrintStackTraceToLogError)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addLogger = this.getAddLogger();
        Boolean other$addLogger = other.getAddLogger();
        if (this$addLogger == null ? other$addLogger != null : !((Object)this$addLogger).equals(other$addLogger)) {
            return false;
        }
        String this$loggerName = this.getLoggerName();
        String other$loggerName = other.getLoggerName();
        if (this$loggerName == null ? other$loggerName != null : !this$loggerName.equals(other$loggerName)) {
            return false;
        }
        String this$loggingFramework = this.getLoggingFramework();
        String other$loggingFramework = other.getLoggingFramework();
        return !(this$loggingFramework == null ? other$loggingFramework != null : !this$loggingFramework.equals(other$loggingFramework));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PrintStackTraceToLogError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addLogger = this.getAddLogger();
        result = result * 59 + ($addLogger == null ? 43 : ((Object)$addLogger).hashCode());
        String $loggerName = this.getLoggerName();
        result = result * 59 + ($loggerName == null ? 43 : $loggerName.hashCode());
        String $loggingFramework = this.getLoggingFramework();
        result = result * 59 + ($loggingFramework == null ? 43 : $loggingFramework.hashCode());
        return result;
    }
}

