/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class JulParameterizedArguments
extends Recipe {
    private static final MethodMatcher METHOD_MATCHER_PARAM = new MethodMatcher("java.util.logging.Logger log(java.util.logging.Level, java.lang.String, java.lang.Object)");
    private static final MethodMatcher METHOD_MATCHER_ARRAY = new MethodMatcher("java.util.logging.Logger log(java.util.logging.Level, java.lang.String, java.lang.Object[])");

    public String getDisplayName() {
        return "Replace parameterized JUL level call with corresponding SLF4J method calls";
    }

    public String getDescription() {
        return "Replace calls to parameterized `Logger.log(Level,String,\u2026)` call with the corresponding slf4j method calls transforming the formatter and parameter lists.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(METHOD_MATCHER_PARAM), new UsesMethod(METHOD_MATCHER_ARRAY)}), (TreeVisitor)new JulParameterizedToSlf4jVisitor());
    }

    private static class JulParameterizedToSlf4jVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private JulParameterizedToSlf4jVisitor() {
        }

        public static boolean isStringLiteral(Expression expression) {
            return expression instanceof J.Literal && TypeUtils.isString((JavaType)((J.Literal)expression).getType());
        }

        @Nullable
        private static String getMethodIdentifier(Expression levelArgument) {
            String levelSimpleName;
            switch (levelSimpleName = levelArgument instanceof J.FieldAccess ? ((J.FieldAccess)levelArgument).getName().getSimpleName() : ((J.Identifier)levelArgument).getSimpleName()) {
                case "ALL": 
                case "FINEST": 
                case "FINER": {
                    return "trace";
                }
                case "FINE": {
                    return "debug";
                }
                case "CONFIG": 
                case "INFO": {
                    return "info";
                }
                case "WARNING": {
                    return "warn";
                }
                case "SEVERE": {
                    return "error";
                }
            }
            return null;
        }

        private static J.Literal buildStringLiteral(String string) {
            return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)string, String.format("\"%s\"", string), null, JavaType.Primitive.String);
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (METHOD_MATCHER_ARRAY.matches((MethodCall)method) || METHOD_MATCHER_PARAM.matches((MethodCall)method)) {
                List originalArguments = method.getArguments();
                Expression levelArgument = (Expression)originalArguments.get(0);
                Expression messageArgument = (Expression)originalArguments.get(1);
                if (!(levelArgument instanceof J.FieldAccess) && !(levelArgument instanceof J.Identifier) || !JulParameterizedToSlf4jVisitor.isStringLiteral(messageArgument)) {
                    return method;
                }
                String newName = JulParameterizedToSlf4jVisitor.getMethodIdentifier(levelArgument);
                if (newName == null) {
                    return method;
                }
                this.maybeRemoveImport("java.util.logging.Level");
                String originalFormatString = Objects.requireNonNull((String)((J.Literal)messageArgument).getValue());
                List<Integer> originalIndices = this.originalLoggedArgumentIndices(originalFormatString);
                List<Expression> originalParameters = JulParameterizedToSlf4jVisitor.originalParameters((Expression)originalArguments.get(2));
                ArrayList<Expression> targetArguments = new ArrayList<Expression>(2);
                targetArguments.add((Expression)JulParameterizedToSlf4jVisitor.buildStringLiteral(originalFormatString.replaceAll("\\{\\d*}", "{}")));
                originalIndices.forEach(i -> targetArguments.add((Expression)originalParameters.get((int)i)));
                return (J.MethodInvocation)JavaTemplate.builder((String)JulParameterizedToSlf4jVisitor.createTemplateString(newName, targetArguments)).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2.1"})).build().apply(this.getCursor(), method.getCoordinates().replaceMethod(), targetArguments.toArray());
            }
            return super.visitMethodInvocation(method, (Object)ctx);
        }

        private List<Integer> originalLoggedArgumentIndices(String strFormat) {
            Matcher matcher = Pattern.compile("\\{(\\d+)}").matcher(strFormat);
            ArrayList<Integer> loggedArgumentIndices = new ArrayList<Integer>(2);
            while (matcher.find()) {
                loggedArgumentIndices.add(Integer.valueOf(matcher.group(1)));
            }
            return loggedArgumentIndices;
        }

        private static List<Expression> originalParameters(Expression logParameters) {
            if (logParameters instanceof J.NewArray) {
                List initializer = ((J.NewArray)logParameters).getInitializer();
                if (initializer == null || initializer.isEmpty()) {
                    return Collections.emptyList();
                }
                return initializer;
            }
            return Collections.singletonList(logParameters);
        }

        private static String createTemplateString(String newName, List<Expression> targetArguments) {
            ArrayList targetArgumentsStrings = new ArrayList();
            targetArguments.forEach(targetArgument -> targetArgumentsStrings.add("#{any()}"));
            return newName + '(' + String.join((CharSequence)",", targetArgumentsStrings) + ')';
        }
    }
}

