/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.log4j;

import java.time.Duration;
import org.kohsuke.randname.RandomNameGenerator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class PrependRandomName
extends Recipe {
    private static final MethodMatcher logStatement = new MethodMatcher("org.apache.log4j.Category *(Object, ..)");
    private final RandomNameGenerator randomName;

    public PrependRandomName() {
        this.randomName = new RandomNameGenerator();
    }

    PrependRandomName(int seed) {
        this.randomName = new RandomNameGenerator(seed);
    }

    public String getDisplayName() {
        return "Prepend a random name to each Log4J statement";
    }

    public String getDescription() {
        return "To make finding the callsite of a logging statement easier in code search.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(logStatement), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                Object parent = this.getCursor().dropParentUntil(J.class::isInstance).getValue();
                if (parent instanceof J.MethodInvocation && logStatement.matches((MethodCall)((J.MethodInvocation)parent)) && JavaType.Primitive.String.equals((Object)literal.getType()) && !literal.getValue().toString().startsWith("<")) {
                    String value = "<" + PrependRandomName.this.randomName.next() + "> " + literal.getValue().toString();
                    return literal.withValue((Object)value).withValueSource("\"" + value + "\"");
                }
                return super.visitLiteral(literal, (Object)ctx);
            }
        });
    }
}

