/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;

public enum LoggingFramework {
    SLF4J("org.slf4j.Logger", "org.slf4j.LoggerFactory"),
    Log4J1("org.apache.log4j.Logger", "org.apache.log4j.LogManager"),
    Log4J2("org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager"),
    JUL("java.util.logging.Logger", "java.util.logging.LogManager");

    private final String loggerType;
    private final String factoryType;

    private LoggingFramework(String loggerType, String factoryType) {
        this.loggerType = loggerType;
        this.factoryType = factoryType;
    }

    public String getLoggerType() {
        return this.loggerType;
    }

    public String getFactoryType() {
        return this.factoryType;
    }

    public static LoggingFramework fromOption(@Nullable String option) {
        if (option != null) {
            for (LoggingFramework value : LoggingFramework.values()) {
                if (!value.toString().equalsIgnoreCase(option)) continue;
                return value;
            }
        }
        return SLF4J;
    }

    public <P> JavaTemplate getErrorTemplate(JavaVisitor<P> visitor, String message) {
        switch (this) {
            case SLF4J: {
                return JavaTemplate.builder((String)("#{any(org.slf4j.Logger)}.error(" + message + ", #{any(java.lang.Throwable)})")).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"slf4j-api"})).build();
            }
            case Log4J1: {
                return JavaTemplate.builder((String)("#{any(org.apache.log4j.Category)}.error(" + message + ", #{any(java.lang.Throwable)})")).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"log4j"})).build();
            }
            case Log4J2: {
                return JavaTemplate.builder((String)("#{any(org.apache.logging.log4j.Logger)}.error(" + message + ", #{any(java.lang.Throwable)})")).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"log4j-api"})).build();
            }
        }
        return JavaTemplate.builder((String)("#{any(java.util.logging.Logger)}.log(Level.SEVERE, " + message + ", #{any(java.lang.Throwable)})")).contextSensitive().imports(new String[]{"java.util.logging.Level"}).build();
    }
}

