/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.dependencies.table.GradleDependencyConfigurationErrors;
import org.openrewrite.java.dependencies.table.RepositoryAccessibilityReport;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryMirror;
import org.openrewrite.maven.tree.MavenResolutionResult;

public final class DependencyResolutionDiagnostic
extends ScanningRecipe<Accumulator> {
    private final transient RepositoryAccessibilityReport report = new RepositoryAccessibilityReport((Recipe)this);
    private final transient GradleDependencyConfigurationErrors gradleErrors = new GradleDependencyConfigurationErrors((Recipe)this);

    public String getDisplayName() {
        return "Dependency resolution diagnostic";
    }

    public String getDescription() {
        return "Recipes which manipulate dependencies must be able to successfully access the artifact repositories and resolve dependencies from them. This recipe produces two data tables used to understand the state of dependency resolution. \n\nThe Repository accessibility report lists all the artifact repositories known to the project and whether respond to network access. The network access is attempted while the recipe is run and so is representative of current conditions. \n\nThe Gradle dependency configuration errors lists all the dependency configurations that failed to resolve one or more dependencies when the project was parsed. This is representative of conditions at the time the LST was parsed.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                tree.getMarkers().findFirst(GradleProject.class).ifPresent(gp -> {
                    acc2.foundGradle = true;
                    acc2.repositoriesFromGradle.addAll(gp.getMavenRepositories());
                    acc2.repositoriesFromGradle.addAll(gp.getMavenPluginRepositories());
                });
                tree.getMarkers().findFirst(MavenResolutionResult.class).ifPresent(mrr -> {
                    acc2.foundMaven = true;
                    acc2.repositoriesFromMaven.addAll(mrr.getPom().getRepositories());
                });
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        HashSet<String> seen = new HashSet<String>();
        if (acc.foundMaven) {
            this.record(true, acc.repositoriesFromMaven, seen, ctx);
        }
        if (acc.foundGradle) {
            this.record(false, acc.repositoriesFromGradle, seen, ctx);
        }
        return Collections.emptyList();
    }

    private void record(boolean addMavenDefaultRepositories, Collection<MavenRepository> repos, Set<String> seen, ExecutionContext ctx) {
        MavenPomDownloader mpd = new MavenPomDownloader(ctx);
        Collection<MavenRepository> effectiveRepos = repos;
        if (addMavenDefaultRepositories) {
            if (!effectiveRepos.contains(MavenRepository.MAVEN_LOCAL_DEFAULT)) {
                effectiveRepos = new ArrayList<MavenRepository>(effectiveRepos);
                effectiveRepos.add(MavenRepository.MAVEN_LOCAL_DEFAULT);
            }
            if (!effectiveRepos.contains(MavenRepository.MAVEN_CENTRAL)) {
                effectiveRepos = new ArrayList<MavenRepository>(effectiveRepos);
                effectiveRepos.add(MavenRepository.MAVEN_CENTRAL);
            }
        }
        for (MavenRepository repo : effectiveRepos) {
            if (seen.contains(DependencyResolutionDiagnostic.noTrailingSlash(repo.getUri()))) continue;
            AtomicReference nullReason = new AtomicReference();
            MavenRepository normalized = mpd.normalizeRepository(repo, null, nullReason::set);
            if (normalized == null) {
                MavenExecutionContextView mctx;
                MavenSettings settings;
                Throwable reason = (Throwable)nullReason.get();
                if (reason == null) {
                    reason = new RuntimeException("Repository unreachable for unknown reason");
                }
                if ((settings = (mctx = new MavenExecutionContextView(ctx)).getSettings()) != null) {
                    repo = MavenRepositoryMirror.apply((Collection)mctx.getMirrors(settings), (MavenRepository)repo);
                }
                if (!seen.add(DependencyResolutionDiagnostic.noTrailingSlash(repo.getUri()))) continue;
                this.report.insertRow(ctx, DependencyResolutionDiagnostic.rowFor(repo, reason));
                continue;
            }
            if (!seen.add(DependencyResolutionDiagnostic.noTrailingSlash(normalized.getUri()))) continue;
            this.report.insertRow(ctx, DependencyResolutionDiagnostic.rowFor(normalized, null));
        }
    }

    private static String noTrailingSlash(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    private static RepositoryAccessibilityReport.Row rowFor(MavenRepository repo, @Nullable Throwable t) {
        Integer httpResponseCode = null;
        String exceptionClass = "";
        String exceptionMessage = "";
        if (t instanceof MavenPomDownloader.HttpSenderResponseException) {
            httpResponseCode = ((MavenPomDownloader.HttpSenderResponseException)t).getResponseCode();
            t = t.getCause();
        }
        if (t instanceof UncheckedIOException) {
            t = t.getCause();
        }
        if (t == null) {
            httpResponseCode = 200;
        } else {
            exceptionClass = t.getClass().getName();
            exceptionMessage = t.getMessage();
        }
        return new RepositoryAccessibilityReport.Row(DependencyResolutionDiagnostic.noTrailingSlash(repo.getUri()), exceptionClass, exceptionMessage, httpResponseCode);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        return new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
                if (!maybeGp.isPresent()) {
                    return cu;
                }
                GradleProject gp = (GradleProject)maybeGp.get();
                G.CompilationUnit g = super.visitCompilationUnit(cu, (Object)ctx);
                for (GradleDependencyConfiguration conf : gp.getConfigurations()) {
                    if (conf.getExceptionType() == null) continue;
                    DependencyResolutionDiagnostic.this.gradleErrors.insertRow(ctx, new GradleDependencyConfigurationErrors.Row(gp.getPath(), conf.getName(), conf.getExceptionType(), conf.getMessage()));
                }
                return g;
            }
        };
    }

    public RepositoryAccessibilityReport getReport() {
        return this.report;
    }

    public GradleDependencyConfigurationErrors getGradleErrors() {
        return this.gradleErrors;
    }

    @NonNull
    public String toString() {
        return "DependencyResolutionDiagnostic(report=" + (Object)((Object)this.getReport()) + ", gradleErrors=" + (Object)((Object)this.getGradleErrors()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyResolutionDiagnostic)) {
            return false;
        }
        DependencyResolutionDiagnostic other = (DependencyResolutionDiagnostic)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DependencyResolutionDiagnostic;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class Accumulator {
        boolean foundGradle;
        Set<MavenRepository> repositoriesFromGradle = new HashSet<MavenRepository>();
        boolean foundMaven;
        Set<MavenRepository> repositoriesFromMaven = new HashSet<MavenRepository>();
    }
}

