/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cucumber.jvm;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class DropSummaryPrinter
extends Recipe {
    private static final String IO_CUCUMBER_PLUGIN_SUMMARY_PRINTER = "io.cucumber.plugin.SummaryPrinter";
    private static final String IO_CUCUMBER_PLUGIN_PLUGIN = "io.cucumber.plugin.Plugin";

    public String getDisplayName() {
        return "Drop `SummaryPrinter`";
    }

    public String getDescription() {
        return "Replace `SummaryPrinter` with `Plugin`, if not already present.";
    }

    public @Nullable Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(IO_CUCUMBER_PLUGIN_SUMMARY_PRINTER, null), (TreeVisitor)new DropSummaryPrinterVisitor());
    }

    static final class DropSummaryPrinterVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        DropSummaryPrinterVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext ctx) {
            J.ClassDeclaration classDeclaration = super.visitClassDeclaration(cd, (Object)ctx);
            boolean implementsSummaryPrinter = Stream.of(classDeclaration.getImplements()).filter(Objects::nonNull).flatMap(Collection::stream).anyMatch(t -> TypeUtils.isOfClassType((JavaType)t.getType(), (String)DropSummaryPrinter.IO_CUCUMBER_PLUGIN_SUMMARY_PRINTER));
            boolean alreadyImplementsPlugin = Stream.of(classDeclaration.getImplements()).filter(Objects::nonNull).flatMap(Collection::stream).anyMatch(t -> TypeUtils.isOfClassType((JavaType)t.getType(), (String)DropSummaryPrinter.IO_CUCUMBER_PLUGIN_PLUGIN));
            if (!implementsSummaryPrinter) {
                return classDeclaration;
            }
            this.doAfterVisit(new ChangeType(DropSummaryPrinter.IO_CUCUMBER_PLUGIN_SUMMARY_PRINTER, DropSummaryPrinter.IO_CUCUMBER_PLUGIN_PLUGIN, Boolean.valueOf(true)).getVisitor());
            this.doAfterVisit((TreeVisitor)new RemoveImport(DropSummaryPrinter.IO_CUCUMBER_PLUGIN_SUMMARY_PRINTER));
            return classDeclaration.withImplements(ListUtils.map((List)classDeclaration.getImplements(), i -> {
                if (TypeUtils.isOfClassType((JavaType)i.getType(), (String)DropSummaryPrinter.IO_CUCUMBER_PLUGIN_SUMMARY_PRINTER) && alreadyImplementsPlugin) {
                    return null;
                }
                return i;
            }));
        }
    }
}

