/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.PathUtils;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.jgit.api.Git;
import org.openrewrite.jgit.lib.FileMode;
import org.openrewrite.jgit.treewalk.AbstractTreeIterator;
import org.openrewrite.jgit.treewalk.FileTreeIterator;
import org.openrewrite.jgit.treewalk.TreeWalk;
import org.openrewrite.jgit.treewalk.WorkingTreeIterator;
import org.openrewrite.jgit.treewalk.filter.PathFilterGroup;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.OperatingSystemProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenLoggingResolutionEventListener;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenPomCacheBuilder;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.ResourceParser;
import org.openrewrite.maven.cache.InMemoryMavenPomCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.internal.RawRepositories;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ProfileActivation;
import org.openrewrite.maven.tree.ResolutionEventListener;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.utilities.MavenWrapper;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParsingExecutionContextView;
import org.openrewrite.xml.tree.Xml;

public class MavenMojoProjectParser {
    private static final String MVN_JVM_CONFIG = ".mvn/jvm.config";
    private static final String MVN_MAVEN_CONFIG = ".mvn/maven.config";
    private static final String MAVEN_COMPILER_PLUGIN = "org.apache.maven.plugins:maven-compiler-plugin";
    public static @Nullable MavenPomCache POM_CACHE;
    private final Log logger;
    private final AtomicBoolean firstWarningLogged = new AtomicBoolean(false);
    private final Path baseDir;
    private final @Nullable org.openrewrite.jgit.lib.Repository repository;
    private final boolean pomCacheEnabled;
    private final @Nullable String pomCacheDirectory;
    private final boolean skipMavenParsing;
    private final BuildTool buildTool;
    private final Collection<String> exclusions;
    private final Collection<String> plainTextMasks;
    private final int sizeThresholdMb;
    private final MavenSession mavenSession;
    private final SettingsDecrypter settingsDecrypter;
    private final boolean runPerSubmodule;
    private final boolean parseAdditionalResources;
    private static final Map<Path, GitProvenance> REPO_ROOT_TO_PROVENANCE;

    public MavenMojoProjectParser(Log logger, Path baseDir, boolean pomCacheEnabled, @Nullable String pomCacheDirectory, RuntimeInformation runtime, boolean skipMavenParsing, Collection<String> exclusions, Collection<String> plainTextMasks, int sizeThresholdMb, MavenSession session, SettingsDecrypter settingsDecrypter, boolean runPerSubmodule, boolean parseAdditionalResources) {
        this.logger = logger;
        this.baseDir = baseDir;
        this.repository = MavenMojoProjectParser.getRepository(baseDir);
        this.pomCacheEnabled = pomCacheEnabled;
        this.pomCacheDirectory = pomCacheDirectory;
        this.skipMavenParsing = skipMavenParsing;
        this.buildTool = new BuildTool(Tree.randomId(), BuildTool.Type.Maven, runtime.getMavenVersion());
        this.exclusions = exclusions;
        this.plainTextMasks = plainTextMasks;
        this.sizeThresholdMb = sizeThresholdMb;
        this.mavenSession = session;
        this.settingsDecrypter = settingsDecrypter;
        this.runPerSubmodule = runPerSubmodule;
        this.parseAdditionalResources = parseAdditionalResources;
    }

    public Stream<SourceFile> listSourceFiles(MavenProject mavenProject, List<NamedStyles> styles, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException, MojoFailureException {
        if (this.runPerSubmodule) {
            List<Marker> projectProvenance = this.generateProvenance(mavenProject);
            Xml.Document maven = this.parseMaven(mavenProject, projectProvenance, ctx);
            return this.listSourceFiles(mavenProject, maven, projectProvenance, styles, ctx);
        }
        Map<MavenProject, List<Marker>> projectProvenances = this.mavenSession.getProjects().stream().collect(Collectors.toMap(Function.identity(), this::generateProvenance));
        Map<MavenProject, Xml.Document> projectMap = this.parseMaven(this.mavenSession.getProjects(), projectProvenances, ctx);
        return this.mavenSession.getProjects().stream().flatMap(project -> {
            List projectProvenance = (List)projectProvenances.get(project);
            try {
                return this.listSourceFiles((MavenProject)project, (Xml.Document)projectMap.get(project), projectProvenance, styles, ctx);
            }
            catch (DependencyResolutionRequiredException | MojoExecutionException e) {
                throw (RuntimeException)MavenMojoProjectParser.sneakyThrow(e);
            }
        });
    }

    public Stream<SourceFile> listSourceFiles(MavenProject mavenProject, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Xml.Document maven, List<Marker> projectProvenance, List<NamedStyles> styles, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        return this.listSourceFiles(mavenProject, maven, projectProvenance, Arrays.asList(MavenScope.MAIN, MavenScope.TEST), styles, ctx);
    }

    public Stream<SourceFile> listSourceFiles(MavenProject mavenProject, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Xml.Document maven, List<Marker> projectProvenance, List<MavenScope> scopes, List<NamedStyles> styles, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        Stream parsedResourceFiles;
        Stream<Object> sourceFiles = Stream.empty();
        HashSet<Path> alreadyParsed = new HashSet<Path>();
        if (maven != null) {
            sourceFiles = Stream.of(maven);
            alreadyParsed.add(this.baseDir.resolve(maven.getSourcePath()));
        }
        JavaParser.Builder javaParserBuilder = JavaParser.fromJavaVersion().styles(styles).logCompilationWarningsAndErrors(false);
        KotlinParser.Builder kotlinParserBuilder = KotlinParser.builder();
        ResourceParser rp = new ResourceParser(this.baseDir, this.repository, this.logger, this.exclusions, this.plainTextMasks, this.sizeThresholdMb, this.pathsToOtherMavenProjects(mavenProject), javaParserBuilder.clone(), kotlinParserBuilder.clone(), ctx);
        if (scopes.contains((Object)MavenScope.MAIN)) {
            sourceFiles = Stream.concat(sourceFiles, this.processMainSources(mavenProject, javaParserBuilder.clone(), kotlinParserBuilder.clone(), rp, projectProvenance, alreadyParsed, ctx));
        }
        if (scopes.contains((Object)MavenScope.TEST)) {
            sourceFiles = Stream.concat(sourceFiles, this.processTestSources(mavenProject, javaParserBuilder.clone(), kotlinParserBuilder.clone(), rp, projectProvenance, alreadyParsed, ctx));
        }
        Collection exclusionMatchers = this.exclusions.stream().map(pattern -> this.baseDir.getFileSystem().getPathMatcher("glob:" + pattern)).collect(Collectors.toList());
        sourceFiles = sourceFiles.map(sourceFile -> {
            if (this.isExcluded(exclusionMatchers, sourceFile.getSourcePath())) {
                return null;
            }
            return sourceFile;
        }).filter(Objects::nonNull);
        int sourcesParsedBefore = alreadyParsed.size();
        if (this.parseAdditionalResources) {
            parsedResourceFiles = rp.parse(mavenProject.getBasedir().toPath(), alreadyParsed).map(this.addProvenance(this.baseDir, projectProvenance, null));
            this.logDebug(mavenProject, "Parsed " + (alreadyParsed.size() - sourcesParsedBefore) + " additional files found within the project.");
        } else {
            parsedResourceFiles = Stream.of(Paths.get(MVN_JVM_CONFIG, new String[0]), Paths.get(MVN_MAVEN_CONFIG, new String[0]), MavenWrapper.WRAPPER_BATCH_LOCATION, MavenWrapper.WRAPPER_JAR_LOCATION, MavenWrapper.WRAPPER_PROPERTIES_LOCATION, MavenWrapper.WRAPPER_SCRIPT_LOCATION).flatMap(path -> rp.parse(mavenProject.getBasedir().toPath().resolve((Path)path), alreadyParsed)).map(this.addProvenance(this.baseDir, projectProvenance, null));
            this.logDebug(mavenProject, "Parsed " + (alreadyParsed.size() - sourcesParsedBefore) + " Maven wrapper files found within the project.");
        }
        sourceFiles = Stream.concat(sourceFiles, parsedResourceFiles);
        return sourceFiles.map(this::logParseErrors);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isExcluded(Collection<PathMatcher> exclusionMatchers, Path path) {
        for (PathMatcher excluded : exclusionMatchers) {
            if (!excluded.matches(path)) continue;
            return true;
        }
        if (!path.isAbsolute() && !path.startsWith(File.separator)) {
            return this.isExcluded(exclusionMatchers, Paths.get("/" + path, new String[0]));
        }
        if (this.repository == null) return false;
        String repoRelativePath = PathUtils.separatorsToUnix((String)path.toString());
        if (repoRelativePath.isEmpty() && "/".equals(repoRelativePath)) {
            return false;
        }
        try (TreeWalk walk = new TreeWalk(this.repository);){
            walk.addTree((AbstractTreeIterator)new FileTreeIterator(this.repository));
            walk.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{repoRelativePath}));
            while (walk.next()) {
                WorkingTreeIterator workingTreeIterator = (WorkingTreeIterator)walk.getTree(0, WorkingTreeIterator.class);
                if (walk.getPathString().equals(repoRelativePath)) {
                    boolean bl = workingTreeIterator.isEntryIgnored();
                    return bl;
                }
                if (!workingTreeIterator.getEntryFileMode().equals(FileMode.TREE)) continue;
                if (workingTreeIterator.isEntryIgnored()) {
                    boolean bl = true;
                    return bl;
                }
                walk.enterSubtree();
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Optional<Charset> getCharset(MavenProject mavenProject) {
        Xpp3Dom encoding;
        String compilerPluginKey = MAVEN_COMPILER_PLUGIN;
        Plugin plugin = Optional.ofNullable(mavenProject.getPlugin(compilerPluginKey)).orElseGet(() -> (Plugin)mavenProject.getPluginManagement().getPluginsAsMap().get(compilerPluginKey));
        if (plugin != null && plugin.getConfiguration() instanceof Xpp3Dom && (encoding = ((Xpp3Dom)plugin.getConfiguration()).getChild("encoding")) != null && StringUtils.isNotEmpty((String)encoding.getValue())) {
            return Optional.of(Charset.forName(encoding.getValue()));
        }
        Object mavenSourceEncoding = mavenProject.getProperties().get("project.build.sourceEncoding");
        if (mavenSourceEncoding != null) {
            return Optional.of(Charset.forName(mavenSourceEncoding.toString()));
        }
        return Optional.empty();
    }

    static @Nullable org.openrewrite.jgit.lib.Repository getRepository(Path rootDir) {
        org.openrewrite.jgit.lib.Repository repository;
        block8: {
            Git git = Git.open((File)rootDir.toFile());
            try {
                repository = git.getRepository();
                if (git == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            git.close();
        }
        return repository;
    }

    private SourceFile logParseErrors(SourceFile source) {
        source.getMarkers().findFirst(ParseExceptionResult.class).ifPresent(e -> {
            if (this.firstWarningLogged.compareAndSet(false, true)) {
                this.logger.warn((CharSequence)("There were problems parsing some source files" + (this.mavenSession.getRequest().isShowErrors() ? "" : ", run with --errors to see full stack traces")));
            }
            this.logger.warn((CharSequence)("There were problems parsing " + source.getSourcePath()));
            if (this.mavenSession.getRequest().isShowErrors()) {
                this.logger.warn((CharSequence)e.getMessage());
            }
        });
        return source;
    }

    public List<Marker> generateProvenance(MavenProject mavenProject) {
        BuildEnvironment buildEnvironment = BuildEnvironment.build(System::getenv);
        return Stream.of(buildEnvironment, this.gitProvenance(this.baseDir, buildEnvironment), OperatingSystemProvenance.current(), this.buildTool, new JavaProject(Tree.randomId(), mavenProject.getName(), new JavaProject.Publication(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion()))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static JavaVersion getSrcMainJavaVersion(MavenProject mavenProject) {
        String sourceCompatibility = null;
        String targetCompatibility = null;
        Plugin compilerPlugin = mavenProject.getPlugin(MAVEN_COMPILER_PLUGIN);
        if (compilerPlugin != null && compilerPlugin.getConfiguration() instanceof Xpp3Dom) {
            Xpp3Dom dom = (Xpp3Dom)compilerPlugin.getConfiguration();
            Xpp3Dom release = dom.getChild("release");
            if (release != null && StringUtils.isNotEmpty((String)release.getValue()) && !release.getValue().contains("${")) {
                sourceCompatibility = release.getValue();
                targetCompatibility = release.getValue();
            } else {
                Xpp3Dom target;
                Xpp3Dom source = dom.getChild("source");
                if (source != null && StringUtils.isNotEmpty((String)source.getValue()) && !source.getValue().contains("${")) {
                    sourceCompatibility = source.getValue();
                }
                if ((target = dom.getChild("target")) != null && StringUtils.isNotEmpty((String)target.getValue()) && !target.getValue().contains("${")) {
                    targetCompatibility = target.getValue();
                }
            }
        }
        if (sourceCompatibility == null || targetCompatibility == null) {
            String propertiesReleaseCompatibility = (String)mavenProject.getProperties().get("maven.compiler.release");
            if (propertiesReleaseCompatibility != null) {
                sourceCompatibility = propertiesReleaseCompatibility;
                targetCompatibility = propertiesReleaseCompatibility;
            } else {
                String propertiesSourceCompatibility = (String)mavenProject.getProperties().get("maven.compiler.source");
                if (sourceCompatibility == null && propertiesSourceCompatibility != null) {
                    sourceCompatibility = propertiesSourceCompatibility;
                }
                String propertiesTargetCompatibility = (String)mavenProject.getProperties().get("maven.compiler.target");
                if (targetCompatibility == null && propertiesTargetCompatibility != null) {
                    targetCompatibility = propertiesTargetCompatibility;
                }
            }
        }
        return MavenMojoProjectParser.getJavaVersionMarker(sourceCompatibility, targetCompatibility);
    }

    static JavaVersion getSrcTestJavaVersion(MavenProject mavenProject) {
        String sourceCompatibility = null;
        String targetCompatibility = null;
        Plugin compilerPlugin = mavenProject.getPlugin(MAVEN_COMPILER_PLUGIN);
        if (compilerPlugin != null && compilerPlugin.getConfiguration() instanceof Xpp3Dom) {
            Xpp3Dom dom = (Xpp3Dom)compilerPlugin.getConfiguration();
            Xpp3Dom release = dom.getChild("testRelease");
            if (release != null && StringUtils.isNotEmpty((String)release.getValue()) && !release.getValue().contains("${")) {
                sourceCompatibility = release.getValue();
                targetCompatibility = release.getValue();
            } else {
                Xpp3Dom target;
                Xpp3Dom source = dom.getChild("testSource");
                if (source != null && StringUtils.isNotEmpty((String)source.getValue()) && !source.getValue().contains("${")) {
                    sourceCompatibility = source.getValue();
                }
                if ((target = dom.getChild("testTarget")) != null && StringUtils.isNotEmpty((String)target.getValue()) && !target.getValue().contains("${")) {
                    targetCompatibility = target.getValue();
                }
            }
        }
        if (sourceCompatibility == null || targetCompatibility == null) {
            String propertiesReleaseCompatibility = (String)mavenProject.getProperties().get("maven.compiler.testRelease");
            if (propertiesReleaseCompatibility != null) {
                sourceCompatibility = propertiesReleaseCompatibility;
                targetCompatibility = propertiesReleaseCompatibility;
            } else {
                String propertiesSourceCompatibility = (String)mavenProject.getProperties().get("maven.compiler.testSource");
                if (sourceCompatibility == null && propertiesSourceCompatibility != null) {
                    sourceCompatibility = propertiesSourceCompatibility;
                }
                String propertiesTargetCompatibility = (String)mavenProject.getProperties().get("maven.compiler.testTarget");
                if (targetCompatibility == null && propertiesTargetCompatibility != null) {
                    targetCompatibility = propertiesTargetCompatibility;
                }
            }
        }
        if (sourceCompatibility == null || targetCompatibility == null) {
            JavaVersion srcMainJavaVersion = MavenMojoProjectParser.getSrcMainJavaVersion(mavenProject);
            if (sourceCompatibility == null && targetCompatibility == null) {
                return srcMainJavaVersion;
            }
            sourceCompatibility = sourceCompatibility == null ? srcMainJavaVersion.getSourceCompatibility() : sourceCompatibility;
            targetCompatibility = targetCompatibility == null ? srcMainJavaVersion.getTargetCompatibility() : targetCompatibility;
        }
        return MavenMojoProjectParser.getJavaVersionMarker(sourceCompatibility, targetCompatibility);
    }

    private static JavaVersion getJavaVersionMarker(@Nullable String sourceCompatibility, @Nullable String targetCompatibility) {
        String javaRuntimeVersion = System.getProperty("java.specification.version");
        String javaVendor = System.getProperty("java.vm.vendor");
        if (sourceCompatibility == null) {
            sourceCompatibility = javaRuntimeVersion;
        }
        if (targetCompatibility == null) {
            targetCompatibility = sourceCompatibility;
        }
        return new JavaVersion(Tree.randomId(), javaRuntimeVersion, javaVendor, sourceCompatibility, targetCompatibility);
    }

    private Stream<SourceFile> processMainSources(MavenProject mavenProject, JavaParser.Builder<? extends JavaParser, ?> javaParserBuilder, KotlinParser.Builder kotlinParserBuilder, ResourceParser resourceParser, List<Marker> projectProvenance, Set<Path> alreadyParsed, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        List<Path> generatedSourcePaths = MavenMojoProjectParser.listJavaSources(mavenProject.getBasedir().toPath().resolve(mavenProject.getBuild().getDirectory()));
        String mavenSourceDirectory = mavenProject.getBuild().getSourceDirectory();
        List mainJavaSources = Stream.concat(generatedSourcePaths.stream(), MavenMojoProjectParser.listJavaSources(mavenProject.getBasedir().toPath().resolve(mavenSourceDirectory)).stream()).collect(Collectors.toList());
        alreadyParsed.addAll(mainJavaSources);
        List<Path> mainKotlinSources = this.listKotlinSources(mavenProject, mavenSourceDirectory);
        alreadyParsed.addAll(mainKotlinSources);
        this.logInfo(mavenProject, "Parsing source files");
        List dependencies = mavenProject.getCompileClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        JavaTypeCache typeCache = new JavaTypeCache();
        javaParserBuilder.classpath(dependencies).typeCache(typeCache);
        kotlinParserBuilder.classpath(dependencies).typeCache(new JavaTypeCache());
        Stream<Object> parsedJava = Stream.empty();
        if (!mainJavaSources.isEmpty()) {
            parsedJava = Stream.of(() -> javaParserBuilder.build()).map(Supplier::get).flatMap(jp -> {
                ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset((Charset)MavenMojoProjectParser.getCharset(mavenProject).orElse(null));
                return (Stream)jp.parse((Iterable)mainJavaSources, this.baseDir, ctx).onClose(() -> ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(null));
            });
            this.logDebug(mavenProject, "Scanned " + mainJavaSources.size() + " java source files in main scope.");
        }
        Stream<Object> parsedKotlin = Stream.empty();
        if (!mainKotlinSources.isEmpty()) {
            parsedKotlin = Stream.of(() -> ((KotlinParser.Builder)kotlinParserBuilder).build()).map(Supplier::get).flatMap(kp -> {
                ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(StandardCharsets.UTF_8);
                return (Stream)kp.parse((Iterable)mainKotlinSources, this.baseDir, ctx).onClose(() -> ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(null));
            });
            this.logDebug(mavenProject, "Scanned " + mainKotlinSources.size() + " kotlin source files in main scope.");
        }
        ArrayList<Marker> mainProjectProvenance = new ArrayList<Marker>(projectProvenance);
        mainProjectProvenance.add((Marker)JavaSourceSet.build((String)"main", dependencies));
        mainProjectProvenance.add((Marker)MavenMojoProjectParser.getSrcMainJavaVersion(mavenProject));
        Path buildDirectory = this.baseDir.relativize(Paths.get(mavenProject.getBuild().getDirectory(), new String[0]));
        Stream sourceFiles = Stream.concat(parsedJava, parsedKotlin).filter(s -> !s.getSourcePath().startsWith(buildDirectory)).map(this.addProvenance(this.baseDir, mainProjectProvenance, generatedSourcePaths));
        int sourcesParsedBefore = alreadyParsed.size();
        Stream parsedResourceFiles = resourceParser.parse(mavenProject.getBasedir().toPath().resolve("src/main/resources"), alreadyParsed).map(this.addProvenance(this.baseDir, mainProjectProvenance, null));
        this.logDebug(mavenProject, "Scanned " + (alreadyParsed.size() - sourcesParsedBefore) + " resource files in main scope.");
        return Stream.concat(sourceFiles, parsedResourceFiles);
    }

    private Stream<SourceFile> processTestSources(MavenProject mavenProject, JavaParser.Builder<? extends JavaParser, ?> javaParserBuilder, KotlinParser.Builder kotlinParserBuilder, ResourceParser resourceParser, List<Marker> projectProvenance, Set<Path> alreadyParsed, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        List testDependencies = mavenProject.getTestClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        JavaTypeCache typeCache = new JavaTypeCache();
        javaParserBuilder.classpath(testDependencies).typeCache(typeCache);
        kotlinParserBuilder.classpath(testDependencies).typeCache(new JavaTypeCache());
        ArrayList<Path> testJavaSources = new ArrayList<Path>();
        for (String p : mavenProject.getTestCompileSourceRoots()) {
            testJavaSources.addAll(MavenMojoProjectParser.listJavaSources(mavenProject.getBasedir().toPath().resolve(p)));
        }
        alreadyParsed.addAll(testJavaSources);
        String mavenTestSourceDirectory = mavenProject.getBuild().getTestSourceDirectory();
        List<Path> testKotlinSources = this.listKotlinSources(mavenProject, mavenTestSourceDirectory);
        alreadyParsed.addAll(testKotlinSources);
        Stream<Object> parsedJava = Stream.empty();
        if (!testJavaSources.isEmpty()) {
            parsedJava = Stream.of(() -> javaParserBuilder.build()).map(Supplier::get).flatMap(jp -> {
                ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset((Charset)MavenMojoProjectParser.getCharset(mavenProject).orElse(null));
                return (Stream)jp.parse((Iterable)testJavaSources, this.baseDir, ctx).onClose(() -> ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(null));
            });
            this.logDebug(mavenProject, "Scanned " + testJavaSources.size() + " java source files in test scope.");
        }
        Stream<Object> parsedKotlin = Stream.empty();
        if (!testKotlinSources.isEmpty()) {
            parsedKotlin = Stream.of(() -> ((KotlinParser.Builder)kotlinParserBuilder).build()).map(Supplier::get).flatMap(kp -> {
                ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(StandardCharsets.UTF_8);
                return (Stream)kp.parse((Iterable)testKotlinSources, this.baseDir, ctx).onClose(() -> ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(null));
            });
            this.logDebug(mavenProject, "Scanned " + testKotlinSources.size() + " kotlin source files in test scope.");
        }
        ArrayList<Marker> markers = new ArrayList<Marker>(projectProvenance);
        markers.add((Marker)JavaSourceSet.build((String)"test", testDependencies));
        markers.add((Marker)MavenMojoProjectParser.getSrcTestJavaVersion(mavenProject));
        int sourcesParsedBefore = alreadyParsed.size();
        Stream<SourceFile> parsedResourceFiles = resourceParser.parse(mavenProject.getBasedir().toPath().resolve("src/test/resources"), alreadyParsed);
        this.logDebug(mavenProject, "Scanned " + (alreadyParsed.size() - sourcesParsedBefore) + " resource files in test scope.");
        return Stream.concat(Stream.concat(parsedJava, parsedKotlin), parsedResourceFiles).map(this.addProvenance(this.baseDir, markers, null));
    }

    private List<Path> listKotlinSources(MavenProject mavenProject, String fallbackSourceDirectory) throws MojoExecutionException {
        String kotlinSourceDir = this.getKotlinDirectory(fallbackSourceDirectory);
        return MavenMojoProjectParser.listSources(mavenProject.getBasedir().toPath().resolve(kotlinSourceDir != null ? kotlinSourceDir : fallbackSourceDirectory), ".kt");
    }

    private @Nullable String getKotlinDirectory(@Nullable String sourceDirectory) {
        File[] subdirectories;
        if (sourceDirectory == null) {
            return null;
        }
        File directory = new File(sourceDirectory);
        File parentDirectory = directory.getParentFile();
        if (parentDirectory != null && (subdirectories = parentDirectory.listFiles(File::isDirectory)) != null) {
            for (File subdirectory : subdirectories) {
                if (!"kotlin".equals(subdirectory.getName())) continue;
                return subdirectory.getAbsolutePath();
            }
        }
        return null;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Xml.Document parseMaven(MavenProject mavenProject, List<Marker> projectProvenance, ExecutionContext ctx) throws MojoFailureException {
        return this.parseMaven(Collections.singletonList(mavenProject), Collections.singletonMap(mavenProject, projectProvenance), ctx).get(mavenProject);
    }

    public Map<MavenProject, Xml.Document> parseMaven(List<MavenProject> mavenProjects, Map<MavenProject, List<Marker>> projectProvenances, ExecutionContext ctx) throws MojoFailureException {
        if (this.skipMavenParsing) {
            this.logger.info((CharSequence)"Skipping Maven parsing...");
            return Collections.emptyMap();
        }
        MavenSettings settings = this.buildSettings();
        MavenExecutionContextView mavenExecutionContext = MavenExecutionContextView.view((ExecutionContext)ctx);
        mavenExecutionContext.setMavenSettings(settings, new String[0]);
        mavenExecutionContext.setResolutionListener((ResolutionEventListener)new MavenLoggingResolutionEventListener(this.logger));
        MavenPomCache pomCache = this.pomCacheEnabled ? MavenMojoProjectParser.getPomCache(this.pomCacheDirectory, this.logger) : mavenExecutionContext.getPomCache();
        mavenExecutionContext.setPomCache(pomCache);
        MavenProject topLevelProject = this.mavenSession.getTopLevelProject();
        this.logInfo(topLevelProject, "Resolving Poms...");
        LinkedHashSet allPoms = new LinkedHashSet();
        mavenProjects.forEach(p -> this.collectPoms((MavenProject)p, allPoms, mavenExecutionContext));
        for (MavenProject mavenProject : mavenProjects) {
            this.mavenSession.getProjectDependencyGraph().getUpstreamProjects(mavenProject, true).forEach(p -> this.collectPoms((MavenProject)p, allPoms, mavenExecutionContext));
        }
        MavenParser.Builder mavenParserBuilder = MavenParser.builder();
        mavenParserBuilder.property("basedir", topLevelProject.getBasedir().getAbsoluteFile().getParent());
        mavenParserBuilder.property("project.basedir", topLevelProject.getBasedir().getAbsoluteFile().getParent());
        topLevelProject.getActiveProfiles().forEach(it -> mavenParserBuilder.activeProfiles(new String[]{it.getId()}));
        this.mavenSession.getRequest().getActiveProfiles().forEach(xva$0 -> mavenParserBuilder.activeProfiles(new String[]{xva$0}));
        this.mavenSession.getUserProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> mavenParserBuilder.property((String)key, (String)value)));
        List mavens = mavenParserBuilder.build().parse(allPoms, this.baseDir, ctx).collect(Collectors.toList());
        if (this.logger.isDebugEnabled()) {
            this.logDebug(topLevelProject, "Base directory : '" + this.baseDir + "'");
            if (allPoms.isEmpty()) {
                this.logDebug(topLevelProject, "There were no collected pom paths.");
            } else {
                for (Path path : allPoms) {
                    this.logDebug(topLevelProject, "  Collected Maven POM : '" + path + "'");
                }
            }
            if (mavens.isEmpty()) {
                this.logDebug(topLevelProject, "There were no parsed maven source files.");
            } else {
                for (SourceFile source : mavens) {
                    this.logDebug(topLevelProject, "  Maven Source : '" + this.baseDir.resolve(source.getSourcePath()) + "'");
                }
            }
        }
        Map projectsByPath = mavenProjects.stream().collect(Collectors.toMap(MavenMojoProjectParser::pomPath, Function.identity()));
        HashMap<MavenProject, Xml.Document> projectMap = new HashMap<MavenProject, Xml.Document>();
        for (SourceFile document : mavens) {
            Path path = this.baseDir.resolve(document.getSourcePath());
            MavenProject mavenProject = (MavenProject)projectsByPath.get(path);
            if (mavenProject == null) continue;
            Optional parseExceptionResult = document.getMarkers().findFirst(ParseExceptionResult.class);
            if (parseExceptionResult.isPresent()) {
                throw new MojoFailureException((Object)mavenProject, "Failed to parse or resolve the Maven POM file or one of its dependencies; We can not reliably continue without this information.", ((ParseExceptionResult)parseExceptionResult.get()).getMessage());
            }
            projectMap.put(mavenProject, (Xml.Document)document);
        }
        for (MavenProject mavenProject : mavenProjects) {
            if (projectMap.get(mavenProject) != null) continue;
            this.logError(mavenProject, "Parse resulted in no Maven source files. Maven Project File '" + mavenProject.getFile().toPath() + "'");
            return Collections.emptyMap();
        }
        for (MavenProject mavenProject : mavenProjects) {
            Xml.Document document = (Xml.Document)projectMap.get(mavenProject);
            List provenance = projectProvenances.getOrDefault(mavenProject, Collections.emptyList());
            Markers markers = document.getMarkers();
            for (Marker marker : provenance) {
                markers = markers.addIfAbsent(marker);
            }
            projectMap.put(mavenProject, document.withMarkers(markers));
        }
        return projectMap;
    }

    private void collectPoms(MavenProject project, Set<Path> paths, MavenExecutionContextView ctx) {
        if (!paths.add(MavenMojoProjectParser.pomPath(project))) {
            return;
        }
        ResolvedGroupArtifactVersion gav = MavenMojoProjectParser.createResolvedGAV(project, ctx);
        ctx.getPomCache().putPom(gav, MavenMojoProjectParser.createPom(project));
        if (project.getCollectedProjects() != null) {
            for (MavenProject child : project.getCollectedProjects()) {
                Path path = MavenMojoProjectParser.pomPath(child);
                if (paths.contains(path)) continue;
                this.collectPoms(child, paths, ctx);
            }
        }
        for (MavenProject parent = project.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
            Path path = MavenMojoProjectParser.pomPath(parent);
            if (paths.contains(path)) continue;
            this.collectPoms(parent, paths, ctx);
        }
    }

    private static Path pomPath(MavenProject mavenProject) {
        Path normalPom;
        Path pomPath = mavenProject.getFile().toPath();
        if ((pomPath.endsWith(".flattened-pom.xml") || pomPath.endsWith("dependency-reduced-pom.xml") || pomPath.endsWith(".ci-friendly-pom.xml") || pomPath.endsWith(".tycho-consumer-pom.xml")) && Files.isReadable(normalPom = mavenProject.getBasedir().toPath().resolve("pom.xml")) && Files.isRegularFile(normalPom, new LinkOption[0])) {
            return normalPom;
        }
        return pomPath;
    }

    private static MavenPomCache getPomCache(@Nullable String pomCacheDirectory, Log logger) {
        if (POM_CACHE == null) {
            POM_CACHE = new MavenPomCacheBuilder(logger).build(pomCacheDirectory);
        }
        if (POM_CACHE == null) {
            POM_CACHE = new InMemoryMavenPomCache();
        }
        return POM_CACHE;
    }

    public MavenSettings buildSettings() {
        MavenExecutionRequest mer = this.mavenSession.getRequest();
        MavenSettings.Profiles profiles = new MavenSettings.Profiles();
        profiles.setProfiles(mer.getProfiles().stream().map(p -> new MavenSettings.Profile(p.getId(), p.getActivation() == null ? null : new ProfileActivation(Boolean.valueOf(p.getActivation().isActiveByDefault()), p.getActivation().getJdk(), p.getActivation().getProperty() == null ? null : new ProfileActivation.Property(p.getActivation().getProperty().getName(), p.getActivation().getProperty().getValue())), MavenMojoProjectParser.buildRawRepositories(p.getRepositories()))).collect(Collectors.toList()));
        MavenSettings.ActiveProfiles activeProfiles = new MavenSettings.ActiveProfiles();
        activeProfiles.setActiveProfiles(mer.getActiveProfiles());
        MavenSettings.Mirrors mirrors = new MavenSettings.Mirrors();
        mirrors.setMirrors(mer.getMirrors().stream().map(m -> new MavenSettings.Mirror(m.getId(), m.getUrl(), m.getMirrorOf(), null, null)).collect(Collectors.toList()));
        MavenSettings.Servers servers = new MavenSettings.Servers();
        servers.setServers(mer.getServers().stream().map(s -> {
            DefaultSettingsDecryptionRequest decryptionRequest = new DefaultSettingsDecryptionRequest(s);
            SettingsDecryptionResult decryptionResult = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)decryptionRequest);
            MavenSettings.ServerConfiguration configuration = null;
            if (s.getConfiguration() != null) {
                try {
                    configuration = (MavenSettings.ServerConfiguration)MavenXmlMapper.readMapper().readValue(s.getConfiguration().toString(), MavenSettings.ServerConfiguration.class);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            return new MavenSettings.Server(s.getId(), s.getUsername(), decryptionResult.getServer().getPassword(), configuration);
        }).collect(Collectors.toList()));
        return new MavenSettings(mer.getLocalRepositoryPath().toString(), profiles, activeProfiles, mirrors, servers);
    }

    private static @Nullable RawRepositories buildRawRepositories(@Nullable List<Repository> repositoriesToMap) {
        if (repositoriesToMap == null) {
            return null;
        }
        RawRepositories rawRepositories = new RawRepositories();
        List transformedRepositories = repositoriesToMap.stream().map(r -> new RawRepositories.Repository(r.getId(), r.getUrl(), r.getReleases() == null ? null : new RawRepositories.ArtifactPolicy(Boolean.toString(r.getReleases().isEnabled())), r.getSnapshots() == null ? null : new RawRepositories.ArtifactPolicy(Boolean.toString(r.getSnapshots().isEnabled())))).collect(Collectors.toList());
        rawRepositories.setRepositories(transformedRepositories);
        return rawRepositories;
    }

    private Set<Path> pathsToOtherMavenProjects(MavenProject mavenProject) {
        return this.mavenSession.getProjects().stream().filter(o -> o != mavenProject).map(o -> o.getBasedir().toPath()).collect(Collectors.toSet());
    }

    private <T extends SourceFile> UnaryOperator<T> addProvenance(Path baseDir, List<Marker> provenance, @Nullable Collection<Path> generatedSources) {
        return s -> {
            Markers markers = s.getMarkers();
            for (Marker marker : provenance) {
                markers = markers.addIfAbsent(marker);
            }
            if (generatedSources != null && generatedSources.contains(baseDir.resolve(s.getSourcePath()))) {
                markers = markers.addIfAbsent((Marker)new Generated(Tree.randomId()));
            }
            return (SourceFile)s.withMarkers(markers);
        };
    }

    private static List<Path> listJavaSources(Path sourceDirectory) throws MojoExecutionException {
        return MavenMojoProjectParser.listSources(sourceDirectory, ".java");
    }

    private static List<Path> listSources(Path sourceDirectory, final String extension) throws MojoExecutionException {
        if (!Files.exists(sourceDirectory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            final ArrayList<Path> result = new ArrayList<Path>();
            Files.walkFileTree(sourceDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.toString().endsWith(extension)) {
                        result.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return result;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to list source files of " + extension, (Exception)e);
        }
    }

    private @Nullable GitProvenance gitProvenance(Path baseDir, @Nullable BuildEnvironment buildEnvironment) {
        try {
            return REPO_ROOT_TO_PROVENANCE.computeIfAbsent(baseDir, dir -> GitProvenance.fromProjectDirectory((Path)dir, (BuildEnvironment)buildEnvironment));
        }
        catch (Exception e) {
            this.logger.debug((CharSequence)"Unable to determine git provenance", (Throwable)e);
            return null;
        }
    }

    private void logError(MavenProject mavenProject, String message) {
        this.logger.error((CharSequence)("Project [" + mavenProject.getName() + "] " + message));
    }

    private void logInfo(MavenProject mavenProject, String message) {
        this.logger.info((CharSequence)("Project [" + mavenProject.getName() + "] " + message));
    }

    private void logDebug(MavenProject mavenProject, String message) {
        this.logger.debug((CharSequence)("Project [" + mavenProject.getName() + "] " + message));
    }

    private static <E extends Throwable> E sneakyThrow(Throwable e) throws E {
        return (E)e;
    }

    private static ResolvedGroupArtifactVersion createResolvedGAV(MavenProject project, MavenExecutionContextView ctx) {
        return new ResolvedGroupArtifactVersion(ctx.getLocalRepository().getUri(), project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getVersion().endsWith("-SNAPSHOT") ? null : project.getVersion());
    }

    private static @Nullable Pom createPom(MavenProject project) {
        Pom pom;
        block8: {
            Path pomPath = project.getFile().toPath();
            InputStream is = Files.newInputStream(pomPath, new OpenOption[0]);
            try {
                RawPom rawPom = RawPom.parse((InputStream)is, null);
                pom = rawPom.toPom(project.getBasedir().toPath().relativize(pomPath), null);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            is.close();
        }
        return pom;
    }

    static {
        REPO_ROOT_TO_PROVENANCE = new HashMap<Path, GitProvenance>();
    }

    public static enum MavenScope {
        MAIN,
        TEST;

    }
}

