/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.config.Environment;
import org.openrewrite.java.style.CheckstyleConfigLoader;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tools.checkstyle.Checker;

public abstract class ConfigurableRewriteMojo
extends AbstractMojo {
    private static final String CHECKSTYLE_DOCTYPE = "module PUBLIC \"-//Checkstyle//DTD Checkstyle Configuration 1.3//EN\" \"https://checkstyle.org/dtds/configuration_1_3.dtd\"";
    @Parameter(property="rewrite.configLocation", alias="configLocation", defaultValue="${maven.multiModuleProjectDirectory}/rewrite.yml")
    protected String configLocation;
    @Parameter(property="rewrite.activeRecipes")
    protected @Nullable LinkedHashSet<String> activeRecipes;
    @Parameter(property="rewrite.activeStyles")
    protected @Nullable LinkedHashSet<String> activeStyles;
    @Parameter(property="rewrite.pomCacheEnabled", alias="pomCacheEnabled", defaultValue="true")
    protected boolean pomCacheEnabled;
    @Parameter(property="rewrite.pomCacheDirectory", alias="pomCacheDirectory")
    protected @Nullable String pomCacheDirectory;
    @Parameter(property="rewrite.skip", defaultValue="false")
    protected boolean rewriteSkip;
    @Parameter(property="skipMavenParsing", defaultValue="false")
    protected boolean skipMavenParsing;
    @Parameter(property="rewrite.checkstyleConfigFile", alias="checkstyleConfigFile")
    protected @Nullable String checkstyleConfigFile;
    @Parameter(property="rewrite.checkstyleDetectionEnabled", alias="checkstyleDetectionEnabled", defaultValue="true")
    protected boolean checkstyleDetectionEnabled;
    @Parameter(property="rewrite.exclusions")
    private @Nullable LinkedHashSet<String> exclusions;
    @Parameter(property="rewrite.plainTextMasks")
    private @Nullable LinkedHashSet<String> plainTextMasks;
    @Parameter(property="rewrite.additionalPlainTextMasks")
    private @Nullable LinkedHashSet<String> additionalPlainTextMasks;
    @Parameter(property="sizeThresholdMb", defaultValue="10")
    protected int sizeThresholdMb;
    @Parameter(property="rewrite.failOnInvalidActiveRecipes", alias="failOnInvalidActiveRecipes", defaultValue="false")
    protected boolean failOnInvalidActiveRecipes;
    @Parameter(property="rewrite.runPerSubmodule", alias="runPerSubmodule", defaultValue="false")
    protected boolean runPerSubmodule;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    protected PluginDescriptor pluginDescriptor;
    private static final String OPENREWRITE_PROCESSED_MARKER = "openrewrite.processed";
    @Parameter(property="rewrite.recipeArtifactCoordinates")
    private @Nullable LinkedHashSet<String> recipeArtifactCoordinates;
    private volatile @Nullable Set<String> computedRecipes;
    private volatile @Nullable Set<String> computedStyles;
    private volatile @Nullable Set<String> computedRecipeArtifactCoordinates;

    protected Set<String> getExclusions() {
        return ConfigurableRewriteMojo.getCleanedSet(this.exclusions);
    }

    protected Set<String> getPlainTextMasks() {
        Set<String> masks = ConfigurableRewriteMojo.getCleanedSet(this.plainTextMasks);
        if (!masks.isEmpty()) {
            return masks;
        }
        masks = new HashSet<String>(Arrays.asList("**/*.adoc", "**/*.aj", "**/*.bash", "**/*.bat", "**/CODEOWNERS", "**/*.css", "**/*.config", "**/[dD]ockerfile*", "**/*.[dD]ockerfile", "**/*[cC]ontainerfile*", "**/*.[cC]ontainerfile", "**/*.env", "**/.gitattributes", "**/.gitignore", "**/*.htm*", "**/gradlew", "**/.java-version", "**/*.jelly", "**/*.jsp", "**/*.ksh", "**/*.lock", "**/lombok.config", "**/*.md", "**/*.mf", "**/META-INF/services/**", "**/META-INF/spring/**", "**/META-INF/spring.factories", "**/mvnw", "**/mvnw.cmd", "**/*.qute.java", "**/.sdkmanrc", "**/*.sh", "**/*.sql", "**/*.svg", "**/*.tsx", "**/*.txt", "**/*.py"));
        masks.addAll(ConfigurableRewriteMojo.getCleanedSet(this.additionalPlainTextMasks));
        return Collections.unmodifiableSet(masks);
    }

    protected void putState(State state) {
        this.getPluginContext().put(OPENREWRITE_PROCESSED_MARKER, state.name());
    }

    private boolean hasState(MavenProject project) {
        Map pluginContext = this.mavenSession.getPluginContext(this.pluginDescriptor, project);
        return pluginContext.containsKey(OPENREWRITE_PROCESSED_MARKER);
    }

    protected boolean allProjectsMarked() {
        return this.mavenSession.getProjects().stream().allMatch(this::hasState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getActiveRecipes() {
        if (this.computedRecipes == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedRecipes == null) {
                    this.computedRecipes = ConfigurableRewriteMojo.getCleanedSet(this.activeRecipes);
                }
            }
        }
        return this.computedRecipes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getActiveStyles() {
        if (this.computedStyles == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedStyles == null) {
                    this.computedStyles = ConfigurableRewriteMojo.getCleanedSet(this.activeStyles);
                }
            }
        }
        return this.computedStyles;
    }

    protected List<NamedStyles> loadStyles(MavenProject project, Environment env) {
        List styles;
        block13: {
            styles = env.activateStyles(this.getActiveStyles());
            try {
                Object checkstyleConfRaw;
                Plugin checkstylePlugin = project.getPlugin("org.apache.maven.plugins:maven-checkstyle-plugin");
                if (this.checkstyleConfigFile != null && !this.checkstyleConfigFile.isEmpty()) {
                    styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)Paths.get(this.checkstyleConfigFile, new String[0]), Collections.emptyMap()));
                    break block13;
                }
                if (!this.checkstyleDetectionEnabled || checkstylePlugin == null || !((checkstyleConfRaw = checkstylePlugin.getConfiguration()) instanceof Xpp3Dom)) break block13;
                Xpp3Dom xmlCheckstyleConf = (Xpp3Dom)checkstyleConfRaw;
                Xpp3Dom xmlConfigLocation = xmlCheckstyleConf.getChild("configLocation");
                Xpp3Dom xmlCheckstyleRules = xmlCheckstyleConf.getChild("checkstyleRules");
                if (xmlConfigLocation != null) {
                    Path configPath = Paths.get(checkstylePlugin.getLocation((Object)"").getSource().getLocation(), new String[0]).resolveSibling(xmlConfigLocation.getValue());
                    if (configPath.toFile().exists()) {
                        styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)configPath, Collections.emptyMap()));
                    }
                    break block13;
                }
                if (xmlCheckstyleRules != null && xmlCheckstyleRules.getChildCount() > 0) {
                    styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((String)this.toCheckStyleDocument(xmlCheckstyleRules.getChild(0)), Collections.emptyMap()));
                    break block13;
                }
                try (InputStream is = Checker.class.getResourceAsStream("/sun_checks.xml");){
                    if (is != null) {
                        styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((InputStream)is, Collections.emptyMap()));
                    }
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Unable to parse checkstyle configuration. Checkstyle will not inform rewrite execution.", (Throwable)e);
            }
        }
        return styles;
    }

    @Language(value="XML")
    private String toCheckStyleDocument(Xpp3Dom dom) throws IOException {
        StringWriter stringWriter = new StringWriter();
        MXSerializer serializer = new MXSerializer();
        serializer.setOutput((Writer)stringWriter);
        serializer.docdecl(CHECKSTYLE_DOCTYPE);
        dom.writeToSerializer("", (XmlSerializer)serializer);
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getRecipeArtifactCoordinates() {
        if (this.computedRecipeArtifactCoordinates == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedRecipeArtifactCoordinates == null) {
                    this.computedRecipeArtifactCoordinates = ConfigurableRewriteMojo.getCleanedSet(this.recipeArtifactCoordinates);
                }
            }
        }
        return this.computedRecipeArtifactCoordinates;
    }

    private static Set<String> getCleanedSet(@Nullable Set<@Nullable String> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        Set cleaned = set.stream().filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(cleaned);
    }

    protected static enum State {
        SKIPPED,
        PROCESSED,
        TO_BE_PROCESSED;

    }
}

