/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.artifact.Artifact;
import org.openrewrite.java.internal.parser.TypeTable;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.ArtifactResolver;

@Mojo(name="typetable", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
@Execute(phase=LifecyclePhase.GENERATE_RESOURCES)
public class RewriteTypeTableMojo
extends AbstractRewriteMojo {
    public void execute() throws MojoExecutionException {
        Set<String> recipeArtifactCoordinates = this.getRecipeArtifactCoordinates();
        String srcMainResources = ((Resource)this.project.getResources().get(0)).getDirectory();
        Path tsvFile = Paths.get(srcMainResources, new String[0]).resolve("META-INF/rewrite/classpath.tsv.zip");
        Path parentFile = tsvFile.getParent();
        if (!parentFile.toFile().mkdirs() && !Files.exists(parentFile, new LinkOption[0])) {
            throw new MojoExecutionException("Unable to create " + parentFile);
        }
        try (TypeTable.Writer writer = TypeTable.newWriter((OutputStream)Files.newOutputStream(tsvFile, new OpenOption[0]));){
            for (String recipeArtifactCoordinate : recipeArtifactCoordinates) {
                for (Artifact artifact : this.resolveArtifacts(recipeArtifactCoordinate)) {
                    writer.jar(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).write(artifact.getFile().toPath());
                    this.getLog().info((CharSequence)String.format("Wrote %s", artifact));
                }
            }
            this.getLog().info((CharSequence)("Wrote " + this.project.getBasedir().toPath().relativize(tsvFile)));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to generate TypeTable", (Exception)e);
        }
    }

    private Set<Artifact> resolveArtifacts(String recipeArtifactCoordinate) throws MojoExecutionException {
        ArtifactResolver resolver = new ArtifactResolver(this.repositorySystem, this.mavenSession);
        Artifact artifact = resolver.createArtifact(recipeArtifactCoordinate);
        return resolver.resolveArtifactsAndDependencies(Collections.singleton(artifact));
    }
}

