/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrewrite.ExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.internal.InMemoryLargeSourceSet;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.AddPlugin;
import org.openrewrite.maven.ChangePluginDependencies;
import org.openrewrite.maven.MavenParser;

@Mojo(name="init", threadSafe=true)
@Execute
public class InitMojo
extends AbstractRewriteMojo {
    @Parameter(property="groupId", defaultValue="org.openrewrite.maven")
    protected String groupId;
    @Parameter(property="artifactId", defaultValue="rewrite-maven-plugin")
    protected String artifactId;
    @Nullable
    @Parameter(property="version")
    protected String version;
    @Nullable
    @Parameter(property="configuration")
    protected String configuration;
    @Nullable
    @Parameter(property="dependencies")
    protected String dependencies;
    @Nullable
    @Parameter(property="executionPhase")
    protected String executionPhase;
    @Nullable
    @Parameter(property="executionGoals")
    protected String executionGoals;
    @Parameter(property="rootOnly", defaultValue="true")
    protected boolean rootOnly;

    public void execute() throws MojoExecutionException {
        Path baseDir = this.getBuildRoot();
        if (this.rootOnly && !this.project.getBasedir().toPath().equals(baseDir)) {
            this.getLog().warn((CharSequence)("Skipping non-root project " + this.project.getFile().getPath()));
            return;
        }
        ExecutionContext ctx = this.executionContext();
        Recipe recipe = new Recipe(){

            public String getDisplayName() {
                return InitMojo.class.getName();
            }

            public String getDescription() {
                return InitMojo.class.getName() + " recipe.";
            }

            public List<Recipe> getRecipeList() {
                return Arrays.asList(new AddPlugin(InitMojo.this.groupId, InitMojo.this.artifactId, InitMojo.this.getVersion(), InitMojo.this.getConfiguration(), null, InitMojo.this.getExecutions()), new ChangePluginDependencies(InitMojo.this.groupId, InitMojo.this.artifactId, InitMojo.this.dependencies));
            }
        };
        MavenParser mp = MavenParser.builder().mavenConfig(baseDir.resolve(".mvn/maven.config")).build();
        List poms = mp.parse(Collections.singleton(this.project.getFile().toPath()), baseDir, ctx).collect(Collectors.toList());
        List results = recipe.run((LargeSourceSet)new InMemoryLargeSourceSet(poms), ctx).getChangeset().getAllResults();
        if (results.isEmpty()) {
            this.getLog().warn((CharSequence)("Plugin " + this.artifactId + " is already part of the build"));
            return;
        }
        Result result = (Result)results.get(0);
        assert (result.getBefore() != null);
        assert (result.getAfter() != null);
        Charset charset = result.getAfter().getCharset() == null ? StandardCharsets.UTF_8 : result.getAfter().getCharset();
        try (BufferedWriter sourceFileWriter = Files.newBufferedWriter(baseDir.resolve(result.getBefore().getSourcePath()), charset, new OpenOption[0]);){
            sourceFileWriter.write(new String(result.getAfter().printAll().getBytes(charset), charset));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getLog().info((CharSequence)("Added " + this.artifactId + " to " + this.project.getFile().getPath()));
    }

    protected String getVersion() {
        if (this.version == null) {
            return new Scanner(InitMojo.class.getResourceAsStream("/version.txt"), "UTF-8").next().trim();
        }
        return this.version;
    }

    @Nullable
    protected String getConfiguration() {
        Set<String> activeRecipes = this.getActiveRecipes();
        if (this.configuration == null && !activeRecipes.isEmpty()) {
            this.configuration = "<configuration>\n<activeRecipes>\n" + activeRecipes.stream().map(it -> "<recipe>" + it + "</recipe>").collect(Collectors.joining("\n")) + "</activeRecipes>\n</configuration>";
        }
        return this.configuration;
    }

    @Nullable
    protected String getExecutions() {
        String executions = null;
        if (this.executionPhase != null && this.executionGoals != null) {
            executions = "<executions>\n<execution>\n<phase>" + this.executionPhase + "</phase>\n<goals>\n" + Arrays.stream(this.executionGoals.split(",")).map(it -> "<goal>" + it + "</goal>").collect(Collectors.joining("\n")) + "\n</goals>\n</execution>\n</executions>";
        }
        return executions;
    }
}

