/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.utilities.PrintMavenAsCycloneDxBom;

@Mojo(name="cyclonedx", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class CycloneDxBomMojo
extends AbstractRewriteMojo {
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        ExecutionContext ctx = this.executionContext();
        Path baseDir = this.getBaseDir();
        Maven maven = this.parseMaven(baseDir, ctx);
        File cycloneDxBom = this.buildCycloneDxBom(maven);
        this.projectHelper.attachArtifact(this.project, "xml", "cyclonedx", cycloneDxBom);
    }

    @Nullable
    private File buildCycloneDxBom(Maven pomAst) {
        try {
            File cycloneDxBom = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + "-cyclonedx.xml");
            Files.write(cycloneDxBom.toPath(), PrintMavenAsCycloneDxBom.print((Maven)pomAst).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return cycloneDxBom;
        }
        catch (Throwable t) {
            this.getLog().warn((CharSequence)"Unable to produce CycloneDX BOM", t);
            return null;
        }
    }
}

