/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.openrewrite.Environment;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeSerializer;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.maven.utilities.PrintMavenAsCycloneDxBom;

@Mojo(name="publish", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class RewritePublishMojo
extends AbstractRewriteMojo {
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        Environment env = this.environment();
        File rewriteJar = this.buildAstJar(env);
        File cycloneDxBom = this.buildCycloneDxBom();
        this.projectHelper.attachArtifact(this.project, rewriteJar, "ast");
        this.projectHelper.attachArtifact(this.project, "xml", "cyclonedx", cycloneDxBom);
    }

    private File buildAstJar(Environment env) throws MojoExecutionException {
        ArrayList<Path> javaSources = new ArrayList<Path>();
        javaSources.addAll(this.listJavaSources(this.project.getBuild().getSourceDirectory()));
        javaSources.addAll(this.listJavaSources(this.project.getBuild().getTestSourceDirectory()));
        List dependencies = this.project.getArtifacts().stream().map(d -> d.getFile().toPath()).collect(Collectors.toList());
        List sourceFiles = JavaParser.fromJavaVersion().styles((Iterable)env.styles((Iterable)this.activeStyles)).classpath(dependencies).logCompilationWarningsAndErrors(false).build().parse(javaSources, this.project.getBasedir().toPath());
        File rewriteJar = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + "-ast.jar");
        TreeSerializer serializer = new TreeSerializer();
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(rewriteJar));){
            for (J.CompilationUnit cu : sourceFiles) {
                ZipEntry entry = new ZipEntry(cu.getSourcePath());
                zos.putNextEntry(entry);
                zos.write(serializer.write((SourceFile)cu));
                zos.closeEntry();
            }
            zos.flush();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write AST JAR", (Exception)e);
        }
        return rewriteJar;
    }

    private File buildCycloneDxBom() throws MojoExecutionException {
        ArrayList<Path> allPoms = new ArrayList<Path>();
        allPoms.add(this.project.getFile().toPath());
        for (MavenProject parent = this.project.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
            allPoms.add(parent.getFile().toPath());
        }
        Maven.Pom pomAst = (Maven.Pom)MavenParser.builder().resolveDependencies(false).build().parse(allPoms, this.project.getBasedir().toPath()).iterator().next();
        pomAst = pomAst.withModel(pomAst.getModel().withTransitiveDependenciesByScope(this.project.getDependencies().stream().collect(Collectors.groupingBy(Dependency::getScope, Collectors.mapping(dep -> new MavenModel.ModuleVersionId(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getVersion(), "jar"), Collectors.toSet())))));
        File cycloneDxBom = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + "-cyclonedx.xml");
        try {
            Files.write(cycloneDxBom.toPath(), ((String)new PrintMavenAsCycloneDxBom().visit((Tree)pomAst)).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write CycloneDX BOM", (Exception)e);
        }
        return cycloneDxBom;
    }
}

