/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultMavenProjectHelper;
import org.openrewrite.Environment;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeSerializer;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="jar", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class RewriteJarMojo
extends AbstractRewriteMojo {
    public void execute() throws MojoExecutionException {
        Environment env = this.environment();
        ArrayList<Path> javaSources = new ArrayList<Path>();
        javaSources.addAll(this.listJavaSources(this.project.getBuild().getSourceDirectory()));
        javaSources.addAll(this.listJavaSources(this.project.getBuild().getTestSourceDirectory()));
        List dependencies = this.project.getArtifacts().stream().map(d -> d.getFile().toPath()).collect(Collectors.toList());
        List sourceFiles = JavaParser.fromJavaVersion().styles((Iterable)env.styles((Iterable)this.activeStyles)).classpath(dependencies).logCompilationWarningsAndErrors(false).build().parse(javaSources, this.project.getBasedir().toPath());
        File rewriteJar = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + "-ast.jar");
        TreeSerializer serializer = new TreeSerializer();
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(rewriteJar));){
            for (J.CompilationUnit cu : sourceFiles) {
                ZipEntry entry = new ZipEntry(cu.getSourcePath());
                zos.putNextEntry(entry);
                zos.write(serializer.write((SourceFile)cu));
                zos.closeEntry();
            }
            zos.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        new DefaultMavenProjectHelper().attachArtifact(this.project, rewriteJar, "ast");
    }
}

