/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.openrewrite.Environment;
import org.openrewrite.Recipe;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="discover", threadSafe=true)
public class RewriteDiscoverMojo
extends AbstractRewriteMojo {
    private final Log log = this.getLog();

    public void execute() throws MojoExecutionException {
        Environment environment = this.environment();
        Map recipesByName = environment.getRecipesByName();
        this.log.info((CharSequence)("Found " + this.activeRecipes.size() + " active recipes and " + recipesByName.size() + " total recipes.\n"));
        this.log.info((CharSequence)"Active Recipe Names:");
        this.activeRecipes.forEach(activeRecipe -> this.log.info((CharSequence)("\t" + activeRecipe + "\n")));
        this.log.info((CharSequence)"Recipes:");
        boolean isFirst = true;
        for (Recipe recipe : recipesByName.values()) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.log.info((CharSequence)"---");
                this.log.info((CharSequence)"");
            }
            this.log.info((CharSequence)("\tname: " + recipe.getName()));
            this.log.info((CharSequence)"\tinclude: ");
            recipe.getInclude().forEach(rec -> this.log.info((CharSequence)("\t\t" + rec.pattern().replace("\\", "").replace("[^.]+", "*"))));
            this.log.info((CharSequence)"\texclude: ");
            recipe.getExclude().forEach(rec -> this.log.info((CharSequence)("\t\t" + rec.pattern().replace("\\", "").replace("[^.]+", "*"))));
            this.log.info((CharSequence)"\tvisitors: ");
            environment.visitors(new String[]{recipe.getName()}).forEach(rec -> this.log.info((CharSequence)("\t\t" + rec.getName())));
            this.log.info((CharSequence)"");
        }
    }
}

