/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openrewrite.Change;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="diff", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class RewriteDiffMojo
extends AbstractRewriteMojo {
    @Parameter(property="reportOutputDirectory", defaultValue="${project.reporting.outputDirectory}/rewrite", required=true)
    private File reportOutputDirectory;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;

    public void execute() throws MojoExecutionException {
        Collection<Change> changes = this.listChanges();
        if (!changes.isEmpty()) {
            for (Change change : changes) {
                this.getLog().warn((CharSequence)("Changes are suggested to " + change.getOriginal().getSourcePath() + " by:"));
                for (String rule : change.getVisitorsThatMadeChanges()) {
                    this.getLog().warn((CharSequence)("   " + rule));
                }
            }
            this.reportOutputDirectory.mkdirs();
            Path patchFile = this.reportOutputDirectory.toPath().resolve("rewrite.patch");
            try {
                BufferedWriter writer = Files.newBufferedWriter(patchFile, new OpenOption[0]);
                Object object = null;
                try {
                    for (Change change : changes) {
                        writer.write(change.diff() + "\n");
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (object != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to generate rewrite diff file.", (Exception)e);
            }
            this.getLog().warn((CharSequence)("A patch file has been generated. Run 'git apply -f " + Paths.get(this.mavenSession.getExecutionRootDirectory(), new String[0]).relativize(patchFile).toString() + "' to apply."));
        }
    }
}

