/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.toolingapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jspecify.annotations.Nullable;
import org.openrewrite.gradle.toolingapi.OpenRewriteModel;

public class OpenRewriteModelBuilder {
    public static OpenRewriteModel forProjectDirectory(File projectDir, @Nullable File buildFile) throws IOException {
        return OpenRewriteModelBuilder.forProjectDirectory(projectDir, buildFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenRewriteModel forProjectDirectory(File projectDir, @Nullable File buildFile, @Nullable String initScript) throws IOException {
        DefaultGradleConnector connector = (DefaultGradleConnector)GradleConnector.newConnector();
        if (Files.exists(projectDir.toPath().resolve("gradle/wrapper/gradle-wrapper.properties"), new LinkOption[0])) {
            connector.useBuildDistribution();
        } else {
            connector.useGradleVersion("8.12");
        }
        connector.forProjectDirectory(projectDir);
        ArrayList<String> arguments = new ArrayList<String>();
        if (buildFile != null && buildFile.exists()) {
            arguments.add("-b");
            arguments.add(buildFile.getAbsolutePath());
        }
        arguments.add("--init-script");
        Path init = projectDir.toPath().resolve("openrewrite-tooling.gradle").toAbsolutePath();
        arguments.add(init.toString());
        try (ProjectConnection connection = connector.connect();){
            OpenRewriteModel openRewriteModel;
            ModelBuilder customModelBuilder = connection.model(OpenRewriteModel.class);
            try {
                if (initScript == null) {
                    try (InputStream is = OpenRewriteModel.class.getResourceAsStream("/init.gradle");){
                        if (is == null) {
                            throw new IllegalStateException("Expected to find init.gradle on the classpath");
                        }
                        Files.copy(is, init, new CopyOption[0]);
                    }
                } else {
                    Files.write(init, initScript.getBytes(), new OpenOption[0]);
                }
                customModelBuilder.withArguments(arguments);
                openRewriteModel = (OpenRewriteModel)customModelBuilder.get();
            }
            catch (Throwable throwable) {
                try {
                    Files.delete(init);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                throw throwable;
            }
            try {
                Files.delete(init);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return openRewriteModel;
        }
    }
}

