/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.toolingapi;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.gradle.UpdateGradleWrapper;
import org.openrewrite.gradle.marker.GradleBuildscript;
import org.openrewrite.gradle.toolingapi.GradleProject;
import org.openrewrite.gradle.toolingapi.GradleSettings;
import org.openrewrite.gradle.toolingapi.OpenRewriteModel;
import org.openrewrite.gradle.toolingapi.OpenRewriteModelBuilder;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.OperatingSystemProvenance;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.test.UncheckedConsumer;
import org.opentest4j.TestAbortedException;

public class Assertions {
    public static UncheckedConsumer<List<SourceFile>> withToolingApi(URI distributionUrl) {
        return Assertions.withToolingApi(GradleWrapper.create((URI)distributionUrl, (ExecutionContext)new InMemoryExecutionContext()));
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(URI distributionUrl, String initScriptContents) {
        return Assertions.withToolingApi(GradleWrapper.create((URI)distributionUrl, (ExecutionContext)new InMemoryExecutionContext()), initScriptContents);
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(@Nullable GradleWrapper gradleWrapper) {
        return Assertions.withToolingApi(gradleWrapper, null);
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(@Nullable GradleWrapper gradleWrapper, @Nullable String initScriptContents) {
        return sourceFiles -> {
            try {
                Path tempDirectory;
                Path projectDir = tempDirectory = Files.createTempDirectory("project", new FileAttribute[0]);
                try {
                    for (SourceFile sourceFile : sourceFiles) {
                        Properties.File f;
                        if (sourceFile instanceof G.CompilationUnit) {
                            G.CompilationUnit g = (G.CompilationUnit)sourceFile;
                            if (!g.getSourcePath().toString().endsWith(".gradle")) continue;
                            Path groovyGradle = tempDirectory.resolve(g.getSourcePath());
                            if (!tempDirectory.equals(groovyGradle.getParent()) && tempDirectory.equals(groovyGradle.getParent().getParent())) {
                                projectDir = groovyGradle.getParent();
                            }
                            Files.createDirectories(groovyGradle.getParent(), new FileAttribute[0]);
                            Files.write(groovyGradle, g.printAllAsBytes(), new OpenOption[0]);
                            continue;
                        }
                        if (!(sourceFile instanceof Properties.File) || !(f = (Properties.File)sourceFile).getSourcePath().endsWith("gradle.properties")) continue;
                        Path gradleProperties = tempDirectory.resolve(f.getSourcePath());
                        if (!tempDirectory.equals(gradleProperties.getParent()) && tempDirectory.equals(gradleProperties.getParent().getParent())) {
                            projectDir = gradleProperties.getParent();
                        }
                        Files.createDirectories(gradleProperties.getParent(), new FileAttribute[0]);
                        Files.write(gradleProperties, f.printAllAsBytes(), new OpenOption[0]);
                    }
                    if (gradleWrapper != null) {
                        Files.createDirectories(projectDir.resolve("gradle/wrapper/"), new FileAttribute[0]);
                        Files.write(projectDir.resolve(GradleWrapper.WRAPPER_PROPERTIES_LOCATION), ("distributionBase=GRADLE_USER_HOME\ndistributionPath=wrapper/dists\ndistributionUrl=" + gradleWrapper.getPropertiesFormattedUrl() + "\n" + (gradleWrapper.getDistributionChecksum() == null ? "" : "distributionSha256Sum=" + gradleWrapper.getDistributionChecksum().getHexValue() + "\n") + "zipStoreBase=GRADLE_USER_HOME\nzipStorePath=wrapper/dists").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW);
                        Files.write(projectDir.resolve(GradleWrapper.WRAPPER_JAR_LOCATION), gradleWrapper.wrapperJar().printAllAsBytes(), StandardOpenOption.CREATE_NEW);
                        Path gradleSh = projectDir.resolve(GradleWrapper.WRAPPER_SCRIPT_LOCATION);
                        Files.copy(Objects.requireNonNull(UpdateGradleWrapper.class.getResourceAsStream("/gradlew")), gradleSh, new CopyOption[0]);
                        OperatingSystemProvenance current = OperatingSystemProvenance.current();
                        if (current.isLinux() || current.isMacOsX()) {
                            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(gradleSh, new LinkOption[0]);
                            permissions.add(PosixFilePermission.OWNER_EXECUTE);
                            Files.setPosixFilePermissions(gradleSh, permissions);
                        }
                        Files.copy(Objects.requireNonNull(UpdateGradleWrapper.class.getResourceAsStream("/gradlew.bat")), projectDir.resolve(GradleWrapper.WRAPPER_BATCH_LOCATION), new CopyOption[0]);
                    }
                    LinkedHashSet allRepositories = new LinkedHashSet();
                    LinkedHashSet allBuildscriptRepositories = new LinkedHashSet();
                    boolean freestandingScriptFound = false;
                    for (int i = 0; i < sourceFiles.size(); ++i) {
                        OpenRewriteModel model;
                        SourceFile sourceFile = (SourceFile)sourceFiles.get(i);
                        if (sourceFile.getSourcePath().endsWith("settings.gradle")) {
                            model = OpenRewriteModelBuilder.forProjectDirectory(tempDirectory.resolve(sourceFile.getSourcePath()).getParent().toFile(), null, initScriptContents);
                            GradleSettings rawSettings = model.gradleSettings();
                            if (rawSettings == null) continue;
                            org.openrewrite.gradle.marker.GradleSettings gradleSettings = GradleSettings.toMarker(rawSettings);
                            sourceFiles.set(i, (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().add((Marker)gradleSettings)));
                            continue;
                        }
                        if (sourceFile.getSourcePath().endsWith("build.gradle")) {
                            model = OpenRewriteModelBuilder.forProjectDirectory(projectDir.toFile(), tempDirectory.resolve(sourceFile.getSourcePath()).toFile(), initScriptContents);
                            org.openrewrite.gradle.marker.GradleProject gradleProject = GradleProject.toMarker(model.gradleProject());
                            allRepositories.addAll(gradleProject.getMavenRepositories());
                            allBuildscriptRepositories.addAll(gradleProject.getBuildscript().getMavenRepositories());
                            sourceFiles.set(i, (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().add((Marker)gradleProject)));
                            continue;
                        }
                        if (!sourceFile.getSourcePath().toString().endsWith(".gradle")) continue;
                        freestandingScriptFound = true;
                    }
                    if (freestandingScriptFound) {
                        org.openrewrite.gradle.marker.GradleProject freestandingScriptMarker = new org.openrewrite.gradle.marker.GradleProject(Tree.randomId(), "", "", "", "", Collections.emptyList(), new ArrayList(allRepositories), Collections.emptyList(), Collections.emptyMap(), new GradleBuildscript(Tree.randomId(), new ArrayList(allBuildscriptRepositories), Collections.emptyMap()));
                        for (int i = 0; i < sourceFiles.size(); ++i) {
                            SourceFile sourceFile = (SourceFile)sourceFiles.get(i);
                            if (!sourceFile.getSourcePath().toString().endsWith(".gradle") || sourceFile.getMarkers().findFirst(org.openrewrite.gradle.marker.GradleProject.class).isPresent() || sourceFile.getMarkers().findFirst(org.openrewrite.gradle.marker.GradleSettings.class).isPresent()) continue;
                            sourceFiles.set(i, (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().add((Marker)freestandingScriptMarker)));
                        }
                    }
                }
                finally {
                    Assertions.deleteDirectory(tempDirectory.toFile());
                }
            }
            catch (IOException e) {
                throw new TestAbortedException("Failed to load Gradle tooling API", (Throwable)e);
            }
        };
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(@Nullable String version, @Nullable String distribution) {
        GradleWrapper gradleWrapper = null;
        if (version != null) {
            gradleWrapper = GradleWrapper.create((String)distribution, (String)version, null, (ExecutionContext)new InMemoryExecutionContext());
        }
        return Assertions.withToolingApi(gradleWrapper);
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi(String version) {
        return Assertions.withToolingApi(version, "bin");
    }

    public static UncheckedConsumer<List<SourceFile>> withToolingApi() {
        return Assertions.withToolingApi((GradleWrapper)null, null);
    }

    private static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                Assertions.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }
}

