/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser;

import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.parser.ParsedBooleanQuery;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.ParsedOperation;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.ParsedUpdate;
import org.openrdf.query.parser.QueryParser;
import org.openrdf.query.parser.QueryParserFactory;
import org.openrdf.query.parser.QueryParserRegistry;
import org.openrdf.query.parser.QueryPrologLexer;

public class QueryParserUtil {
    public static QueryParser createParser(QueryLanguage ql) throws UnsupportedQueryLanguageException {
        QueryParserFactory factory = (QueryParserFactory)QueryParserRegistry.getInstance().get(ql).orElseThrow(() -> new UnsupportedQueryLanguageException("No factory available for query language " + ql));
        return factory.getParser();
    }

    public static ParsedOperation parseOperation(QueryLanguage ql, String operation, String baseURI) throws MalformedQueryException {
        String strippedOperation;
        ParsedOperation parsedOperation = null;
        QueryParser parser = QueryParserUtil.createParser(ql);
        parsedOperation = QueryLanguage.SPARQL.equals((Object)ql) ? ((strippedOperation = QueryParserUtil.removeSPARQLQueryProlog(operation).toUpperCase()).startsWith("SELECT") || strippedOperation.startsWith("CONSTRUCT") || strippedOperation.startsWith("DESCRIBE") || strippedOperation.startsWith("ASK") ? parser.parseQuery(operation, baseURI) : parser.parseUpdate(operation, baseURI)) : parser.parseQuery(operation, baseURI);
        return parsedOperation;
    }

    public static ParsedUpdate parseUpdate(QueryLanguage ql, String update, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        QueryParser parser = QueryParserUtil.createParser(ql);
        return parser.parseUpdate(update, baseURI);
    }

    public static ParsedQuery parseQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        QueryParser parser = QueryParserUtil.createParser(ql);
        return parser.parseQuery(query, baseURI);
    }

    public static ParsedTupleQuery parseTupleQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        ParsedQuery q = QueryParserUtil.parseQuery(ql, query, baseURI);
        if (q instanceof ParsedTupleQuery) {
            return (ParsedTupleQuery)q;
        }
        throw new IllegalArgumentException("query is not a tuple query: " + query);
    }

    public static ParsedGraphQuery parseGraphQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        ParsedQuery q = QueryParserUtil.parseQuery(ql, query, baseURI);
        if (q instanceof ParsedGraphQuery) {
            return (ParsedGraphQuery)q;
        }
        throw new IllegalArgumentException("query is not a graph query: " + query);
    }

    public static ParsedBooleanQuery parseBooleanQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, UnsupportedQueryLanguageException {
        ParsedQuery q = QueryParserUtil.parseQuery(ql, query, baseURI);
        if (q instanceof ParsedBooleanQuery) {
            return (ParsedBooleanQuery)q;
        }
        throw new IllegalArgumentException("query is not a boolean query: " + query);
    }

    public static String removeSPARQLQueryProlog(String queryString) {
        QueryPrologLexer.Token t = QueryPrologLexer.getRestOfQueryToken(queryString);
        if (t != null) {
            return t.getStringValue();
        }
        return queryString;
    }
}

