/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.util;

import info.aduna.lang.ObjectUtil;
import java.util.Comparator;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class ValueComparator
implements Comparator<Value> {
    @Override
    public int compare(Value o1, Value o2) {
        if (ObjectUtil.nullEquals((Object)o1, (Object)o2)) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        boolean b1 = o1 instanceof BNode;
        boolean b2 = o2 instanceof BNode;
        if (b1 && b2) {
            return this.compareBNodes((BNode)o1, (BNode)o2);
        }
        if (b1) {
            return -1;
        }
        if (b2) {
            return 1;
        }
        boolean u1 = o1 instanceof URI;
        boolean u2 = o2 instanceof URI;
        if (u1 && u2) {
            return this.compareURIs((URI)o1, (URI)o2);
        }
        if (u1) {
            return -1;
        }
        if (u2) {
            return 1;
        }
        return this.compareLiterals((Literal)o1, (Literal)o2);
    }

    private int compareBNodes(BNode leftBNode, BNode rightBNode) {
        return leftBNode.getID().compareTo(rightBNode.getID());
    }

    private int compareURIs(URI leftURI, URI rightURI) {
        return leftURI.toString().compareTo(rightURI.toString());
    }

    private int compareLiterals(Literal leftLit, Literal rightLit) {
        if (!QueryEvaluationUtil.isPlainLiteral((Value)leftLit) && !QueryEvaluationUtil.isPlainLiteral((Value)rightLit)) {
            try {
                boolean isSmaller = QueryEvaluationUtil.compareLiterals(leftLit, rightLit, Compare.CompareOp.LT);
                if (isSmaller) {
                    return -1;
                }
                boolean isEquivalent = QueryEvaluationUtil.compareLiterals(leftLit, rightLit, Compare.CompareOp.EQ);
                if (isEquivalent) {
                    return 0;
                }
                return 1;
            }
            catch (ValueExprEvaluationException isSmaller) {
                // empty catch block
            }
        }
        int result = 0;
        URI leftDatatype = leftLit.getDatatype();
        URI rightDatatype = rightLit.getDatatype();
        if (leftDatatype != null) {
            result = rightDatatype != null ? this.compareDatatypes(leftDatatype, rightDatatype) : 1;
        } else if (rightDatatype != null) {
            result = -1;
        }
        if (result == 0) {
            String leftLanguage = leftLit.getLanguage();
            String rightLanguage = rightLit.getLanguage();
            if (leftLanguage != null) {
                result = rightLanguage != null ? leftLanguage.compareTo(rightLanguage) : 1;
            } else if (rightLanguage != null) {
                result = -1;
            }
        }
        if (result == 0) {
            result = leftLit.getLabel().compareTo(rightLit.getLabel());
        }
        return result;
    }

    private int compareDatatypes(URI leftDatatype, URI rightDatatype) {
        if (XMLDatatypeUtil.isNumericDatatype((URI)leftDatatype)) {
            if (XMLDatatypeUtil.isNumericDatatype((URI)rightDatatype)) {
                return this.compareURIs(leftDatatype, rightDatatype);
            }
            return -1;
        }
        if (XMLDatatypeUtil.isNumericDatatype((URI)rightDatatype)) {
            return 1;
        }
        if (XMLDatatypeUtil.isCalendarDatatype((URI)leftDatatype)) {
            if (XMLDatatypeUtil.isCalendarDatatype((URI)rightDatatype)) {
                return this.compareURIs(leftDatatype, rightDatatype);
            }
            return -1;
        }
        if (XMLDatatypeUtil.isCalendarDatatype((URI)rightDatatype)) {
            return 1;
        }
        return this.compareURIs(leftDatatype, rightDatatype);
    }
}

